/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.RB;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.models.IncrementInterface;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AlarmButtonModel;
import com.sas.visuals.ArrowButton;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.ScrollSlider;
import com.sas.visuals.ScrollbarButtonLayout;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Scrollbar
extends CompositeContainer
implements ActionListener,
Adjustable,
AdjustmentListener,
IncrementInterface {
    static final long serialVersionUID = -4529445756573007495L;
    protected ArrowButton upArrow;
    protected ArrowButton downArrow;
    protected ScrollSlider trackArea;
    static int defaultWidth = 16;
    static int defaultHeight = 124;
    protected transient AdjustmentListener adjustmentListener;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "blockIncrement"}, {"Expert", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "maximum"}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Expert", "true"}}, {{"Name", "orientation"}, {"Property editor class", "com.sas.beans.editors.ScrollbarOrientationEditor"}}, {{"Name", "unitIncrement"}, {"Expert", "true"}}, {{"Name", "value"}, {"Expert", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "16"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "numberValue";
        ebi.defaultOutputPropertyName = "numberValue";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public long getDelay() {
        ButtonModelInterface btnModel = this.upArrow.getButtonModel();
        if (btnModel instanceof AlarmButtonModel) {
            return ((AlarmButtonModel)this.upArrow.getButtonModel()).getDelay();
        }
        return -1L;
    }

    public void setDelay(long delay) {
        ButtonModelInterface upBtnModel = this.upArrow.getButtonModel();
        ButtonModelInterface downBtnModel = this.downArrow.getButtonModel();
        ButtonModelInterface trackDecModel = this.trackArea.getDecrementModel();
        ButtonModelInterface trackIncModel = this.trackArea.getIncrementModel();
        if (upBtnModel instanceof AlarmButtonModel) {
            ((AlarmButtonModel)upBtnModel).setDelay(delay);
        }
        if (downBtnModel instanceof AlarmButtonModel) {
            ((AlarmButtonModel)downBtnModel).setDelay(delay);
        }
        if (trackDecModel instanceof AlarmButtonModel) {
            ((AlarmButtonModel)trackDecModel).setDelay(delay);
        }
        if (trackIncModel instanceof AlarmButtonModel) {
            ((AlarmButtonModel)trackIncModel).setDelay(delay);
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        return this.trackArea.getRequiredInterfaces();
    }

    @Override
    public int getOrientation() {
        return this.trackArea.getOrientation();
    }

    public void setOrientation(int orient) {
        if (orient != this.trackArea.getOrientation()) {
            this.trackArea.setOrientation(orient);
            BaseBorder border = (BaseBorder)this.trackArea.getBorder();
            ScrollbarButtonLayout layout = (ScrollbarButtonLayout)((Object)this.getLayout());
            layout.setOrientation(orient);
            if (orient == 0) {
                border.setSidesPainted(12);
                this.upArrow.setOrientation(1);
                this.downArrow.setOrientation(2);
                layout.setRemainderColumn(2);
                layout.setRemainderRow(1);
            } else {
                border.setSidesPainted(3);
                this.upArrow.setOrientation(4);
                this.downArrow.setOrientation(8);
                layout.setRemainderColumn(1);
                layout.setRemainderRow(2);
            }
            Dimension size = this.getSize();
            this.setSize(size.height, size.width);
            this.invalidate();
            this.validate();
        }
    }

    public Number getVisibleAmountNumber() {
        return this.trackArea.getVisibleAmountNumber();
    }

    public void setVisibleAmountNumber(Number amt) {
        this.trackArea.setVisibleAmountNumber(amt);
    }

    @Override
    public int getVisibleAmount() {
        return this.trackArea.getVisibleAmount();
    }

    @Override
    public void setVisibleAmount(int amt) {
        this.trackArea.setVisibleAmount(amt);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        ScrollbarButtonLayout layout = new ScrollbarButtonLayout(3, 1, 0, 0, true, true, true);
        this.setLayout((LayoutManager)((Object)layout));
        layout.setRemainderRow(2);
        this.setIDEDnDDropTarget(false);
        this.trackArea = new ScrollSlider();
        BaseBorder border = (BaseBorder)this.trackArea.getBorder();
        border.setBaseColor(SystemColor.controlShadow);
        border.setSidesPainted(3);
        border.setStyle(2);
        border.setBorderWidth(1);
        this.upArrow = new ArrowButton(4);
        this.downArrow = new ArrowButton(8);
        Util.addPropertyChangeListener((Object)this.trackArea, (PropertyChangeListener)((Object)this));
        this.upArrow.addActionListener(this);
        this.downArrow.addActionListener(this);
        this.trackArea.addAdjustmentListener(this);
        this.add(this.upArrow);
        this.add(this.trackArea);
        this.add(this.downArrow);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.trackArea.setEnabled(enabled);
            this.upArrow.setEnabled(enabled && this.trackArea.isTrackEnabled());
            this.downArrow.setEnabled(enabled && this.trackArea.isTrackEnabled());
            super.setEnabled(enabled);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "adjustmentL", this.adjustmentListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("adjustmentL" == key) {
                this.addAdjustmentListener((AdjustmentListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        Util.addPropertyChangeListener((Object)this.trackArea, (PropertyChangeListener)((Object)this));
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.trackArea) {
            this.processAdjustmentEvent(new AdjustmentEvent(this, e.getID(), e.getAdjustmentType(), e.getValue()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Number newValue;
        Object eSource = e.getSource();
        Number oldValue = this.trackArea.getNumberValue();
        if (this.upArrow == eSource) {
            Number newValue2 = this.trackArea.incrementBy(-1, 0);
            if (!oldValue.equals(newValue2)) {
                this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
            }
        } else if (this.downArrow == eSource && !oldValue.equals(newValue = this.trackArea.incrementBy(1, 0))) {
            this.processAdjustmentEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        this.trackArea.attachModel(model);
    }

    @Override
    public void detachModel(ModelInterface model) {
        this.trackArea.detachModel(model);
    }

    @Override
    public ModelInterface getModelInterface() {
        return this.trackArea.getModelInterface();
    }

    @Override
    public void setModelInterface(ModelInterface model) {
        this.trackArea.setModelInterface(model);
    }

    @Override
    public void refresh(ModelInterface model) {
        this.trackArea.refresh(model);
    }

    public Number incrementBy(int increment, int incrementType) {
        return this.trackArea.incrementBy(increment, incrementType);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        String propName = event.getPropertyName();
        if (event.getSource() == this.trackArea && propName != null) {
            if (propName.equals("visibleAmount") || propName.equals("visibleAmountNumber") || propName.equals("modelInterface") || propName.equals("blockIncrement") || propName.equals("maximum") || propName.equals("minimum") || propName.equals("unitIncrement") || propName.equals("value") || propName.equals("maximumReachable") || propName.equals("minimumThumbHeight") || propName.equals("roundNumberTransform") || propName.equals("blockIncrementNumber") || propName.equals("maximumNumber") || propName.equals("minimumNumber") || propName.equals("unitIncrementNumber") || propName.equals("numberValue")) {
                this.firePropertyChange(propName, event.getOldValue(), event.getNewValue());
            } else if (propName.equals("trackEnabled")) {
                boolean enabled;
                boolean bl = enabled = this.trackArea.isTrackEnabled() && this.isEnabled();
                if (this.upArrow.getButtonModel().isPressed() && !enabled) {
                    this.upArrow.getButtonModel().setPressed(false);
                }
                if (this.downArrow.getButtonModel().isPressed() && !enabled) {
                    this.downArrow.getButtonModel().setPressed(false);
                }
                this.upArrow.setEnabled(enabled);
                this.downArrow.setEnabled(enabled);
            }
        }
    }

    @Override
    public final int getBlockIncrement() {
        return this.trackArea.getBlockIncrementNumber().intValue();
    }

    @Override
    public final int getMaximum() {
        return this.trackArea.getMaximumNumber().intValue();
    }

    @Override
    public final int getMinimum() {
        return this.trackArea.getMinimumNumber().intValue();
    }

    @Override
    public final int getUnitIncrement() {
        return this.trackArea.getUnitIncrementNumber().intValue();
    }

    @Override
    public final int getValue() {
        return this.trackArea.getNumberValue().intValue();
    }

    @Override
    public final void setBlockIncrement(int block) {
        this.trackArea.setBlockIncrementNumber(new Integer(block));
    }

    public boolean isMaximumReachable() {
        return this.trackArea.isMaximumReachable();
    }

    public void setMaximumReachable(boolean reachable) {
        this.trackArea.setMaximumReachable(reachable);
    }

    @Override
    public final void setMaximum(int max) {
        this.trackArea.setMaximumNumber(new Long(max));
    }

    @Override
    public final void setMinimum(int min) {
        this.trackArea.setMinimumNumber(new Long(min));
    }

    public int getMinimumThumbHeight() {
        return this.trackArea.getMinimumThumbHeight();
    }

    public void setMinimumThumbHeight(int minThumb) {
        this.trackArea.setMinimumThumbHeight(minThumb);
    }

    public TransformInterface getRoundNumberTransform() {
        return this.trackArea.getRoundNumberTransform();
    }

    public void setRoundNumberTransform(TransformInterface transform) {
        this.trackArea.setRoundNumberTransform(transform);
    }

    @Override
    public final void setUnitIncrement(int unit) {
        this.trackArea.setUnitIncrement(unit);
    }

    @Override
    public final void setValue(int newValue) {
        this.trackArea.setValue(newValue);
    }

    public Number getUnitIncrementNumber() {
        return this.trackArea.getUnitIncrementNumber();
    }

    public Number getBlockIncrementNumber() {
        return this.trackArea.getBlockIncrementNumber();
    }

    public Number getMaximumNumber() {
        return this.trackArea.getMaximumNumber();
    }

    public Number getMinimumNumber() {
        return this.trackArea.getMinimumNumber();
    }

    public Number getNumberValue() {
        return this.trackArea.getNumberValue();
    }

    public synchronized void setMaximumNumber(Number max) {
        this.trackArea.setMaximumNumber(max);
    }

    public synchronized void setMinimumNumber(Number min) {
        this.trackArea.setMinimumNumber(min);
    }

    public synchronized void setBlockIncrementNumber(Number block) {
        this.trackArea.setBlockIncrementNumber(block);
    }

    public synchronized void setUnitIncrementNumber(Number unit) {
        this.trackArea.setUnitIncrementNumber(unit);
    }

    public synchronized void setNumberValue(Number newValue) {
        this.trackArea.setNumberValue(newValue);
    }
}

