/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.RB;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.models.IncrementInterface;
import com.sas.models.RangeInterface;
import com.sas.util.Util;
import com.sas.util.transforms.RoundNumberTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AlarmButtonModel;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ButtonListenerInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.DefaultButtonModel;
import com.sas.visuals.SliderInterface;
import com.sas.visuals.SliderListener;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ScrollSlider
extends Component
implements SliderInterface,
RangeInterface,
IncrementInterface,
ActionListener,
Adjustable {
    static final long serialVersionUID = 5685271723946819104L;
    protected boolean trackEnabled;
    protected boolean thumbVisible;
    protected boolean allowIncrements;
    protected boolean maximumReachable;
    protected int orientation;
    protected Number visibleAmt;
    protected int minThumbHeight;
    protected transient boolean modelSet;
    protected transient boolean validBounds;
    protected transient Rectangle incrementBounds;
    protected transient Rectangle decrementBounds;
    protected transient Rectangle thumbBounds;
    protected transient boolean thumbMove;
    protected transient AdjustmentListener adjustmentListener;
    protected TransformInterface roundNumberTransform;
    protected ButtonModelInterface incrModel;
    protected ButtonModelInterface decrModel;
    protected ButtonModelInterface trackModel;
    protected ButtonListenerInterface sliderListener;
    protected BoundedNumberInterface defaultModel;
    static String[] requiredInterfacesString = new String[]{"com.sas.models.BoundedNumberInterface"};
    static int defaultWidth = 16;
    static int defaultHeight = 124;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "blockIncrement"}, {"Expert", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "maximum"}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Expert", "true"}}, {{"Name", "orientation"}, {"Property editor class", "com.sas.beans.editors.ScrollbarOrientationEditor"}}, {{"Name", "unitIncrement"}, {"Expert", "true"}}, {{"Name", "value"}, {"Expert", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "16"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "numberValue";
        ebi.defaultOutputPropertyName = "numberValue";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int typeEvent = -1;
        if (evt.getSource() == this.incrModel) {
            typeEvent = 4;
            this.incrementBy(1, 1);
        } else if (evt.getSource() == this.decrModel) {
            typeEvent = 3;
            this.incrementBy(-1, 1);
        } else if (evt.getSource() == this.trackModel) {
            typeEvent = 5;
            Rectangle repaintArea = this.layoutActionAreas();
            this.repaint(repaintArea.x, repaintArea.y, repaintArea.width, repaintArea.height);
        }
        if (typeEvent == 4 || typeEvent == 3) {
            this.processAdjustmentEvent(new AdjustmentEvent(this, 601, typeEvent, this.getValue()));
        }
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public void setModelInterface(ModelInterface model) {
        try {
            if (model != null) {
                this.modelSet = true;
            }
            super.setModelInterface(model);
        }
        finally {
            this.modelSet = false;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        com.sas.beans.Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null && !this.modelSet) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    @Override
    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 0) {
            return new Dimension(20, 14);
        }
        return new Dimension(14, 20);
    }

    @Override
    public final int getBlockIncrement() {
        return this.getBlockIncrementNumber().intValue();
    }

    public ButtonModelInterface getDecrementModel() {
        return this.decrModel;
    }

    public ButtonModelInterface getIncrementModel() {
        return this.incrModel;
    }

    @Override
    public final int getMaximum() {
        return this.getMaximumNumber().intValue();
    }

    @Override
    public final int getMinimum() {
        return this.getMinimumNumber().intValue();
    }

    public int getMinimumThumbHeight() {
        return this.minThumbHeight;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public ButtonModelInterface getTrackModel() {
        return this.trackModel;
    }

    @Override
    public final int getUnitIncrement() {
        return this.getUnitIncrementNumber().intValue();
    }

    @Override
    public final int getValue() {
        return this.getNumberValue().intValue();
    }

    public Number getVisibleAmountNumber() {
        return this.visibleAmt;
    }

    @Override
    public int getVisibleAmount() {
        return this.visibleAmt.intValue();
    }

    public Number incrementBy(int increment, int incrementType) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && (increment < 0 || this.allowIncrements || this.isMaximumReachable())) {
            return model.incrementBy(increment, incrementType);
        }
        return this.getNumberValue();
    }

    public boolean isMaximumReachable() {
        return this.maximumReachable;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g != null && !this.validBounds) {
            this.layoutActionAreas();
        }
        this.paintBackground(g);
        this.paintIncrementArea(g, this.getIncrementBounds());
        this.paintDecrementArea(g, this.getDecrementBounds());
        this.paintThumbArea(g, this.getThumbBounds());
    }

    protected void paintBackground(Graphics g) {
    }

    protected void paintIncrementArea(Graphics g, Rectangle incrBounds) {
    }

    protected void paintDecrementArea(Graphics g, Rectangle decrBounds) {
    }

    protected void paintThumbArea(Graphics g, Rectangle tRect) {
        Dimension size = this.getSize();
        if (this.orientation == 1 && tRect.height >= size.height || this.orientation == 0 && tRect.width >= size.width || !this.isThumbVisible()) {
            return;
        }
        Shape clip = g.getClip();
        g.setClip(tRect);
        g.clipRect(0, 0, size.width, size.height);
        g.setColor(SystemColor.control);
        g.fillRect(tRect.x, tRect.y, tRect.width, tRect.height);
        BaseBorder.paintBorder(g, tRect.x, tRect.y, tRect.width, tRect.height, null, null, 4, 2, 5, 15);
        g.setClip(clip);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (eSource == this.getModelInterface() && propName != null && oldValue != null && oldValue instanceof Number && newValue != null && newValue instanceof Number) {
            Integer oldIntegerValue = new Integer(((Number)oldValue).intValue());
            Integer newIntegerValue = new Integer(((Number)newValue).intValue());
            if (propName.equals("minimumNumber")) {
                this.firePropertyChange("minimum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("maximumNumber")) {
                this.firePropertyChange("maximum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("numberValue")) {
                this.firePropertyChange("value", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("blockIncrementNumber")) {
                this.firePropertyChange("blockIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("unitIncrementNumber")) {
                this.firePropertyChange("unitIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else {
                return;
            }
            if (!this.thumbMove) {
                Rectangle repaintArea = this.layoutActionAreas();
                this.repaint(repaintArea.x, repaintArea.y, repaintArea.width, repaintArea.height);
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        AlarmButtonModel decrementModel;
        AlarmButtonModel incrementModel;
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("adjustmentL" == key) {
                this.addAdjustmentListener((AdjustmentListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.trackModel != null) {
            this.trackModel.removeActionListener(this);
            this.trackModel.addActionListener(this);
        }
        this.incrementBounds = new Rectangle();
        this.decrementBounds = new Rectangle();
        this.thumbBounds = new Rectangle();
        this.thumbMove = false;
        this.validBounds = false;
        this.modelSet = false;
        if (this.incrModel != null && this.incrModel instanceof AlarmButtonModel && (incrementModel = (AlarmButtonModel)this.incrModel).getDelay() == 0L) {
            incrementModel.setDelay(500L);
        }
        if (this.decrModel != null && this.decrModel instanceof AlarmButtonModel && (decrementModel = (AlarmButtonModel)this.decrModel).getDelay() == 0L) {
            decrementModel.setDelay(500L);
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null && model instanceof BoundedNumberInterface) {
            com.sas.beans.Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
            BoundedNumberInterface boundedNumber = (BoundedNumberInterface)model;
            Integer integerValue = new Integer(boundedNumber.getNumberValue().intValue());
            Integer integerMax = new Integer(boundedNumber.getMaximumNumber().intValue());
            Integer integerMin = new Integer(boundedNumber.getMinimumNumber().intValue());
            Integer integerBlock = new Integer(boundedNumber.getBlockIncrementNumber().intValue());
            Integer integerUnit = new Integer(boundedNumber.getUnitIncrementNumber().intValue());
            this.firePropertyChange("value", integerValue, integerValue);
            this.firePropertyChange("maximum", integerMax, integerMax);
            this.firePropertyChange("minimum", integerMin, integerMin);
            this.firePropertyChange("blockIncrement", integerBlock, integerBlock);
            this.firePropertyChange("unitIncrement", integerUnit, integerUnit);
            this.firePropertyChange("numberValue", boundedNumber.getNumberValue(), boundedNumber.getNumberValue());
            this.firePropertyChange("maximumNumber", boundedNumber.getMaximumNumber(), boundedNumber.getMaximumNumber());
            this.firePropertyChange("minimumNumber", boundedNumber.getMinimumNumber(), boundedNumber.getMinimumNumber());
            this.firePropertyChange("blockIncrementNumber", boundedNumber.getBlockIncrementNumber(), boundedNumber.getBlockIncrementNumber());
            this.firePropertyChange("unitIncrementNumber", boundedNumber.getUnitIncrementNumber(), boundedNumber.getUnitIncrementNumber());
            com.sas.beans.Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
            if (!this.thumbMove) {
                Rectangle repaintArea = this.layoutActionAreas();
                this.repaint(repaintArea.x, repaintArea.y, repaintArea.width, repaintArea.height);
            }
        }
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.validBounds = false;
        super.setBounds(x, y, width, height);
    }

    @Override
    public final void setBlockIncrement(int block) {
        this.setBlockIncrementNumber(new Integer(block));
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setBackground(SystemColor.scrollbar);
        this.setTransparent(false);
        this.thumbMove = false;
        this.incrModel = new AlarmButtonModel();
        this.incrModel.addActionListener(this);
        ((AlarmButtonModel)this.incrModel).setDelay(500L);
        ((AlarmButtonModel)this.incrModel).setStartInterval(150L);
        this.decrModel = new AlarmButtonModel();
        this.decrModel.addActionListener(this);
        ((AlarmButtonModel)this.decrModel).setDelay(500L);
        ((AlarmButtonModel)this.decrModel).setStartInterval(150L);
        this.trackModel = new DefaultButtonModel();
        this.trackModel.addActionListener(this);
        this.sliderListener = new SliderListener(this.trackModel, this.incrModel, this.decrModel, this);
        this.addMouseListener(this.sliderListener);
        this.addMouseMotionListener(this.sliderListener);
        this.addKeyListener(this.sliderListener);
        this.maximumReachable = false;
        this.orientation = 1;
        this.setRoundNumberTransform((TransformInterface)new RoundNumberTransform(2));
        this.setMinimumThumbHeight(7);
        this.setThumbVisible(true);
        this.defaultModel = new BoundedLong();
        this.visibleAmt = this.defaultModel.getBlockIncrementNumber();
        this.setModelInterface((ModelInterface)this.defaultModel);
        this.validBounds = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.setTrackEnabled(enabled);
        }
    }

    public void setMaximumReachable(boolean reachable) {
        if (reachable != this.maximumReachable) {
            this.maximumReachable = reachable;
            Rectangle repaintArea = this.layoutActionAreas();
            this.repaint(repaintArea.x, repaintArea.y, repaintArea.width, repaintArea.height);
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"maximumReachable", (boolean)this.maximumReachable);
        }
    }

    @Override
    public final void setMaximum(int max) {
        this.setMaximumNumber(new Long(max));
    }

    @Override
    public final void setMinimum(int min) {
        this.setMinimumNumber(new Long(min));
    }

    public void setMinimumThumbHeight(int minThumb) {
        if (minThumb != this.minThumbHeight) {
            int oldMinThumb = this.minThumbHeight;
            this.minThumbHeight = minThumb;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"minimumThumbHeight", (int)oldMinThumb, (int)this.minThumbHeight);
        }
    }

    public boolean isTrackEnabled() {
        return this.trackEnabled;
    }

    public void setTrackEnabled(boolean te) {
        if (te != this.trackEnabled) {
            boolean enabled = te;
            if (!this.isMaximumReachable()) {
                int minThumb;
                int thumbHeight;
                Dimension size = this.getSize();
                double diff = this.getMaximumNumber().doubleValue() - this.getMinimumNumber().doubleValue();
                double thumbPercent = this.getVisibleAmountNumber().doubleValue() / diff;
                if (thumbPercent > 1.0) {
                    thumbPercent = 1.0;
                }
                int sizeField = size.height;
                if (this.orientation == 1) {
                    sizeField = size.width;
                }
                if ((thumbHeight = (int)((double)sizeField * thumbPercent)) < (minThumb = this.getMinimumThumbHeight())) {
                    thumbHeight = minThumb;
                }
                enabled = thumbHeight < sizeField && te && this.isEnabled();
            }
            if (enabled != this.trackEnabled) {
                this.trackEnabled = enabled;
                this.incrModel.setDisabled(!this.trackEnabled);
                this.decrModel.setDisabled(!this.trackEnabled);
                this.trackModel.setDisabled(!this.trackEnabled);
                this.setThumbVisible(this.trackEnabled);
                ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"trackEnabled", (boolean)this.trackEnabled);
            }
        }
    }

    public boolean isThumbVisible() {
        return this.thumbVisible;
    }

    public void setThumbVisible(boolean vis) {
        if (vis != this.thumbVisible) {
            this.thumbVisible = vis;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"thumbVisible", (boolean)this.thumbVisible);
        }
    }

    public TransformInterface getRoundNumberTransform() {
        return this.roundNumberTransform;
    }

    public void setRoundNumberTransform(TransformInterface transform) {
        if (transform != this.roundNumberTransform) {
            TransformInterface oldTransform = this.roundNumberTransform;
            this.roundNumberTransform = transform;
            this.firePropertyChange("roundNumberTransform", oldTransform, this.roundNumberTransform);
        }
    }

    @Override
    public final void setUnitIncrement(int unit) {
        this.setUnitIncrementNumber(new Long(unit));
    }

    @Override
    public final void setValue(int newValue) {
        this.setNumberValue(new Long(newValue));
    }

    @Override
    public void setVisibleAmount(int visAmount) {
        this.setVisibleAmountNumber(new Integer(visAmount));
    }

    public void setVisibleAmountNumber(Number visAmount) {
        if (visAmount != null && Util.unequal((Object)visAmount, (Object)this.visibleAmt)) {
            Number oldVisAmt = this.visibleAmt;
            this.visibleAmt = visAmount;
            Rectangle paintRect = this.layoutActionAreas();
            this.repaint(paintRect.x, paintRect.y, paintRect.width, paintRect.height);
            this.firePropertyChange("visibleAmount", oldVisAmt, this.visibleAmt);
            this.firePropertyChange("visibleAmountNumber", oldVisAmt, this.visibleAmt);
        }
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
    }

    public Number getUnitIncrementNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getUnitIncrementNumber();
        }
        return null;
    }

    public Number getBlockIncrementNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getBlockIncrementNumber();
        }
        return null;
    }

    public Number getMaximumNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getMaximumNumber();
        }
        return null;
    }

    public Number getMinimumNumber() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getMinimumNumber();
        }
        return null;
    }

    public Number getNumberValue() {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null) {
            return model.getNumberValue();
        }
        return null;
    }

    public synchronized void setMaximumNumber(Number max) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && max != null) {
            model.setMaximumNumber(max);
        }
    }

    public synchronized void setMinimumNumber(Number min) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && min != null) {
            model.setMinimumNumber(min);
        }
    }

    public synchronized void setBlockIncrementNumber(Number block) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && block != null) {
            model.setBlockIncrementNumber(block);
        }
    }

    public synchronized void setUnitIncrementNumber(Number unit) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && unit != null) {
            model.setUnitIncrementNumber(unit);
        }
    }

    public synchronized void setNumberValue(Number newValue) {
        BoundedNumberInterface model = (BoundedNumberInterface)this.getModelInterface();
        if (model != null && newValue != null) {
            model.setNumberValue(newValue);
        }
    }

    protected Rectangle layoutActionAreas() {
        double diff = this.getMaximumNumber().doubleValue() - this.getMinimumNumber().doubleValue();
        double valueDiff = this.getNumberValue().doubleValue() - this.getMinimumNumber().doubleValue();
        double visibleAmount = this.getVisibleAmountNumber().doubleValue();
        Dimension size = this.getSize();
        if (this.thumbBounds == null) {
            this.thumbBounds = new Rectangle(0, 0, size.width, size.height);
        }
        if (this.incrementBounds == null) {
            this.incrementBounds = new Rectangle();
        }
        if (this.decrementBounds == null) {
            this.decrementBounds = new Rectangle();
        }
        Rectangle diffRect = new Rectangle(this.thumbBounds);
        this.allowIncrements = true;
        if (this.isMaximumReachable()) {
            int thumbHeight = 0;
            if (this.orientation == 1) {
                double unitDisplay = (double)size.height / (diff + this.getUnitIncrementNumber().doubleValue());
                this.thumbBounds.x = 0;
                this.thumbBounds.y = (int)(unitDisplay * valueDiff);
                thumbHeight = (int)(unitDisplay * visibleAmount);
                double maxThumb = this.getNumberValue().doubleValue() + visibleAmount;
                if (maxThumb > this.getMaximumNumber().doubleValue()) {
                    thumbHeight = size.height - this.thumbBounds.y;
                }
                if (thumbHeight < this.getMinimumThumbHeight() && this.thumbBounds.y + (thumbHeight = this.getMinimumThumbHeight()) > size.height) {
                    this.thumbBounds.y = size.height - thumbHeight;
                }
                this.thumbBounds.height = thumbHeight;
                this.thumbBounds.width = size.width;
            } else {
                double unitDisplay = (double)size.width / (diff + this.getUnitIncrementNumber().doubleValue());
                this.thumbBounds.y = 0;
                this.thumbBounds.x = (int)(unitDisplay * valueDiff);
                thumbHeight = (int)(unitDisplay * visibleAmount);
                double maxThumb = this.getNumberValue().doubleValue() + visibleAmount;
                if (maxThumb > this.getMaximumNumber().doubleValue()) {
                    thumbHeight = size.width - this.thumbBounds.x;
                }
                if (thumbHeight < this.getMinimumThumbHeight() && this.thumbBounds.x + (thumbHeight = this.getMinimumThumbHeight()) > size.width) {
                    this.thumbBounds.x = size.width - thumbHeight;
                }
                this.thumbBounds.width = thumbHeight;
                this.thumbBounds.height = size.height;
            }
        } else {
            double thumbPercent = visibleAmount / diff;
            double visDiff = diff - visibleAmount;
            double visDecrPercent = valueDiff / visDiff;
            int thumbHeight = 0;
            if (this.orientation == 1) {
                int minThumb;
                if (thumbPercent > 1.0) {
                    thumbPercent = 1.0;
                }
                if ((thumbHeight = (int)((double)size.height * thumbPercent)) < (minThumb = this.getMinimumThumbHeight())) {
                    thumbHeight = minThumb;
                }
                this.thumbBounds.height = thumbHeight;
                this.thumbBounds.width = size.width;
                this.thumbBounds.x = 0;
                this.thumbBounds.y = (int)((double)(size.height - thumbHeight) * visDecrPercent);
                if (this.thumbBounds.y < 0) {
                    this.thumbBounds.y = 0;
                } else if (this.thumbBounds.y + thumbHeight >= size.height) {
                    this.thumbBounds.y = size.height - thumbHeight;
                    this.allowIncrements = false;
                }
            } else {
                int minThumb;
                if (thumbPercent > 1.0) {
                    thumbPercent = 1.0;
                }
                if ((thumbHeight = (int)((double)size.width * thumbPercent)) < (minThumb = this.getMinimumThumbHeight())) {
                    thumbHeight = minThumb;
                }
                this.thumbBounds.width = thumbHeight;
                this.thumbBounds.height = size.height;
                this.thumbBounds.y = 0;
                this.thumbBounds.x = (int)((double)(size.width - thumbHeight) * visDecrPercent);
                if (this.thumbBounds.x < 0) {
                    this.thumbBounds.x = 0;
                } else if (this.thumbBounds.x + thumbHeight >= size.width) {
                    this.thumbBounds.x = size.width - thumbHeight;
                    this.allowIncrements = false;
                }
            }
        }
        if (this.orientation == 1) {
            this.checkTrackEnabled(this.thumbBounds.height, size.height);
            this.incrementBounds.height = size.height - (this.thumbBounds.y + this.thumbBounds.height);
            this.incrementBounds.y = this.thumbBounds.y + this.thumbBounds.height;
            this.incrementBounds.x = 0;
            this.incrementBounds.width = size.width;
            this.decrementBounds.height = this.thumbBounds.y;
            this.decrementBounds.y = 0;
            this.decrementBounds.x = 0;
            this.decrementBounds.width = size.width;
        } else {
            this.checkTrackEnabled(this.thumbBounds.width, size.width);
            this.incrementBounds.height = size.height;
            this.incrementBounds.width = size.width - (this.thumbBounds.x + this.thumbBounds.width);
            this.incrementBounds.y = 0;
            this.incrementBounds.x = size.width - this.incrementBounds.width;
            this.decrementBounds.height = size.height;
            this.decrementBounds.width = this.thumbBounds.x;
            this.decrementBounds.y = 0;
            this.decrementBounds.x = 0;
        }
        diffRect.add(this.thumbBounds);
        diffRect.grow(1, 1);
        this.validBounds = true;
        return diffRect;
    }

    protected void checkTrackEnabled(int thumbHeight, int sizeHeight) {
        if (thumbHeight >= sizeHeight) {
            this.setTrackEnabled(false);
        } else {
            this.setTrackEnabled(true);
        }
    }

    @Override
    public Rectangle getIncrementBounds() {
        if (this.incrementBounds == null) {
            this.layoutActionAreas();
        }
        return this.incrementBounds;
    }

    @Override
    public Rectangle getDecrementBounds() {
        if (this.decrementBounds == null) {
            this.layoutActionAreas();
        }
        return this.decrementBounds;
    }

    protected Rectangle getThumbBounds() {
        if (this.thumbBounds == null) {
            this.layoutActionAreas();
        }
        return this.thumbBounds;
    }

    @Override
    public Point getThumbPosition() {
        return new Point(this.thumbBounds.x, this.thumbBounds.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThumbPosition(Point pt) {
        try {
            double unitIncrement;
            this.thumbMove = true;
            Dimension size = this.getSize();
            Number oldNumberValue = this.getNumberValue();
            double minNumber = this.getMinimumNumber().doubleValue();
            double maxNumber = this.getMaximumNumber().doubleValue();
            double diff = maxNumber - minNumber;
            double visibleAmount = this.getVisibleAmountNumber().doubleValue();
            int thumbSize = this.thumbBounds.height;
            int sizeField = size.height;
            int point = pt.y;
            if (this.orientation == 0) {
                point = pt.x;
                sizeField = size.width;
                thumbSize = this.thumbBounds.width;
            }
            double newValue = 0.0;
            if (!this.isMaximumReachable()) {
                double adjustedMax;
                double visDiff = diff - visibleAmount;
                double thumbPercent = visibleAmount / diff;
                int thumbHeight = (int)((double)sizeField * thumbPercent);
                int minThumb = this.getMinimumThumbHeight();
                if (thumbHeight < minThumb) {
                    thumbHeight = minThumb;
                }
                if ((newValue = visDiff * (double)point / (double)(sizeField - thumbHeight) + minNumber) > (adjustedMax = maxNumber - visibleAmount)) {
                    newValue = adjustedMax;
                }
            } else {
                double unitIncrement2 = this.getUnitIncrementNumber().doubleValue();
                double adjustedDiff = diff + unitIncrement2;
                double unitDisplay = (double)sizeField / adjustedDiff;
                newValue = minNumber + (double)point / unitDisplay;
            }
            Number numberValue = new Double(newValue);
            if (this.roundNumberTransform != null) {
                try {
                    numberValue = (Number)this.roundNumberTransform.transform((Object)numberValue);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            Rectangle diffRect = new Rectangle(this.thumbBounds);
            boolean validValue = true;
            if (this.orientation == 0) {
                if (pt.x + this.thumbBounds.width > size.width) {
                    if (this.thumbBounds.x == size.width - this.thumbBounds.width) {
                        double value;
                        unitIncrement = 0.0;
                        if (this.isMaximumReachable()) {
                            unitIncrement = this.getUnitIncrementNumber().doubleValue();
                        }
                        if ((value = maxNumber - visibleAmount + unitIncrement) <= this.getNumberValue().doubleValue()) {
                            return;
                        }
                    }
                    this.thumbBounds.x = size.width - this.thumbBounds.width;
                    this.incrementBounds.x = this.thumbBounds.x + this.thumbBounds.width;
                    this.incrementBounds.width = 0;
                    this.decrementBounds.width = this.thumbBounds.x;
                    validValue = false;
                } else if (pt.x < 0) {
                    if (this.thumbBounds.x == 0) {
                        return;
                    }
                    this.thumbBounds.x = 0;
                    this.decrementBounds.width = 0;
                    this.incrementBounds.x = this.thumbBounds.width;
                    this.incrementBounds.width = size.width - this.thumbBounds.width;
                } else {
                    this.thumbBounds.x = pt.x;
                    this.incrementBounds.x = pt.x + this.thumbBounds.width;
                    this.incrementBounds.width = size.width - this.incrementBounds.y;
                    this.decrementBounds.width = pt.x;
                }
            } else if (pt.y + this.thumbBounds.height > size.height) {
                if (this.thumbBounds.y == size.height - this.thumbBounds.height) {
                    double value;
                    unitIncrement = 0.0;
                    if (this.isMaximumReachable()) {
                        unitIncrement = this.getUnitIncrementNumber().doubleValue();
                    }
                    if ((value = maxNumber - visibleAmount + unitIncrement) <= this.getNumberValue().doubleValue()) {
                        return;
                    }
                }
                this.thumbBounds.y = size.height - this.thumbBounds.height;
                this.incrementBounds.y = this.thumbBounds.y + this.thumbBounds.height;
                this.incrementBounds.height = 0;
                this.decrementBounds.height = this.thumbBounds.y;
                validValue = false;
            } else if (pt.y < 0) {
                if (this.thumbBounds.y == 0) {
                    return;
                }
                this.thumbBounds.y = 0;
                this.decrementBounds.height = 0;
                this.incrementBounds.y = this.thumbBounds.height;
                this.incrementBounds.height = size.height - this.thumbBounds.height;
            } else {
                this.thumbBounds.y = pt.y;
                this.incrementBounds.y = this.thumbBounds.y + this.thumbBounds.height;
                this.incrementBounds.height = size.height - this.incrementBounds.y;
                this.decrementBounds.height = this.thumbBounds.y;
            }
            diffRect.add(this.thumbBounds);
            diffRect.grow(1, 1);
            this.validBounds = true;
            this.repaint(diffRect.x, diffRect.y, diffRect.width, diffRect.height);
            if (!validValue) {
                unitIncrement = 0.0;
                if (this.isMaximumReachable()) {
                    unitIncrement = this.getUnitIncrementNumber().doubleValue();
                }
                numberValue = new Double(maxNumber - visibleAmount + unitIncrement);
            }
            this.setNumberValue(numberValue);
            if (!oldNumberValue.equals(this.getNumberValue())) {
                this.processEvent(new AdjustmentEvent(this, 601, 5, this.getValue()));
            }
        }
        finally {
            this.thumbMove = false;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "adjustmentL", this.adjustmentListener);
        s.writeObject(null);
    }
}

