/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;

class Rocket {
    public boolean sleep = true;
    private int energy;
    private int patch;
    private int length;
    private int mx;
    private int my;
    private int gravity;
    private int ox;
    private int oy;
    private int[] vx;
    private int[] vy;
    private int x;
    private int y;
    private int red;
    private int blue;
    private int green;
    private int t;
    private Random random;

    public Rocket(int a, int b, int g) {
        this.mx = a;
        this.my = b;
        this.gravity = g;
    }

    public void init(int e, int p, int l, long seed) {
        this.energy = e;
        this.patch = p;
        this.length = l;
        this.random = new Random(seed);
        this.vx = new int[this.patch];
        this.vy = new int[this.patch];
        this.red = (int)(this.random.nextDouble() * 128.0) + 128;
        this.blue = (int)(this.random.nextDouble() * 128.0) + 128;
        this.green = (int)(this.random.nextDouble() * 128.0) + 128;
        this.ox = (int)(Math.random() * (double)this.mx / 2.0) + this.mx / 4;
        this.oy = (int)(Math.random() * (double)this.my / 2.0) + this.my / 4;
        for (int i = 0; i < this.patch; ++i) {
            this.vx[i] = (int)(Math.random() * (double)this.energy) - this.energy / 2;
            this.vy[i] = (int)(Math.random() * (double)this.energy * 7.0 / 8.0) - this.energy / 8;
        }
    }

    public void start() {
        this.t = 0;
        this.sleep = false;
    }

    public void showRocket(Graphics g) {
        if (!this.sleep) {
            if (this.t < this.length) {
                int c = (int)(this.random.nextDouble() * 64.0) - 32 + this.red;
                if (c >= 0 && c < 256) {
                    this.red = c;
                }
                if ((c = (int)(this.random.nextDouble() * 64.0) - 32 + this.blue) >= 0 && c < 256) {
                    this.blue = c;
                }
                if ((c = (int)(this.random.nextDouble() * 64.0) - 32 + this.green) >= 0 && c < 256) {
                    this.green = c;
                }
                Color color = new Color(this.red, this.blue, this.green);
                Color prevColor = g.getColor();
                for (int i = 0; i < this.patch; ++i) {
                    double s = (double)this.t / 100.0;
                    this.x = (int)((double)this.vx[i] * s);
                    this.y = (int)((double)this.vy[i] * s - (double)this.gravity * s * s);
                    g.setColor(color);
                    g.drawLine(this.ox + this.x, this.oy - this.y, this.ox + this.x, this.oy - this.y);
                    if (this.t < this.length / 2) continue;
                    for (int j = 0; j < 2; ++j) {
                        s = (double)((this.t - this.length / 2) * 2 + j) / 100.0;
                        this.x = (int)((double)this.vx[i] * s);
                        this.y = (int)((double)this.vy[i] * s - (double)this.gravity * s * s);
                        g.setColor(prevColor);
                        int x1 = this.ox + this.x;
                        int y1 = this.oy - this.y;
                        int x2 = this.ox + this.x;
                        int y2 = this.oy - this.y;
                        g.drawLine(x1, y1, x2, y2);
                    }
                }
                ++this.t;
            } else {
                this.sleep = true;
            }
        }
    }
}

