/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.BaseButton;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.IconInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

public class RadioButtonIcon
implements IconInterface {
    static final long serialVersionUID = -7302021990471403191L;

    public Dimension getPreferredSize() {
        return new Dimension(11, 11);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        Color bg = comp.getBackground();
        boolean btnState = false;
        if (comp instanceof BaseButton) {
            ButtonModelInterface btnModel = ((BaseButton)comp).getButtonModel();
            btnState = btnModel.isSelected();
            if (btnModel.isPressed() || btnModel.isDisabled()) {
                g.setColor(bg);
            } else {
                g.setColor(SystemColor.window);
            }
        }
        g.fillRect(x + 2, y + 2, 8, 8);
        if (btnState) {
            if (!comp.isEnabled()) {
                g.setColor(bg.darker());
            } else {
                g.setColor(Color.black);
            }
            g.fillOval(x + 4, y + 4, 4, 4);
        }
        g.setColor(bg.darker());
        g.drawLine(x + 4, y, x + 7, y);
        g.drawLine(x + 2, y + 1, x + 3, y + 1);
        g.drawLine(x + 8, y + 1, x + 9, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 3);
        g.drawLine(x, y + 4, x, y + 7);
        g.drawLine(x + 1, y + 8, x + 1, y + 9);
        g.setColor(Color.white);
        g.drawLine(x + 2, y + 10, x + 3, y + 10);
        g.drawLine(x + 8, y + 10, x + 9, y + 10);
        g.drawLine(x + 4, y + 11, x + 7, y + 11);
        g.drawLine(x + 10, y + 9, x + 10, y + 8);
        g.drawLine(x + 10, y + 2, x + 10, y + 3);
        g.drawLine(x + 11, y + 4, x + 11, y + 7);
        g.setColor(Color.black);
        g.drawLine(x + 4, y + 1, x + 7, y + 1);
        g.drawLine(x + 2, y + 2, x + 3, y + 2);
        g.drawLine(x + 8, y + 2, x + 9, y + 2);
        g.drawLine(x + 2, y + 2, x + 2, y + 3);
        g.drawLine(x + 2, y + 8, x + 2, y + 8);
        g.drawLine(x + 1, y + 4, x + 1, y + 7);
        g.setColor(new Color(210, 210, 210));
        g.drawLine(x + 4, y + 10, x + 7, y + 10);
        g.drawLine(x + 2, y + 9, x + 3, y + 9);
        g.drawLine(x + 8, y + 9, x + 9, y + 9);
        g.drawLine(x + 9, y + 9, x + 9, y + 8);
        g.drawLine(x + 9, y + 3, x + 9, y + 3);
        g.drawLine(x + 10, y + 4, x + 10, y + 7);
        g.setColor(comp.getForeground());
    }
}

