/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.ContainerInterface;
import com.sas.awt.VisualInterface;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.InvalidElementTypeException;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.graphics.ElasticComponentList;
import com.sas.lang.StringDataInterface;
import com.sas.text.Message;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.RB;
import com.sas.visuals.RowColumnLayout;
import com.sas.visuals.SelectableInterface;
import com.sas.visuals.SelectionGroupInterface;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class RadioBox
extends CompositeContainer
implements PropertyChangeListener,
ItemSelectable,
ItemListener,
ContentsChangedListener,
ViewDefaultModelInterface,
StringDataInterface {
    static final long serialVersionUID = 5693952005539402541L;
    public static final String defaultSelectionGroupClass = "com.sas.visuals.SelectionGroup";
    public static final String defaultRadioButtonClass = "com.sas.visuals.RadioButton";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    static final String RB_KEY = "RadioBox.";
    protected transient boolean noPrevAdd;
    private transient Object prevSelectedItem;
    private transient int prevSelectedIndex;
    private transient Class radioButtonClass;
    private transient String selectedItem;
    private String radioButtonClassName;
    private SelectionGroupInterface radioGroup;
    private OrderedCollection defaultModel;
    private TransformInterface outputTransform;
    private TransformInterface inputTransform;
    private TransformInterface displayTransform;
    private transient ActionListener actionListener;
    private transient ItemListener itemListener;
    private transient boolean viewerInvoked;
    private transient boolean modelInvoked;
    private static int defaultHeight = 46;
    private static int defaultWidth = 124;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "deselectable"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"deselectableSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"deselectable.pd.txt")}}, {{"Name", "displayTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"displayTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "initialItems"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"initialItems.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"initialItems.pd.txt")}}, {{"Name", "inputTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"inputTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "layout"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"layoutSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"layout.pd.txt")}, {"Hidden", "false"}}, {{"Name", "outputTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"outputTransformSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "radioButtonClass"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"radioButtonClass.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"radioButtonClass.pd.txt")}, {"Expert", "true"}}, {{"Name", "selectionGroup"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"selectionGroup.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectionGroup.pd.txt")}, {"Hidden", "true"}}, {{"Name", "selectedIndex"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}}, {{"Name", "selectedItem"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public void addItem(Object item) {
        this.addItem(item, this.getComponentCount());
    }

    public void addItem(Object item, int index) {
        ModelInterface model = this.getModelInterface();
        if (model == null) {
            this.addModelItem(item, index);
        } else if (model instanceof OrderedCollectionInterface) {
            Object itemData = item;
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println(RB.getStringResource((String)RB_KEY, (String)"transformAddItem.ex.txt"));
                }
            }
            ((OrderedCollectionInterface)model).add(itemData, index);
        }
    }

    protected synchronized void addModelItem(Object item, int index) {
        try {
            SelectableInterface radioBtn;
            if (this.radioButtonClass == null) {
                this.radioButtonClass = GlobalInfoTable.loadClass((String)this.radioButtonClassName);
            }
            if ((radioBtn = (SelectableInterface)this.radioButtonClass.newInstance()) instanceof Component) {
                radioBtn.setItem(item);
                this.modelInvoked = true;
                this.add((Component)((Object)radioBtn), index);
                this.validate();
                this.repaint();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.add.ex.txt"));
        }
        catch (InstantiationException classInstantiationException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.add.ex.txt"));
        }
        catch (IllegalAccessException classIllegalAccessException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.add.ex.txt"));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof SelectableInterface) {
            try {
                if (!this.modelInvoked) {
                    Object compItem = ((SelectableInterface)((Object)comp)).getItem();
                    ModelInterface model = this.getModelInterface();
                    if (model != null && model instanceof OrderedCollectionInterface && compItem != null) {
                        this.viewerInvoked = true;
                        try {
                            if (index == -1) {
                                ((OrderedCollectionInterface)model).add(compItem);
                            }
                            ((OrderedCollectionInterface)model).add(compItem, index);
                        }
                        catch (ClassCastException e) {
                            System.out.println(Message.format((String)RB_KEY, (Object)"classCastException.addImpl.ex.txt", (Object)compItem, (Object)model));
                            this.modelInvoked = false;
                            return;
                        }
                    } else {
                        return;
                    }
                }
                comp.setBackground(this.getBackground());
                comp.setForeground(this.getForeground());
                super.addImpl(comp, constraints, index);
                if (comp instanceof ContainerInterface) {
                    ((ContainerInterface)((Object)comp)).setIDEDnDDropTarget(false);
                }
                if (index == -1) {
                    this.radioGroup.add((SelectableInterface)((Object)comp));
                } else {
                    this.radioGroup.add((SelectableInterface)((Object)comp), index);
                }
                ((SelectableInterface)((Object)comp)).setDisplayTransform(this.displayTransform);
                com.sas.beans.Util.addPropertyChangeListener((Object)comp, (PropertyChangeListener)this);
            }
            finally {
                this.modelInvoked = false;
            }
        } else {
            throw new InvalidElementTypeException();
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(ContentsChangedEvent evt) {
        try {
            OrderedCollectionInterface eSource = (OrderedCollectionInterface)evt.getSource();
            ModelInterface modelInterface = this.getModelInterface();
            if (eSource != modelInterface) {
                return;
            }
            if (modelInterface != null && !this.viewerInvoked) {
                OrderedCollectionInterface model = (OrderedCollectionInterface)modelInterface;
                if (evt instanceof CollectionChangedInfo) {
                    CollectionChangedInfo evtInfo = (CollectionChangedInfo)evt;
                    if (evtInfo.howChanged == HowChanged.ADDED) {
                        if (evtInfo.whatChanged != null) {
                            Object dItem = evtInfo.whatChanged;
                            this.addModelItem(dItem, evtInfo.start);
                        } else {
                            Enumeration modelE = model.getItems(evtInfo.start, evtInfo.end);
                            int position = evtInfo.start;
                            while (modelE.hasMoreElements()) {
                                Object dItem = modelE.nextElement();
                                this.addModelItem(dItem, position++);
                            }
                        }
                    } else if (evtInfo.howChanged == HowChanged.REMOVED) {
                        this.modelInvoked = true;
                        if (model.count() == 0) {
                            this.removeAll();
                        } else {
                            for (int i = evtInfo.end - 1; i >= evtInfo.start; --i) {
                                this.modelInvoked = true;
                                this.remove(i);
                            }
                        }
                    } else if (evtInfo.howChanged == HowChanged.REPLACED) {
                        this.modelInvoked = true;
                        Object obj = model.get(evtInfo.start);
                        ((SelectableInterface)this.radioGroup.get(evtInfo.start)).setItem(obj);
                    }
                } else {
                    int modelCount = model.count();
                    int componentCount = this.radioGroup.count();
                    int n = 0;
                    Enumeration groupE = this.radioGroup.getItems();
                    Enumeration modelE = model.getItems();
                    while (n < modelCount || n < componentCount) {
                        if (n < componentCount && n < modelCount) {
                            this.modelInvoked = true;
                            SelectableInterface sel = (SelectableInterface)groupE.nextElement();
                            Object item = modelE.nextElement();
                            sel.setItem(item);
                            ++n;
                            continue;
                        }
                        if (n < componentCount && n >= modelCount) {
                            this.modelInvoked = true;
                            this.remove(n);
                            componentCount = this.radioGroup.count();
                            continue;
                        }
                        if (n >= componentCount && n < modelCount) {
                            this.addModelItem(modelE.nextElement(), -1);
                            ++n;
                            continue;
                        }
                        ++n;
                    }
                }
            }
            this.firePropertyChange("", null, null);
            this.invalidate();
            this.validate();
        }
        finally {
            this.modelInvoked = false;
            this.viewerInvoked = false;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
    }

    @Override
    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation != 4) {
            return super.dragOver(point, representation, keyState, data);
        }
        try {
            Class selectableInterface = GlobalInfoTable.loadClass((String)"com.sas.visuals.SelectableInterface");
            Class dropElementClass = GlobalInfoTable.loadClass((String)((String)data.elementAt(0)));
            if (selectableInterface.isAssignableFrom(dropElementClass)) {
                ElasticComponentList.setDropSite(this);
                return 2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.dragOver.ex.txt"));
        }
        ElasticComponentList.setDropSite(null);
        return 4;
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    public String[] getInitialItems() {
        int i = 0;
        int modelCount = this.defaultModel.count();
        String[] items = new String[modelCount];
        Enumeration modelE = this.defaultModel.getItems();
        EnumerationTransform initialItemsE = new EnumerationTransform(modelE, this.outputTransform);
        while (initialItemsE.hasMoreElements()) {
            items[i++] = initialItemsE.nextElement().toString();
        }
        return items;
    }

    public synchronized void setInitialItems(String[] items) {
        int i = 0;
        int modelCount = this.defaultModel.count();
        if (items == null) {
            String[] stringArray = items;
        } else {
            int itemsCount = items.length;
            while (i < itemsCount || i < modelCount) {
                Object itemData = null;
                if (i < itemsCount) {
                    itemData = items[i];
                }
                if (this.inputTransform != null) {
                    try {
                        itemData = this.inputTransform.transform(itemData);
                    }
                    catch (TransformException te) {
                        System.out.println(RB.getStringResource((String)RB_KEY, (String)"transform.setInitialItems.ex.txt"));
                    }
                }
                if (i < modelCount) {
                    if (i < itemsCount) {
                        this.defaultModel.set(i, itemData);
                    } else {
                        this.defaultModel.removeAt(itemsCount);
                    }
                    ++i;
                    continue;
                }
                this.defaultModel.add(itemData, i++);
            }
        }
        ModelInterface model = this.getModelInterface();
        if (model == null || model != this.defaultModel) {
            this.detachModel(model);
        }
        this.firePropertyChange("initialItems", null, items);
    }

    public Object getItem(int index) {
        return this.radioGroup.getItem(index);
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    public Class getRadioButtonClass() {
        return this.radioButtonClass;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public SelectionGroupInterface getSelectionGroup() {
        return this.radioGroup;
    }

    public int getSelectedIndex() {
        return this.radioGroup.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.radioGroup.getSelectedItem();
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.radioGroup.getSelectedObjects();
    }

    public String getText() {
        Object textObject = this.getSelectedItem();
        if (textObject == null) {
            return null;
        }
        return textObject.toString();
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isDeselectable() {
        return this.radioGroup.isDeselectable();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isDesignTime() && this.noPrevAdd && this.getModelInterface() == this.defaultModel && this.defaultModel.count() == 0) {
            Message msg1 = new Message(RB.getResources(), "RadioBox.defaultLabel.txt", (Object)new Integer(1));
            Message msg2 = new Message(RB.getResources(), "RadioBox.defaultLabel.txt", (Object)new Integer(2));
            this.defaultModel.add((Object)msg1.toString());
            this.defaultModel.add((Object)msg2.toString());
        }
        this.noPrevAdd = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.radioGroup) {
            Object item = e.getItem();
            this.processEvent(new ItemEvent(this, 701, item, e.getStateChange()));
            if (item != null) {
                this.processEvent(new ActionEvent(this, 1001, item.toString()));
            } else {
                this.processEvent(new ActionEvent(this, 1001, null));
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        ModelInterface modelInterface;
        super.propertyChange(event);
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        if (eSource == this.radioGroup) {
            if (propName != null && propName.equals("selectedIndex")) {
                this.firePropertyChange("selectedIndex", event.getOldValue(), event.getNewValue());
            } else if (propName != null && propName.equals("selectedItem")) {
                this.firePropertyChange("selectedItem", event.getOldValue(), event.getNewValue());
            }
            this.firePropertyChange("selectionGroup", null, this.radioGroup);
        } else if (eSource == this.displayTransform) {
            this.firePropertyChange("displayTransform", null, this.displayTransform);
        } else if (eSource == this.inputTransform) {
            this.firePropertyChange("inputTransform", null, this.inputTransform);
        } else if (eSource == this.outputTransform) {
            this.firePropertyChange("outputTransform", null, this.outputTransform);
        } else if (!this.modelInvoked && eSource instanceof SelectableInterface && eSource instanceof Component && ((Component)eSource).getParent() == this && propName != null && propName.equals("item") && (modelInterface = this.getModelInterface()) != null) {
            Object oldItem = event.getOldValue();
            Object newItem = event.getNewValue();
            int index = ((StaticOrderedCollectionInterface)modelInterface).getIndex(oldItem, 0);
            if (index >= 0 && modelInterface instanceof OrderedCollectionInterface) {
                this.viewerInvoked = true;
                ((OrderedCollectionInterface)modelInterface).set(index, newItem);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        this.noPrevAdd = false;
        this.viewerInvoked = false;
        this.modelInvoked = false;
        if (this.radioGroup != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.radioGroup, (PropertyChangeListener)this);
        }
        if (this.displayTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)this);
        }
        if (this.inputTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)this);
        }
        if (this.outputTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)this);
        }
        this.setIDEDnDDropBarrier(true);
        this.setIDEDnDDropTarget(false);
        try {
            this.radioButtonClass = GlobalInfoTable.loadClass((String)this.radioButtonClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(RB.getStringResource((String)RB_KEY, (String)"classNotFound.radioButtonClass.ex.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            try {
                if (model instanceof OrderedCollectionInterface) {
                    ((OrderedCollectionInterface)model).addContentsChangedListener((ContentsChangedListener)this);
                }
                int modelCount = ((StaticOrderedCollectionInterface)model).count();
                int componentCount = this.radioGroup.count();
                int n = 0;
                Enumeration groupE = this.radioGroup.getItems();
                Enumeration modelE = ((StaticOrderedCollectionInterface)model).getItems();
                while (n < modelCount || n < componentCount) {
                    if (n < componentCount && n < modelCount) {
                        this.modelInvoked = true;
                        ((SelectableInterface)groupE.nextElement()).setItem(modelE.nextElement());
                        ++n;
                        continue;
                    }
                    if (n < componentCount && n >= modelCount) {
                        this.modelInvoked = true;
                        this.remove(n);
                        componentCount = this.radioGroup.count();
                        continue;
                    }
                    if (n >= componentCount && n < modelCount) {
                        this.addModelItem(modelE.nextElement(), -1);
                        ++n;
                        continue;
                    }
                    ++n;
                }
            }
            finally {
                this.modelInvoked = false;
                this.viewerInvoked = false;
            }
        }
    }

    @Override
    public synchronized void remove(int index) {
        try {
            ModelInterface model = this.getModelInterface();
            if (model == null || this.modelInvoked) {
                this.radioGroup.removeAt(index);
                super.remove(index);
                this.validate();
            } else if (model instanceof OrderedCollectionInterface) {
                this.viewerInvoked = true;
                ((OrderedCollectionInterface)model).removeAt(index);
            }
        }
        finally {
            this.modelInvoked = false;
        }
    }

    public synchronized void removeItem(Object item) {
        ModelInterface model = this.getModelInterface();
        if (model == null) {
            int index = this.radioGroup.getItemIndex(item);
            this.remove(index);
        } else if (model instanceof OrderedCollectionInterface) {
            Object itemData = item;
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println(RB.getStringResource((String)RB_KEY, (String)"transform.removeItem.ex.txt"));
                }
            }
            ((OrderedCollectionInterface)model).remove(itemData);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    @Override
    public synchronized void removeAll() {
        try {
            ModelInterface model = this.getModelInterface();
            if (model == null || this.modelInvoked) {
                this.radioGroup.removeAll();
                super.removeAll();
                this.validate();
            } else if (model instanceof OrderedCollectionInterface) {
                this.viewerInvoked = true;
                ((OrderedCollectionInterface)model).removeAll();
            }
        }
        finally {
            this.modelInvoked = false;
        }
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized void replaceItem(Object newItem, int index) {
        ModelInterface model = this.getModelInterface();
        if (model == null || this.modelInvoked) {
            SelectableInterface radioBtn = (SelectableInterface)this.radioGroup.get(index);
            radioBtn.setItem(newItem);
            this.validate();
        } else if (model instanceof OrderedCollectionInterface) {
            Object itemData = newItem;
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println(RB.getStringResource((String)RB_KEY, (String)"transform.replaceItem.ex.txt"));
                }
            }
            ((OrderedCollectionInterface)model).set(index, itemData);
        }
    }

    @Override
    public void setBackground(Color c) {
        if (c != this.getBackground()) {
            Color oldColor = this.getBackground();
            super.setBackground(c);
            Enumeration e = this.radioGroup.getItems();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                ((Component)comp).setBackground(c);
            }
            this.firePropertyChange("background", oldColor, c);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Util.setEnabledOnContainer(this, enabled);
    }

    @Override
    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            Color oldColor = this.getForeground();
            super.setForeground(c);
            Enumeration e = this.radioGroup.getItems();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                ((Component)comp).setForeground(c);
            }
            this.firePropertyChange("foreground", oldColor, c);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        try {
            Class selectionGroupClass = GlobalInfoTable.loadClass((String)defaultSelectionGroupClass);
            this.radioGroup = (SelectionGroupInterface)selectionGroupClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.setDefaultValues.ex.txt"));
        }
        catch (InstantiationException classInstantiationException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.setDefaultValues.ex.txt"));
        }
        catch (IllegalAccessException classIllegalAccessException) {
            com.sas.util.Util.println((String)RB.getStringResource((String)RB_KEY, (String)"classNotFound.setDefaultValues.ex.txt"));
        }
        this.noPrevAdd = true;
        this.viewerInvoked = false;
        this.modelInvoked = false;
        this.inputTransform = null;
        this.outputTransform = null;
        this.displayTransform = null;
        this.setIDEDnDDropBarrier(true);
        this.setIDEDnDDropTarget(false);
        this.radioButtonClassName = defaultRadioButtonClass;
        this.radioGroup.addItemListener(this);
        this.radioGroup.setDisplayTransform(this.displayTransform);
        this.radioGroup.setInputTransform(this.inputTransform);
        this.radioGroup.setOutputTransform(this.outputTransform);
        this.radioGroup.addPropertyChangeListener(this);
        super.setLayout((LayoutManager)new RowColumnLayout());
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    public void setDeselectable(boolean state) {
        if (this.isDeselectable() != state) {
            this.radioGroup.setDeselectable(state);
            this.firePropertyChange("deselectable", new Boolean(!state), new Boolean(state));
        }
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (transform != this.displayTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            if (this.displayTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)this);
            }
            this.radioGroup.setDisplayTransform(this.displayTransform);
            this.firePropertyChange("displayTransform", oldTransform, transform);
        }
    }

    public void setInputTransform(TransformInterface transform) {
        if (transform != this.inputTransform) {
            TransformInterface oldTransform = this.inputTransform;
            this.inputTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            if (this.inputTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)this);
            }
            this.radioGroup.setInputTransform(this.inputTransform);
            this.firePropertyChange("inputTransform", oldTransform, transform);
        }
    }

    public void setOutputTransform(TransformInterface transform) {
        if (transform != this.outputTransform) {
            TransformInterface oldTransform = this.outputTransform;
            this.outputTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)this);
            }
            if (this.outputTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)this);
            }
            this.radioGroup.setOutputTransform(this.outputTransform);
            this.firePropertyChange("outputTransform", oldTransform, transform);
        }
    }

    public void setRadioButtonClass(Class rClass) {
        if (rClass != null && rClass != this.radioButtonClass) {
            Class oldRadioButtonClass = this.radioButtonClass;
            try {
                Class selectableInterfaceClass = GlobalInfoTable.loadClass((String)"com.sas.visuals.SelectableInterface");
                Class<Component> componentClass = Component.class;
                if (!componentClass.isAssignableFrom(rClass) || !selectableInterfaceClass.isAssignableFrom(rClass)) {
                    return;
                }
                this.radioButtonClass = rClass;
                this.radioButtonClassName = this.radioButtonClass.getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(RB.getStringResource((String)RB_KEY, (String)"classNotFound.setRadioButtonClass.ex.txt"));
                return;
            }
            this.firePropertyChange("radioButtonClass", oldRadioButtonClass, this.radioButtonClass);
        }
    }

    public synchronized void setSelectionGroup(SelectionGroupInterface selectionGroup) {
        if (this.radioGroup != selectionGroup) {
            SelectionGroupInterface oldSelectionGroup = this.radioGroup;
            if (oldSelectionGroup != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldSelectionGroup, (PropertyChangeListener)this);
            }
            selectionGroup.setDisplayTransform(this.displayTransform);
            selectionGroup.setInputTransform(this.inputTransform);
            selectionGroup.setOutputTransform(this.outputTransform);
            int count = this.getComponentCount();
            for (int i = count - 1; i >= 0; --i) {
                SelectableInterface radioBtn = (SelectableInterface)this.radioGroup.get(i);
                selectionGroup.add(radioBtn);
            }
            this.radioGroup = selectionGroup;
            if (this.radioGroup != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.radioGroup, (PropertyChangeListener)this);
            }
            this.firePropertyChange("selectionGroup", oldSelectionGroup, this.radioGroup);
        }
    }

    public void setSelectedIndex(int index) {
        this.radioGroup.setSelectedIndex(index);
    }

    public void setSelectedItem(Object item) {
        this.radioGroup.setSelectedItem(item);
    }

    public void setText(String txt) {
        this.setSelectedItem(txt);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListener);
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    @Override
    public void setTransparent(boolean t) {
        if (t != this.isTransparent()) {
            boolean oldT = this.isTransparent();
            super.setTransparent(t);
            if (this.radioGroup != null) {
                Enumeration e = this.radioGroup.getItems();
                while (e.hasMoreElements()) {
                    Object comp = e.nextElement();
                    ((VisualInterface)comp).setTransparent(t);
                }
            }
            this.firePropertyChange("transparent", new Boolean(oldT), new Boolean(t));
        }
    }
}

