/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentException;
import com.sas.awt.Choice;
import com.sas.awt.Panel;
import com.sas.beans.ExtendedPropertyEditorInterface;
import com.sas.beans.Introspector;
import com.sas.beans.PropertyEditorBeanRequestor;
import com.sas.beans.PropertyEditorDescriptorRequestor;
import com.sas.beans.SwingCustomizerUtil;
import com.sas.graphics.IDEDnDManager;
import com.sas.swing.visuals.SwingCustomizerDialog;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SystemLog;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.MessageBox;
import com.sas.visuals.PEHostLabel;
import com.sas.visuals.PEHostTextField;
import com.sas.visuals.PropertyEditorPaintArea;
import com.sas.visuals.PushButton;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class PropertyEditorHost
extends Panel
implements ActionListener,
MouseListener,
FocusListener,
ItemListener,
PropertyChangeListener,
WindowListener,
ComponentListener {
    static final long serialVersionUID = 114027145874281113L;
    static int PAINT_AREA_SIZE = 18;
    protected Object bean;
    protected String property;
    protected int index;
    protected boolean indexed;
    protected boolean readOnly;
    protected boolean writeOnly;
    protected boolean masked;
    protected Object propertyValue;
    protected Class propertyType = null;
    protected PropertyEditor propertyEditor;
    protected PEHostLabel valueLabel;
    protected PEHostLabel editValueLabel;
    protected PEHostTextField textField;
    protected Choice choice;
    protected PropertyEditorPaintArea paintArea;
    protected PropertyEditorPaintArea editPaintArea;
    protected PushButton customButton;
    protected AutoSizingGridLayout layout;
    protected AutoSizingGridLayout editLayout;
    protected boolean alwaysShowControls = true;
    protected Window customEditorWindow;
    protected java.awt.Panel viewPanel;
    protected java.awt.Panel editPanel;
    protected boolean ignoreFocusLost = false;
    protected boolean dontSetFocus = false;
    protected int maximumValueFieldWidth = 512;
    protected String[] oldTags = new String[0];

    public PropertyEditorHost() {
        CardLayout cardLayout = new CardLayout();
        this.setLayout(cardLayout);
        this.layout = new AutoSizingGridLayout(1, 0);
        this.layout.setFillCell(true);
        this.layout.setUseColumnRemainder(true);
        this.layout.setRemainderColumn(1);
        this.layout.setUseRowRemainder(true);
        this.layout.setHgap(3);
        this.editLayout = new AutoSizingGridLayout(1, 0);
        this.editLayout.setFillCell(true);
        this.editLayout.setUseColumnRemainder(true);
        this.editLayout.setRemainderColumn(1);
        this.editLayout.setUseRowRemainder(true);
        this.editLayout.setHgap(3);
        this.viewPanel = new java.awt.Panel();
        this.viewPanel.setLayout((LayoutManager)this.layout);
        this.add((Component)this.viewPanel, "view");
        this.editPanel = new java.awt.Panel();
        this.editPanel.setLayout((LayoutManager)this.editLayout);
        this.add((Component)this.editPanel, "edit");
    }

    @Override
    public void initialize() {
        if (this.propertyEditor != null) {
            this.propertyEditor.addPropertyChangeListener(this);
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public int getMaximumValueFieldWidth() {
        return this.maximumValueFieldWidth;
    }

    public void setMaximumValueFieldWidth(int width) {
        this.maximumValueFieldWidth = width;
    }

    public boolean isAlwaysShowControls() {
        return this.alwaysShowControls;
    }

    public void setAlwaysShowControls(boolean show) {
        try {
            this.getToolkit().getSystemEventQueue();
            this.alwaysShowControls = show;
        }
        catch (Exception e) {
            this.alwaysShowControls = true;
        }
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.createControls();
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(this);
        }
    }

    public void setPropertyValue(Object value, Class propertyType) {
        this.propertyValue = value;
        this.bean = null;
        this.property = null;
        this.propertyType = propertyType;
        if (this.propertyEditor != null) {
            this.propertyEditor.removePropertyChangeListener(this);
        }
        this.propertyEditor = null;
        this.indexed = false;
        this.inspectProperty();
        this.createControls();
        this.setEnabled(this.isEnabled());
        if (this.propertyEditor != null) {
            this.propertyEditor.addPropertyChangeListener(this);
        }
    }

    public void setPropertyValue(Object value) {
        this.propertyValue = value;
    }

    public void setProperty(Object bean, String property) {
        this.bean = bean;
        this.property = property;
        if (this.propertyEditor != null) {
            this.propertyEditor.removePropertyChangeListener(this);
        }
        this.propertyEditor = null;
        this.propertyType = null;
        this.inspectProperty();
        this.createControls();
        if (this.propertyEditor != null) {
            this.propertyEditor.addPropertyChangeListener(this);
        }
    }

    public void setProperty(Object bean, String property, int index) {
        this.index = index;
        this.indexed = true;
        this.setProperty(bean, property);
    }

    protected void inspectProperty() {
        if (this.propertyType == null && this.bean != null) {
            if (this.indexed) {
                this.propertyValue = com.sas.beans.Util.getIndexedPropertyValue((Object)this.bean, (String)this.property, (int)this.index);
                this.propertyType = this.propertyValue != null ? this.propertyValue.getClass() : com.sas.beans.Util.getIndexedPropertyType((Object)this.bean, (String)this.property, (int)this.index);
            } else {
                try {
                    this.propertyValue = com.sas.beans.Util.getPropertyValue((Object)this.bean, (String)this.property);
                    if (this.propertyValue != null) {
                        this.propertyType = this.propertyValue.getClass();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.propertyType == null) {
                    this.propertyType = com.sas.beans.Util.getPropertyType((Object)this.bean, (String)this.property);
                }
            }
            Class propertyEditorClass = com.sas.beans.Util.getPropertyEditorClass((Object)this.bean, (String)this.property);
            if (propertyEditorClass != null) {
                try {
                    this.propertyEditor = (PropertyEditor)propertyEditorClass.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.propertyEditor == null) {
            this.propertyEditor = PropertyEditorManager.findEditor(this.propertyType);
            if (this.propertyEditor == null && this.bean != null) {
                this.propertyType = this.indexed ? com.sas.beans.Util.getIndexedPropertyType((Object)this.bean, (String)this.property, (int)this.index) : com.sas.beans.Util.getPropertyType((Object)this.bean, (String)this.property);
                this.propertyEditor = PropertyEditorManager.findEditor(this.propertyType);
            }
        }
        if (this.propertyEditor != null && this.propertyValue != null) {
            this.propertyEditor.setValue(this.propertyValue);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean != null ? this.bean.getClass() : this.propertyType);
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor((String)this.property, (BeanInfo)beanInfo);
            if (this.propertyEditor != null && propertyDescriptor != null && this.propertyEditor instanceof PropertyEditorDescriptorRequestor) {
                ((PropertyEditorDescriptorRequestor)this.propertyEditor).setPropertyDescriptor(propertyDescriptor);
            }
            this.masked = false;
            if (propertyDescriptor instanceof com.sas.beans.PropertyDescriptor) {
                this.masked = ((com.sas.beans.PropertyDescriptor)propertyDescriptor).isMasked();
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor pd = (IndexedPropertyDescriptor)propertyDescriptor;
                if (pd.getIndexedWriteMethod() == null) {
                    this.readOnly = true;
                }
                if (pd.getIndexedReadMethod() == null) {
                    this.writeOnly = true;
                }
            } else {
                if (propertyDescriptor.getWriteMethod() == null) {
                    this.readOnly = true;
                }
                if (propertyDescriptor.getReadMethod() == null) {
                    this.writeOnly = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.propertyEditor != null && this.bean != null && this.propertyEditor instanceof PropertyEditorBeanRequestor) {
            ((PropertyEditorBeanRequestor)this.propertyEditor).setBeanContainingProperty(this.bean);
        }
        if (this.propertyEditor != null && this.propertyEditor instanceof ExtendedPropertyEditorInterface && !((ExtendedPropertyEditorInterface)this.propertyEditor).isEditable()) {
            this.readOnly = true;
        }
    }

    protected void removeEventHandlers() {
        if (this.textField != null) {
            this.textField.removeActionListener(this);
            this.textField.removeFocusListener(this);
        }
        if (this.choice != null) {
            this.choice.removeItemListener(this);
            this.choice.removeFocusListener(this);
        }
        if (this.customButton != null) {
            this.customButton.removeActionListener(this);
            this.customButton.removeFocusListener(this);
        }
        if (this.valueLabel != null) {
            this.valueLabel.removeMouseListener(this);
        }
        if (this.editValueLabel != null) {
            this.editValueLabel.removeMouseListener(this);
        }
        if (this.paintArea != null) {
            this.paintArea.removeMouseListener(this);
        }
        if (this.editPaintArea != null) {
            this.editPaintArea.removeMouseListener(this);
        }
    }

    protected void createControls() {
        this.removeEventHandlers();
        this.textField = null;
        this.choice = null;
        this.oldTags = new String[0];
        this.paintArea = null;
        this.editPaintArea = null;
        this.customButton = null;
        this.valueLabel = null;
        this.editValueLabel = null;
        this.viewPanel.removeAll();
        this.editPanel.removeAll();
        this.layout.setRemainderColumn(1);
        this.editLayout.setRemainderColumn(1);
        if (this.propertyEditor == null || this.readOnly) {
            String labelText = this.propertyValue == null ? (this.writeOnly ? "[ write-only property ]" : "null") : (this.propertyEditor != null ? this.getLabelAsText() : (this.propertyValue instanceof String || this.propertyValue instanceof Boolean || this.propertyValue instanceof Number ? this.propertyValue.toString() : (this.propertyValue instanceof Class ? ((Class)this.propertyValue).getName() : "[ instance of " + this.propertyValue.getClass().getName() + " ]")));
            this.valueLabel = new PEHostLabel(labelText, this.maximumValueFieldWidth);
            this.valueLabel.initialize();
            this.valueLabel.setMasked(this.masked);
            this.valueLabel.setEnabled(false);
            this.viewPanel.add(this.valueLabel);
            this.editValueLabel = new PEHostLabel(labelText, this.maximumValueFieldWidth);
            this.editValueLabel.initialize();
            this.editValueLabel.setMasked(this.masked);
            this.editValueLabel.setEnabled(false);
            this.editPanel.add(this.editValueLabel);
            return;
        }
        if (this.propertyEditor.isPaintable()) {
            int paintWidth = PAINT_AREA_SIZE;
            if (this.getAsText() == null) {
                paintWidth = 100;
            }
            this.paintArea = new PropertyEditorPaintArea(this.propertyEditor, paintWidth, PAINT_AREA_SIZE);
            this.paintArea.initialize();
            this.paintArea.addMouseListener(this);
            this.viewPanel.add(this.paintArea);
            this.editPaintArea = new PropertyEditorPaintArea(this.propertyEditor, paintWidth, PAINT_AREA_SIZE);
            this.editPaintArea.initialize();
            this.editPaintArea.addMouseListener(this);
            this.editPanel.add(this.editPaintArea);
        }
        if (this.alwaysShowControls) {
            this.createEdittingControls();
            if (this.propertyEditor.supportsCustomEditor()) {
                this.customButton = new PushButton("...");
                this.editPanel.add(this.customButton);
                this.customButton.addActionListener(this);
            }
            ((CardLayout)this.getLayout()).show(this, "edit");
        } else {
            String valueText = "";
            valueText = this.getLabelAsText();
            if (valueText != null) {
                if (valueText == null) {
                    valueText = "";
                }
                this.valueLabel = new PEHostLabel(valueText, this.maximumValueFieldWidth);
                this.valueLabel.initialize();
                this.valueLabel.setMasked(this.masked);
                this.viewPanel.add(this.valueLabel);
                this.valueLabel.addMouseListener(this);
                if (this.paintArea != null) {
                    this.layout.setRemainderColumn(2);
                }
            }
        }
        this.validate();
        this.repaint();
    }

    protected String getLabelAsText() {
        if (this.writeOnly) {
            return "[ write-only property ]";
        }
        String text = this.propertyEditor.getAsText();
        return text;
    }

    protected String getAsText() {
        if (this.writeOnly) {
            return "";
        }
        String text = this.propertyEditor.getAsText();
        return text;
    }

    protected void readTags(String[] tags) {
        int i;
        boolean differentTags = false;
        if (this.oldTags != null && tags != null && this.oldTags.length == tags.length) {
            for (i = 0; i < this.oldTags.length; ++i) {
                if (!this.oldTags[i].equals(tags[i])) {
                    differentTags = true;
                }
                this.oldTags[i] = tags[i];
            }
            if (!differentTags) {
                return;
            }
        } else {
            this.oldTags = new String[tags.length];
            System.arraycopy(tags, 0, this.oldTags, 0, tags.length);
        }
        if (this.choice != null) {
            String text;
            this.choice.removeAll();
            if (tags != null) {
                for (i = 0; i < tags.length; ++i) {
                    this.choice.add(tags[i]);
                }
            }
            if ((text = this.getAsText()) != null) {
                this.choice.select(text);
            }
        }
    }

    protected void createEdittingControls() {
        String[] tags = this.propertyEditor.getTags();
        if (tags != null) {
            this.choice = new Choice();
            this.choice.initialize();
            this.readTags(tags);
            this.editPanel.add(this.choice);
            this.choice.addItemListener(this);
            this.choice.addFocusListener(this);
            if (this.editPaintArea != null) {
                this.editLayout.setRemainderColumn(2);
            }
        } else {
            String text = this.getAsText();
            if (text != null) {
                this.textField = new PEHostTextField(text, this.maximumValueFieldWidth);
                this.textField.initialize();
                this.textField.setMasked(this.masked);
                this.editPanel.add(this.textField);
                this.textField.addActionListener(this);
                this.textField.addFocusListener(this);
                if (this.editPaintArea != null) {
                    this.editLayout.setRemainderColumn(2);
                }
            }
        }
    }

    public void updateValue() {
        String text;
        if (this.propertyEditor == null) {
            return;
        }
        if (this.bean != null) {
            Object value;
            if (!this.indexed) {
                value = com.sas.beans.Util.getPropertyValue((Object)this.bean, (String)this.property);
                Object propertyEditorValue = this.propertyEditor.getValue();
                if ((propertyEditorValue != value || propertyEditorValue != null && !propertyEditorValue.equals(value)) && !this.writeOnly) {
                    this.propertyEditor.setValue(value);
                }
            } else {
                value = com.sas.beans.Util.getIndexedPropertyValue((Object)this.bean, (String)this.property, (int)this.index);
                Object propertyEditorValue = this.propertyEditor.getValue();
                if (propertyEditorValue != value || propertyEditorValue != null && !propertyEditorValue.equals(value)) {
                    this.propertyEditor.setValue(value);
                }
            }
        }
        if (this.choice != null && (text = this.getAsText()) != null) {
            this.choice.select(text);
        }
        if (this.textField != null) {
            this.textField.setText(this.getAsText());
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText(this.getLabelAsText());
        }
        if (this.editValueLabel != null) {
            this.editValueLabel.setText(this.getLabelAsText());
        }
        if (this.paintArea != null) {
            this.paintArea.repaint();
        }
        if (this.editPaintArea != null) {
            this.editPaintArea.repaint();
        }
    }

    public void handleException(Exception e) {
        this.handleException((Throwable)e);
    }

    public void handleException(Throwable e) {
        this.ignoreFocusLost = true;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        SystemLog.logException((String)("Unable to set property value for " + this.property), (Throwable)e);
        Frame frame = this.getContainingFrame();
        if (this.customButton != null) {
            this.customButton.getButtonModel().setArmed(false);
        }
        final MessageBox mb = new MessageBox(frame, "Note", true, "Unable to set value of property " + this.property + " : " + e.getClass() + " - " + e.getMessage(), 1, 1, 1);
        Util.centerOver((Window)mb, (Component)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mb.setVisible(true);
            }
        });
        this.updateValue();
        this.ignoreFocusLost = false;
    }

    public void updateTextValue() {
        if (this.propertyEditor == null || this.textField == null || this.textField.getPeer() == null) {
            return;
        }
        String oldText = this.getAsText();
        String text = this.textField.getText();
        if (oldText == null || text == null || !oldText.equals(text)) {
            try {
                this.propertyEditor.setAsText(text);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.textField) {
            if (this.editPaintArea != null) {
                this.editPaintArea.repaint();
            }
            this.updateTextValue();
        } else if (evt.getSource() == this.customButton) {
            this.customButton.setEnabled(false);
            this.showCustomEditor();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.choice) {
            String text = this.choice.getSelectedItem();
            try {
                this.propertyEditor.setAsText(text);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
        if (this.editPaintArea != null) {
            this.editPaintArea.invalidate();
            this.editPaintArea.repaint();
        }
        this.readTags(this.propertyEditor.getTags());
    }

    public void showCustomEditor() {
        SwingCustomizerDialog dialog;
        Component customEditor = this.propertyEditor.getCustomEditor();
        if (customEditor instanceof Window) {
            this.customEditorWindow = (Window)customEditor;
        } else if (customEditor != null && (dialog = SwingCustomizerUtil.getCustomizerDialog(this.propertyEditor.getValue(), customEditor, this.getContainingFrame())) != null) {
            dialog.setModal(true);
            this.customEditorWindow = dialog;
            Dimension prefSize = customEditor.getPreferredSize();
            Dimension curSize = this.customEditorWindow.getSize();
            Dimension newSize = new Dimension();
            newSize.width = Math.max(curSize.width, prefSize.width);
            newSize.height = Math.max(curSize.height, prefSize.height);
            this.customEditorWindow.setSize(newSize);
        }
        if (this.customEditorWindow == null) {
            this.handleException((Exception)new ComponentException("Unable to create custom editor"));
            return;
        }
        this.customEditorWindow.addWindowListener(this);
        Util.centerOverWindow((Window)this.customEditorWindow, (Component)this);
        IDEDnDManager.suspend(this.getContainingFrame());
        this.customEditorWindow.setVisible(true);
        IDEDnDManager.resume(this.getContainingFrame());
    }

    protected Frame getContainingFrame() {
        Container component;
        for (component = this; component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        if (component == null) {
            component = new Frame();
        }
        return (Frame)component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.propertyEditor && e.getPropertyName() == null) {
            String text;
            if (this.valueLabel != null) {
                text = this.getLabelAsText();
                this.valueLabel.setText(text);
            }
            if (this.textField != null) {
                text = this.getAsText();
                this.textField.setText(text);
            }
            if (this.choice != null) {
                this.readTags(this.propertyEditor.getTags());
                text = this.getAsText();
                this.choice.setSelectedItem(text);
            }
            if (this.paintArea != null) {
                this.paintArea.invalidate();
                this.paintArea.repaint();
            }
            if (this.editPaintArea != null) {
                this.editPaintArea.invalidate();
                this.editPaintArea.repaint();
            }
            this.firePropertyChange(null, null, this.propertyEditor.getValue());
        } else if (e.getSource() == this.bean && e.getPropertyName().equals(this.property)) {
            this.updateValue();
        }
    }

    @Override
    public void windowOpened(WindowEvent evt) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        if (parentWindow != null) {
            Util.centerOver((Window)this.customEditorWindow, (Component)parentWindow);
        } else {
            Util.centerOverWindow((Window)this.customEditorWindow, (Component)this);
        }
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.windowClosed(evt);
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        if (this.customEditorWindow != null && evt.getSource() == this.customEditorWindow) {
            this.customEditorWindow.dispose();
            this.customEditorWindow = null;
            if (this.customButton != null) {
                this.customButton.setEnabled(true);
                this.customButton.requestFocus();
                this.updateValue();
            }
        }
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (evt.getSource() == this) {
            this.mousePressed(null);
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (this.ignoreFocusLost) {
            return;
        }
        if (this.editPaintArea != null) {
            this.editPaintArea.repaint();
        }
        this.updateTextValue();
        if (this.alwaysShowControls) {
            return;
        }
        AWTEvent nextEvent = this.getToolkit().getSystemEventQueue().peekEvent(1004);
        Component focusOwner = null;
        if (nextEvent != null) {
            focusOwner = (Component)nextEvent.getSource();
        }
        if (focusOwner != null && focusOwner == this) {
            this.dontSetFocus = true;
            return;
        }
        if (focusOwner != null && (focusOwner == this.textField || focusOwner == this.choice || focusOwner == this.customButton || focusOwner == this.customEditorWindow)) {
            this.dontSetFocus = false;
            return;
        }
        ((CardLayout)this.getLayout()).show(this, "view");
        this.firePropertyChange("_focus", null, Boolean.FALSE);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.firePropertyChange("_focus", null, Boolean.TRUE);
        if (this.valueLabel != null && !this.valueLabel.isEnabled()) {
            return;
        }
        if (!this.alwaysShowControls) {
            if (this.textField == null && this.choice == null && this.getAsText() != null) {
                this.createEdittingControls();
            }
            if (this.customButton == null && this.propertyEditor.supportsCustomEditor()) {
                this.customButton = new PushButton("...");
                this.editPanel.add(this.customButton);
                if (this.textField == null && this.choice == null) {
                    this.customButton.requestFocus();
                }
                this.customButton.addActionListener(this);
                this.customButton.addFocusListener(this);
            }
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
            ((CardLayout)this.getLayout()).show(this, "edit");
        }
        if (!this.dontSetFocus) {
            if (this.textField != null) {
                this.textField.requestFocus();
            }
            if (this.choice != null) {
                this.choice.requestFocus();
            }
        } else {
            this.dontSetFocus = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public boolean isFocusTraversable() {
        if (this.valueLabel != null) {
            return this.valueLabel.isEnabled();
        }
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addFocusListener(this);
        this.enableSubcomponents(this.isEnabled());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    @Override
    public void componentResized(ComponentEvent evt) {
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }

    protected void enableSubcomponents(boolean enabled) {
        if (!enabled) {
            if (this.valueLabel != null) {
                this.valueLabel.setEnabled(enabled);
            }
            if (this.editValueLabel != null) {
                this.editValueLabel.setEnabled(enabled);
            }
            if (this.textField != null) {
                this.textField.setEnabled(enabled);
            }
            if (this.choice != null) {
                this.choice.setEnabled(enabled);
            }
        } else {
            if (this.valueLabel != null) {
                this.valueLabel.setEnabled(!this.readOnly);
            }
            if (this.editValueLabel != null) {
                this.editValueLabel.setEnabled(!this.readOnly);
            }
            if (this.textField != null) {
                this.textField.setEnabled(!this.readOnly);
            }
            if (this.choice != null) {
                this.choice.setEnabled(!this.readOnly);
            }
        }
        if (this.customButton != null) {
            this.customButton.setEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableSubcomponents(enabled);
    }

    static {
        com.sas.beans.Util.prependToPropertyEditorSearchPath((String)"com.sas.beans.editors");
    }
}

