/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Container;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ImageView;
import com.sas.visuals.SelectionGroup;
import com.sas.visuals.ToggleButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class OrientationSelector
extends Container
implements ItemListener {
    protected int indexSelected;
    protected int orientationValue;
    SelectionGroup defaultGroup;
    ToggleButton dg1;
    ToggleButton dg2;
    ToggleButton dg3;
    ToggleButton dg4;
    ToggleButton dg5;
    ToggleButton dg6;
    ToggleButton dg7;
    ToggleButton dg8;
    ToggleButton dg9;
    Vector dg;
    com.sas.awt.Color defaultColor;

    public OrientationSelector() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 3, 0, 0, false, false, false);
        layout.setUseRowRemainder(false);
        layout.setUseColumnRemainder(false);
        this.setLayout((LayoutManager)layout);
        this.setInsets(new Insets(5, 35, 5, 35));
        this.dg1 = new ToggleButton();
        this.dg1.initialize();
        this.dg2 = new ToggleButton();
        this.dg2.initialize();
        this.dg3 = new ToggleButton();
        this.dg3.initialize();
        this.dg4 = new ToggleButton();
        this.dg4.initialize();
        this.dg5 = new ToggleButton();
        this.dg5.initialize();
        this.dg6 = new ToggleButton();
        this.dg6.initialize();
        this.dg7 = new ToggleButton();
        this.dg7.initialize();
        this.dg8 = new ToggleButton();
        this.dg8.initialize();
        this.dg9 = new ToggleButton();
        this.dg9.initialize();
        this.defaultGroup = new SelectionGroup();
        this.defaultGroup.initialize();
        this.defaultGroup.addItemListener(this);
        this.defaultGroup.add(this.dg1);
        this.defaultGroup.add(this.dg2);
        this.defaultGroup.add(this.dg3);
        this.defaultGroup.add(this.dg4);
        this.defaultGroup.add(this.dg5);
        this.defaultGroup.add(this.dg6);
        this.defaultGroup.add(this.dg7);
        this.defaultGroup.add(this.dg8);
        this.defaultGroup.add(this.dg9);
        this.dg = new Vector();
        this.dg.addElement(this.dg1);
        this.dg.addElement(this.dg2);
        this.dg.addElement(this.dg3);
        this.dg.addElement(this.dg4);
        this.dg.addElement(this.dg5);
        this.dg.addElement(this.dg6);
        this.dg.addElement(this.dg7);
        this.dg.addElement(this.dg8);
        this.dg.addElement(this.dg9);
        ImageView image = new ImageView();
        image.setPreferredSize(new Dimension(20, 20));
        for (int i = 0; i < this.dg.size(); ++i) {
            ((ToggleButton)this.dg.elementAt(i)).setPreferredSize(new Dimension(20, 20));
            ((ToggleButton)this.dg.elementAt(i)).setBorder(new BaseBorder(3));
            ((ToggleButton)this.dg.elementAt(i)).setFocusPainted(true);
        }
        ((ToggleButton)this.dg.elementAt(this.indexSelected)).setBackgroundColor((Color)new com.sas.awt.Color("cyan"));
        this.add(this.dg1);
        this.add(this.dg2);
        this.add(this.dg3);
        this.add(this.dg4);
        this.add(this.dg5);
        this.add(this.dg6);
        this.add(this.dg7);
        this.add(this.dg8);
        this.add(this.dg9);
        this.indexSelected = 0;
        this.orientationValue = 5;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.defaultGroup) {
            this.setOrientationValue(this.indexToOrientation(this.defaultGroup.getSelectedIndex()));
            this.setIndexSelected(this.defaultGroup.getSelectedIndex());
            for (int i = 0; i < this.dg.size(); ++i) {
                if (this.indexSelected != i) {
                    ((ToggleButton)this.dg.elementAt(i)).setBackgroundColor((Color)new com.sas.awt.Color("lightGray"));
                    continue;
                }
                ((ToggleButton)this.dg.elementAt(i)).setBackgroundColor((Color)new com.sas.awt.Color("cyan"));
            }
        }
    }

    public int orientationToIndex(int orient) {
        switch (orient) {
            case 5: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 256: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 10: {
                return 8;
            }
        }
        return 0;
    }

    public int indexToOrientation(int index) {
        switch (index) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 256;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 10;
            }
        }
        return 5;
    }

    public boolean isValidOrientation(int orient) {
        switch (orient) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 256: {
                return true;
            }
        }
        return false;
    }

    public int getIndexSelected() {
        return this.indexSelected;
    }

    public void setIndexSelected(int in) {
        this.indexSelected = in;
    }

    public int getOrientationValue() {
        return this.orientationValue;
    }

    public void setOrientationValue(int in) {
        int oldValue = this.orientationValue;
        if (this.isValidOrientation(in)) {
            if (oldValue != in) {
                this.orientationValue = in;
                this.firePropertyChange("orientationValue", null, new Integer(this.orientationValue));
                this.defaultGroup.setSelectedIndex(this.orientationToIndex(this.orientationValue));
            }
        } else {
            throw new IllegalArgumentException("invalid orientation value");
        }
    }
}

