/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.ButtonDialog;
import com.sas.visuals.ButtonPanel;
import com.sas.visuals.PushButton;
import com.sas.visuals.RB;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class OkCancelHelpDialog
extends ButtonDialog
implements ActionListener {
    static String RB_KEY = "OkCancelHelpDialog.";
    public static String CLOSE = "Close";
    public static String CANCEL = "Cancel";
    public static String HELP = "Help";
    private boolean validatorUsed;
    private transient boolean wasCancelled;

    public OkCancelHelpDialog(Frame frame) {
        super(frame, new String[][]{{RB.getStringResource((String)RB_KEY, (String)"okButton.txt"), CLOSE}, {RB.getStringResource((String)RB_KEY, (String)"cancelButton.txt"), CANCEL}, {RB.getStringResource((String)RB_KEY, (String)"helpButton.txt"), HELP}});
        this.init();
    }

    public OkCancelHelpDialog(Frame frame, String title) {
        super(frame, title, new String[][]{{RB.getStringResource((String)RB_KEY, (String)"okButton.txt"), CLOSE}, {RB.getStringResource((String)RB_KEY, (String)"cancelButton.txt"), CANCEL}, {RB.getStringResource((String)RB_KEY, (String)"helpButton.txt"), HELP}});
        this.init();
    }

    private void init() {
        PushButton okButton = this.getButtonPanel().getButton(RB.getStringResource((String)RB_KEY, (String)"okButton.txt"));
        PushButton cancelButton = this.getButtonPanel().getButton(RB.getStringResource((String)RB_KEY, (String)"cancelButton.txt"));
        PushButton helpButton = this.getButtonPanel().getButton(RB.getStringResource((String)RB_KEY, (String)"helpButton.txt"));
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        helpButton.addActionListener(this);
        helpButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != null) {
            if (e.getActionCommand().equals(CLOSE)) {
                this.close();
            } else if (e.getActionCommand().equals(CANCEL)) {
                this.cancel();
            } else if (e.getActionCommand().equals(HELP)) {
                this.help();
            }
        }
    }

    public boolean isValidateBeforeClosing() {
        return this.validatorUsed;
    }

    public void setValidateBeforeClosing(boolean checkValidator) {
        if (this.validatorUsed != checkValidator) {
            this.validatorUsed = checkValidator;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"validateBeforeClosing", (boolean)this.validatorUsed);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        ValidationInterface validator;
        if (!visible && this.validatorUsed && !this.wasCancelled && (validator = this.getValidator()) != null && !validator.validateValue((Object)this, null)) {
            return;
        }
        if (visible) {
            this.wasCancelled = false;
        }
        super.setVisible(visible);
    }

    protected void close() {
        this.setVisible(false);
    }

    protected void cancel() {
        this.wasCancelled = true;
        this.setVisible(false);
    }

    protected void help() {
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        boolean cancelVisible;
        ButtonPanel btnPanel = this.getButtonPanel();
        PushButton okButton = btnPanel.getButtonFromActionCommand(CLOSE);
        PushButton cancelButton = btnPanel.getButtonFromActionCommand(CANCEL);
        PushButton helpButton = btnPanel.getButtonFromActionCommand(HELP);
        boolean bl = cancelVisible = cancelButton.getParent() != null && cancelButton.isVisible();
        if (cancelVisible) {
            this.cancel();
        } else {
            this.close();
        }
    }
}

