/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.beans.PropertyChangeListenerList;
import com.sas.beans.PropertyChangeSource;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.models.MutableNodeInterface;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticNodeStyleInterface;
import com.sas.table.FontStyle;
import com.sas.text.Message;
import com.sas.util.AbstractCommand;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.Util;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.IconInterface;
import com.sas.visuals.NodeState;
import com.sas.visuals.NodeViewTextEditor;
import com.sas.visuals.RB;
import com.sas.visuals.TreeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;

public class NodeView
implements CommandsInterface,
NodeIconInterface,
PropertyChangeListener,
PropertyChangeSource {
    public static final String RB_KEY = "NodeView.";
    public static final String NODE_EDITING_ERROR = "Node Editing Error";
    private transient OrderedCollection children = null;
    transient int depth = -1;
    transient boolean expandable = false;
    transient NodeInterface nodeData = null;
    transient NodeView parent = null;
    transient String nodeText = null;
    transient String nodeExpandedText = null;
    transient String nodeType = null;
    transient int visibleNodeCount = 1;
    transient IconInterface defaultIcon = null;
    transient IconInterface selectedIcon = null;
    transient IconInterface expandedIcon = null;
    transient IconInterface expandedSelectedIcon = null;
    transient int nodeChildCount;
    transient TreeView treeView;
    private transient PropertyChangeListenerList allPropertyChangeListeners;
    private transient OrderedCollection tempCollection;
    transient Rectangle _tempRect = new Rectangle();
    transient int _x;
    transient int _y;
    transient int _width;
    transient int _height;
    transient boolean _resized;
    transient PropertyBagInterface _nodeStyle;
    transient PropertyBagInterface _defaultNodeStyle;
    transient PropertyBagListener _pbagListener;
    transient StaticPropertyBagInterface _modelNodeStyle;
    transient StaticPropertyBagInterface _modelDefaultNodeStyle;
    transient String[] _nodeTypes;
    private transient int _internalCount;
    private transient Dimension _effectiveImageSize;
    private static final FontStyle _fontStyle = new FontStyle();
    private static RenameNode _renameNode;
    transient int _flags;
    private static final int NV_EXPANDED = 1;
    private static final int NV_SELECTED = 2;
    private static final int NV_REQUERY_LEAF_NODE = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeView(TreeView treeView, NodeInterface node) {
        if (node == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullNodeInterface.ex.txt"));
        }
        this.treeView = treeView;
        NodeInterface nodeInterface = node;
        synchronized (nodeInterface) {
            this.nodeData = node;
            this.expandable = !node.isLeafNode();
            this.nodeChildCount = -2;
            this.depth = 0;
            this.nodeText = node.getNodeText();
            this.nodeExpandedText = node.getNodeExpandedText();
            this.nodeType = node.getNodeType();
            if (this.nodeText != null) {
                this.nodeText = this.nodeText.trim();
            }
            if (this.nodeExpandedText != null) {
                this.nodeExpandedText = this.nodeExpandedText.trim();
            }
            if (this.nodeType != null) {
                this.nodeType = this.nodeType.trim();
            }
            if (node instanceof NodeIconInterface) {
                NodeIconInterface nodeIcon = (NodeIconInterface)node;
                this.defaultIcon = nodeIcon.getDefaultIcon();
                this.selectedIcon = nodeIcon.getSelectedIcon();
                this.expandedIcon = nodeIcon.getExpandedIcon();
                this.expandedSelectedIcon = nodeIcon.getExpandedSelectedIcon();
            }
            if (node instanceof StaticNodeStyleInterface) {
                this.setModelStyle(((StaticNodeStyleInterface)node).getNodeStyle());
                this.setModelDefaultStyle(((StaticNodeStyleInterface)node).getDefaultNodeStyle());
                this._nodeTypes = ((StaticNodeStyleInterface)node).getNodeTypes();
            }
            com.sas.beans.Util.addPropertyChangeListener((Object)node, (PropertyChangeListener)this);
        }
        this._resized = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners == null) {
            this.allPropertyChangeListeners = new PropertyChangeListenerList();
        }
        this.allPropertyChangeListeners.add(listener);
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.nodeData.countNodeChildren(maximumChildCount);
    }

    public Command[] getCommands() {
        Command[] commands = null;
        if (this.nodeData instanceof CommandsInterface) {
            commands = ((CommandsInterface)this.nodeData).getCommands();
        }
        if (!this.isEditable()) {
            return commands;
        }
        if (_renameNode == null) {
            _renameNode = new RenameNode();
        }
        NodeView._renameNode._node = this;
        if (commands != null) {
            Command[] tempCommands = new Command[commands.length + 2];
            for (Command tempCommands[i] : commands) {
            }
            tempCommands[tempCommands.length - 2] = MenuSeparatorCommand.instance();
            tempCommands[tempCommands.length - 1] = _renameNode;
            return tempCommands;
        }
        return new Command[]{_renameNode};
    }

    public IconInterface getDefaultIcon() {
        if (this.getNodeStyle() != null) {
            IconInterface icon = (IconInterface)this.getNodeStyle().get("defaultIcon", (Object)this.defaultIcon);
            if (icon != null) {
                return icon;
            }
        } else if (this.defaultIcon != null) {
            return this.defaultIcon;
        }
        return (IconInterface)this.getEffectiveStylePropertyValue("defaultIcon", null);
    }

    public PropertyBagInterface getDefaultNodeStyle() {
        return this._defaultNodeStyle;
    }

    public int getDepth() {
        return this.depth;
    }

    public IconInterface getExpandedIcon() {
        IconInterface icon;
        if (this.getNodeStyle() != null) {
            icon = (IconInterface)this.getNodeStyle().get("expandedIcon", (Object)this.expandedIcon);
            if (icon != null) {
                return icon;
            }
        } else if (this.expandedIcon != null) {
            return this.expandedIcon;
        }
        if ((icon = (IconInterface)this.getEffectiveStylePropertyValue("expandedIcon", null)) != null) {
            return icon;
        }
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        IconInterface icon;
        if (this.getNodeStyle() != null) {
            icon = (IconInterface)this.getNodeStyle().get("expandedSelectedIcon", (Object)this.expandedSelectedIcon);
            if (icon != null) {
                return icon;
            }
        } else if (this.expandedSelectedIcon != null) {
            return this.expandedSelectedIcon;
        }
        if ((icon = (IconInterface)this.getEffectiveStylePropertyValue("expandedSelectedIcon", null)) != null) {
            return icon;
        }
        return this.getExpandedIcon();
    }

    public int getIndex(NodeView childNode, int startIndex) {
        return this.children == null ? -1 : this.children.getIndex((Object)childNode, startIndex);
    }

    public NodeView getNextSibling() {
        if (this.parent != null) {
            int index = this.parent.getIndex(this, 0);
            if (index != -1 && (index + 1 < this.parent.getNodeChildCount() || this.parent.getNodeChildCount() == -1)) {
                return (NodeView)this.parent.getNodeChild(index + 1);
            }
            return null;
        }
        return null;
    }

    public NodeInterface getNode() {
        return this.nodeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleNodeInterface getNodeChild(int index) {
        if (this.modelIsLeafNode()) {
            return null;
        }
        NodeInterface nodeInterface = this.nodeData;
        synchronized (nodeInterface) {
            SimpleNodeInterface[] sni = null;
            if (this.children == null) {
                SimpleNodeInterface[] simpleNodeInterfaceArray;
                if (index == 0) {
                    SimpleNodeInterface[] simpleNodeInterfaceArray2 = new SimpleNodeInterface[1];
                    simpleNodeInterfaceArray = simpleNodeInterfaceArray2;
                    simpleNodeInterfaceArray2[0] = this.nodeData.getNodeChild(0);
                } else {
                    simpleNodeInterfaceArray = this.nodeData.getNodeChildren(0, index + 1);
                }
                sni = simpleNodeInterfaceArray;
            } else if (index >= this.children.count() && (this._internalCount == -1 || this._internalCount == -2)) {
                SimpleNodeInterface[] simpleNodeInterfaceArray;
                int cnt = this.children.count();
                int amount = index + 1 - cnt;
                if (amount == 1) {
                    SimpleNodeInterface[] simpleNodeInterfaceArray3 = new SimpleNodeInterface[1];
                    simpleNodeInterfaceArray = simpleNodeInterfaceArray3;
                    simpleNodeInterfaceArray3[0] = this.nodeData.getNodeChild(cnt);
                } else {
                    simpleNodeInterfaceArray = this.nodeData.getNodeChildren(cnt, amount);
                }
                sni = simpleNodeInterfaceArray;
            } else if (this._internalCount != -1 && this._internalCount != -2 && index >= this._internalCount) {
                return null;
            }
            if (!(this.children != null && this.children.count() > index || this.internalSetChildren(sni) || sni == null || sni.length != 1)) {
                return null;
            }
        }
        return this.children == null ? null : (NodeView)this.children.get(index);
    }

    public int getNodeChildCount() {
        if (this.nodeChildCount == -2) {
            this.nodeChildCount = this.nodeData.getNodeChildCount();
            this._internalCount = this.nodeChildCount == -1 ? -1 : -2;
        }
        return this.nodeChildCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        if (this.modelIsLeafNode()) {
            return null;
        }
        this.getNodeChildCount();
        NodeInterface nodeInterface = this.nodeData;
        synchronized (nodeInterface) {
            if (this.children == null) {
                SimpleNodeInterface[] sni = this.nodeData.getNodeChildren(0, startIndex + count);
                if (this.children == null || this.children.count() <= startIndex + count) {
                    this.internalSetChildren(sni);
                }
            } else if (startIndex + count > this.children.count() && this._internalCount != -1) {
                int cnt = this.children.count();
                SimpleNodeInterface[] sni = this.nodeData.getNodeChildren(cnt, startIndex + count - cnt);
                if (this.children.count() <= startIndex + count) {
                    this.internalSetChildren(sni);
                }
            }
            if (this.children == null && this._internalCount != -2) {
                return new SimpleNodeInterface[0];
            }
            if (this.children != null && startIndex + count > this.children.count() && this._internalCount != -2) {
                if (startIndex < this.children.count()) {
                    return this.internalGetChildren(startIndex, this.children.count() - startIndex);
                }
                return new SimpleNodeInterface[0];
            }
            return this.internalGetChildren(startIndex, count);
        }
    }

    public String getNodeExpandedText() {
        if (this.nodeExpandedText == null && this.nodeData != null) {
            this.nodeExpandedText = this.nodeData.getNodeExpandedText();
            if (this.nodeExpandedText != null) {
                this.nodeExpandedText = this.nodeExpandedText.trim();
            }
        }
        return this.nodeExpandedText;
    }

    public PropertyBagInterface getNodeStyle() {
        return this._nodeStyle;
    }

    public String getNodeText() {
        if (this.nodeText == null && this.nodeData != null) {
            this.nodeText = this.nodeData.getNodeText();
            if (this.nodeText != null) {
                this.nodeText = this.nodeText.trim();
            }
        }
        return this.nodeText;
    }

    public String getNodeType() {
        if (this.nodeType == null && this.nodeData != null) {
            this.nodeType = this.nodeData.getNodeType();
            if (this.nodeType != null) {
                this.nodeType = this.nodeType.trim();
            }
        }
        return this.nodeType;
    }

    public NodeView getParent() {
        return this.parent;
    }

    public NodeView getPreviousSibling() {
        int index;
        if (this.parent != null && (index = this.parent.getIndex(this, 0)) > 0) {
            return (NodeView)this.parent.getNodeChild(index - 1);
        }
        return null;
    }

    public IconInterface getSelectedIcon() {
        IconInterface icon;
        if (this.getNodeStyle() != null) {
            icon = (IconInterface)this.getNodeStyle().get("selectedIcon", (Object)this.selectedIcon);
            if (icon != null) {
                return icon;
            }
        } else if (this.selectedIcon != null) {
            return this.selectedIcon;
        }
        if ((icon = (IconInterface)this.getEffectiveStylePropertyValue("selectedIcon", null)) != null) {
            return icon;
        }
        return this.getDefaultIcon();
    }

    public NodeState getSingleState() {
        return new NodeState(this);
    }

    public NodeState getState() {
        NodeState state = this.getSingleState();
        if (this.children != null) {
            state.children = new OrderedCollection();
            int cnt = this.children.count();
            for (int i = 0; i < cnt; ++i) {
                NodeView nv = (NodeView)this.children.get(i);
                state.children.add((Object)nv.getState());
            }
        }
        return state;
    }

    public int getVisibleNodeCount() {
        return this.visibleNodeCount;
    }

    public boolean isEditing() {
        return this.isBeingEdited();
    }

    public boolean isExpanded() {
        if (this.isFlagSet(4)) {
            this.isLeafNode();
        }
        return this.isFlagSet(1);
    }

    public boolean isLeafNode() {
        boolean leafNode = this.modelIsLeafNode();
        if (!leafNode && this.isLeafNodeVerificationEnabled()) {
            return this.internalIsLeafNode();
        }
        return leafNode;
    }

    public boolean isSelected() {
        return this.isFlagSet(2);
    }

    public boolean isVisible() {
        return (Boolean)this.getEffectiveStylePropertyValue("visible", Boolean.TRUE);
    }

    public void onAction() {
        if (!this.modelIsLeafNode()) {
            this.setExpanded(!this.isExpanded());
        }
    }

    public void onSelect() {
        this.setSelected(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof NodeView) {
            return;
        }
        if (source instanceof NodeInterface) {
            String propertyName = event.getPropertyName();
            Object newValue = event.getNewValue();
            NodeInterface node = (NodeInterface)source;
            if (Util.equal((Object)propertyName, (Object)"nodeText")) {
                if (this.isBeingEdited()) {
                    this.treeView._editableNode.cancel();
                }
                this.internalSetNodeText((String)newValue);
            } else if (Util.equal((Object)propertyName, (Object)"nodeChildren")) {
                this.nodeChildCount = -2;
                this.setFlag(4);
                if (event instanceof CollectionChangedInfo) {
                    this.specialChange((CollectionChangedInfo)event);
                } else {
                    this.repopulate();
                }
                this.getNodeChildCount();
            } else if (Util.equal((Object)propertyName, (Object)"nodeExpandedText")) {
                if (this.isBeingEdited()) {
                    this.treeView._editableNode.cancel();
                }
                this.internalSetNodeExpandedText((String)newValue);
            } else if (Util.equal((Object)propertyName, (Object)"nodeType")) {
                this.internalSetNodeType((String)newValue);
            } else if (Util.equal((Object)propertyName, (Object)"leafNode")) {
                this.internalSetLeafNode((Boolean)newValue);
            } else if (Util.equal((Object)propertyName, (Object)"defaultIcon")) {
                this.refreshIcons();
            } else if (Util.equal((Object)propertyName, (Object)"selectedIcon")) {
                this.refreshIcons();
            } else if (Util.equal((Object)propertyName, (Object)"expandedIcon")) {
                this.refreshIcons();
            } else if (Util.equal((Object)propertyName, (Object)"expandedSelectedIcon")) {
                this.refreshIcons();
            } else if (this.getNode() instanceof StaticNodeStyleInterface) {
                if (Util.equal((Object)propertyName, (Object)"nodeStyle")) {
                    this.setModelStyle(((StaticNodeStyleInterface)this.getNode()).getNodeStyle());
                } else if (Util.equal((Object)propertyName, (Object)"defaultNodeStyle")) {
                    this.setModelDefaultStyle(((StaticNodeStyleInterface)this.getNode()).getDefaultNodeStyle());
                } else if (Util.equal((Object)propertyName, (Object)"nodeTypes")) {
                    this._nodeTypes = ((StaticNodeStyleInterface)this.getNode()).getNodeTypes();
                } else {
                    return;
                }
                this.treeView.noteNodeResized(this);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners != null) {
            this.allPropertyChangeListeners.remove(listener);
        }
    }

    public void repopulate() {
        if (this.children != null) {
            int cnt = this.children.count();
            for (int i = 0; i < cnt; ++i) {
                com.sas.beans.Util.removePropertyChangeListener((Object)this.children.get(i), (PropertyChangeListener)this);
            }
            this.children.removeAll();
        }
        this.treeView.noteNodeChildrenChanged(this);
        this.firePropertyChange("nodeChildren", null, null);
    }

    public void setDefaultNodeStyle(PropertyBagInterface newValue) {
        PropertyBagInterface oldValue = this.getDefaultNodeStyle();
        if (Util.equal((Object)oldValue, (Object)newValue)) {
            return;
        }
        if (this._pbagListener == null) {
            this._pbagListener = new PropertyBagListener();
        }
        this._defaultNodeStyle = newValue;
        newValue = this.getDefaultNodeStyle();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            if (oldValue != null) {
                oldValue.removePropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            }
            if (newValue != null) {
                newValue.addPropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            }
            this.firePropertyChange("defaultNodeStyle", oldValue, newValue);
            this.treeView.noteNodeResized(this);
        }
    }

    public void setEditing(boolean newValue) {
        this.setEditable(newValue);
    }

    public void setExpanded(boolean newValue) {
        if (newValue == this.isExpanded()) {
            return;
        }
        if (this.treeView.noteNodeExpanding(this, newValue)) {
            return;
        }
        if (newValue) {
            this.setFlag(1);
        } else {
            this.unsetFlag(1);
        }
        if (this._internalCount != -2 && this.isExpanded()) {
            this.nodeChildCount = -2;
        }
        this.updateVisibleNodeCount();
        this.treeView.noteNodeExpandedChanged(this);
        this.firePropertyChange("expanded", this.isExpanded() ? Boolean.FALSE : Boolean.TRUE, this.isExpanded() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setNodeStyle(PropertyBagInterface newValue) {
        PropertyBagInterface oldValue = this.getNodeStyle();
        if (Util.equal((Object)oldValue, (Object)newValue)) {
            return;
        }
        if (this._pbagListener == null) {
            this._pbagListener = new PropertyBagListener();
        }
        this._nodeStyle = newValue;
        newValue = this.getNodeStyle();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            if (oldValue != null) {
                oldValue.removePropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            }
            if (newValue != null) {
                newValue.addPropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            }
            boolean oldBoolean = true;
            if (oldValue != null && oldValue.containsKey("visible")) {
                oldBoolean = (Boolean)oldValue.get("visible");
            }
            boolean newBoolean = true;
            if (newValue != null && newValue.containsKey("visible")) {
                newBoolean = (Boolean)newValue.get("visible");
            }
            if (oldBoolean != newBoolean) {
                this.updateVisibleNodeCount();
            }
            this.firePropertyChange("nodeStyle", oldValue, newValue);
            this.treeView.noteNodeResized(this);
        }
    }

    public void setSelected(boolean newValue) {
        if (newValue && !this.isSelectable()) {
            newValue = false;
        }
        if (newValue == this.isSelected()) {
            return;
        }
        if (newValue && !this.isBeingEdited() && this.treeView._editableNode != null && this.treeView._editableNode.getNodeView() != null) {
            this.treeView._editableNode.getNodeView().setEditable(false);
        }
        if (newValue) {
            this.setFlag(2);
        } else {
            this.unsetFlag(2);
        }
        this.treeView.noteNodeSelectedChanged(this);
        this.firePropertyChange("selected", this.isSelected() ? Boolean.FALSE : Boolean.TRUE, this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setState(NodeState state) {
        this.setExpanded(state.expanded);
        this.setSelected(state.selected);
        this.setDefaultNodeStyle(state.defaultNodeStyle);
        this.setNodeStyle(state.nodeStyle);
        if (state.children != null) {
            int ncCnt;
            int cnt = state.children.count();
            if (cnt != (ncCnt = this.getNodeChildCount()) && ncCnt != -1) {
                return;
            }
            for (int i = 0; i < cnt; ++i) {
                NodeView nv = (NodeView)this.getNodeChild(i);
                nv.setState((NodeState)state.children.get(i));
            }
        }
        this._resized = true;
        this.treeView.noteNodeResized(this);
    }

    public void setVisible() {
        for (NodeView parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isExpanded()) continue;
            parent.setExpanded(true);
        }
    }

    public String toString() {
        return this.getDisplayedText();
    }

    public void updateVisibleNodeCount() {
        int count = 1;
        if (!this.modelIsLeafNode() && this.isExpanded()) {
            if (this.children == null) {
                int cnt = this.getNodeChildCount();
                if (cnt == -1) {
                    cnt = this.countNodeChildren(0);
                }
                if (cnt == -1) {
                    if (this._internalCount == -1) {
                        this.setVisibleNodeCount(-1);
                        return;
                    }
                    cnt = this._internalCount;
                } else if (cnt == 0) {
                    return;
                }
                SimpleNodeInterface[] sni = this.getNodeChildren(0, cnt);
                if (sni == null) {
                    return;
                }
                for (int i = 0; i < sni.length; ++i) {
                    NodeView nodeView = (NodeView)sni[i];
                    if (!nodeView.isVisible()) continue;
                    int vncCount = nodeView.getVisibleNodeCount();
                    if (vncCount == -1) {
                        this.setVisibleNodeCount(-1);
                        return;
                    }
                    count += vncCount;
                }
            } else {
                Enumeration enumer = this.children.getItems();
                while (enumer.hasMoreElements()) {
                    NodeView nodeView = (NodeView)enumer.nextElement();
                    if (!nodeView.isVisible()) continue;
                    int vncCount = nodeView.getVisibleNodeCount();
                    if (vncCount == -1) {
                        this.setVisibleNodeCount(-1);
                        return;
                    }
                    count += vncCount;
                }
            }
        }
        this.setVisibleNodeCount(count);
    }

    private void add(NodeInterface childNode) {
        this.add(childNode, true, true);
    }

    private void add(NodeInterface childNode, boolean fireEvent, boolean updateVNC) {
        if (childNode != null) {
            if (this.children == null) {
                this.children = new OrderedCollection();
            }
            NodeView node = new NodeView(this.treeView, childNode);
            node.depth = this.depth + 1;
            node.parent = this;
            this.expandable = true;
            this.add(node, fireEvent, updateVNC);
        }
    }

    private void add(NodeInterface childNode, int position) {
        this.add(childNode, position, true, true);
    }

    private void add(NodeInterface childNode, int position, boolean fireEvent, boolean updateVNC) {
        if (childNode == null) {
            return;
        }
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        if (position > this.children.count() || position < 0) {
            return;
        }
        NodeView node = new NodeView(this.treeView, childNode);
        node.depth = this.depth + 1;
        node.parent = this;
        this.expandable = true;
        if (this.children != null && position < this.children.count()) {
            this.add(node, position, fireEvent, updateVNC);
        } else {
            this.add(node, fireEvent, updateVNC);
        }
    }

    private void add(NodeView node, boolean fireEvent, boolean updateVNC) {
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        node.depth = this.depth + 1;
        node.parent = this;
        this.expandable = true;
        this.children.add((Object)node);
        if (updateVNC) {
            this.updateVisibleNodeCount();
        }
        if (fireEvent) {
            this.treeView.noteNodeChildrenChanged(this);
            this.firePropertyChange("nodeChildren", null, null);
        }
    }

    private void add(NodeView childNode, int position, boolean fireEvent, boolean updateVNC) {
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        if (position > this.children.count() || position < 0) {
            return;
        }
        childNode.depth = this.depth + 1;
        childNode.parent = this;
        this.expandable = true;
        this.children.add((Object)childNode, position);
        if (updateVNC) {
            this.updateVisibleNodeCount();
        }
        if (fireEvent) {
            this.treeView.noteNodeChildrenChanged(this);
            this.firePropertyChange("nodeChildren", null, null);
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.notifyPropertyChange(event);
    }

    private SimpleNodeInterface[] internalGetChildren(int startIndex, int count) {
        if (this.children == null) {
            return null;
        }
        if (startIndex >= this.children.count()) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"indexOutOfRange.ex.txt"), (Object)new Integer(startIndex), (Object)new Integer(this.children.count() - 1)));
        }
        if (startIndex + count > this.children.count()) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"lessNodesThanAskedFor.ex.txt"));
        }
        SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
        int cnt = startIndex + count;
        for (int i = startIndex; i < cnt; ++i) {
            sni[i - startIndex] = (SimpleNodeInterface)this.children.get(i);
        }
        return sni;
    }

    private boolean internalIsLeafNode() {
        int childCnt = this.getNodeChildCount();
        if (childCnt > 0 || childCnt == -1 && (childCnt = this._internalCount) > 0) {
            for (int i = 0; i < childCnt; ++i) {
                NodeView child = (NodeView)this.getNodeChild(i);
                if (!child.isVisible()) continue;
                return false;
            }
            return true;
        }
        if (childCnt == -1) {
            NodeView child;
            while ((child = (NodeView)this.getNodeChild(++childCnt)) != null) {
                if (!child.isVisible()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean internalSetChildren(SimpleNodeInterface[] sni) {
        if (sni == null || sni.length == 0) {
            return false;
        }
        int childCount = this.children == null ? 0 : this.children.count();
        int cnt = sni.length;
        for (int i = 0; i < cnt; ++i) {
            if (sni[i] == null) {
                if (this.children == null || this._internalCount == -2) break;
                this._internalCount = this.children.count();
                break;
            }
            this.add((NodeInterface)sni[i], false, false);
        }
        if (this.children == null || childCount == this.children.count()) {
            return false;
        }
        this.updateVisibleNodeCount();
        this.treeView.noteNodeChildrenChanged(this);
        this.firePropertyChange("nodeChildren", null, null);
        return true;
    }

    private void internalSetDefaultIcon(IconInterface newValue) {
        if (newValue == this.defaultIcon) {
            return;
        }
        IconInterface oldValue = this.defaultIcon;
        this.defaultIcon = newValue;
        this.treeView.noteNodeIconChanged(this);
        this.firePropertyChange("defaultIcon", oldValue, newValue);
    }

    private void internalSetExpandedIcon(IconInterface newValue) {
        if (newValue == this.expandedIcon) {
            return;
        }
        IconInterface oldValue = this.expandedIcon;
        this.expandedIcon = newValue;
        this.treeView.noteNodeIconChanged(this);
        this.firePropertyChange("expandedIcon", oldValue, newValue);
    }

    private void internalSetExpandedSelectedIcon(IconInterface newValue) {
        if (newValue == this.expandedSelectedIcon) {
            return;
        }
        IconInterface oldValue = this.expandedSelectedIcon;
        this.expandedSelectedIcon = newValue;
        this.treeView.noteNodeIconChanged(this);
        this.firePropertyChange("expandedSelectedIcon", oldValue, newValue);
    }

    private void internalSetLeafNode(boolean newValue) {
        if (newValue == !this.expandable) {
            return;
        }
        if (newValue) {
            this.setExpanded(false);
        }
        this.expandable = !newValue;
        this.treeView.noteNodeChildrenChanged(this);
        this.firePropertyChange("leafNode", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    private void internalSetNodeExpandedText(String newValue) {
        if (newValue == this.nodeExpandedText) {
            return;
        }
        String oldValue = this.nodeExpandedText;
        this.nodeExpandedText = newValue;
        this._resized = true;
        this.treeView.noteNodeExpandedTextChanged(this);
        this.firePropertyChange("nodeExpandedText", oldValue, newValue);
    }

    private void internalSetNodeText(String newValue) {
        if (newValue == this.nodeText) {
            return;
        }
        String oldValue = this.nodeText;
        this.nodeText = newValue;
        this._resized = true;
        this.treeView.noteNodeTextChanged(this);
        this.firePropertyChange("nodeText", oldValue, newValue);
    }

    private void internalSetNodeType(String newValue) {
        if (newValue == this.nodeType) {
            return;
        }
        String oldValue = this.nodeType;
        this.nodeType = newValue;
        this.treeView.noteNodeTypeChanged(this);
        this.firePropertyChange("nodeType", oldValue, newValue);
    }

    private void internalSetSelectedIcon(IconInterface newValue) {
        if (newValue == this.selectedIcon) {
            return;
        }
        IconInterface oldValue = this.selectedIcon;
        this.selectedIcon = newValue;
        this.treeView.noteNodeIconChanged(this);
        this.firePropertyChange("selectedIcon", oldValue, newValue);
    }

    private void paintSelectionBorder(Rectangle r, Graphics g) {
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        g.setXORMode(Color.black);
        g.setColor(Color.white);
        this.drawDottedLine(1, x, y, x + w - 1, y, g);
        this.drawDottedLine(2, x, y + 2, x, y + h - 1, g);
        if (w % 2 == 0) {
            this.drawDottedLine(2, x + w - 1, y + 1, x + w - 1, y + h - 2, g);
        } else {
            this.drawDottedLine(2, x + w - 1, y + 2, x + w - 1, y + h - 2, g);
        }
        if (h % 2 == 0) {
            this.drawDottedLine(1, x + 1, y + h - 1, x + w - 1, y + h - 1, g);
        } else {
            this.drawDottedLine(1, x, y + h - 1, x + w - 1, y + h - 1, g);
        }
        g.setPaintMode();
    }

    private void refreshIcons() {
        if (this.nodeData instanceof NodeIconInterface) {
            NodeIconInterface nodeIcon = (NodeIconInterface)this.nodeData;
            this.internalSetDefaultIcon(nodeIcon.getDefaultIcon());
            this.internalSetSelectedIcon(nodeIcon.getSelectedIcon());
            this.internalSetExpandedIcon(nodeIcon.getExpandedIcon());
            this.internalSetExpandedSelectedIcon(nodeIcon.getExpandedSelectedIcon());
            this._resized = true;
            this.treeView.noteNodeResized(this);
        }
    }

    private void remove(NodeInterface childNode, int index) {
        if (this.children == null || index >= this.children.count()) {
            this.treeView.noteNodeChildrenChanged(this);
            this.firePropertyChange("nodeChildren", null, null);
            return;
        }
        com.sas.beans.Util.removePropertyChangeListener((Object)childNode, (PropertyChangeListener)this);
        NodeView child = (NodeView)this.children.get(index);
        child.setSelected(false);
        this.children.removeAt(index);
        if (this.nodeData.isLeafNode()) {
            this.children = null;
            this.expandable = false;
            this.unsetFlag(1);
        }
        this.updateVisibleNodeCount();
        this.treeView.noteNodeChildrenChanged(this);
        this.firePropertyChange("nodeChildren", null, null);
    }

    private void reorderNodeChildren(int startIndex, int endIndex) {
        int count = endIndex - startIndex + 1;
        if (this.getNodeChildren(startIndex, count) == null) {
            return;
        }
        if (this.tempCollection == null) {
            this.tempCollection = new OrderedCollection();
        }
        this.tempCollection.removeAll();
        this.tempCollection.addItems(this.children.getItems(startIndex, endIndex + 1));
        int cnt = count;
        for (int i = 0; i < cnt; ++i) {
            this.children.removeAt(startIndex);
        }
        SimpleNodeInterface[] temp = this.nodeData.getNodeChildren(startIndex, count);
        block1: for (int i = 0; i < temp.length; ++i) {
            for (int j = 0; j < count; ++j) {
                NodeView nv = (NodeView)this.tempCollection.get(j);
                NodeInterface sni = nv.getNode();
                if (sni != temp[i]) continue;
                this.children.add((Object)nv, startIndex + i);
                continue block1;
            }
        }
        this.treeView.noteNodeChildrenChanged(this);
        this.firePropertyChange("nodeChildren", null, null);
    }

    private void setVisibleNodeCount(int newValue) {
        this.visibleNodeCount = newValue;
        if (this.parent != null) {
            this.parent.updateVisibleNodeCount();
        }
    }

    private void specialChange(CollectionChangedInfo cci) {
        if (cci.howChanged == HowChanged.ADDED) {
            if (cci.start == cci.end - 1) {
                this.add((NodeInterface)cci.whatChanged, cci.start);
                return;
            }
        } else if (cci.howChanged == HowChanged.REMOVED) {
            if (cci.start == cci.end - 1) {
                this.remove((NodeInterface)cci.whatChanged, cci.start);
                return;
            }
        } else if (cci.howChanged == HowChanged.REORDERED) {
            this.reorderNodeChildren(cci.start, cci.end);
            return;
        }
        this.repopulate();
    }

    protected void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        PropertyChangeListener[] listenerList = this.allPropertyChangeListeners.getListeners();
        int n = listenerList.length;
        for (int i = 0; i < n; ++i) {
            listenerList[i].propertyChange(event);
        }
    }

    protected boolean supportsCommandsInterface() {
        return this.nodeData instanceof CommandsInterface;
    }

    void drawDottedLine(int direction, int ax, int ay, int bx, int by, Graphics g) {
        int xincr = direction == 1 ? 2 : 0;
        int yincr = xincr == 2 ? 0 : 2;
        int x = ax;
        for (int y = ay; x <= bx && y <= by; x += xincr, y += yincr) {
            g.drawLine(x, y, x, y);
        }
    }

    Rectangle getCurrentCueBounds(Rectangle r) {
        if (r == null) {
            r = this._tempRect;
        }
        r.x = 0;
        r.y = 0;
        r.width = this.getWidth();
        r.height = this.getHeight();
        boolean excludeImage = true;
        if (excludeImage) {
            IconInterface icon;
            IconInterface iconInterface = icon = this.isImageVisible() ? this.getIcon() : null;
            if (icon != null) {
                Dimension imageSize = this.getEffectiveImageSize();
                r.x += imageSize.width;
                Integer tg = (Integer)this.getEffectiveStylePropertyValue("textGap", null);
                if (tg != null) {
                    r.x += tg.intValue();
                }
            }
        }
        if (r.x != 0) {
            r.width -= r.x;
        }
        return r;
    }

    String getDisplayedText() {
        if (this.isExpandedTextDisplayed()) {
            return this.getNodeExpandedText();
        }
        return this.getNodeText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Font getEffectiveFont() {
        FontStyle fontStyle = _fontStyle;
        synchronized (fontStyle) {
            this.getEffectiveStylePropertyBag("fontStyle", (PropertyBagInterface)_fontStyle, true);
            return _fontStyle.getFont();
        }
    }

    Dimension getEffectiveImageSize() {
        if (this._effectiveImageSize == null) {
            this._effectiveImageSize = (Dimension)this.getEffectiveStylePropertyValue("imageSize", null);
            if (this._effectiveImageSize == null) {
                IconInterface icon = this.getIcon();
                this._effectiveImageSize = icon.getPreferredSize();
            } else if (this._effectiveImageSize.width == -1 || this._effectiveImageSize.height == -1) {
                Dimension d2 = new Dimension(this._effectiveImageSize.width, this._effectiveImageSize.height);
                if (this._effectiveImageSize.width == -1) {
                    d2.width = this.getImageWidth();
                }
                if (this._effectiveImageSize.height == -1) {
                    d2.height = this.getImageHeight();
                }
                this._effectiveImageSize = d2;
            }
        }
        return this._effectiveImageSize;
    }

    private int getImageWidth() {
        IconInterface icon = this.getIcon();
        if (icon != null) {
            return icon.getPreferredSize().width;
        }
        return 16;
    }

    private int getImageHeight() {
        IconInterface icon = this.getIcon();
        if (icon != null) {
            return icon.getPreferredSize().height;
        }
        return 16;
    }

    void getEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag, boolean clearBag) {
        if (clearBag) {
            bag.removeAll();
        }
        this.onGetEffectiveStylePropertyBag(propertyID, bag);
        if (propertyID == "fontStyle") {
            bag.merge((StaticPropertyBagInterface)this.treeView.getDefaultFontStyle());
        }
    }

    Object getEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        PropertyBagInterface spbi = this.getNodeStyle();
        if (spbi != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        spbi = this.getModelStyle();
        if (spbi != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        StaticDictionaryInterface sdi = this.treeView.getNodeTypeStyles();
        if (sdi != null && sdi.containsKey((Object)this.getNodeType()) && (spbi = (StaticPropertyBagInterface)sdi.get((Object)this.getNodeType())) != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        if (this._nodeTypes != null) {
            int cnt = this._nodeTypes.length;
            for (int i = 0; i < cnt; ++i) {
                if (sdi == null || !sdi.containsKey((Object)this._nodeTypes[i]) || (spbi = (StaticPropertyBagInterface)sdi.get((Object)this._nodeTypes[i])) == null || !spbi.containsKey(propertyID)) continue;
                return spbi.get(propertyID);
            }
        }
        if ((spbi = this.getDefaultNodeStyle()) != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        spbi = this.getModelDefaultStyle();
        if (spbi != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        for (NodeView parent = this.getParent(); parent != null; parent = parent.getParent()) {
            spbi = parent.getDefaultNodeStyle();
            if (spbi != null && spbi.containsKey(propertyID)) {
                return spbi.get(propertyID);
            }
            spbi = parent.getModelDefaultStyle();
            if (spbi == null || !spbi.containsKey(propertyID)) continue;
            return spbi.get(propertyID);
        }
        spbi = this.treeView.getDefaultNodeStyle();
        if (spbi != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        spbi = this.treeView._modelDefaultNodeStyle;
        if (spbi != null && spbi.containsKey(propertyID)) {
            return spbi.get(propertyID);
        }
        return defaultValue;
    }

    int getHeight() {
        return this._height;
    }

    IconInterface getIcon() {
        IconInterface icon = null;
        icon = this.isSelected() ? (this.isExpanded() ? this.getExpandedSelectedIcon() : this.getSelectedIcon()) : (this.isExpanded() ? this.getExpandedIcon() : this.getDefaultIcon());
        return icon == null ? this.treeView.getIcon(this.getNodeType()) : icon;
    }

    int getImageX() {
        IconInterface icon;
        int x = 0;
        IconInterface iconInterface = icon = this.isImageVisible() ? this.getIcon() : null;
        if (icon != null) {
            Dimension imageSize = this.getEffectiveImageSize();
            Integer tg = (Integer)this.getEffectiveStylePropertyValue("textGap", null);
            if (tg != null) {
                x += tg.intValue();
            }
            x += imageSize.width;
        }
        return x;
    }

    OrderedCollection getInMemoryChildren() {
        return this.children;
    }

    StaticPropertyBagInterface getModelDefaultStyle() {
        return this._modelDefaultNodeStyle;
    }

    StaticPropertyBagInterface getModelStyle() {
        return this._modelNodeStyle;
    }

    int getPreferredHeight(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.getEffectiveFont());
        int textHeight = fm.getHeight() + 2;
        Boolean b = (Boolean)this.getEffectiveStylePropertyValue("imageVisible", Boolean.FALSE);
        if (b != null && b.booleanValue()) {
            Dimension d = this.getEffectiveImageSize();
            return Math.max(textHeight, d.height);
        }
        return textHeight;
    }

    int getPreferredWidth(Graphics g) {
        Integer tp;
        IconInterface icon;
        String str = this.getDisplayedText();
        FontMetrics fm = g.getFontMetrics(this.getEffectiveFont());
        int width = fm.stringWidth(str != null ? str : "");
        IconInterface iconInterface = icon = this.isImageVisible() ? this.getIcon() : null;
        if (icon != null) {
            width += this.getEffectiveImageSize().width;
            Integer tg = (Integer)this.getEffectiveStylePropertyValue("textGap", null);
            if (tg != null) {
                width += tg.intValue();
            }
        }
        if ((tp = (Integer)this.getEffectiveStylePropertyValue("textPad", null)) != null && tp != 0) {
            width += tp.intValue();
        }
        return width;
    }

    int getTextX() {
        return this.getTextX(this.isImageVisible() ? this.getIcon() : null);
    }

    int getTextX(IconInterface icon) {
        Integer tp;
        int x = 0;
        if (icon != null) {
            Dimension imageSize = this.getEffectiveImageSize();
            Integer tg = (Integer)this.getEffectiveStylePropertyValue("textGap", null);
            if (tg != null) {
                x += tg.intValue();
            }
            x += imageSize.width;
        }
        if ((tp = (Integer)this.getEffectiveStylePropertyValue("textPad", null)) != null && tp != 0) {
            x += tp / 2;
        }
        return x;
    }

    int getTextY(FontMetrics fm) {
        int y = (this.getHeight() - fm.getHeight()) / 2;
        return y += fm.getAscent();
    }

    NodeView getVisibleNodeChild(int index) {
        int numFound = -1;
        int childCount = this.getNodeChildCount();
        if (childCount == -1 && this._internalCount == -1) {
            NodeView node;
            int idx = -1;
            while ((node = (NodeView)this.getNodeChild(++idx)) != null && node.isVisible()) {
                if (++numFound != index) continue;
                return node;
            }
        } else {
            int cnt = this._internalCount == -2 ? childCount : this._internalCount;
            for (int i = 0; i < cnt; ++i) {
                NodeView node = (NodeView)this.getNodeChild(i);
                if (!node.isVisible() || ++numFound != index) continue;
                return node;
            }
        }
        return null;
    }

    int getVisibleNodeChildCount() {
        int childCount = this.getNodeChildCount();
        if (childCount <= 0) {
            return childCount;
        }
        int retCount = childCount;
        for (int i = 0; i < childCount; ++i) {
            NodeView child = (NodeView)this.getNodeChild(i);
            if (child.isVisible()) continue;
            --retCount;
        }
        return retCount;
    }

    int getWidth() {
        return this._width;
    }

    int getX() {
        return this._x;
    }

    int getY() {
        return this._y;
    }

    boolean isBeingEdited() {
        return this.treeView._editableNode != null && this.treeView._editableNode.getNodeView() == this;
    }

    boolean isCurrent() {
        return this.treeView.getCurrentNode() == this;
    }

    boolean isDragExpandEnabled() {
        return (Boolean)this.getEffectiveStylePropertyValue("dragExpandEnabled", Boolean.TRUE);
    }

    boolean isEditable() {
        return this.getNode() instanceof MutableNodeInterface && (Boolean)this.getEffectiveStylePropertyValue("editable", Boolean.FALSE) != false;
    }

    boolean isExpandedTextDisplayed() {
        return (Boolean)this.getEffectiveStylePropertyValue("expandedTextDisplayed", Boolean.FALSE);
    }

    boolean isImageVisible() {
        return (Boolean)this.getEffectiveStylePropertyValue("imageVisible", Boolean.TRUE);
    }

    boolean isLeafNodeVerificationEnabled() {
        return (Boolean)this.getEffectiveStylePropertyValue("leafNodeVerificationEnabled", Boolean.FALSE);
    }

    boolean isSelectable() {
        return (Boolean)this.getEffectiveStylePropertyValue("selectable", Boolean.TRUE);
    }

    boolean modelIsLeafNode() {
        if (this.isFlagSet(4)) {
            this.unsetFlag(4);
            boolean bl = this.expandable = !this.nodeData.isLeafNode();
            if (!this.expandable && this.isExpanded()) {
                this.setExpanded(false);
            }
        }
        return !this.expandable;
    }

    void onGetEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        StaticDictionaryInterface sdi;
        PropertyBagInterface nodeStyle = this.getNodeStyle();
        if (nodeStyle != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        if ((nodeStyle = this.getModelStyle()) != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        if ((sdi = this.treeView.getNodeTypeStyles()) != null && sdi.containsKey((Object)this.getNodeType()) && (nodeStyle = (StaticPropertyBagInterface)sdi.get((Object)this.getNodeType())) != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        if (this._nodeTypes != null) {
            int cnt = this._nodeTypes.length;
            for (int i = 0; i < cnt; ++i) {
                if (sdi == null || !sdi.containsKey((Object)this._nodeTypes[i]) || (nodeStyle = (StaticPropertyBagInterface)sdi.get((Object)this._nodeTypes[i])) == null || !nodeStyle.containsKey(propertyID)) continue;
                bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
            }
        }
        if ((nodeStyle = this.getDefaultNodeStyle()) != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        if ((nodeStyle = this.getModelDefaultStyle()) != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        NodeView parent = this;
        while ((parent = parent.getParent()) != null) {
            nodeStyle = parent.getDefaultNodeStyle();
            if (nodeStyle != null && nodeStyle.containsKey(propertyID)) {
                bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
            }
            if ((nodeStyle = parent.getModelDefaultStyle()) == null || !nodeStyle.containsKey(propertyID)) continue;
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        nodeStyle = this.treeView.getDefaultNodeStyle();
        if (nodeStyle != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
        if ((nodeStyle = this.treeView._modelDefaultNodeStyle) != null && nodeStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)nodeStyle.get(propertyID));
        }
    }

    void onPaintBackground(Graphics g, int width, int height) {
        Color c = (Color)this.getEffectiveStylePropertyValue("backgroundColor", null);
        if (c == null) {
            c = this.treeView.getBackgroundColor();
        }
        if (c != null) {
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.isSelected() && !this.isBeingEdited() && (c = (Color)this.getEffectiveStylePropertyValue("selectedBackgroundColor", c)) != null) {
            Rectangle r = this.getCurrentCueBounds(null);
            g.setColor(c);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    void onPaintBackground(Graphics g, Graphics g2, int width, int height) {
        Color c = (Color)this.getEffectiveStylePropertyValue("backgroundColor", null);
        if (c == null) {
            c = this.treeView.getBackgroundColor();
        }
        if (c != null) {
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(c);
            g2.fillRect(0, 0, width, height);
        }
    }

    void onPaintBorder(Graphics g, int width, int height) {
        Rectangle curCue = this.getCurrentCueBounds(null);
        if (!this.isBeingEdited()) {
            if (this.isCurrent()) {
                this.paintSelectionBorder(curCue, g);
            }
        } else {
            BaseBorder.paintBorder(g, 0, 0, this.treeView._editableNode.getWidth(), curCue.height, Color.black, Color.black, 2, 1, 5, 15);
        }
    }

    void onPaintForeground(Graphics g, int width, int height) {
        IconInterface icon;
        IconInterface iconInterface = icon = this.isImageVisible() ? this.getIcon() : null;
        if (icon != null) {
            Dimension imageSize = this.getEffectiveImageSize();
            int imgHeight = imageSize.height;
            int x = 0;
            int y = this.getHeight() - imageSize.height;
            if (y != 0) {
                y /= 2;
            }
            icon.paint((Component)this.treeView, g, x, y, imageSize.width, imageSize.height);
        }
        if (this.isBeingEdited()) {
            return;
        }
        Color c = null;
        if (this.isSelected()) {
            c = (Color)this.getEffectiveStylePropertyValue("selectedForegroundColor", null);
        }
        if (c == null && (c = (Color)this.getEffectiveStylePropertyValue("foregroundColor", null)) == null) {
            c = this.treeView.getForegroundColor();
        }
        g.setColor(c);
        String text = this.getDisplayedText();
        if (text != null) {
            g.setFont(this.getEffectiveFont());
            g.drawString(text, this.getTextX(icon), this.getTextY(g.getFontMetrics()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics g) {
        int cx = this.getX();
        int cy = this.getY();
        int cw = this.getWidth();
        int ch = this.getHeight();
        Graphics cg = g.create(cx, cy, cw, ch);
        Graphics cg2 = null;
        try {
            if (this.isBeingEdited()) {
                Rectangle cueBounds = this.getCurrentCueBounds(null);
                this.treeView._editableNode.getPreferredWidth(g);
                int preferredWidth = this.treeView._editableNode.getWidth();
                cg2 = g.create(cueBounds.x + cx, cueBounds.y + cy, preferredWidth, cueBounds.height);
                this.onPaintBackground(cg, cg2, preferredWidth, cueBounds.height);
                this.onPaintForeground(cg, cw, ch);
                this.treeView._editableNode.paint(cg2);
                this.onPaintBorder(cg2, cw, ch);
            } else {
                this.onPaintBackground(cg, cw, ch);
                this.onPaintForeground(cg, cw, ch);
                this.onPaintBorder(cg, cw, ch);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            cg.dispose();
            if (cg2 != null) {
                cg2.dispose();
            }
        }
    }

    boolean processKeyEvent(KeyEvent event) {
        if (this.treeView._editableNode.getNodeView() == this) {
            this.treeView._editableNode.processKeyEvent(event);
        }
        return true;
    }

    boolean processMouseEvent(MouseEvent event) {
        if (this.treeView._editableNode.getNodeView() == this) {
            Rectangle cueBounds = this.getCurrentCueBounds(null);
            cueBounds.x += this.getX();
            cueBounds.y += this.getY();
            cueBounds.width = this.treeView._editableNode.getWidth();
            if (cueBounds.contains(event.getPoint())) {
                event.translatePoint(-cueBounds.x, -cueBounds.y);
                this.treeView._editableNode.processMouseEvent(event);
                return true;
            }
        }
        return false;
    }

    boolean processMouseMotionEvent(MouseEvent event) {
        if (this.treeView._editableNode.getNodeView() == this) {
            Rectangle cueBounds = this.getCurrentCueBounds(null);
            cueBounds.width = cueBounds.x;
            cueBounds.x = this.getX();
            cueBounds.y = this.getY();
            if (cueBounds.contains(event.getPoint())) {
                return true;
            }
            cueBounds = this.getCurrentCueBounds(null);
            cueBounds.x += this.getX();
            cueBounds.y += this.getY();
            cueBounds.width = this.treeView._editableNode.getWidth();
            if (cueBounds.contains(event.getPoint())) {
                event.translatePoint(-cueBounds.x, -cueBounds.y);
                this.treeView._editableNode.processMouseMotionEvent(event);
                return true;
            }
        }
        return false;
    }

    void remeasure(Graphics g, boolean force) {
        if (!this._resized && !force) {
            return;
        }
        this._resized = false;
        this._effectiveImageSize = null;
        int height = this.getPreferredHeight(g);
        this.setHeight(height);
        int width = this.getPreferredWidth(g);
        this.setWidth(width);
    }

    void setBounds(int x, int y, int width, int height) {
        this._x = x;
        this._y = y;
        this._width = width;
        this._height = height;
    }

    void setDisplayedText(String text) {
        if (this.isExpandedTextDisplayed()) {
            this.setNodeExpandedText(text);
        } else {
            this.setNodeText(text);
        }
    }

    void setEditable(boolean newValue) {
        if (!this.isEditable()) {
            return;
        }
        if (this.treeView._editableNode == null && newValue) {
            this.treeView._editableNode = new NodeViewTextEditor();
        }
        if (!newValue && this.treeView._editableNode != null) {
            try {
                this.treeView._editableNode.applyText();
            }
            catch (Exception ex) {
                Object objErrHandler = this.getEffectiveStylePropertyValue("errorHandler", null);
                if (objErrHandler == null) {
                    objErrHandler = this.treeView.getErrorHandler();
                }
                if (objErrHandler == null || !(objErrHandler instanceof ErrorHandlerInterface)) {
                    ex.printStackTrace();
                } else {
                    ErrorHandlerInterface errHandler = (ErrorHandlerInterface)objErrHandler;
                    String msg = ex.getMessage();
                    if (msg == null) {
                        msg = ex.toString();
                    }
                    errHandler.handleError((ComponentInterface)this.treeView, new Message(msg), NODE_EDITING_ERROR);
                }
                this.treeView._editableNode.selectAll();
                return;
            }
        }
        if (newValue) {
            this.treeView.noteNodeRenameStarting(this);
        }
        if (this.treeView._editableNode != null) {
            this.treeView._editableNode.setNodeView(newValue ? this : null);
        }
        if (!newValue) {
            this.treeView.noteNodeRenameEnding(this);
        }
        this.firePropertyChange("editing", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        this.treeView.repaint();
    }

    void setFullyExpanded(boolean expand) {
        this.setFullyExpanded(expand, false);
    }

    void setFullyExpanded(boolean expand, boolean expandHiddenNodes) {
        if (this.modelIsLeafNode()) {
            return;
        }
        this.setExpanded(expand);
        if (expand ^ this.isExpanded()) {
            return;
        }
        int cnt = this.getNodeChildCount();
        if (cnt != -1 || (cnt = this._internalCount) != -1) {
            for (int i = 0; i < cnt; ++i) {
                NodeView child = (NodeView)this.getNodeChild(i);
                if (child == null || !child.isVisible() && !expandHiddenNodes) continue;
                child.setFullyExpanded(expand);
            }
        } else {
            int i = 0;
            NodeView nv = (NodeView)this.getNodeChild(i);
            while (nv != null) {
                if (nv.isVisible() || expandHiddenNodes) {
                    nv.setFullyExpanded(expand);
                }
                nv = (NodeView)this.getNodeChild(++i);
            }
        }
    }

    void setHeight(int height) {
        this.setBounds(this._x, this._y, this._width, height);
    }

    void setModelDefaultStyle(StaticPropertyBagInterface style) {
        if (this._pbagListener == null) {
            this._pbagListener = new PropertyBagListener();
        }
        if (this._modelDefaultNodeStyle != null) {
            this._modelDefaultNodeStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            this._modelDefaultNodeStyle = null;
        }
        this._modelDefaultNodeStyle = style;
        if (this._modelDefaultNodeStyle != null) {
            this._modelDefaultNodeStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
        }
    }

    void setModelStyle(StaticPropertyBagInterface style) {
        if (this._pbagListener == null) {
            this._pbagListener = new PropertyBagListener();
        }
        if (this._modelNodeStyle != null) {
            this._modelNodeStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
            this._modelNodeStyle = null;
        }
        this._modelNodeStyle = style;
        if (this._modelNodeStyle != null) {
            this._modelNodeStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this._pbagListener);
        }
    }

    void setNodeExpandedText(String newValue) {
        if (!this.isEditable()) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"notMutableNodeInterface.ex.txt"));
        }
        if (this.getNode() instanceof MutableNodeInterface) {
            ((MutableNodeInterface)this.getNode()).setNodeExpandedText(newValue);
        }
        if (Util.unequal((Object)this.getNodeExpandedText(), (Object)newValue)) {
            this.internalSetNodeExpandedText(newValue);
        }
    }

    void setNodeText(String newValue) {
        if (!this.isEditable()) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"notMutableNodeInterface.ex.txt"));
        }
        if (this.getNode() instanceof MutableNodeInterface) {
            ((MutableNodeInterface)this.getNode()).setNodeText(newValue);
        }
        if (Util.unequal((Object)this.getNodeText(), (Object)newValue)) {
            this.internalSetNodeText(newValue);
        }
    }

    void setWidth(int width) {
        if (width != this.getWidth()) {
            this.setBounds(this._x, this._y, width, this._height);
        }
    }

    void setX(int x) {
        this.setBounds(x, this._y, this._width, this._height);
    }

    void setY(int y) {
        this.setBounds(this._x, y, this._width, this._height);
    }

    boolean isFlagSet(int flag) {
        return (this._flags & flag) != 0;
    }

    void setFlag(int flag) {
        this._flags |= flag;
    }

    void unsetFlag(int flag) {
        this._flags &= ~flag;
    }

    class RenameNode
    extends AbstractCommand {
        public NodeView _node;
        String _cmdText;

        RenameNode() {
        }

        public String getText() {
            if (this._cmdText == null) {
                this._cmdText = RB.getStringResource((String)NodeView.RB_KEY, (String)"renameCommandLabel.txt");
            }
            return this._cmdText;
        }

        public Object clone() {
            return new RenameNode();
        }

        public void execute(Object object) {
            TreeView treeView = (TreeView)object;
            if (this._node == treeView.getCurrentNode()) {
                this._node.setEditable(true);
            }
        }
    }

    class PropertyBagListener
    implements PropertyBagChangedListener {
        PropertyBagListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent event) {
            if (Util.equal((Object)event.getPropertyName(), (Object)"visible")) {
                NodeView.this.updateVisibleNodeCount();
            }
            NodeView.this.treeView.noteNodeResized(NodeView.this);
        }
    }
}

