/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Dialog;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AssociationList;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.ButtonPanel;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.LabelView;
import com.sas.visuals.MessageBoxEscapeKeyAdapter;
import com.sas.visuals.MessageBoxEvent;
import com.sas.visuals.MessageBoxFocusAdapter;
import com.sas.visuals.MessageBoxListener;
import com.sas.visuals.MessageBoxListenerList;
import com.sas.visuals.MessageBoxSource;
import com.sas.visuals.PushButton;
import com.sas.visuals.RB;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.MinMaxSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageBox
extends Dialog
implements WindowListener,
ActionListener,
FocusListener,
MessageBoxSource {
    static final long serialVersionUID = -5020294287482489776L;
    public static final String RB_KEY = "MessageBox.";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_YES = 2;
    public static final int BUTTON_NO = 4;
    public static final int BUTTON_ABORT = 8;
    public static final int BUTTON_RETRY = 16;
    public static final int BUTTON_IGNORE = 32;
    public static final int BUTTON_CANCEL = 64;
    public static final int BUTTON_HELP = 128;
    public static final int BUTTON_STOP = 256;
    public static final int BUTTON_CONTINUE = 512;
    public static final int BUTTON_SKIP = 1024;
    private static final int BUTTON_MAX = 1024;
    public static final int BUTTONS_NONE = 0;
    public static final int BUTTONS_OK_CANCEL = 65;
    public static final int BUTTONS_YES_NO = 6;
    public static final int BUTTONS_YES_NO_CANCEL = 70;
    public static final int BUTTONS_ABORT_RETRY_IGNORE = 56;
    public static final int BUTTONS_RETRY_CANCEL = 80;
    public static final int BUTTONS_STOP_CONTINUE = 768;
    public static final int BUTTONS_STOP_SKIP = 1280;
    public static final int ICON_NONE = 0;
    public static final int ICON_INFO = 1;
    public static final int ICON_ERROR = 2;
    public static final int ICON_WARNING = 3;
    public static final int ICON_QUERY = 4;
    protected AssociationList buttonControls;
    protected ImageView image;
    protected PushButton lastButtonWithFocus;
    protected MessageBoxEscapeKeyAdapter escKeyAdapter;
    protected String message;
    protected int buttons;
    protected int focusButton;
    protected int icon;
    protected int selectedButton;
    protected Panel main;
    protected Panel panelBottom;
    protected Panel panelMiddle;
    protected ButtonPanel buttonPanel;
    protected boolean customButtonsFlag = false;
    protected Panel panelButtons;
    protected String[][] customButtons;
    protected Panel mainTop;
    protected String selectedActionCommand;
    private LabelView messageLabel;
    private static Hashtable buttonTitles = new Hashtable();
    protected MessageBoxListenerList messageBoxListenerList = new MessageBoxListenerList();

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "selectedButton"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedButton.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "selectedButton";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int showModalMessageBox(String message) {
        return MessageBox.showModalMessageBox(null, message);
    }

    public static int showModalMessageBox(Component frame, String message) {
        return MessageBox.showModalMessageBox(frame, RB.getStringResource((String)RB_KEY, (String)"note.txt"), message, 1, 1, 1);
    }

    public static int showModalMessageBox(String title, String message, int buttons, int defaultButton, int icon) {
        return MessageBox.showModalMessageBox(null, title, message, buttons, defaultButton, icon);
    }

    public static String showModalMessageBox(String title, String message, String[][] customButtons, int icon) {
        return MessageBox.showModalMessageBox(null, title, message, customButtons, icon);
    }

    public static int showModalMessageBox(Component frame, String title, String message, int buttons, int defaultButton, int icon) {
        boolean centerOverFrame = true;
        if (frame == null) {
            frame = new Frame();
            centerOverFrame = false;
        }
        MessageBox mb = new MessageBox((Frame)frame, title, true, message, buttons, defaultButton, icon);
        try {
            if (centerOverFrame) {
                Util.centerOver(mb, frame);
            } else {
                Util.center(mb);
            }
        }
        catch (IllegalComponentStateException e) {
            Util.center(mb);
        }
        mb.setVisible(true);
        return mb.getSelectedButton();
    }

    public static String showModalMessageBox(Component frame, String title, String message, String[][] customButtons, int icon) {
        boolean centerOverFrame = true;
        if (frame == null) {
            frame = new Frame();
            centerOverFrame = false;
        }
        MessageBox mb = new MessageBox((Frame)frame, title, true, message, customButtons, icon);
        try {
            if (centerOverFrame) {
                Util.centerOver(mb, frame);
            } else {
                Util.center(mb);
            }
        }
        catch (IllegalComponentStateException e) {
            Util.center(mb);
        }
        mb.setVisible(true);
        return mb.getSelectedActionCommand();
    }

    public MessageBox(Frame frame, String message) {
        this(frame, RB.getStringResource((String)RB_KEY, (String)"note.txt"), true, message, 1, 1, 1);
    }

    public MessageBox(Frame frame, String title, boolean modal, String message, int buttons, int defaultButton, int icon) {
        super(frame, title, modal);
        this.icon = icon;
        this.buttons = buttons;
        this.focusButton = defaultButton;
        this.message = message;
        this.commonInit();
    }

    public MessageBox(Frame frame, String title, boolean modal, String message, String[][] customButtons, int icon) {
        super(frame, title, modal);
        this.icon = icon;
        this.message = message;
        this.customButtonsFlag = true;
        this.customButtons = customButtons;
        this.buttonPanel = new ButtonPanel(customButtons);
        this.buttonPanel.initialize();
        this.commonInit();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.message = RB.getStringResource((String)RB_KEY, (String)"continue.txt");
        this.buttons = 6;
        this.focusButton = 2;
        this.icon = 0;
        this.selectedButton = 0;
        this.buttonControls = new AssociationList();
        this.selectedActionCommand = "Cancel";
        this.escKeyAdapter = new MessageBoxEscapeKeyAdapter(this);
    }

    protected void commonInit() {
        this.panelMiddle = new Panel();
        this.panelMiddle.setLayout((LayoutManager)new AutoSizingGridLayout(1, 0, 0, 0, false, false, true));
        this.panelBottom = new Panel();
        AutoSizingGridLayout panelBottomLayout = new AutoSizingGridLayout(1, 0, 0, 0, false, false, true);
        this.panelBottom.setLayout((LayoutManager)panelBottomLayout);
        panelBottomLayout.setGridGravity(256);
        this.setResizable(true);
        this.setInsets(10, 10, 10, 10);
        this.setLayout(new BorderLayout());
        this.main = new Panel();
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(4, 0, 5, 5, true, false, true);
        mainLayout.setGridGravity(256);
        mainLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new MinMaxSpacePartitioner(new int[]{200}, null));
        this.main.setLayout((LayoutManager)mainLayout);
        this.add((Component)this.main, "Center");
        this.mainTop = new Panel();
        this.mainTop.setLayout((LayoutManager)new AutoSizingGridLayout(0, 2, 5, 0, false, false, true));
        if (this.icon != 0) {
            try {
                Image name = Resources.getImage((String)this.getImageName());
                this.image = new ImageView();
                this.image.initialize();
                this.image.setImage(name);
                this.image.setResizeToFit(true);
                this.mainTop.add(this.image);
            }
            catch (Exception e) {
                this.icon = 0;
            }
        }
        this.messageLabel = new LabelView();
        this.messageLabel.setVerticalAlignment(256);
        this.messageLabel.setHorizontalAlignment(1);
        this.messageLabel.setInsets(new Insets(5, 5, 5, 5));
        this.messageLabel.setText(this.message);
        this.mainTop.add(this.messageLabel);
        this.main.add(this.mainTop);
        this.main.add(this.panelMiddle);
        Panel panel1 = new Panel();
        panel1.setName("code panel1");
        AutoSizingGridLayout panel1Layout = new AutoSizingGridLayout(1, 0);
        panel1Layout.setFillCell(true);
        panel1Layout.setGridGravity(256);
        panel1.setLayout((LayoutManager)panel1Layout);
        this.main.add(panel1);
        this.panelButtons = new Panel();
        this.panelButtons.setName("panelButtons");
        AutoSizingGridLayout buttonPanelLayout = new AutoSizingGridLayout(1, 0);
        buttonPanelLayout.setFillCell(true);
        buttonPanelLayout.setHgap(6);
        EqualSpacePartitioner buttonSpacePartitioner = new EqualSpacePartitioner();
        buttonSpacePartitioner.setMinimumSize(75);
        buttonPanelLayout.setColumnSpacePartitioner((SpacePartitionerInterface)buttonSpacePartitioner);
        this.panelButtons.setLayout((LayoutManager)buttonPanelLayout);
        panel1.add(this.panelButtons);
        if (!this.customButtonsFlag) {
            for (int i = 1; i <= 1024; i *= 2) {
                if ((this.buttons & i) == 0) continue;
                PushButton button = new PushButton();
                String label = (String)buttonTitles.get(new Integer(i));
                button.setText(label);
                this.panelButtons.add(button);
                button.addActionListener(this);
                button.addFocusListener(this);
                this.buttonControls.set((Object)button, (Object)new Integer(i));
                if (i != this.focusButton) continue;
                this.addWindowListener(new MessageBoxFocusAdapter(button));
            }
        } else {
            for (int j = 0; j < this.customButtons.length; ++j) {
                PushButton pButton = this.getButtonPanel().getButton(this.customButtons[j][0]);
                pButton.addActionListener(this);
                pButton.addFocusListener(this);
            }
            this.panelButtons.add(this.buttonPanel);
        }
        this.main.add(this.panelBottom);
        this.addWindowListener(this);
        this.main.validate();
        this.pack();
    }

    public void addBottomPanel(Container cont) {
        this.main.invalidate();
        this.panelBottom.add(cont);
        this.main.validate();
    }

    public void addMiddlePanel(Container cont) {
        this.main.invalidate();
        this.panelMiddle.add(cont);
        this.main.validate();
    }

    public String getSelectedActionCommand() {
        return this.selectedActionCommand;
    }

    public void addButton(String buttonText, String actionCommand) {
        if (this.customButtonsFlag) {
            PushButton pButton = this.buttonPanel.addButton(buttonText, actionCommand);
            pButton.addActionListener(this);
            pButton.addFocusListener(this);
            this.main.validate();
        }
    }

    public PushButton getButton(String buttonText) {
        if (this.customButtonsFlag) {
            return this.buttonPanel.getButton(buttonText);
        }
        return null;
    }

    public LabelView getLabel() {
        return this.messageLabel;
    }

    private ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public IconInterface getIcon() {
        return this.image;
    }

    public void setIcon(IconInterface image) {
        this.mainTop.removeAll();
        this.mainTop.add((com.sas.awt.Component)image);
        this.mainTop.add(this.messageLabel);
        this.main.validate();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.selectedButton = 0;
            this.selectedActionCommand = "Cancel";
        }
        super.setVisible(visible);
    }

    @Override
    protected String paramString() {
        String string = "title=" + this.getTitle() + ",";
        string = string + "message=" + this.message;
        return string;
    }

    public void setLabelHorizontalAlignment(int align) {
        this.messageLabel.setHorizontalAlignment(align);
        this.validate();
    }

    public int getLabelHorizontalAlignment() {
        return this.messageLabel.getHorizontalAlignment();
    }

    public void setLabelVerticalAlignment(int align) {
        this.messageLabel.setVerticalAlignment(align);
        this.validate();
    }

    public int getLabelVerticalAlignment() {
        return this.messageLabel.getVerticalAlignment();
    }

    protected String getImageName() {
        switch (this.icon) {
            case 2: {
                return "MessageBoxError";
            }
            case 1: {
                return "MessageBoxInfo";
            }
            case 3: {
                return "MessageBoxWarning";
            }
            case 4: {
                return "MessageBoxQuery";
            }
        }
        return null;
    }

    public int getSelectedButton() {
        return this.selectedButton;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.fireMessageBoxEvent(64);
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (this.lastButtonWithFocus != null) {
            this.lastButtonWithFocus.requestFocus();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (!this.customButtonsFlag) {
            Enumeration buttonEnum = this.buttonControls.getKeys();
            while (buttonEnum.hasMoreElements()) {
                PushButton button = (PushButton)buttonEnum.nextElement();
                if (source != button) continue;
                Integer buttonInteger = (Integer)this.buttonControls.get((Object)button);
                this.fireMessageBoxEvent(buttonInteger);
                this.dispose();
            }
        } else {
            this.selectedActionCommand = ((PushButton)source).getActionCommand();
            this.fireMessageBoxEvent(this.selectedActionCommand);
            this.dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.lastButtonWithFocus = (PushButton)event.getSource();
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void addMessageBoxListener(MessageBoxListener listener) {
        this.messageBoxListenerList.add(listener);
    }

    @Override
    public void removeMessageBoxListener(MessageBoxListener listener) {
        this.messageBoxListenerList.remove(listener);
    }

    public void fireMessageBoxEvent(int button) {
        this.selectedButton = button;
        MessageBoxListener[] listeners = this.messageBoxListenerList.getListeners();
        if (button != 64) {
            PushButton buttonTemp = (PushButton)this.buttonControls.getKey((Object)new Integer(button));
            for (int i = 0; i < listeners.length; ++i) {
                MessageBoxEvent event = new MessageBoxEvent((Object)this, 1001, button, buttonTemp.getActionCommand());
                listeners[i].messageBoxButtonSelected(event);
            }
        } else {
            for (int i = 0; i < listeners.length; ++i) {
                MessageBoxEvent event = new MessageBoxEvent((Object)this, 1001, button, "Cancel");
                listeners[i].messageBoxButtonSelected(event);
            }
        }
    }

    public void fireMessageBoxEvent(String command) {
        MessageBoxListener[] listeners = this.messageBoxListenerList.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            MessageBoxEvent event = new MessageBoxEvent(this, 1001, command);
            listeners[i].messageBoxButtonSelected(event);
        }
    }

    static {
        buttonTitles.put(new Integer(1), com.sas.util.Util.getCommonStringResource((String)"Ok.txt"));
        buttonTitles.put(new Integer(64), com.sas.util.Util.getCommonStringResource((String)"Cancel.txt"));
        buttonTitles.put(new Integer(2), com.sas.util.Util.getCommonStringResource((String)"Yes.txt"));
        buttonTitles.put(new Integer(4), com.sas.util.Util.getCommonStringResource((String)"No.txt"));
        buttonTitles.put(new Integer(8), com.sas.util.Util.getCommonStringResource((String)"Abort.txt"));
        buttonTitles.put(new Integer(16), com.sas.util.Util.getCommonStringResource((String)"Retry.txt"));
        buttonTitles.put(new Integer(32), com.sas.util.Util.getCommonStringResource((String)"Ignore.txt"));
        buttonTitles.put(new Integer(128), com.sas.util.Util.getCommonStringResource((String)"Help.txt"));
        buttonTitles.put(new Integer(256), "Stop");
        buttonTitles.put(new Integer(512), "Continue");
        buttonTitles.put(new Integer(1024), "Skip");
    }
}

