/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.GlobalInfoTable;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.security.SecuritySupport;
import com.sas.util.Util;
import com.sas.visuals.ForwardedActionEvent;
import com.sas.visuals.ForwardedActionListener;
import com.sas.visuals.ForwardedActionListenerList;
import com.sas.visuals.ForwardedActionSource;
import com.sas.visuals.ForwardedItemEvent;
import com.sas.visuals.ForwardedItemListener;
import com.sas.visuals.ForwardedItemListenerList;
import com.sas.visuals.ForwardedItemSource;
import com.sas.visuals.MultipleValueEventSourceInterface;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class MenuBar
extends java.awt.MenuBar
implements ForwardedActionSource,
ForwardedItemSource,
ItemSelectable,
ItemListener,
ActionListener,
MultipleValueEventSourceInterface {
    static final long serialVersionUID = 7586755436511081275L;
    protected transient ItemListener itemListenerList;
    protected transient ForwardedActionListenerList forwardedActionListenerList;
    protected transient ForwardedItemListenerList forwardedItemListenerList;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "name"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public Menu add(Menu m) {
        Menu menu = super.add(m);
        this.parseMenu(menu, true);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String cmd = evt.getActionCommand();
        if (source != null && source instanceof MenuItem) {
            cmd = ((MenuItem)source).getActionCommand();
        }
        ForwardedActionEvent newEvent = new ForwardedActionEvent((Object)this, evt.getID(), cmd, evt.getModifiers(), evt);
        this.processForwardedActionEvent(newEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        String cmd = null;
        if (source != null && source instanceof MenuItem) {
            cmd = ((MenuItem)source).getActionCommand();
        }
        ForwardedActionEvent newActionEvent = new ForwardedActionEvent((Object)this, evt.getID(), cmd, evt);
        this.processForwardedActionEvent(newActionEvent);
        ForwardedItemEvent newItemEvent = new ForwardedItemEvent(this, evt.getID(), evt.getItem(), evt.getStateChange(), cmd, evt);
        this.processItemEvent(newItemEvent);
        this.processForwardedItemEvent(newItemEvent);
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    @Override
    public void addForwardedActionListener(ForwardedActionListener listener) {
        if (this.forwardedActionListenerList == null) {
            this.forwardedActionListenerList = new ForwardedActionListenerList();
        }
        this.forwardedActionListenerList.add(listener);
    }

    @Override
    public void removeForwardedActionListener(ForwardedActionListener listener) {
        if (this.forwardedActionListenerList != null) {
            this.forwardedActionListenerList.remove(listener);
        }
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListenerList = AWTEventMulticaster.add(this.itemListenerList, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListenerList = AWTEventMulticaster.remove(this.itemListenerList, listener);
    }

    @Override
    public void addForwardedItemListener(ForwardedItemListener listener) {
        if (this.forwardedItemListenerList == null) {
            this.forwardedItemListenerList = new ForwardedItemListenerList();
        }
        this.forwardedItemListenerList.add(listener);
    }

    @Override
    public void removeForwardedItemListener(ForwardedItemListener listener) {
        if (this.forwardedItemListenerList != null) {
            this.forwardedItemListenerList.remove(listener);
        }
    }

    protected void processForwardedActionEvent(ForwardedActionEvent e) {
        if (this.forwardedActionListenerList != null) {
            ForwardedActionListener[] forwardedActionListeners = this.forwardedActionListenerList.getListeners();
            for (int i = 0; i < forwardedActionListeners.length; ++i) {
                forwardedActionListeners[i].forwardedActionPerformed(e);
            }
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListenerList != null) {
            this.itemListenerList.itemStateChanged(e);
        }
    }

    protected void processForwardedItemEvent(ForwardedItemEvent e) {
        if (this.forwardedItemListenerList != null) {
            ForwardedItemListener[] forwardedItemListeners = this.forwardedItemListenerList.getListeners();
            for (int i = 0; i < forwardedItemListeners.length; ++i) {
                forwardedItemListeners[i].forwardedItemStateChanged(e);
            }
        }
    }

    public synchronized MenuItem[] getMenuItems(String cmdStr) {
        if (cmdStr == null) {
            return null;
        }
        OrderedCollection menuItems = new OrderedCollection();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            Menu menu = this.getMenu(i);
            Enumeration menuE = this.parseMenuCommands(menu, cmdStr);
            if (menuE == null) continue;
            menuItems.addItems(menuE);
        }
        MenuItem[] items = new MenuItem[menuItems.count()];
        Enumeration menuE = menuItems.getItems();
        int i = 0;
        while (menuE.hasMoreElements()) {
            items[i++] = (MenuItem)menuE.nextElement();
        }
        if (menuItems.count() > 0) {
            return items;
        }
        return null;
    }

    public void setMenuItemsEnabled(String cmd, boolean enabled) {
        MenuItem[] items = this.getMenuItems(cmd);
        for (int i = 0; i < items.length; ++i) {
            items[i].setEnabled(enabled);
        }
    }

    protected Enumeration parseMenuCommands(Menu currentMenu, String cmdStr) {
        OrderedCollection menuItems = new OrderedCollection();
        String cmdID = currentMenu.getActionCommand();
        if (cmdID != null && (cmdStr == null || cmdID.equals(cmdStr))) {
            menuItems.add((Object)currentMenu);
        }
        for (int i = 0; i < currentMenu.getItemCount(); ++i) {
            MenuItem item = currentMenu.getItem(i);
            cmdID = item.getActionCommand();
            if (item instanceof Menu) {
                menuItems.addItems(this.parseMenuCommands((Menu)item, cmdStr));
                continue;
            }
            if (cmdID == null || cmdStr != null && !cmdID.equals(cmdStr)) continue;
            menuItems.add((Object)item);
        }
        return menuItems.getItems();
    }

    public void updateMenuItems() {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            Menu menuItem = this.getMenu(i);
            this.parseMenu(menuItem, true);
        }
    }

    protected void parseMenu(Menu currentMenu, boolean addListeners) {
        for (int i = 0; i < currentMenu.getItemCount(); ++i) {
            MenuItem item = currentMenu.getItem(i);
            if (item instanceof Menu) {
                this.parseMenu((Menu)item, addListeners);
                continue;
            }
            if (addListeners) {
                this.addListeners(item, false);
                continue;
            }
            this.removeListeners(item, false);
        }
    }

    public void removeListeners(MenuItem menuItem, boolean parseMenu) {
        menuItem.removeActionListener(this);
        if (menuItem instanceof ItemSelectable) {
            ((ItemSelectable)((Object)menuItem)).removeItemListener(this);
        }
        if (menuItem instanceof Menu && parseMenu) {
            this.parseMenu((Menu)menuItem, false);
        }
    }

    public void addListeners(MenuItem menuItem, boolean parseMenu) {
        this.removeListeners(menuItem, false);
        menuItem.addActionListener(this);
        if (menuItem instanceof ItemSelectable) {
            ((ItemSelectable)((Object)menuItem)).addItemListener(this);
        }
        if (menuItem instanceof Menu && parseMenu) {
            this.parseMenu((Menu)menuItem, false);
        }
    }

    public boolean supportsListenerInterface(Class listenerInterface) {
        return listenerInterface == GlobalInfoTable._loadClass((String)"com.sas.visuals.ForwardedActionListener");
    }

    public Method getEventMethod(Method lMethod) {
        Class faeClass = GlobalInfoTable._loadClass((String)"com.sas.visuals.ForwardedActionEvent");
        Method eventMethod = null;
        Class<?>[] parameterClass = lMethod.getParameterTypes();
        if (Util.equal((Object)lMethod.getName(), (Object)"forwardedActionPerformed") && Util.equal(parameterClass[0], (Object)faeClass)) {
            try {
                eventMethod = SecuritySupport.securitySupport.getMethod(faeClass, "getActionCommand", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                eventMethod = null;
            }
            catch (SecurityException e) {
                eventMethod = null;
            }
        }
        return eventMethod;
    }

    public String[] getEventValues(Method lMethod) {
        Class<?>[] parameterClass = lMethod.getParameterTypes();
        if (Util.equal((Object)lMethod.getName(), (Object)"forwardedActionPerformed") && Util.equal(parameterClass[0], (Object)GlobalInfoTable._loadClass((String)"com.sas.visuals.ForwardedActionEvent"))) {
            OrderedCollection menuItemCommands = new OrderedCollection();
            int count = this.getMenuCount();
            for (int i = 0; i < count; ++i) {
                Menu menu = this.getMenu(i);
                Enumeration menuE = this.parseCommands(menu);
                if (menuE == null) continue;
                menuItemCommands.addItems(menuE);
            }
            count = menuItemCommands.count();
            String[] menuCmds = new String[count];
            for (int i = 0; i < count; ++i) {
                menuCmds[i] = (String)menuItemCommands.get(i);
            }
            return menuCmds;
        }
        return null;
    }

    protected Enumeration parseCommands(Menu currentMenu) {
        OrderedCollection menuCommands = new OrderedCollection();
        int count = currentMenu.getItemCount();
        for (int i = 0; i < count; ++i) {
            MenuItem item = currentMenu.getItem(i);
            String cmdID = item.getActionCommand();
            if (item instanceof Menu) {
                menuCommands.addItems(this.parseCommands((Menu)item));
                continue;
            }
            if (cmdID == null || cmdID.equals("-")) continue;
            menuCommands.add((Object)("\"" + cmdID + "\""));
        }
        return menuCommands.getItems();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "itemL", this.itemListenerList);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }
}

