/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.lang.ObjectDataInterface;
import com.sas.models.DefaultColorList;
import com.sas.util.Command;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.DetailedSelectorInterface;
import com.sas.visuals.UpDownListBox;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class ListBoxSelector
implements DetailedSelectorInterface,
ItemListener {
    public UpDownListBox listBox;
    private transient ItemListener itemListener;
    protected boolean reorderControlVisible = true;
    public OrderedCollection buttonPanelCommands;
    public OrderedCollection bottomButtonPanelCommands;
    protected String componentTitle = null;
    public Component detailsComponent = null;
    public Object defaultItemValue = null;
    Command addCommand;
    Command removeCommand;
    Command replaceCommand;
    protected transient ItemListener itemListenerList;

    public ListBoxSelector() {
        this.setDefaultValues();
    }

    public ListBoxSelector(String componentTitle) {
        this.componentTitle = componentTitle;
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.buttonPanelCommands = new OrderedCollection();
        this.bottomButtonPanelCommands = new OrderedCollection();
        this.listBox = new UpDownListBox();
        this.listBox.initialize();
        this.listBox.setMultipleMode(true);
        this.listBox.setDisplayTransform((TransformInterface)ObjectToStringTransform.defaultInstance);
        this.listBox.addItemListener(this);
        this.addCommand = new AddCommand();
        this.removeCommand = new RemoveCommand();
        this.replaceCommand = new ReplaceCommand();
        this.buttonPanelCommands.add((Object)this.addCommand);
        this.buttonPanelCommands.add((Object)this.replaceCommand);
        this.bottomButtonPanelCommands.add((Object)this.removeCommand);
        String itemsTitle = com.sas.util.Util.getCommonStringResource((String)"Customizer.itemsLabel.txt");
        this.setComponentTitle(itemsTitle);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.listBox) {
            Object item = event.getItem();
            int index = (Integer)item;
            this.setSelectedItem(index);
            this.detailsComponent.requestFocus();
        }
    }

    protected void setSelectedItem(int index) {
        int[] selectedIndex = this.listBox.getSelectedIndexes();
        this.enableButtons();
        if (index != -1 && selectedIndex.length == 1) {
            if (selectedIndex[0] != index) {
                index = selectedIndex[0];
            }
            OrderedCollectionInterface model = (OrderedCollectionInterface)this.listBox.getModelInterface();
            ((ObjectDataInterface)this.detailsComponent).setObjectData(model.get(index));
        } else {
            ((ObjectDataInterface)this.detailsComponent).setObjectData(this.defaultItemValue);
        }
    }

    public void setReorderControlVisible(boolean hidden) {
        if (hidden != this.isReorderControlVisible()) {
            this.reorderControlVisible = hidden;
        }
        if (!this.isReorderControlVisible()) {
            this.listBox.setSpinButtonVisible(false);
        } else {
            this.listBox.setSpinButtonVisible(true);
        }
    }

    public boolean isReorderControlVisible() {
        return this.reorderControlVisible;
    }

    @Override
    public Component getComponent() {
        return this.listBox;
    }

    @Override
    public String getComponentTitle() {
        return this.componentTitle;
    }

    public void setComponentTitle(String title) {
        this.componentTitle = title;
    }

    public void add(Object item, int pos) {
        this.listBox.add(item, pos);
    }

    public void deselectAll() {
        this.listBox.deselectAll();
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model != null) {
            this.listBox.setModelInterface(null);
        }
    }

    public int getItemCount() {
        return this.listBox.getItemCount();
    }

    @Override
    public ModelInterface getModelInterface() {
        if (this.listBox.getModelInterface() != null) {
            return this.listBox.getModelInterface();
        }
        return new DefaultColorList();
    }

    public int[] getSelectedIndexes() {
        return this.listBox.getSelectedIndexes();
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.listBox.getSelectedObjects();
    }

    public void refresh() {
        this.listBox.refresh();
    }

    public Object getDefaultItemValue() {
        return this.defaultItemValue;
    }

    public void setDefaultItemValue(Object defaultItemValue) {
        this.defaultItemValue = defaultItemValue;
        this.setSelectedItem(-1);
    }

    public void replaceItem(Object newValue, int index) {
        this.listBox.replaceItem(newValue, index);
    }

    public void remove(int index) {
        this.listBox.remove(index);
    }

    public void select(int index) {
        this.listBox.select(index);
    }

    public void setSpinButtonVisible(boolean bool) {
        this.listBox.setSpinButtonVisible(bool);
    }

    @Override
    public void setModelInterface(ModelInterface model) {
        if (model instanceof OrderedCollectionInterface) {
            this.listBox.setModelInterface(model);
        }
    }

    @Override
    public void setDetailsComponent(Component detailsComponent) {
        this.detailsComponent = detailsComponent;
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void setEnabled(boolean bool) {
        this.listBox.setEnabled(bool);
    }

    @Override
    public Command[] getBottomButtonPanelCommands() {
        int commandCount = this.bottomButtonPanelCommands.count();
        Command[] commands = new Command[commandCount];
        for (int i = 0; i < commandCount; ++i) {
            commands[i] = (Command)this.bottomButtonPanelCommands.get(i);
        }
        return commands;
    }

    @Override
    public Command[] getButtonPanelCommands() {
        int commandCount = this.buttonPanelCommands.count();
        Command[] commands = new Command[commandCount];
        for (int i = 0; i < commandCount; ++i) {
            commands[i] = (Command)this.buttonPanelCommands.get(i);
        }
        return commands;
    }

    @Override
    public Vector getRequiredInterfaces() {
        return this.listBox.getRequiredInterfaces();
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.listBox.addItemListener(listener);
        this.itemListenerList = AWTEventMulticaster.add(this.itemListenerList, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.listBox.removeItemListener(listener);
        this.itemListenerList = AWTEventMulticaster.remove(this.itemListenerList, listener);
    }

    protected void fireItemEvent(ItemEvent e) {
        this.itemListenerList.itemStateChanged(e);
        this.itemStateChanged(e);
    }

    @Override
    public void enableButtons() {
        int[] selectedIndexes = this.listBox.getSelectedIndexes();
        if (selectedIndexes.length == 0) {
            ((AddCommand)this.addCommand).setExecutable(true);
            ((ReplaceCommand)this.replaceCommand).setExecutable(false);
            ((RemoveCommand)this.removeCommand).setExecutable(false);
            if (this.detailsComponent != null && this.listBox.getItemCount() == 0) {
                Util.setEnabledOnContainer((Container)this.detailsComponent, true);
            }
        } else {
            if (selectedIndexes.length == 1) {
                ((ReplaceCommand)this.replaceCommand).setExecutable(true);
                ((AddCommand)this.addCommand).setExecutable(true);
                Util.setEnabledOnContainer((Container)this.detailsComponent, true);
            } else if (selectedIndexes.length > 1) {
                ((ReplaceCommand)this.replaceCommand).setExecutable(false);
                ((AddCommand)this.addCommand).setExecutable(false);
                Util.setEnabledOnContainer((Container)this.detailsComponent, false);
            } else {
                ((ReplaceCommand)this.replaceCommand).setExecutable(false);
            }
            ((RemoveCommand)this.removeCommand).setExecutable(true);
        }
    }

    class AddCommand
    implements Command {
        String commandText = com.sas.util.Util.getCommonStringResource((String)"Add.txt");
        int addIndex = -1;
        boolean enabled = true;

        public void execute(Object arg) {
            if (ListBoxSelector.this.detailsComponent != null) {
                int[] selectedIndexes = ListBoxSelector.this.listBox.getSelectedIndexes();
                int selectedIndex = ListBoxSelector.this.listBox.getItemCount();
                if (selectedIndexes.length > 0) {
                    selectedIndex = selectedIndexes[selectedIndexes.length - 1] + 1;
                }
                if (arg != null && arg instanceof Integer) {
                    this.addIndex = (Integer)arg;
                }
                Object data = ((ObjectDataInterface)ListBoxSelector.this.detailsComponent).getObjectData();
                ListBoxSelector.this.listBox.deselectAll();
                if (this.addIndex == -1) {
                    ListBoxSelector.this.listBox.add(data, selectedIndex);
                    ListBoxSelector.this.listBox.select(selectedIndex);
                    ListBoxSelector.this.fireItemEvent(new ItemEvent(ListBoxSelector.this.listBox, 701, new Integer(selectedIndex), 1));
                } else {
                    ListBoxSelector.this.listBox.add(data, this.addIndex);
                    ListBoxSelector.this.listBox.select(this.addIndex);
                    ListBoxSelector.this.fireItemEvent(new ItemEvent(ListBoxSelector.this.listBox, 701, new Integer(this.addIndex), 1));
                }
                ListBoxSelector.this.detailsComponent.requestFocus();
                ListBoxSelector.this.listBox.refresh();
            }
        }

        public Object clone() {
            return null;
        }

        public boolean isExecutable() {
            return this.enabled;
        }

        public void setExecutable(boolean enable) {
            this.enabled = enable;
        }

        public boolean isUndoable() {
            return false;
        }

        public void undo() {
        }

        public void setText(String text) {
            this.commandText = text;
        }

        public String getText() {
            return this.commandText;
        }
    }

    class RemoveCommand
    implements Command {
        String commandText = com.sas.util.Util.getCommonStringResource((String)"Remove.txt");
        boolean enabled = false;

        public void execute(Object arg) {
            if (ListBoxSelector.this.detailsComponent != null) {
                Object data = ((ObjectDataInterface)ListBoxSelector.this.detailsComponent).getObjectData();
                int[] selectedIndexes = ListBoxSelector.this.listBox.getSelectedIndexes();
                if (selectedIndexes.length > 0) {
                    for (int i = selectedIndexes.length - 1; i >= 0; --i) {
                        ListBoxSelector.this.listBox.remove(selectedIndexes[i]);
                    }
                    int selectedIndex = selectedIndexes[selectedIndexes.length - 1] - selectedIndexes.length + 1;
                    if (selectedIndex >= ListBoxSelector.this.listBox.getItemCount()) {
                        selectedIndex = ListBoxSelector.this.listBox.getItemCount() - 1;
                    }
                    if (selectedIndex != -1) {
                        ListBoxSelector.this.listBox.select(selectedIndex);
                    }
                    ListBoxSelector.this.setSelectedItem(selectedIndex);
                    ListBoxSelector.this.fireItemEvent(new ItemEvent(ListBoxSelector.this.listBox, 701, new Integer(selectedIndex), 1));
                }
                ListBoxSelector.this.listBox.refresh();
            }
        }

        public Object clone() {
            return null;
        }

        public boolean isExecutable() {
            return this.enabled;
        }

        public void setExecutable(boolean enable) {
            this.enabled = enable;
        }

        public boolean isUndoable() {
            return false;
        }

        public void undo() {
        }

        public void setText(String text) {
            this.commandText = text;
        }

        public String getText() {
            return this.commandText;
        }
    }

    class ReplaceCommand
    implements Command {
        String commandText = com.sas.util.Util.getCommonStringResource((String)"Replace.txt");
        boolean enabled = false;

        public void execute(Object arg) {
            if (ListBoxSelector.this.detailsComponent != null) {
                Object data = ((ObjectDataInterface)ListBoxSelector.this.detailsComponent).getObjectData();
                int[] selectedIndexes = ListBoxSelector.this.listBox.getSelectedIndexes();
                if (selectedIndexes.length == 1) {
                    ListBoxSelector.this.listBox.replaceItem(data, selectedIndexes[0]);
                    ListBoxSelector.this.listBox.select(selectedIndexes[0]);
                    ListBoxSelector.this.detailsComponent.requestFocus();
                    ListBoxSelector.this.fireItemEvent(new ItemEvent(ListBoxSelector.this.listBox, 701, new Integer(selectedIndexes[0]), 2));
                }
                ListBoxSelector.this.listBox.refresh();
            }
        }

        public Object clone() {
            return null;
        }

        public boolean isExecutable() {
            return this.enabled;
        }

        public void setExecutable(boolean enable) {
            this.enabled = enable;
        }

        public boolean isUndoable() {
            return false;
        }

        public void undo() {
        }

        public void setText(String text) {
            this.commandText = text;
        }

        public String getText() {
            return this.commandText;
        }
    }
}

