/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.awt.print.PrintException;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.StringCollection;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.util.Strings;
import com.sas.visuals.Alignment;
import com.sas.visuals.IconInterface;
import com.sas.visuals.RB;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LabelView
extends com.sas.awt.Component
implements StringDataInterface,
IconInterface,
Alignment,
ResizeToFitInterface,
PublicClonable,
ViewDefaultModelInterface {
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER_LEFT = 257;
    public static final int CENTER_RIGHT = 258;
    static final long serialVersionUID = 7063356250913448657L;
    static final String RB_KEY = "LabelView.";
    static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    StringData defaultModel;
    StringCollection multilineText;
    String text;
    int hAlign;
    int vAlign;
    Insets currentInsets;
    boolean resizeToFit;
    boolean wordWrap = false;
    transient int fontAscent;
    transient int fontDescent;
    transient int fontHeight;
    transient Vector lineWidths;
    transient Dimension currentTextSize;
    transient Font prevFont;
    int tab = 4;
    private static int defaultHeight = 23;
    private static int defaultWidth = 124;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "horizontalAlignment"}, {"Property editor class", "com.sas.beans.editors._LabelViewHorizontalAlignmentEditor"}}, {{"Name", "verticalAlignment"}, {"Property editor class", "com.sas.beans.editors._VerticalAlignmentEditor"}}};
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.pd.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public LabelView() {
        if (this.isDesignTime()) {
            this.setText(RB.getStringResource((String)RB_KEY, (String)"defaultLabel.txt"));
        }
    }

    public LabelView(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LabelView clone = (LabelView)super.clone();
        ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
        VisualInterfaceSupport.clone(this, clone);
        if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
            StringData clonedModel = (StringData)this.defaultModel.clone();
            clone.setModelInterface((ModelInterface)clonedModel);
            clone.defaultModel = clonedModel;
        }
        try {
            clone.multilineText = (StringCollection)this.multilineText.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.currentInsets = new Insets(this.currentInsets.top, this.currentInsets.left, this.currentInsets.bottom, this.currentInsets.right);
        clone.lineWidths = new Vector();
        clone.currentTextSize = null;
        return clone;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.resizeToFit();
    }

    public int getHorizontalAlignment() {
        return this.hAlign;
    }

    public Insets getInsets() {
        Insets borderInsets = this.getBorder().getInsets();
        Insets insets = new Insets(this.currentInsets.top, this.currentInsets.left, this.currentInsets.bottom, this.currentInsets.right);
        if (this.currentInsets.top < borderInsets.top) {
            insets.top = borderInsets.top;
        }
        if (this.currentInsets.bottom < borderInsets.bottom) {
            insets.bottom = borderInsets.bottom;
        }
        if (this.currentInsets.left < borderInsets.left) {
            insets.left = borderInsets.left;
        }
        if (this.currentInsets.right < borderInsets.right) {
            insets.right = borderInsets.right;
        }
        return insets;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minSize = new Dimension(0, 0);
        Insets insets = this.getInsets();
        if (this.currentTextSize == null) {
            this.currentTextSize = this.calculateTextDisplay();
            if (this.currentTextSize == null) {
                return minSize;
            }
        }
        if (this.currentTextSize.width > 0 && this.currentTextSize.height > 0) {
            minSize.width = this.currentTextSize.width + insets.left + insets.right;
            minSize.height = this.currentTextSize.height + insets.top + insets.bottom;
        }
        return minSize;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    public int getTabSpace() {
        return this.tab;
    }

    public String getText() {
        return ((StringDataInterface)this.getModelInterface()).getText();
    }

    public int getVerticalAlignment() {
        return this.vAlign;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        if (this.text == null) {
            return;
        }
        Insets insets = this.getInsets();
        Dimension paintSize = new Dimension();
        Point initPoint = new Point(x, y);
        paintSize.width = width - insets.left - insets.right;
        paintSize.height = height - insets.top - insets.bottom;
        Component comp = component;
        if (component == null) {
            comp = this;
        }
        Font f = comp.getFont();
        if (comp == this && f != this.prevFont) {
            this.prevFont = f;
            this.currentTextSize = null;
        }
        if (this.currentTextSize == null) {
            this.currentTextSize = this.calculateTextDisplay();
            if (this.isWordWrap()) {
                this.parseText();
                this.currentTextSize = this.calculateTextDisplay();
            }
            if (this.currentTextSize == null) {
                return;
            }
            this.resizeToFit();
        }
        Rectangle clipBounds = g.getClipBounds();
        g.clipRect(x, y, paintSize.width, paintSize.height);
        g.setColor(comp.getForeground());
        if (f != null && !f.equals(g.getFont())) {
            g.setFont(f);
        }
        if (paintSize.width < this.currentTextSize.width) {
            if (this.hAlign == 257) {
                initPoint.x = insets.left;
            } else if (this.hAlign == 258) {
                initPoint.x = paintSize.width - this.currentTextSize.width + x;
            } else if (this.hAlign == 256) {
                initPoint.x = (paintSize.width - this.currentTextSize.width) / 2 + x;
            } else if (this.hAlign == 2) {
                initPoint.x = paintSize.width - this.currentTextSize.width + x;
            }
        } else if (this.hAlign == 256 || this.hAlign == 258 || this.hAlign == 257) {
            initPoint.x = (paintSize.width - this.currentTextSize.width) / 2 + x;
        } else if (this.hAlign == 2) {
            initPoint.x = paintSize.width - this.currentTextSize.width + x;
        }
        if (this.vAlign == 256) {
            initPoint.y = (paintSize.height - this.currentTextSize.height) / 2 + y;
        } else if (this.vAlign == 8) {
            initPoint.y = paintSize.height - this.currentTextSize.height + y;
        }
        initPoint.y += this.fontAscent;
        int origX = initPoint.x;
        int multilineCount = this.multilineText.count();
        if (this.lineWidths.size() < multilineCount) {
            multilineCount = this.lineWidths.size();
        }
        for (int i = 0; i < multilineCount; ++i) {
            int lineWidth = (Integer)this.lineWidths.elementAt(i);
            if (paintSize.width < this.currentTextSize.width) {
                if (this.hAlign == 258 || this.hAlign == 2) {
                    initPoint.x = origX + this.currentTextSize.width - lineWidth;
                } else if (this.hAlign == 257 || this.hAlign == 1) {
                    initPoint.x = insets.left;
                } else if (this.hAlign == 256) {
                    initPoint.x = origX + (this.currentTextSize.width - lineWidth) / 2;
                }
            } else if (this.hAlign == 256 || this.hAlign == 258 || this.hAlign == 257) {
                initPoint.x = origX + (this.currentTextSize.width - lineWidth) / 2;
            } else if (this.hAlign == 2) {
                initPoint.x = origX + this.currentTextSize.width - lineWidth;
            }
            com.sas.awt.util.Util.drawString(g, (String)this.multilineText.get(i), initPoint.x, initPoint.y, this.isEnabled());
            initPoint.y += this.fontHeight;
            initPoint.x = origX;
        }
        g.setClip(clipBounds);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.paint(this, g, insets.left, insets.top, size.width, size.height);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.getModelInterface() && com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text")) {
            this.refresh();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.hAlign == 0) {
            this.hAlign = 256;
        }
        if (this.vAlign == 0) {
            this.vAlign = 256;
        }
        this.lineWidths = new Vector();
    }

    @Override
    public void refresh(ModelInterface model) {
        this.refresh();
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            String modelText = ((StringDataInterface)model).getText();
            String oldText = this.text;
            this.text = modelText;
            this.parseText();
            this.currentTextSize = this.calculateTextDisplay();
            this.resizeToFit();
            this.repaint();
            if (oldText != this.text) {
                this.firePropertyChange("text", oldText, this.text);
            }
        }
    }

    protected synchronized void parseText() {
        String txt = this.getText();
        if (txt.indexOf("\r") != -1) {
            txt = Strings.replace((String)txt, (int)0, (int)-1, (String)"\r", (String)"");
        }
        if (txt.indexOf("\t") != -1) {
            StringBuffer tabSpace = new StringBuffer();
            int spaces = this.getTabSpace();
            for (int i = 0; i < spaces; ++i) {
                tabSpace.append(' ');
            }
            txt = Strings.replace((String)txt, (int)0, (int)-1, (String)"\t", (String)tabSpace.toString());
        }
        this.multilineText = new StringCollection();
        StringCollection tempMultilineText = new StringCollection();
        if (this.isWordWrap() && this.currentTextSize != null) {
            this.wordWrap(txt);
        } else {
            int txtLength = txt.length() - 1;
            int[] positions = Strings.positions((String)txt, (int)0, (int)-1, (char)'\n');
            int posLength = positions.length;
            String subString = "";
            for (int i = 0; i < posLength; ++i) {
                subString = i == 0 ? txt.substring(0, positions[i]) : txt.substring(positions[i - 1], positions[i]);
                if (subString.length() == 1 && subString.equals("\n")) {
                    tempMultilineText.add(" ");
                } else if (subString.startsWith("\n")) {
                    tempMultilineText.add(subString.substring(1));
                } else {
                    tempMultilineText.add(subString);
                }
                if (positions[i] != txtLength) continue;
                tempMultilineText.add(" ");
            }
            if (posLength == 0) {
                tempMultilineText.add(txt);
            } else if (positions[posLength - 1] < txtLength) {
                tempMultilineText.add(txt.substring(positions[positions.length - 1] + 1));
            }
            int tempCount = tempMultilineText.count();
            for (int i = 0; i < tempCount; ++i) {
                this.multilineText.add(tempMultilineText.get(i));
            }
        }
    }

    protected void wordWrap(String string) {
        Dimension Psize = this.getSize();
        this.multilineText = new StringCollection();
        StringCollection tempMultilineText = new StringCollection();
        StringTokenizer st = new StringTokenizer(string, " \t\r\n", true);
        Font f = this.getFont();
        Container parent = this.getParent();
        if (f == null && parent != null) {
            f = parent.getFont();
        }
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(f);
        int wordIndex = 0;
        int startIndex = 0;
        int subLength = 0;
        int endIndex = 0;
        int wordLength = 0;
        Insets inset = this.getInsets();
        int PsizeWidth = Psize.width - inset.right - inset.left;
        if (fm.stringWidth(string) > PsizeWidth) {
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (word.equals(" ")) continue;
                wordIndex = string.indexOf(word, endIndex) == -1 ? string.indexOf(word) : string.indexOf(word, endIndex);
                wordLength = word.equals("\t") ? this.getTabSpace() : word.length();
                endIndex = wordIndex + wordLength;
                String subString = string.substring(startIndex, endIndex);
                subLength = fm.stringWidth(subString);
                if (word.equals("\n")) {
                    if (tempMultilineText.count() >= 1) {
                        tempMultilineText.removeAt(tempMultilineText.count() - 1);
                    }
                    tempMultilineText.add(string.substring(startIndex, wordIndex));
                    tempMultilineText.add(string.substring(wordIndex + 1, string.length()));
                    startIndex = wordIndex + 1;
                    continue;
                }
                if (subLength > PsizeWidth && wordIndex > startIndex) {
                    if (tempMultilineText.count() >= 1) {
                        tempMultilineText.removeAt(tempMultilineText.count() - 1);
                    }
                    tempMultilineText.add(string.substring(startIndex, wordIndex - 1));
                    tempMultilineText.add(string.substring(wordIndex, string.length()));
                    startIndex = wordIndex;
                    continue;
                }
                if (tempMultilineText.count() >= 1) {
                    tempMultilineText.removeAt(tempMultilineText.count() - 1);
                }
                tempMultilineText.add(string.substring(startIndex, endIndex));
            }
        } else {
            tempMultilineText.addItems((Enumeration)new StringTokenizer(string, "\n"));
        }
        int tempCount = tempMultilineText.count();
        for (int i = 0; i < tempCount; ++i) {
            this.multilineText.add(tempMultilineText.get(i));
        }
    }

    protected Dimension calculateTextDisplay() {
        String txt = this.getText();
        if (txt != null) {
            Font f = this.getFont();
            Container parent = this.getParent();
            if (f == null && parent != null) {
                f = parent.getFont();
            }
            if (f == null) {
                return null;
            }
            int multilineCount = this.multilineText.count();
            FontMetrics fontInfo = this.getFontMetrics(f);
            this.fontAscent = fontInfo.getAscent();
            this.fontDescent = fontInfo.getDescent();
            this.fontHeight = fontInfo.getHeight();
            Dimension textSize = new Dimension(0, this.fontHeight * multilineCount);
            this.lineWidths.removeAllElements();
            for (int i = 0; i < multilineCount; ++i) {
                int width = fontInfo.stringWidth(this.multilineText.getString(i));
                this.lineWidths.addElement(new Integer(width));
                if (width <= textSize.width) continue;
                textSize.width = width;
            }
            return textSize;
        }
        return null;
    }

    public void resizeToFit() {
        if (this.isResizeToFit() && this.isDisplayable()) {
            this.setSize(this.getPreferredSize());
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                parent.validate();
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (!this.isResizeToFit()) {
            this.currentTextSize = null;
            super.setBounds(x, y, width, height);
        } else {
            Dimension pSize = this.getPreferredSize();
            super.setBounds(x, y, pSize.width, pSize.height);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.currentTextSize = null;
        this.lineWidths = new Vector();
        this.vAlign = 256;
        this.hAlign = 1;
        this.fontAscent = 0;
        this.fontDescent = 0;
        this.fontHeight = 0;
        this.resizeToFit = false;
        this.defaultModel = new StringData();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        this.currentTextSize = this.calculateTextDisplay();
        this.resizeToFit();
    }

    public void setHorizontalAlignment(int align) {
        if (align != this.hAlign) {
            int oldAlign = this.hAlign;
            this.hAlign = align;
            this.repaint();
            this.firePropertyChange("horizontalAlignment", new Integer(oldAlign), new Integer(this.hAlign));
        }
    }

    public void setInsets(Insets margins) {
        if (!com.sas.util.Util.equal((Object)margins, (Object)this.currentInsets)) {
            Insets oldInsets = this.currentInsets;
            this.currentInsets = margins;
            if (this.isWordWrap()) {
                this.parseText();
                this.currentTextSize = null;
            }
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("insets", oldInsets, this.currentInsets);
        }
    }

    public void setResizeToFit(boolean resize) {
        if (this.resizeToFit != resize) {
            this.resizeToFit = resize;
            this.resizeToFit();
            this.firePropertyChange("resizeToFit", new Boolean(!this.resizeToFit), new Boolean(this.resizeToFit));
        }
    }

    public void setTabSpace(int space) {
        if (this.tab != space) {
            int oldTab = this.tab;
            this.tab = space;
            this.parseText();
            this.currentTextSize = null;
            this.resizeToFit();
            this.repaint();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"tabSpace", (int)oldTab, (int)this.tab);
        }
    }

    public void setVerticalAlignment(int align) {
        if (align != this.vAlign) {
            int oldAlign = this.vAlign;
            this.vAlign = align;
            this.repaint();
            this.firePropertyChange("horizontalAlignment", new Integer(oldAlign), new Integer(this.vAlign));
        }
    }

    public void setWordWrap(boolean wrap) {
        if (this.wordWrap != wrap) {
            this.wordWrap = wrap;
            this.parseText();
            this.currentTextSize = null;
            this.resizeToFit();
            this.repaint();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"wordWrap", (boolean)this.wordWrap);
        }
    }

    public synchronized void setText(String label) {
        String currentText = this.getText();
        if (currentText == null && label != null || currentText != null && label == null || currentText != label && com.sas.util.Util.unequal((Object)currentText, (Object)label) && this.getModelInterface() != null) {
            String newText = label;
            if (this.isDesignTime() && newText != null) {
                newText = Strings.replace((String)label, (int)0, (int)-1, (String)"\\n", (String)"\n");
                newText = Strings.replace((String)newText, (int)0, (int)-1, (String)"\\t", (String)"\t");
                newText = Strings.replace((String)newText, (int)0, (int)-1, (String)"\\r", (String)"\r");
            }
            ((StringDataInterface)this.getModelInterface()).setText(newText);
        }
    }

    @Override
    public void print(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void print(Graphics g, int pageNumber, int pageWidth, int pageHeight) throws PrintException {
        if (!this.pageExists(pageNumber)) {
            throw new IndexOutOfBoundsException();
        }
        Font font = this.getFont();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        double xRatio = (double)(pageWidth - insets.left - insets.right) / (double)(size.width - insets.left - insets.right);
        double yRatio = (double)(pageHeight - insets.top - insets.bottom) / (double)(size.height - insets.top - insets.bottom);
        if (xRatio < yRatio) {
            yRatio = xRatio;
        }
        try {
            this.setFont(font.deriveFont((float)Math.floor((double)font.getSize() * yRatio)));
            this.setSize(pageWidth, pageHeight);
            this.print(g);
        }
        finally {
            this.setFont(font);
            this.setSize(size);
        }
    }
}

