/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.AnimationIconInterface;
import com.sas.visuals.ImageView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Vector;

public class ImageAnimationIcon
extends Component
implements AnimationIconInterface {
    static final long serialVersionUID = -3729950066545825829L;
    protected int width;
    protected int height;
    protected int direction;
    protected int scrollingSpeed;
    protected boolean appletRelative;
    protected boolean imageScroll;
    protected String[] imageSources;
    protected URL[] imageURLs;
    protected transient Dimension maxD;
    protected transient int startPosition;
    protected transient int imgIndex;
    protected transient int numberOfImages;
    protected transient MediaTracker tracker;
    protected transient Point maxPos;
    protected transient Image offScreen;
    protected transient Graphics offScreenGraphics;
    protected transient Vector images;
    protected transient Dimension[] dim;
    protected transient Point[] pos;
    protected transient ImageView img;

    public ImageAnimationIcon() {
        this.setDefaultValues();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(this.width, this.height);
        if (this.imageScroll) {
            return prefSize;
        }
        return this.maxD;
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (this.width != d.width || this.height != d.height) {
            this.width = d.width;
            this.height = d.height;
            this.offScreen = null;
            this.offScreenGraphics = null;
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public int getScrollingSpeed() {
        return this.scrollingSpeed;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public String[] getSequence() {
        return this.imageSources;
    }

    public URL[] getURLSequence() {
        return this.imageURLs;
    }

    public boolean isImageScroll() {
        return this.imageScroll;
    }

    public void setImageScroll(boolean s) {
        this.imageScroll = s;
    }

    public boolean isSourceAppletRelative() {
        return this.appletRelative;
    }

    public void setSourceAppletRelative(boolean b) {
        if (b != this.appletRelative) {
            this.appletRelative = b;
            Image[] imgs = this.loadImageSequence(this.getSequence());
            this.setImageSequence(imgs);
        }
    }

    public void setDirection(int d) {
        this.direction = d;
    }

    public void setScrollingSpeed(int s) {
        this.scrollingSpeed = s;
    }

    public synchronized void setSequence(String[] sources) {
        if (sources == null) {
            this.imageSources = null;
        } else {
            this.imageSources = new String[sources.length];
            System.arraycopy(sources, 0, this.imageSources, 0, sources.length);
        }
        Image[] imgs = this.loadImageSequence(this.imageSources);
        this.setImageSequence(imgs);
    }

    public synchronized void setURLSequence(URL[] sources) {
        if (sources == null) {
            this.imageURLs = null;
        } else {
            this.imageURLs = new URL[sources.length];
            System.arraycopy(sources, 0, this.imageURLs, 0, sources.length);
        }
        Image[] imgs = this.loadImageSequence(this.imageURLs);
        this.setImageSequence(imgs);
    }

    public synchronized void setImageSequence(Image[] imgs) {
        this.images.removeAllElements();
        this.numberOfImages = 0;
        if (imgs == null || imgs.length == 0) {
            return;
        }
        this.tracker = new MediaTracker(this);
        for (int i = 0; i < imgs.length; ++i) {
            if (imgs[i] == null) continue;
            this.images.addElement(imgs[i]);
            this.tracker.addImage(imgs[i], 0);
            ++this.numberOfImages;
        }
        try {
            this.tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.loadDimensions();
        this.loadPositions();
    }

    @Override
    public void reset() {
        this.imgIndex = 0;
        this.startPosition = 0;
        this.loadPositions();
    }

    @Override
    public void increment() {
        if (this.imageScroll) {
            int max = this.maxPos.x;
            if (this.direction == 8 || this.direction == 4) {
                max = this.maxPos.y;
            }
            this.startPosition = this.startPosition + this.scrollingSpeed > max ? this.startPosition + this.scrollingSpeed - max : (this.startPosition += this.scrollingSpeed);
        } else {
            ++this.imgIndex;
            if (this.imgIndex >= this.numberOfImages) {
                this.imgIndex = 0;
            }
        }
    }

    @Override
    public void decrement() {
        if (this.imageScroll) {
            int max = this.maxPos.x;
            if (this.direction == 8 || this.direction == 4) {
                max = this.maxPos.y;
            }
            this.startPosition = this.startPosition - this.scrollingSpeed < 0 ? max + this.startPosition - this.scrollingSpeed : (this.startPosition -= this.scrollingSpeed);
        } else {
            --this.imgIndex;
            if (this.imgIndex < 0) {
                this.imgIndex = this.numberOfImages - 1;
            }
        }
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.offScreen = comp.createImage(width, height);
        this.offScreenGraphics = this.offScreen.getGraphics();
        this.paintAnimation(comp, g, x, y, width, height);
    }

    @Override
    public void paintAnimation(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.offScreen == null || this.offScreenGraphics == null) {
            if (width <= 0 || height <= 0) {
                return;
            }
            this.offScreen = comp.createImage(width, height);
            this.offScreenGraphics = this.offScreen.getGraphics();
        }
        this.offScreenGraphics.setColor(comp.getBackground());
        this.offScreenGraphics.fillRect(0, 0, width + 1, height + 1);
        this.offScreenGraphics.setColor(comp.getForeground());
        if (this.imageScroll && this.numberOfImages != 0) {
            int start = 0;
            int end = width;
            boolean vertical = false;
            if (this.direction == 8 || this.direction == 4) {
                vertical = true;
                end = height;
                start = 0;
            }
            int xPos = 0;
            int yPos = 0;
            int imgN = 0;
            int curPos = this.startPosition;
            while (curPos < end) {
                if (vertical) {
                    yPos = curPos;
                } else {
                    xPos = curPos;
                }
                this.offScreenGraphics.drawImage((Image)this.images.elementAt(imgN), xPos, yPos, comp);
                curPos = vertical ? (curPos += this.dim[imgN].height) : (curPos += this.dim[imgN].width);
                if (++imgN < this.numberOfImages) continue;
                imgN = 0;
            }
            xPos = 0;
            yPos = 0;
            imgN = this.numberOfImages - 1;
            curPos = this.startPosition;
            while (curPos > start) {
                if (vertical) {
                    yPos = curPos - this.dim[imgN].height;
                } else {
                    xPos = curPos - this.dim[imgN].width;
                }
                this.offScreenGraphics.drawImage((Image)this.images.elementAt(imgN), xPos, yPos, comp);
                curPos = vertical ? (curPos -= this.dim[imgN].height) : (curPos -= this.dim[imgN].width);
                if (--imgN >= 0) continue;
                imgN = this.numberOfImages - 1;
            }
        } else if (this.numberOfImages > 0) {
            this.offScreenGraphics.drawImage((Image)this.images.elementAt(this.imgIndex), 0, 0, comp);
        }
        g.drawImage(this.offScreen, x, y, comp);
    }

    protected Image[] loadImageSequence(String[] srcs) {
        this.img = new ImageView();
        if (srcs == null || srcs.length == 0) {
            return null;
        }
        Image[] imgs = new Image[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            imgs[i] = this.loadImage(srcs[i]);
        }
        this.img = null;
        return imgs;
    }

    protected Image[] loadImageSequence(URL[] srcs) {
        this.img = new ImageView();
        if (srcs == null || srcs.length == 0) {
            return null;
        }
        Image[] imgs = new Image[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            imgs[i] = this.loadImage(srcs[i]);
        }
        this.img = null;
        return imgs;
    }

    protected void loadDimensions() {
        this.maxD.width = 0;
        this.maxD.height = 0;
        this.dim = new Dimension[this.numberOfImages];
        for (int i = 0; i < this.images.size(); ++i) {
            Image img = (Image)this.images.elementAt(i);
            Dimension d = new Dimension(0, 0);
            d.height = img.getHeight(this);
            d.width = img.getWidth(this);
            if (d.height > this.maxD.height) {
                this.maxD.height = d.height;
            }
            if (d.width > this.maxD.width) {
                this.maxD.width = d.width;
            }
            this.dim[i] = d;
        }
    }

    protected void loadPositions() {
        this.maxPos.y = 0;
        this.maxPos.x = 0;
        this.pos = new Point[this.numberOfImages];
        for (int i = 0; i < this.dim.length; ++i) {
            Point pt = new Point(0, 0);
            pt.y = this.maxPos.y;
            pt.x = this.maxPos.x;
            this.pos[i] = pt;
            this.maxPos.y = pt.y + this.dim[i].height;
            this.maxPos.x = pt.x + this.dim[i].width;
        }
    }

    protected Image loadImage(String source) {
        if (source == null) {
            return null;
        }
        if (this.img == null) {
            this.img = new ImageView();
        }
        this.img.setSourceAppletRelative(this.appletRelative);
        this.img.setSource(source);
        return this.img.getImage();
    }

    protected Image loadImage(URL source) {
        return this.getToolkit().getImage(source);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.images = new Vector();
        this.maxPos = new Point();
        this.maxD = new Dimension();
        this.tracker = new MediaTracker(this);
        if (this.imageURLs != null) {
            this.setImageSequence(this.loadImageSequence(this.imageURLs));
        } else {
            this.setImageSequence(this.loadImageSequence(this.imageSources));
        }
    }

    public void setDefaultValues() {
        this.imgIndex = 0;
        this.scrollingSpeed = 2;
        this.direction = 4;
        this.images = new Vector();
        this.maxPos = new Point();
        this.tracker = new MediaTracker(this);
        this.maxD = new Dimension();
        this.imageURLs = null;
        this.appletRelative = false;
    }
}

