/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StringCollection;
import com.sas.visuals.AnimationIconInterface;
import com.sas.visuals.AnimationIconView;
import com.sas.visuals.ImageAnimationIcon;
import com.sas.visuals.RB;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class ImageAnimation
extends AnimationIconView
implements ContentsChangedListener,
ViewDefaultModelInterface {
    static final long serialVersionUID = -7032754509940286471L;
    public static final String RB_KEY = "ImageAnimation.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    protected transient ImageAnimationIcon imgAnimation;
    protected OrderedCollection defaultSequenceModel;
    private static int defaultHeight = 32;
    private static int defaultWidth = 32;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Expert", "true"}}, {{"Name", "direction"}, {"Property editor class", "com.sas.beans.editors._DirectionEditor"}}, {{"Name", "imageSequence"}, {"Property editor class", "com.sas.beans.editors._ImageSequenceEditor"}}, {{"Name", "animationIcon"}, {"Hidden", "true"}}, {{"Name", "decrement"}, {"Hidden", "true"}}, {{"Name", "icon"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.defaultInputPropertyName = "imageSequence";
        ebi.defaultOutputPropertyName = "imageSequence";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultSequenceModel == this.getModelInterface();
    }

    public boolean isImageScroll() {
        return this.imgAnimation.isImageScroll();
    }

    public void setImageScroll(boolean s) {
        boolean oldS = this.imgAnimation.isImageScroll();
        if (s != oldS) {
            this.imgAnimation.setImageScroll(s);
            this.firePropertyChange("imageScroll", new Boolean(oldS), new Boolean(s));
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.imgAnimation.setPreferredSize(new Dimension(width, height));
    }

    public int getDirection() {
        return this.imgAnimation.getDirection();
    }

    public void setDirection(int d) {
        int oldD = this.imgAnimation.getDirection();
        if (d != oldD) {
            this.imgAnimation.setDirection(d);
            if (d == 8 || d == 2) {
                this.setDecrement(true);
            } else {
                this.setDecrement(false);
            }
            this.firePropertyChange("direction", new Integer(oldD), new Integer(d));
        }
    }

    public int getScrollingSpeed() {
        return this.imgAnimation.getScrollingSpeed();
    }

    public void setScrollingSpeed(int s) {
        int oldS = this.imgAnimation.getScrollingSpeed();
        if (s != oldS) {
            this.imgAnimation.setScrollingSpeed(s);
            this.firePropertyChange("scrollingSpeed", new Integer(oldS), new Integer(s));
        }
    }

    public void contentsChanged(ContentsChangedEvent evt) {
        StaticOrderedCollectionInterface model = (StaticOrderedCollectionInterface)evt.getSource();
        if (model != null) {
            this.refreshSequence(model);
        }
    }

    @Override
    protected AnimationIconView createIconObject(AnimationIconView icon) {
        ImageAnimation clone = (ImageAnimation)icon;
        ImageAnimationIcon newAniIcon = new ImageAnimationIcon();
        newAniIcon.setDirection(this.getDirection());
        newAniIcon.setScrollingSpeed(this.getScrollingSpeed());
        newAniIcon.setImageScroll(this.isImageScroll());
        newAniIcon.setSequence(this.getImageSequence());
        clone.icon = null;
        clone.setAnimationIcon(newAniIcon);
        if (clone.defaultSequenceModel == this.defaultSequenceModel) {
            OrderedCollection newDefaultModel = new OrderedCollection();
            if (newDefaultModel != null) {
                newDefaultModel.addItems(clone.defaultSequenceModel.getItems());
            }
            clone.defaultSequenceModel = newDefaultModel;
        }
        if (clone.getModelInterface() == this.defaultSequenceModel) {
            clone.setModelInterface(null);
        }
        return clone;
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultSequenceModel);
        }
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.imgAnimation = (ImageAnimationIcon)this.getAnimationIcon();
        if (this.defaultSequenceModel == null) {
            this.defaultSequenceModel = new OrderedCollection();
            this.defaultSequenceModel.initialize();
            OrderedCollection sequence = new OrderedCollection((Object[])this.getImageSequence());
            this.defaultSequenceModel.addItems(sequence.getItems());
            ModelInterface model = this.getModelInterface();
            if (model == null || model instanceof StringCollection) {
                this.setModelInterface((ModelInterface)this.defaultSequenceModel);
            }
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            if (model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
            this.refreshSequence((StaticOrderedCollectionInterface)model);
        } else {
            this.imgAnimation.setSequence(null);
        }
    }

    protected void refreshSequence(StaticOrderedCollectionInterface model) {
        int nItems = model.count();
        if (nItems == 0) {
            this.imgAnimation.setSequence(null);
            this.firePropertyChange("imageSequence", null, null);
            return;
        }
        String[] imageSources = null;
        URL[] imageURLs = null;
        Image[] images = null;
        Object modelItem = model.get(0);
        if (modelItem instanceof String) {
            imageSources = new String[nItems];
        } else if (modelItem instanceof URL) {
            imageURLs = new URL[nItems];
        } else if (modelItem instanceof Image) {
            images = new Image[nItems];
        } else {
            this.imgAnimation.setSequence(null);
            this.firePropertyChange("imageSequence", null, null);
            return;
        }
        int i = 0;
        Enumeration e = model.getItems();
        while (e.hasMoreElements()) {
            if (imageSources != null) {
                imageSources[i++] = (String)e.nextElement();
                continue;
            }
            if (imageURLs != null) {
                imageURLs[i++] = (URL)e.nextElement();
                continue;
            }
            if (images == null) continue;
            images[i++] = (Image)e.nextElement();
        }
        if (imageSources != null) {
            this.imgAnimation.setSequence(imageSources);
        } else if (imageURLs != null) {
            this.imgAnimation.setURLSequence(imageURLs);
        } else if (images != null) {
            this.imgAnimation.setImageSequence(images);
        }
        this.firePropertyChange("imageSequence", null, null);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.imgAnimation = new ImageAnimationIcon();
        this.setAnimationIcon(this.imgAnimation);
        this.defaultSequenceModel = new OrderedCollection();
        this.setModelInterface((ModelInterface)this.defaultSequenceModel);
    }

    public boolean isSourceAppletRelative() {
        return this.imgAnimation.isSourceAppletRelative();
    }

    public void setSourceAppletRelative(boolean b) {
        if (b != this.imgAnimation.isSourceAppletRelative()) {
            this.imgAnimation.setSourceAppletRelative(b);
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"sourceAppletRelative", (boolean)b);
        }
    }

    public String[] getImageSequence() {
        return this.imgAnimation.getSequence();
    }

    public synchronized void setImageSequence(String[] sources) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            StringCollection sequence = new StringCollection(sources);
            ((OrderedCollectionInterface)model).removeAll();
            ((OrderedCollectionInterface)model).addItems(sequence.getItems());
        }
    }

    public URL[] getImageURLSequence() {
        return this.imgAnimation.getURLSequence();
    }

    public synchronized void setImageURLSequence(URL[] sources) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            OrderedCollection sequence = new OrderedCollection((Object[])sources);
            ((OrderedCollectionInterface)model).removeAll();
            ((OrderedCollectionInterface)model).addItems(sequence.getItems());
        }
    }

    @Override
    public void setAnimationIcon(AnimationIconInterface animIcon) {
        AnimationIconInterface oldIcon = this.getAnimationIcon();
        if (oldIcon != animIcon) {
            this.imgAnimation = (ImageAnimationIcon)animIcon;
            super.setAnimationIcon(animIcon);
        }
    }
}

