/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Component;
import com.sas.visuals.IconInterface;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class IconView
extends Component
implements IconInterface {
    static final long serialVersionUID = -8920538229968176929L;
    protected IconInterface icon;

    public IconView() {
    }

    public IconView(IconInterface icon) {
        this.setIcon(icon);
    }

    public IconInterface getIcon() {
        return this.icon;
    }

    @Override
    public Dimension computePreferredSize() {
        if (this.icon != null) {
            return this.icon.getPreferredSize();
        }
        return super.computePreferredSize();
    }

    public Insets getInsets() {
        Insets borderInsets = this.getBorder().getInsets((java.awt.Component)this);
        Insets viewInsets = new Insets(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right);
        if (this.icon != null) {
            Insets iconInsets = this.icon.getInsets();
            viewInsets.top += iconInsets.top;
            viewInsets.bottom += iconInsets.bottom;
            viewInsets.left += iconInsets.left;
            viewInsets.right += iconInsets.right;
        }
        return viewInsets;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.paint(this, g, insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    public void paint(java.awt.Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.icon != null) {
            this.icon.paint(comp, g, x, y, width, height);
        }
    }

    public void setIcon(IconInterface i) {
        if (this.icon != i) {
            IconInterface oldIcon = this.icon;
            this.icon = i;
            this.firePropertyChange("icon", oldIcon, this.icon);
        }
    }
}

