/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class DualSelectorLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -3894531005708279569L;
    private transient Component list1Label;
    private transient Component list2Label;
    private transient Component list1;
    private transient Component list2;
    private transient Component list1Up;
    private transient Component list1Down;
    private transient Component list2Up;
    private transient Component list2Down;
    private transient Component alternating;
    private transient Component allRight;
    private transient Component allLeft;
    private transient boolean layoutComponents = false;
    private static final int SPACE = 5;
    private static final String LIST_1_LABEL = "list1Label";
    private static final String LIST_2_LABEL = "list2Label";
    private static final String LIST_1 = "list1";
    private static final String LIST_2 = "list2";
    private static final String LIST_1_UP = "list1Up";
    private static final String LIST_1_DOWN = "list1Down";
    private static final String LIST_2_UP = "list2Up";
    private static final String LIST_2_DOWN = "list2Down";
    private static final String ALTERNATING = "alternating";
    private static final String ALL_RIGHT = "allRight";
    private static final String ALL_LEFT = "allLeft";
    private transient Dimension prefSize = new Dimension();

    DualSelectorLayout() {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals(LIST_1_LABEL)) {
            this.list1Label = comp;
        } else if (name.equals(LIST_2_LABEL)) {
            this.list2Label = comp;
        } else if (name.equals(LIST_1)) {
            this.list1 = comp;
        } else if (name.equals(LIST_2)) {
            this.list2 = comp;
        } else if (name.equals(LIST_1_UP)) {
            this.list1Up = comp;
        } else if (name.equals(LIST_1_DOWN)) {
            this.list1Down = comp;
        } else if (name.equals(LIST_2_UP)) {
            this.list2Up = comp;
        } else if (name.equals(LIST_2_DOWN)) {
            this.list2Down = comp;
        } else if (name.equals(ALTERNATING)) {
            this.alternating = comp;
        } else if (name.equals(ALL_RIGHT)) {
            this.allRight = comp;
        } else if (name.equals(ALL_LEFT)) {
            this.allLeft = comp;
        }
        this.layoutComponents = this.list1Label != null && this.list2Label != null && this.list1 != null && this.list2 != null && this.alternating != null && this.allRight != null && this.allLeft != null && this.list1Up != null && this.list1Down != null && this.list2Up != null && this.list2Down != null;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!this.layoutComponents) {
            return;
        }
        Insets insets = parent.getInsets();
        ++insets.left;
        ++insets.right;
        ++insets.top;
        ++insets.bottom;
        Dimension size = parent.getSize();
        Dimension buttonPrefSize = this.alternating.getMinimumSize();
        int width = size.width - (insets.right + insets.left);
        int height = size.height - (insets.top + insets.bottom);
        int top = insets.top;
        int bottom = height + insets.top;
        int left = insets.left;
        int listWidth = (width - (5 + buttonPrefSize.width + 5)) / 2;
        Dimension labelPrefSize = this.list1Label.getPreferredSize();
        this.list1Label.setBounds(left, top, listWidth, labelPrefSize.height);
        int listHeight = bottom - (top += labelPrefSize.height);
        if (this.list1Up.isVisible() && this.list1Down.isVisible()) {
            listHeight -= 5 + buttonPrefSize.height + 5;
        }
        this.list1.setBounds(left, top, listWidth, listHeight);
        top += listHeight + 5;
        int unit = listWidth / 2;
        if (this.list1Up.isVisible() && this.list1Down.isVisible()) {
            this.list1Up.setBounds(left += unit - buttonPrefSize.width, top, buttonPrefSize.width, buttonPrefSize.height);
            this.list1Down.setBounds(left += buttonPrefSize.width, top, buttonPrefSize.width, buttonPrefSize.height);
        }
        left = this.layoutMiddleButtons(height, buttonPrefSize, listWidth, listHeight, labelPrefSize.height, insets);
        top = insets.top;
        this.list2Label.setBounds(left += 5 + buttonPrefSize.width, top, listWidth, labelPrefSize.height);
        int oldHeight = listHeight;
        listHeight = bottom - (top += labelPrefSize.height);
        if (this.list2Up.isVisible() && this.list2Down.isVisible()) {
            listHeight -= 5 + buttonPrefSize.height + 5;
        }
        this.list2.setBounds(left, top, listWidth, listHeight);
        top += listHeight + 5;
        if (this.list2Up.isVisible() && this.list2Down.isVisible()) {
            this.list2Up.setBounds(left += unit - buttonPrefSize.width, top, buttonPrefSize.width, buttonPrefSize.height);
            this.list2Down.setBounds(left += buttonPrefSize.width, top, buttonPrefSize.width, buttonPrefSize.height);
        }
        if (listHeight < oldHeight) {
            this.layoutMiddleButtons(height, buttonPrefSize, listWidth, listHeight, labelPrefSize.height, insets);
        }
    }

    private int layoutMiddleButtons(int height, Dimension buttonPrefSize, int listWidth, int listHeight, int labelHeight, Insets insets) {
        boolean transferAllVisible;
        int totalButtonSpace = 3 * buttonPrefSize.height + 10;
        int top = insets.top;
        if (totalButtonSpace <= listHeight) {
            top = insets.top + labelHeight + (listHeight - totalButtonSpace) / 2;
        } else if (totalButtonSpace <= height) {
            top = insets.top + (height - totalButtonSpace) / 2;
        }
        boolean bl = transferAllVisible = this.allRight.isVisible() && this.allLeft.isVisible();
        if (!transferAllVisible) {
            top += buttonPrefSize.height + 5;
        }
        int left = insets.left + listWidth + 5;
        this.alternating.setBounds(left, top, buttonPrefSize.width, buttonPrefSize.height);
        if (transferAllVisible) {
            this.allRight.setBounds(left, top += buttonPrefSize.height + 5, buttonPrefSize.width, buttonPrefSize.height);
            this.allLeft.setBounds(left, top += buttonPrefSize.height + 5, buttonPrefSize.width, buttonPrefSize.height);
        }
        return left;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = this.list1.getPreferredSize().width + 5 + this.alternating.getMinimumSize().width + 5 + this.list2.getPreferredSize().width;
        int height = this.list1Label.getPreferredSize().height + 5 + this.list1.getPreferredSize().height + 5 + this.list1Up.getMinimumSize().height;
        this.prefSize.width = width;
        this.prefSize.height = height;
        return this.prefSize;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (Util.equal((Object)comp, (Object)this.list1Label)) {
            this.list1Label = null;
        } else if (Util.equal((Object)comp, (Object)this.list2Label)) {
            this.list2Label = null;
        } else if (Util.equal((Object)comp, (Object)this.list1)) {
            this.list1 = null;
        } else if (Util.equal((Object)comp, (Object)this.list2)) {
            this.list2 = null;
        } else if (Util.equal((Object)comp, (Object)this.list1Up)) {
            this.list1Up = null;
        } else if (Util.equal((Object)comp, (Object)this.list1Down)) {
            this.list1Down = null;
        } else if (Util.equal((Object)comp, (Object)this.list2Up)) {
            this.list2Up = null;
        } else if (Util.equal((Object)comp, (Object)this.list2Down)) {
            this.list2Down = null;
        } else if (Util.equal((Object)comp, (Object)this.alternating)) {
            this.alternating = null;
        } else if (Util.equal((Object)comp, (Object)this.allRight)) {
            this.allRight = null;
        } else if (Util.equal((Object)comp, (Object)this.allLeft)) {
            this.allLeft = null;
        }
        this.layoutComponents = this.list1Label != null && this.list2Label != null && this.list1 != null && this.list2 != null && this.alternating != null && this.allRight != null && this.allLeft != null && this.list1Up != null && this.list1Down != null && this.list2Up != null && this.list2Down != null;
    }
}

