/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.io.FileSystemList;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.visuals.DirNode;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;

class DirectoryList
extends Component
implements TreeInterface {
    protected DirNode _root;
    protected DirNode _lastDirectoryNode;

    DirectoryList() {
    }

    public void setStartingDirectory(String directory, boolean includeChildren, boolean isDrive) {
        DirNode currentNode = null;
        DirNode node = null;
        StringTokenizer st = new StringTokenizer(directory, File.separator);
        StringBuffer path = new StringBuffer();
        File file = null;
        int numTokens = st.countTokens();
        for (int tokenCount = 0; tokenCount < numTokens; ++tokenCount) {
            String s = st.nextToken();
            path.append(s);
            node = new DirNode(s, path.toString());
            path.append(File.separator);
            if (tokenCount == 0) {
                if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                    if (s.indexOf(":") != -1) {
                        this._root = new DirNode("My Computer", "My Computer");
                        this._root.setDefaultIcon("MyComputer");
                        this._root.setExpandedIcon("MyComputer");
                        currentNode = this._root;
                        DirNode startPath = null;
                        FileSystemList fsl = new FileSystemList();
                        Enumeration enumer = fsl.getItems();
                        while (enumer.hasMoreElements()) {
                            String temp = new String((String)enumer.nextElement());
                            DirNode nodeTemp = new DirNode(temp, temp + File.separator);
                            nodeTemp.setDefaultIcon("Drive");
                            nodeTemp.setExpandedIcon("Drive");
                            currentNode.addNodeChild((SimpleNodeInterface)nodeTemp, tokenCount);
                            if (s.trim().toUpperCase().equals(temp.trim().toUpperCase())) {
                                startPath = nodeTemp;
                            }
                            ++tokenCount;
                            ++numTokens;
                        }
                        node = startPath != null ? startPath : currentNode;
                    }
                } else {
                    this._root = node;
                    this._root.setNodeText(this._root.getNodeText() + File.separator);
                }
            } else {
                currentNode.addNodeChild((SimpleNodeInterface)node, 0);
                currentNode.setNodeType("Directory");
            }
            if (!(file = new File(path.toString())).isDirectory()) break;
            currentNode = node;
        }
        if (file == null) {
            return;
        }
        if (includeChildren || isDrive) {
            String[] dirlist = file.list();
            int dirCount = 0;
            if (dirlist == null) {
                return;
            }
            for (int i = 0; i < dirlist.length; ++i) {
                File tfile = isDrive ? new File(file.getAbsolutePath() + dirlist[i]) : new File(file.getAbsolutePath() + File.separator + dirlist[i]);
                if (!tfile.isDirectory()) continue;
                node = new DirNode(dirlist[i], tfile.getAbsolutePath());
                currentNode.addNodeChild((SimpleNodeInterface)node, dirCount++);
            }
        }
        this._lastDirectoryNode = node;
    }

    public NodeInterface getRoot() {
        if (this._root != null && this._root.getNodeChildCount() == 0) {
            this._root = null;
        }
        return this._root;
    }

    public String getRootText() {
        NodeInterface root = this.getRoot();
        if (root != null) {
            return ((DirNode)root).getNodeExpandedText();
        }
        return "";
    }

    public String getLastDirectoryName() {
        return this._lastDirectoryNode != null ? this._lastDirectoryNode.getNodeExpandedText() : "";
    }
}

