/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Canvas;
import com.sas.visuals.BasicColorsPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;

class CustomColorsCanvas
extends Canvas {
    static final long serialVersionUID = -8391551057968674666L;
    protected Color _Color;
    protected int xstarting = 0;
    protected static final int BOX_HEIGHT = 16;
    protected static final int BOX_WIDTH = 16;
    protected static final int GAP = 4;
    protected static final int NUM_COLUMNS = 8;
    protected static final int NUM_CUSTOM_ROWS = 2;
    public int _selectedIdx = -1;
    protected static int _maxFilledIdx = -1;
    static int CUSTOM_PALETTE_SIZE = 16;
    public static final String AP_CUSTOMCOLORS = "CustomColors";
    protected static com.sas.awt.Color[] _ColorPalette = new com.sas.awt.Color[CUSTOM_PALETTE_SIZE];
    private BasicColorsPanel bp;

    public CustomColorsCanvas() {
        this.enableEvents(84L);
        this.commonInit();
    }

    public void commonInit() {
        this._Color = new com.sas.awt.Color(255, 255, 255);
        if (null == _ColorPalette[0]) {
            int idx = 0;
            String c = System.getProperty(AP_CUSTOMCOLORS);
            if (null != c) {
                StringTokenizer ct = new StringTokenizer(c, ",", false);
                this.bp = new BasicColorsPanel();
                while (ct.hasMoreTokens()) {
                    CustomColorsCanvas._ColorPalette[idx] = (com.sas.awt.Color)com.sas.awt.Color.decode((String)((String)ct.nextElement()));
                    if (!this.bp._basicCanvas.colorList.contains(_ColorPalette[idx])) {
                        this.bp._basicCanvas.colorList.add(_ColorPalette[idx]);
                    }
                    if (++idx < CUSTOM_PALETTE_SIZE) continue;
                }
                _maxFilledIdx = idx - 1;
            }
            if (idx < CUSTOM_PALETTE_SIZE) {
                for (int i = idx; i < CUSTOM_PALETTE_SIZE; ++i) {
                    CustomColorsCanvas._ColorPalette[i] = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.lightGray);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredDimension = new Dimension(226, 42);
        return preferredDimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        int xpos = 4;
        int ypos = 4;
        int colEntries = 0;
        int totalSize = 156;
        int Center = 113;
        this.xstarting = xpos = Center - totalSize / 2;
        com.sas.awt.Color insideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.black);
        com.sas.awt.Color insideBottomRight = new com.sas.awt.Color(210, 210, 220);
        com.sas.awt.Color outsideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.gray);
        com.sas.awt.Color outsideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.white);
        for (int idx = 0; idx < CUSTOM_PALETTE_SIZE; ++idx) {
            Rectangle r = new Rectangle(xpos, ypos, 16, 16);
            this.paintBorder(g, r, outsideTopLeft, outsideBottomRight);
            r.grow(-1, -1);
            this.paintBorder(g, r, insideTopLeft, insideBottomRight);
            r.grow(1, 1);
            g.setColor((Color)_ColorPalette[idx]);
            g.fillRect(xpos + 1, ypos + 1, 14, 14);
            xpos += 20;
            if (++colEntries % 8 != 0) continue;
            xpos = Center - totalSize / 2;
            ypos += 20;
            colEntries = 0;
        }
        if (this._selectedIdx > -1 && this._selectedIdx < CUSTOM_PALETTE_SIZE) {
            Point p = this.Palette2Coord(this._selectedIdx);
            Rectangle r = new Rectangle(p.x, p.y, 16, 16);
            insideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.white);
            insideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.gray);
            outsideTopLeft = new com.sas.awt.Color(210, 210, 220);
            outsideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.black);
            this.paintBorder(g, r, outsideTopLeft, outsideBottomRight);
            r.grow(-1, -1);
            this.paintBorder(g, r, insideTopLeft, insideBottomRight);
            r.grow(1, 1);
        }
    }

    private void paintBorder(Graphics g, Rectangle r, com.sas.awt.Color topLeft, com.sas.awt.Color bottomRight) {
        g.setColor((Color)topLeft);
        g.drawLine(r.x, r.y, r.x + r.width - 2, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + r.height - 2);
        g.setColor((Color)bottomRight);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Point p;
        int idx;
        super.processMouseEvent(e);
        if (e.getID() == 501 && (idx = this.Coord2CustomPalette(p = new Point(e.getX(), e.getY()))) <= _maxFilledIdx) {
            this._selectedIdx = idx;
            this.setCurrentColor((Color)_ColorPalette[this._selectedIdx]);
        }
    }

    private Point Palette2Coord(int pal) {
        Point p = new Point(pal % 8 * 16, pal / 8 * 16);
        p.x = this.xstarting + pal % 8 * 20;
        p.y += pal / 8 * 4;
        p.y += 4;
        return p;
    }

    private int Coord2CustomPalette(Point coordinate) {
        int pal = (coordinate.x - this.xstarting) / 20 + coordinate.y / 20 * 8;
        return pal >= CUSTOM_PALETTE_SIZE ? -1 : pal;
    }

    public void setCurrentColor(Color c) {
        Color oldColor = this.getCurrentColor();
        if (c instanceof SystemColor) {
            this._Color = c;
            this.repaint();
            this.firePropertyChange("currentColor", oldColor, this._Color);
        } else if (oldColor != c) {
            this._Color = c;
            this._selectedIdx = -1;
            com.sas.awt.Color newColor = com.sas.awt.Color.newColor((Color)c);
            for (int idx = 0; idx <= _maxFilledIdx; ++idx) {
                if (!_ColorPalette[idx].equals((Object)newColor)) continue;
                this._selectedIdx = idx;
            }
            this.repaint();
            this.firePropertyChange("currentColor", oldColor, this._Color);
        }
    }

    public Color getCurrentColor() {
        return this._Color;
    }

    public void createCustomColor(com.sas.awt.Color c) {
        _maxFilledIdx = _maxFilledIdx + 1 < CUSTOM_PALETTE_SIZE ? _maxFilledIdx + 1 : CUSTOM_PALETTE_SIZE - 1;
        CustomColorsCanvas._ColorPalette[CustomColorsCanvas._maxFilledIdx] = c;
        this.setCurrentColor((Color)c);
        this.updateAppProperties();
    }

    private void updateAppProperties() {
        if (null == _ColorPalette[0]) {
            return;
        }
        StringBuffer sb = new StringBuffer(9 * CUSTOM_PALETTE_SIZE);
        int count = 0;
        int idx = 0;
        while (idx <= _maxFilledIdx) {
            sb.append(CustomColorsCanvas.encode(_ColorPalette[idx]) + ",");
            ++idx;
            ++count;
        }
        if (count > 0) {
            sb.setLength(count * 9 - 1);
            String oldProperty = System.getProperty(AP_CUSTOMCOLORS);
            if (oldProperty == null || !oldProperty.equals(sb.toString())) {
                System.getProperties().put(AP_CUSTOMCOLORS, sb.toString());
                this.firePropertyChange(AP_CUSTOMCOLORS, oldProperty, sb.toString());
            }
        }
    }

    public static String encode(com.sas.awt.Color c) {
        int rgb = c.getRGB();
        String color = rgb < 0 ? "0x" + Integer.toHexString(rgb).substring(2).toUpperCase() : (0 == rgb ? "0x000000" : (rgb <= 256 ? "0x0000" + Integer.toHexString(rgb).toUpperCase() : (rgb <= 65535 ? "0x00" + Integer.toHexString(rgb).toUpperCase() : "0x" + Integer.toHexString(rgb).toUpperCase())));
        return color;
    }
}

