/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.util.Util;
import com.sas.security.SecuritySupport;
import com.sas.util.ThreadedCommand;
import com.sas.visuals.AbortableThread;
import com.sas.visuals.CommandProgressThread;
import com.sas.visuals.ProgressDialog;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.net.URL;
import java.security.PrivilegedAction;

public class CommandProgress {
    protected static ProgressDialog _progressDialog;
    protected static boolean interrupted;

    public static void executeAsynchronously(ThreadedCommand command, Object commandArg, String dialogTitle, String progressMessage, Object owner, Component ctr) throws Exception {
        CommandProgress.executeAsynchronously(command, commandArg, dialogTitle, progressMessage, owner, ctr, true, null);
    }

    public static void executeAsynchronously(ThreadedCommand command, Object commandArg, String dialogTitle, String progressMessage, Object owner, Component ctr, boolean allowCancel) throws Exception {
        CommandProgress.executeAsynchronously(command, commandArg, dialogTitle, progressMessage, owner, ctr, allowCancel, null);
    }

    public static void executeAsynchronously(final ThreadedCommand command, final Object commandArg, String dialogTitle, String progressMessage, Object owner, Component ctr, boolean allowCancel, Dimension defaultDimension) throws Exception {
        AbortableThread thread = (AbortableThread)SecuritySupport.securitySupport.doThreadPrivileged(new PrivilegedAction(){

            public Object run() {
                return new AbortableThread(command, commandArg);
            }
        });
        Frame parent = Util.getParentFrame(ctr);
        if (parent == null) {
            parent = new Frame();
        }
        URL codeBase = null;
        if (owner != null && owner instanceof Applet) {
            codeBase = ((Applet)owner).getCodeBase();
        }
        try {
            CommandProgress.doWork(parent, ctr, codeBase, thread, dialogTitle, progressMessage, allowCancel, defaultDimension);
        }
        catch (Exception e) {
            command.interrupt();
            thread.stop();
            throw e;
        }
    }

    public static void setMessage(String message) {
        if (_progressDialog != null) {
            _progressDialog.setMessage(message);
        }
    }

    protected static void doWork(Frame parent, Component ctr, URL codeBase, AbortableThread thread, String dialogTitle, String message, boolean allowCancel, Dimension defaultDimension) throws Exception {
        block11: {
            thread.start();
            if (null == _progressDialog) {
                _progressDialog = new ProgressDialog(parent, codeBase, dialogTitle, allowCancel, defaultDimension);
            }
            _progressDialog.setMessage(message);
            try {
                Util.centerOverWindow(_progressDialog, parent);
            }
            catch (IllegalComponentStateException e) {
                if (ctr == null) break block11;
                try {
                    Util.centerOver(_progressDialog, ctr);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
        _progressDialog.setCommandThread(thread);
        Thread.sleep(50L);
        if (interrupted) {
            _progressDialog = null;
            throw new Exception();
        }
        if (thread._exceptionCaught || thread.wasAborted()) {
            _progressDialog = null;
            throw thread._exception;
        }
        if (thread.isAlive()) {
            final ProgressDialog _progressDialogFinal = _progressDialog;
            final AbortableThread threadFinal = thread;
            CommandProgressThread commandProgressThread = (CommandProgressThread)SecuritySupport.securitySupport.doThreadPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new CommandProgressThread(_progressDialogFinal, threadFinal);
                }
            });
            commandProgressThread.start();
            if (thread.isAlive()) {
                _progressDialog.setModal(true);
                _progressDialog.setVisible(true);
            }
            if (interrupted) {
                _progressDialog = null;
                throw new Exception();
            }
            if (_progressDialog.wasCancelled() || thread._exceptionCaught || thread.wasAborted()) {
                _progressDialog = null;
                throw thread._exception;
            }
        }
        _progressDialog = null;
    }

    public static void setInterrupted(boolean value) {
        interrupted = value;
    }

    public static boolean isInterrupted() {
        return interrupted;
    }

    static {
        interrupted = false;
    }
}

