/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.ModelInterface;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.ListBox;
import com.sas.awt.TextField;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.OrderedListCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StringCollection;
import com.sas.lang.StringDataInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.ComboBoxFocusHandler;
import com.sas.visuals.ComboBoxPrefixLinker;
import com.sas.visuals.ComboButton;
import com.sas.visuals.ComboList;
import com.sas.visuals.ComboText;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.ImageView;
import com.sas.visuals.PushButton;
import com.sas.visuals.RB;
import com.sas.visuals.ResizeToFitInterface;
import com.sas.visuals.Resources;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ComboBox
extends CompositePanel
implements StringDataInterface,
ContentsChangedListener,
ResizeToFitInterface,
ItemSelectable,
ViewDefaultModelInterface {
    public boolean textOverride = false;
    public transient int oldSelectedIndex = -1;
    public transient ItemListener itemListener;
    public transient KeyListener keyListener;
    private ListBox lb1;
    private ComboText ctf1;
    private TextField tf1;
    private PushButton pb1;
    private ComboButton cb1;
    private Window wn1;
    private boolean matchedEntry = false;
    private int comboStyle = -1;
    private int tf1Columns = 12;
    private boolean addToList = false;
    private boolean hasInitialized = false;
    private boolean setTextToNull = false;
    private OrderedCollection defaultModel;
    private int prevColumns = 0;
    private TransformInterface displayTransform;
    private TransformInterface inputTransform;
    private TransformInterface outputTransform;
    private boolean resizeToFit = false;
    private boolean allowDragging = true;
    private boolean changingStyles = false;
    private boolean resizing = true;
    private boolean doSuper = false;
    private boolean upgraded = false;
    private boolean autoHighlight = false;
    private String comboBoxText = null;
    private transient boolean executingReadObject;
    private int serialVersion;
    public transient OrderedListCollection excludedKeys;
    protected ComboBoxFocusHandler focusHandler = new ComboBoxFocusHandler();
    static final long serialVersionUID = 875974139161177426L;
    public static final String RB_KEY = "ComboBox.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    public static final int DROPDOWN = 0;
    public static final int SIMPLE = 1;
    public static final int DROPDOWNLIST = 2;
    static int defaultWidth = 124;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "addTextToList"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"addTextToList.pd.txt")}}, {{"Name", "autoHighlight"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"autoHighlight.pd.txt")}}, {{"Name", "displayTransform"}, {"Description", RB.getStringResource((String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "errorHandler"}, {"Hidden", "true"}}, {{"Name", "initialItems"}, {"Description", RB.getStringResource((String)"initialItems.pd.txt")}}, {{"Name", "inputTransform"}, {"Description", RB.getStringResource((String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "matchedEntry"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"matchedEntry.pd.txt")}}, {{"Name", "outputTransform"}, {"Description", RB.getStringResource((String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "resizeToFit"}, {"Description", Util.getCommonStringResource((String)"resizeToFit.spd.txt")}}, {{"Name", "selectedItem"}, {"Description", RB.getStringResource((String)"selectedItem.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SelectedItemEditor"}}, {{"Name", "selectedIndex"}, {"Description", RB.getStringResource((String)"selectedIndex.pd.txt")}}, {{"Name", "selectedObjects"}, {"Expert", "true"}}, {{"Name", "style"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"style.pd.txt")}, {"Property editor class", "com.sas.beans.editors.ComboBoxStyleEditor"}}, {{"Name", "text"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "validator"}, {"Hidden", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", com.sas.RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "23"}, {"Description", com.sas.RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public ComboBox() {
        this.focusHandler.combo = this;
        this.focusHandler.lb1 = this.lb1 = new ComboList();
        this.lb1.initialize();
        this.lb1.setMultipleMode(false);
        this.lb1.setDisplayTransform(this.getDisplayTransform());
        this.lb1.setKeyboardSelectable(true);
        this.focusHandler.cb1 = this.cb1 = this.newComboButton();
        this.cb1.initialize();
        this.cb1.addActionListener(this.focusHandler);
        this.tf1Columns = 12;
        this.focusHandler.ctf1 = this.ctf1 = new ComboText();
        this.ctf1.initialize();
        this.ctf1.setColumns(this.tf1Columns);
        this.ctf1.setResizeToFit(false);
        this.ctf1.addActionListener(this.focusHandler);
        this.ctf1.addKeyListener(this.focusHandler);
        this.ctf1.addFocusListener(this.focusHandler);
        this.ctf1.addMouseListener(this.focusHandler);
        new ComboBoxPrefixLinker(this.lb1, this.ctf1);
        this.lb1.addFocusListener(this.focusHandler);
        this.lb1.addMouseListener(this.focusHandler);
        this.lb1.addKeyListener(this.focusHandler);
        this.initializeComponent();
        this.setStyle(0);
        this.layoutDropCombo();
        this.enableEvents(8L);
    }

    public void add(Component comp) {
    }

    public void add(String name, Component comp) {
    }

    public void add(Component comp, int index) {
    }

    public void add(Component comp, Object constraints) {
    }

    public void add(Component comp, Object constraints, int index) {
    }

    public void addImpl(Component comp, Object constraints, int index) {
    }

    public void addItem(Object item) {
        this.lb1.add(item);
        if (this.getText() == null || this.getText().length() == 0) {
            this.setSelectedText();
        }
    }

    public void addItem(Object item, int index) {
        this.lb1.add(item, index);
        this.oldSelectedIndex = this.lb1.getSelectedIndex();
        if (this.getText() == null || this.getText().length() == 0) {
            this.setSelectedText();
        }
    }

    public void add(Object[] items) {
        this.lb1.add(items);
        if (this.getText() == null || this.getText().length() == 0) {
            this.setSelectedText();
        }
    }

    public void add(Enumeration items) {
        this.lb1.addItems(items);
        if (this.getText() == null || this.getText().length() == 0) {
            this.setSelectedText();
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.upgraded) {
            this.setSize(this.computePreferredSize());
            this.upgraded = false;
        } else if (this.isResizeToFit()) {
            this.setSize(this.computePreferredSize());
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        if (this.lb1 != null) {
            String textFieldText;
            String oldSelItem = textFieldText = this.getText();
            int oldSelected = this.oldSelectedIndex;
            Object[] oldSelObjects = this.getSelectedObjects();
            ModelInterface modelInterface = this.lb1.getModelInterface();
            if (modelInterface != null) {
                this.lb1.detachModel(modelInterface);
            }
            this.lb1.attachModel(model);
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this.lb1);
            if (model != this.defaultModel && this.isResizeToFit()) {
                this.resizing = true;
                this.setSize(this.computePreferredSize());
                this.validate();
                this.resizing = false;
            }
            if (model instanceof StaticOrderedCollectionInterface) {
                StaticOrderedCollectionInterface collection = (StaticOrderedCollectionInterface)model;
                if (collection.count() > 0) {
                    boolean foundEntry = false;
                    if (Util.unequal((Object)textFieldText, (Object)"") && this.executingReadObject) {
                        for (int i = 0; i < collection.count(); ++i) {
                            Object item = collection.get(i);
                            if (foundEntry || !Util.equal((Object)textFieldText, (Object)item.toString())) continue;
                            this.lb1.setSelectedIndex(i);
                            this.oldSelectedIndex = i;
                            this.comboBoxText = textFieldText;
                            foundEntry = true;
                        }
                    }
                    if (!foundEntry) {
                        this.setSelectedText();
                    }
                } else {
                    this.setSelectedIndex(-1);
                    this.comboBoxText = null;
                    this.oldSelectedIndex = -1;
                }
            } else {
                this.setText(null);
            }
            this.executingReadObject = false;
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.oldSelectedIndex));
            this.firePropertyChange("selectedItem", oldSelItem, this.comboBoxText);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.comboBoxText);
        }
    }

    protected int calculateWindowHeight() {
        int heightAdjustmentFactor = 4;
        if (this.getFont() != null) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
            int count = this.lb1.getItemCount();
            int calculatedHeight = fontmetrics.getHeight() * (count > 8 ? 8 : count);
            if (this.isResizeToFit()) {
                return calculatedHeight + heightAdjustmentFactor;
            }
            int listBoxScrollbarheight = 17;
            int maxwidth = -1;
            Enumeration elements = null;
            ModelInterface model = this.getModelInterface();
            elements = ((StaticOrderedCollectionInterface)model).getItems();
            while (elements.hasMoreElements()) {
                Object t = elements.nextElement();
                Object item = null;
                String temp = null;
                if (this.displayTransform != null) {
                    try {
                        item = this.displayTransform.transform(t);
                        if (item == null) {
                            throw new NullPointerException(RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        temp = item.toString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    if (t == null) {
                        throw new NullPointerException(RB.getStringResource((String)"NullPointerException.ex.txt"));
                    }
                    temp = t.toString();
                }
                maxwidth = Math.max(maxwidth, fontmetrics.stringWidth(temp));
            }
            if (maxwidth > this.getSize().width) {
                return calculatedHeight + heightAdjustmentFactor + listBoxScrollbarheight;
            }
            return calculatedHeight + heightAdjustmentFactor;
        }
        return heightAdjustmentFactor;
    }

    @Override
    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    public void contentsChanged(ContentsChangedEvent evt) {
        if (this.isResizeToFit()) {
            this.resizing = true;
            this.setSize(this.computePreferredSize());
            this.validate();
            this.resizing = false;
        }
        String item = this.ctf1.getText();
        boolean hadItem = false;
        int listCount = this.lb1.getItemCount();
        for (int i = 0; i < listCount; ++i) {
            String listItem = this.lb1.getItem(i);
            if (!Util.equal((Object)listItem, (Object)item)) continue;
            hadItem = true;
            break;
        }
        int oldIndex = this.getSelectedIndex();
        String oldItem = this.getSelectedItem();
        Object[] oldSelObjects = this.getSelectedObjects();
        this.refresh();
        if (!(evt instanceof CollectionChangedInfo)) {
            this.ctf1.setText(null);
            this.comboBoxText = null;
        } else {
            int itemsCount;
            CollectionChangedInfo nevt = (CollectionChangedInfo)evt;
            int selIndex = this.getSelectedIndex();
            if (nevt.howChanged == HowChanged.ADDED) {
                if (nevt.whatChanged != null && selIndex >= nevt.start) {
                    this.setSelectedIndex(selIndex + 1);
                }
            } else if (nevt.howChanged == HowChanged.REMOVED || nevt.howChanged == HowChanged.REPLACED) {
                Object inputItem = this.ctf1.getText();
                if (this.inputTransform != null) {
                    try {
                        inputItem = this.inputTransform.transform(inputItem);
                    }
                    catch (TransformException transformException) {
                        System.out.println((Object)transformException);
                    }
                }
                ModelInterface model = this.getModelInterface();
                boolean hasItem = ((OrderedCollectionInterface)model).contains(inputItem);
                if (hadItem && !hasItem) {
                    this.setText(null);
                }
                if (nevt.howChanged == HowChanged.REMOVED) {
                    if (nevt.whatChanged != null) {
                        if (selIndex > nevt.start) {
                            this.setSelectedIndex(selIndex - 1);
                        }
                    } else if (nevt.start == 0) {
                        this.comboBoxText = null;
                        this.oldSelectedIndex = -1;
                        if (oldIndex != -1) {
                            this.firePropertyChange("selectedIndex", new Integer(oldIndex), new Integer(-1));
                            this.firePropertyChange("selectedItem", oldItem, null);
                            this.firePropertyChange("selectedObjects", oldSelObjects, new Object[0]);
                            this.firePropertyChange("text", oldItem, null);
                        }
                    }
                }
            }
            if ((itemsCount = this.lb1.getItemCount()) == 0) {
                this.oldSelectedIndex = -1;
            }
        }
        if (this.getText() == null || this.getText().length() == 0) {
            this.setSelectedText();
        }
    }

    protected void createItemEvent(int changed, String selItem, int selected) {
        ItemEvent e = new ItemEvent(this, changed, selItem, selected);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    protected void createKeyEvent(int id, long when, int modifiers, int keyCode, char keyChar) {
        KeyEvent e = new KeyEvent(this, id, when, modifiers, keyCode, keyChar);
        if (this.keyListener != null) {
            if (id == 401) {
                this.keyListener.keyPressed(e);
            } else if (id == 402) {
                this.keyListener.keyReleased(e);
            } else if (id == 400) {
                this.keyListener.keyTyped(e);
            }
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (this.lb1 != null) {
            this.lb1.detachModel(model);
        }
        if (this.defaultModel != null && this.defaultModel.count() > 0) {
            this.defaultModel.removeAll();
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    public void displayList() {
        if (this.wn1 == null) {
            this.layoutWindow();
        }
        Point p = this.getLocationOnScreen();
        Insets ins = this.getInsets();
        int padt = ins.top;
        int padb = ins.bottom;
        int padl = ins.left;
        int padr = ins.right;
        int ylocation = p.y + this.computePreferredSize().height + padt;
        this.wn1.setBounds(p.x + padl, ylocation, this.getSize().width - padr - padl, this.calculateWindowHeight() - padb);
        this.wn1.setVisible(true);
        this.lb1.setVisible(true);
        this.lb1.requestFocus();
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public String[] getInitialItems() {
        String[] returnValue = new String[this.defaultModel.count()];
        TransformInterface displayTransform = this.getDisplayTransform();
        int i = 0;
        Enumeration e = this.defaultModel.getItems();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (displayTransform != null) {
                try {
                    item = displayTransform.transform(item);
                    if (!(item instanceof String)) {
                        item = item.toString();
                    }
                }
                catch (TransformException transformException) {
                    System.out.println((Object)transformException);
                }
            }
            returnValue[i++] = (String)item;
        }
        return returnValue;
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    @Override
    public Dimension getMinimumSize() {
        Enumeration elements = null;
        ModelInterface model = this.getModelInterface();
        if (model != null && this.isResizeToFit()) {
            int itemCount = ((StaticOrderedCollectionInterface)model).count();
            int maxwidth = -1;
            if (itemCount > 0 && this.getFont() != null) {
                elements = ((StaticOrderedCollectionInterface)model).getItems();
                FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
                int lbwidth = this.lb1.getMinimumSize().width;
                while (elements.hasMoreElements()) {
                    Object t = elements.nextElement();
                    Object item = null;
                    String temp = null;
                    if (this.displayTransform != null) {
                        try {
                            item = this.displayTransform.transform(t);
                            if (item == null) {
                                throw new NullPointerException(RB.getStringResource((String)"NullPointerException.ex.txt"));
                            }
                            temp = item.toString();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        if (t == null) {
                            throw new NullPointerException(RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        temp = t.toString();
                    }
                    maxwidth = Math.max(maxwidth, fontmetrics.stringWidth(temp));
                }
                boolean doLoop = true;
                int testSize = 0;
                int j = 1;
                int padding = 9;
                while (doLoop) {
                    Dimension testd = this.ctf1.getPreferredSize(j);
                    if (this.comboStyle == 1) {
                        padding = 30;
                    }
                    if (testd.width > maxwidth + padding && testd.width > lbwidth) {
                        doLoop = false;
                        this.tf1Columns = j;
                        break;
                    }
                    if (testSize == testd.width) break;
                    testSize = testd.width;
                    ++j;
                }
            }
            if (this.upgraded && this.prevColumns > 0) {
                this.tf1Columns = this.prevColumns - 1;
            }
            Dimension d = this.ctf1.getPreferredSize(this.tf1Columns);
            Insets ins = this.getInsets();
            int padw = ins.left + ins.right;
            int padh = ins.top + ins.bottom;
            if (this.comboStyle == 1) {
                Dimension d1 = this.lb1.getPreferredSize();
                return new Dimension(d.width + padw, d.height + d1.height + padh);
            }
            Dimension d2 = this.cb1.getPreferredSize();
            return new Dimension(d.width + d2.width + padw, d.height + padh);
        }
        return new Dimension(ComboBox.getDefaultWidth(), ComboBox.getDefaultHeight());
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public int getSelectedIndex() {
        return this.oldSelectedIndex;
    }

    public String getSelectedItem() {
        return this.lb1.getSelectedItem();
    }

    @Override
    public Object[] getSelectedObjects() {
        int selIndex = this.getSelectedIndex();
        ModelInterface model = this.getModelInterface();
        if (model != null && ((StaticOrderedCollectionInterface)model).count() > 0 && selIndex != -1) {
            int count = ((StaticOrderedCollectionInterface)model).count();
            if (selIndex >= count) {
                return new Object[0];
            }
            Object[] items = new Object[1];
            if (this.outputTransform != null) {
                try {
                    Object temp = ((StaticOrderedCollectionInterface)model).get(selIndex);
                    items[0] = this.outputTransform.transform(temp);
                }
                catch (TransformException transformException) {}
            } else {
                items[0] = ((StaticOrderedCollectionInterface)model).get(selIndex);
            }
            return items;
        }
        return new Object[0];
    }

    public int getStyle() {
        return this.comboStyle;
    }

    public String getText() {
        return this.ctf1.getText();
    }

    public void hideList() {
        if (this.wn1 != null) {
            this.wn1.setVisible(false);
            this.lb1.setVisible(false);
        }
    }

    @Override
    public void initialize() {
        this.setTextToNull = false;
        this.hasInitialized = true;
    }

    private void initializeExcludedKeys() {
        this.excludedKeys.add((Object)new Integer(8));
        this.excludedKeys.add((Object)new Integer(9));
        this.excludedKeys.add((Object)new Integer(18));
        this.excludedKeys.add((Object)new Integer(20));
        this.excludedKeys.add((Object)new Integer(17));
        this.excludedKeys.add((Object)new Integer(157));
        this.excludedKeys.add((Object)new Integer(16));
        this.excludedKeys.add((Object)new Integer(112));
        this.excludedKeys.add((Object)new Integer(113));
        this.excludedKeys.add((Object)new Integer(114));
        this.excludedKeys.add((Object)new Integer(115));
        this.excludedKeys.add((Object)new Integer(116));
        this.excludedKeys.add((Object)new Integer(117));
        this.excludedKeys.add((Object)new Integer(118));
        this.excludedKeys.add((Object)new Integer(119));
        this.excludedKeys.add((Object)new Integer(120));
        this.excludedKeys.add((Object)new Integer(121));
        this.excludedKeys.add((Object)new Integer(122));
        this.excludedKeys.add((Object)new Integer(123));
        this.excludedKeys.add((Object)new Integer(154));
        this.excludedKeys.add((Object)new Integer(145));
        this.excludedKeys.add((Object)new Integer(19));
        this.excludedKeys.add((Object)new Integer(127));
        this.excludedKeys.add((Object)new Integer(155));
        this.excludedKeys.add((Object)new Integer(34));
        this.excludedKeys.add((Object)new Integer(33));
        this.excludedKeys.add((Object)new Integer(37));
        this.excludedKeys.add((Object)new Integer(39));
        this.excludedKeys.add((Object)new Integer(35));
        this.excludedKeys.add((Object)new Integer(36));
        this.excludedKeys.add((Object)new Integer(30));
        this.excludedKeys.add((Object)new Integer(144));
        this.excludedKeys.add((Object)new Integer(3));
        this.excludedKeys.add((Object)new Integer(12));
        this.excludedKeys.add((Object)new Integer(28));
        this.excludedKeys.add((Object)new Integer(24));
        this.excludedKeys.add((Object)new Integer(156));
        this.excludedKeys.add((Object)new Integer(21));
        this.excludedKeys.add((Object)new Integer(25));
        this.excludedKeys.add((Object)new Integer(31));
        this.excludedKeys.add((Object)new Integer(29));
    }

    public boolean isAddTextToList() {
        return this.addToList;
    }

    public boolean isAutoHighlight() {
        return this.autoHighlight;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isMatchedEntry() {
        return this.matchedEntry;
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    private void layoutDropCombo() {
        this.changingStyles = true;
        super.removeAll();
        AutoSizingGridLayout gbl = new AutoSizingGridLayout(1, 2, 0, 0, true, false, true);
        this.setLayout((LayoutManager)gbl);
        gbl.setRemainderColumn(1);
        super.add(this.ctf1);
        super.add(this.cb1);
        this.resizing = true;
        this.setSize(this.computePreferredSize());
        this.validate();
        this.repaint();
        if (this.resizeToFit) {
            this.resizing = false;
        }
    }

    private void layoutSimpleCombo() {
        this.changingStyles = true;
        super.removeAll();
        if (this.wn1 != null) {
            this.wn1.setVisible(false);
        }
        AutoSizingGridLayout gbl = new AutoSizingGridLayout(2, 1, 0, 1, true, false, true);
        this.setLayout((LayoutManager)gbl);
        super.add(this.ctf1);
        super.add(this.lb1);
        this.resizing = true;
        this.setSize(this.computePreferredSize());
        this.validate();
        if (this.resizeToFit) {
            this.resizing = false;
        }
    }

    void layoutWindow() {
        Container root = this;
        while (root.getParent() != null) {
            if (!((root = root.getParent()) instanceof Frame)) continue;
            Frame fr1 = (Frame)root;
            if (this.wn1 == null) {
                this.focusHandler.wn1 = this.wn1 = new Window(fr1);
                this.wn1.add(this.lb1);
                this.wn1.pack();
            }
            this.wn1.addWindowListener(this.focusHandler);
            this.wn1.addMouseListener(this.focusHandler);
            this.wn1.addFocusListener(this.focusHandler);
            break;
        }
    }

    protected ComboButton newComboButton() {
        return new ComboButton(null, new ImageView(ImageView.class, "res/ComboArrow.gif"));
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        this.refresh(model);
    }

    @Override
    public void refresh(ModelInterface model) {
        if (this.lb1 != null) {
            this.lb1.refresh(model);
        }
    }

    public void remove(Component comp) {
    }

    @Override
    public void remove(int index) {
    }

    @Override
    public void removeAll() {
    }

    public void removeAllItems() {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).removeAll();
        }
    }

    public void removeItem(String item) {
        this.lb1.remove(item);
        int currIndex = this.lb1.getSelectedIndex();
        this.setSelectedIndex(currIndex);
    }

    public void removeItem(Object item) throws TransformException {
        this.lb1.remove(item);
    }

    public void removeItem(int index) {
        this.lb1.remove(index);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.isAutoHighlight() && this.getStyle() != 2) {
            this.ctf1.requestFocus();
        }
    }

    public void replaceItem(Object newvalue, int index) throws TransformException {
        ModelInterface model;
        Object inputItem = newvalue;
        if (this.inputTransform != null) {
            try {
                inputItem = this.inputTransform.transform(newvalue);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if ((model = this.getModelInterface()) != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).set(index, inputItem);
        }
    }

    public void setAddTextToList(boolean state) {
        if (this.isAddTextToList() != state) {
            this.addToList = state;
            this.firePropertyChange("addTextToList", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setAutoHighlight(boolean value) {
        if (value != this.autoHighlight) {
            this.autoHighlight = value;
            this.firePropertyChange("autoHighlight", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        if (this.lb1 != null) {
            this.lb1.setBackgroundColor(color);
        }
        if (this.ctf1 != null) {
            this.ctf1.setBackgroundColor(color);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Point currentPos = this.getLocation();
        int currentWidth = this.getSize().width;
        if ((currentPos.x != x || currentPos.y != y) && currentWidth == width) {
            super.setBounds(x, y, width, height);
        } else if (this.resizing) {
            super.setBounds(x, y, width, height);
            this.validate();
        } else {
            Dimension prefSize = this.computePreferredSize();
            if (width == prefSize.width && height == prefSize.height) {
                super.setBounds(x, y, width, height);
            }
        }
    }

    public void setDisplayTransform(TransformInterface transform) {
        TransformInterface oldTransform = this.getDisplayTransform();
        if (transform != oldTransform) {
            this.displayTransform = transform;
            if (this.lb1 != null) {
                this.lb1.setDisplayTransform(transform);
            }
            this.firePropertyChange("displayTransform", oldTransform, transform);
        }
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.lb1 != null) {
            this.lb1.setEnabled(value);
        }
        if (this.ctf1 != null) {
            this.ctf1.setEnabled(value);
        }
        if (this.pb1 != null) {
            this.pb1.setEnabled(value);
        }
        super.setEnabled(value);
    }

    @Override
    public void setFont(Font font) {
        if (this.lb1 != null) {
            this.lb1.setFont(font);
        }
        if (this.ctf1 != null) {
            this.ctf1.setFont(font);
        }
        super.setFont(font);
        if (this.isResizeToFit()) {
            this.resizing = true;
            this.setSize(this.computePreferredSize());
            this.validate();
            this.resizing = false;
        }
    }

    @Override
    public void setForegroundColor(Color color) {
        if (this.lb1 != null) {
            this.lb1.setForegroundColor(color);
        }
        if (this.ctf1 != null) {
            this.ctf1.setForegroundColor(color);
        }
        super.setForegroundColor(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.lb1 != null) {
            this.lb1.setForegroundColor(color);
        }
        if (this.ctf1 != null) {
            this.ctf1.setForegroundColor(color);
        }
    }

    public void setInputTransform(TransformInterface transform) {
        TransformInterface oldTransform = this.getInputTransform();
        if (transform != oldTransform) {
            this.inputTransform = transform;
            this.firePropertyChange("inputTransform", oldTransform, transform);
        }
    }

    public void setOutputTransform(TransformInterface transform) {
        TransformInterface oldTransform = this.getOutputTransform();
        if (transform != oldTransform) {
            this.outputTransform = transform;
            this.firePropertyChange("outputTransform", oldTransform, transform);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropTarget(false);
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.attachModel((ModelInterface)this.defaultModel);
        this.serialVersion = 1;
        this.excludedKeys = new OrderedListCollection();
        this.initializeExcludedKeys();
    }

    public void setInitialItems(String[] items) {
        StringCollection newItems;
        StringCollection curItems;
        boolean i = false;
        String[] oldItems = this.getInitialItems();
        if (items == null) {
            items = new String[]{};
        }
        if (Util.equal((Object)(curItems = new StringCollection(oldItems)), (Object)(newItems = new StringCollection(items)))) {
            return;
        }
        this.defaultModel.removeAll();
        Enumeration eitems = newItems.getItems();
        this.add(eitems);
        ModelInterface model = this.getModelInterface();
        if (model == null || model != this.defaultModel) {
            this.detachModel(model);
        }
        if (this.resizeToFit) {
            this.resizing = true;
            this.setSize(this.computePreferredSize());
            this.validate();
            this.resizing = false;
        }
        this.firePropertyChange("initialItems", oldItems, items);
        this.setSelectedText();
    }

    public void setMatchedEntry(boolean state) {
        if (this.isMatchedEntry() != state) {
            this.matchedEntry = state;
            this.lb1.setKeyboardSelectable(state);
            this.ctf1.setKeystrokeUpdate(state);
            this.firePropertyChange("matchedEntry", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setResizeToFit(boolean value) {
        if (value != this.resizeToFit) {
            this.resizeToFit = value;
            ModelInterface model = this.getModelInterface();
            if (model != null && this.resizeToFit && ((StaticOrderedCollectionInterface)model).count() > 0) {
                this.setSize(this.computePreferredSize());
                this.validate();
            }
            this.resizing = !this.resizeToFit;
            this.firePropertyChange("resizeToFit", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setSelectedIndex(int index) {
        if (index != this.getSelectedIndex()) {
            StaticOrderedCollectionInterface collection;
            Integer oldIndex = new Integer(this.getSelectedIndex());
            Object selectedObject = null;
            ModelInterface modelInterface = this.getModelInterface();
            if (modelInterface instanceof StaticOrderedCollectionInterface && (collection = (StaticOrderedCollectionInterface)modelInterface).count() > 0 && index != -1) {
                selectedObject = collection.get(index);
            }
            String oldText = this.getText();
            Object[] oldSelObjects = this.getSelectedObjects();
            if (selectedObject != null) {
                this.ctf1.setText(selectedObject.toString());
                this.comboBoxText = selectedObject.toString();
                this.lb1.setSelectedIndex(index);
                this.oldSelectedIndex = index;
            } else {
                this.ctf1.setText(null);
                this.comboBoxText = null;
                if (this.lb1.getSelectedIndex() != -1) {
                    this.lb1.setSelectedIndex(-1);
                }
                this.oldSelectedIndex = -1;
            }
            this.firePropertyChange("selectedIndex", oldIndex, new Integer(index));
            this.firePropertyChange("selectedItem", oldText, this.getText());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldText, this.getText());
        }
    }

    public void selectedItem(Object text) throws TransformException {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof StaticOrderedCollectionInterface) {
            Object inputItem = text;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(text);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            Integer oldSelected = new Integer(this.getSelectedIndex());
            String oldSelItem = this.getSelectedItem();
            Object[] oldSelObjects = this.getSelectedObjects();
            boolean found_item = false;
            if (inputItem == null) {
                this.ctf1.setText(null);
                this.comboBoxText = null;
                this.lb1.select(-1);
                this.oldSelectedIndex = -1;
            } else {
                if (Util.equal((Object)oldSelItem, (Object)inputItem)) {
                    return;
                }
                int itemCount = ((StaticOrderedCollectionInterface)model).count();
                for (int i = 0; i < itemCount; ++i) {
                    if (!Util.equal((Object)inputItem, (Object)((StaticOrderedCollectionInterface)model).get(i))) continue;
                    this.ctf1.setText(inputItem.toString());
                    this.comboBoxText = inputItem.toString();
                    this.lb1.select(i);
                    this.oldSelectedIndex = i;
                    found_item = true;
                    break;
                }
            }
            if (!found_item) {
                this.setText(null);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            if (found_item || inputItem == null && oldSelItem != null) {
                this.firePropertyChange("selectedItem", oldSelItem, inputItem);
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelItem, inputItem);
                Integer newSelected = new Integer(this.lb1.getSelectedIndex());
                if (Util.unequal((Object)oldSelected, (Object)newSelected)) {
                    this.firePropertyChange("selectedIndex", oldSelected, newSelected);
                }
            }
        }
    }

    public void setSelectedItem(String text) {
        try {
            if (this.inputTransform != null) {
                String temp = text;
                this.selectedItem(temp);
                return;
            }
        }
        catch (TransformException temp) {
            // empty catch block
        }
        Integer oldSelected = new Integer(this.getSelectedIndex());
        String oldSelItem = this.getSelectedItem();
        Object[] oldSelObjects = this.getSelectedObjects();
        boolean found_item = false;
        if (text == null) {
            this.ctf1.setText(null);
            this.comboBoxText = null;
            this.lb1.select(-1);
            this.oldSelectedIndex = -1;
        } else {
            if (Util.equal((Object)oldSelItem, (Object)text)) {
                return;
            }
            for (int i = 0; i < this.lb1.getItemCount(); ++i) {
                if (!Util.equal((Object)this.lb1.getItem(i), (Object)text)) continue;
                this.ctf1.setText(text);
                this.comboBoxText = text;
                this.lb1.select(i);
                this.oldSelectedIndex = i;
                found_item = true;
                break;
            }
        }
        if (!found_item) {
            this.setText(null);
        }
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        if (found_item || text == null && oldSelItem != null) {
            this.firePropertyChange("selectedItem", oldSelItem, text);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, text);
            Integer newSelected = new Integer(this.lb1.getSelectedIndex());
            if (Util.unequal((Object)oldSelected, (Object)newSelected)) {
                this.firePropertyChange("selectedIndex", oldSelected, newSelected);
            }
        }
    }

    private void setSelectedText() {
        String oldSelItem = this.comboBoxText;
        int oldSelected = this.oldSelectedIndex;
        Object[] oldSelObjects = this.getSelectedObjects();
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface instanceof StaticOrderedCollectionInterface) {
            StaticOrderedCollectionInterface collection = (StaticOrderedCollectionInterface)modelInterface;
            if (collection.count() > 0) {
                Object selectedObject = collection.get(0);
                if (this.getDisplayTransform() != null) {
                    try {
                        selectedObject = this.getDisplayTransform().transform(selectedObject);
                    }
                    catch (TransformException transformException) {
                        System.out.println((Object)transformException);
                    }
                }
                this.ctf1.setText(selectedObject.toString());
                this.comboBoxText = selectedObject.toString();
                this.lb1.setSelectedIndex(0);
                this.oldSelectedIndex = 0;
            } else {
                this.ctf1.setText(null);
                this.comboBoxText = null;
                this.oldSelectedIndex = -1;
                this.lb1.deselectAll();
            }
        } else {
            this.ctf1.setText(null);
            this.comboBoxText = null;
            this.oldSelectedIndex = -1;
        }
        if (this.anyPropertyChangeListeners() && this.oldSelectedIndex != oldSelected) {
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.oldSelectedIndex));
            this.firePropertyChange("selectedItem", oldSelItem, this.comboBoxText);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.comboBoxText);
        }
    }

    public void setStyle(int cstyle) {
        if (this.getStyle() != cstyle) {
            int oldStyle = this.getStyle();
            this.comboStyle = cstyle;
            if (this.comboStyle == 1) {
                this.layoutSimpleCombo();
            } else {
                if (this.comboStyle == 2) {
                    this.ctf1.setEditable(false);
                } else {
                    this.ctf1.setEditable(true);
                }
                if (oldStyle == 1) {
                    this.layoutDropCombo();
                }
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("style", new Integer(oldStyle), new Integer(cstyle));
        }
    }

    public void setText(String text) {
        if (text == null) {
            if (!this.hasInitialized) {
                this.setTextToNull = true;
            }
            text = "";
        }
        if (this.getText() == null || Util.unequal((Object)this.getText(), (Object)text) || this.textOverride) {
            int oldIndex = this.getSelectedIndex();
            String oldText = this.comboBoxText;
            Object[] oldSelObjects = this.getSelectedObjects();
            boolean isThere = false;
            int i = -1;
            ModelInterface modelInterface = this.getModelInterface();
            int count = this.lb1.getItemCount();
            if (count > 0) {
                for (i = 0; i < count; ++i) {
                    String item = this.lb1.getItem(i);
                    if (!Util.equal((Object)text, (Object)item)) continue;
                    isThere = true;
                    break;
                }
            }
            this.ctf1.setText(text);
            if (isThere) {
                this.lb1.setSelectedIndex(i);
                this.oldSelectedIndex = i;
            } else {
                int currIndex = this.lb1.getSelectedIndex();
                if (currIndex != -1) {
                    this.lb1.deselect(currIndex);
                    this.oldSelectedIndex = -1;
                }
            }
            if (this.isAddTextToList() && text != "" && !isThere && this.comboStyle != 2) {
                Object newItem = text.trim();
                if (this.getOutputTransform() != null) {
                    try {
                        newItem = this.getOutputTransform().transform(newItem);
                    }
                    catch (TransformException transformException) {
                        System.out.println((Object)transformException);
                    }
                }
                if (modelInterface instanceof OrderedCollectionInterface) {
                    OrderedCollectionInterface collection = (OrderedCollectionInterface)modelInterface;
                    collection.add(newItem);
                    this.lb1.setSelectedIndex(collection.count() - 1);
                    this.oldSelectedIndex = this.lb1.getSelectedIndex();
                }
            }
            if (this.comboBoxText == null || Util.unequal((Object)this.comboBoxText, (Object)text)) {
                this.comboBoxText = text;
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                this.firePropertyChange("selectedIndex", new Integer(oldIndex), new Integer(this.getSelectedIndex()));
                this.firePropertyChange("selectedItem", oldText, text);
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldText, text);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion > 1) {
            Object keyOrNull;
            while (null != (keyOrNull = s.readObject())) {
                String key = ((String)keyOrNull).intern();
                if ("itemL" == key) {
                    this.addItemListener((ItemListener)s.readObject());
                    continue;
                }
                s.readObject();
            }
        }
        Image img = Resources.getImage((String)"ComboArrow");
        if (this.pb1 != null) {
            this.pb1.removeActionListener(this.focusHandler);
            this.remove(this.pb1);
            this.pb1 = null;
            this.focusHandler.cb1 = this.cb1 = new ComboButton(null, new ImageView(img));
            this.cb1.initialize();
            this.cb1.addActionListener(this.focusHandler);
        }
        if (this.tf1 != null) {
            this.prevColumns = this.tf1Columns;
            this.tf1.removeActionListener(this.focusHandler);
            this.tf1.removeKeyListener(this.focusHandler);
            this.remove(this.tf1);
            this.tf1 = null;
            this.focusHandler.ctf1 = this.ctf1 = new ComboText();
            this.ctf1.initialize();
            this.ctf1.setColumns(12);
            this.ctf1.setResizeToFit(false);
            this.ctf1.addActionListener(this.focusHandler);
            this.ctf1.addKeyListener(this.focusHandler);
            new ComboBoxPrefixLinker(this.lb1, this.ctf1);
            this.lb1.addMouseListener(this.focusHandler);
            this.upgraded = true;
        }
        this.cb1.setDefaultIcon(new ImageView(img));
        this.validate();
        this.oldSelectedIndex = this.lb1.getSelectedIndex();
        this.lb1.removeKeyListener(this.focusHandler);
        this.lb1.addKeyListener(this.focusHandler);
        this.ctf1.removeMouseListener(this.focusHandler);
        this.ctf1.addMouseListener(this.focusHandler);
        if (this.excludedKeys == null) {
            this.excludedKeys = new OrderedListCollection();
            this.initializeExcludedKeys();
        }
        this.executingReadObject = true;
    }
}

