/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Button;
import com.sas.awt.Dialog;
import com.sas.awt.Panel;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.text.Message;
import com.sas.visuals.ColorPanel;
import com.sas.visuals.MessageBoxEvent;
import com.sas.visuals.MessageBoxListener;
import com.sas.visuals.MessageBoxListenerList;
import com.sas.visuals.MessageBoxSource;
import com.sas.visuals.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ColorDialog
extends Dialog
implements WindowListener,
ActionListener,
FocusListener,
MessageBoxSource {
    public static final String RB_KEY = "ColorDialog.";
    static final long serialVersionUID = 7896982960127835893L;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 64;
    public static final int BUTTONS_OK_CANCEL = 65;
    protected Button lastButtonWithFocus;
    protected int selectedButton = 0;
    protected ColorPanel cp;
    protected Button buttonOK;
    protected Button buttonCancel;
    protected Button buttonAdd;
    protected boolean showCustom = false;
    protected MessageBoxListenerList messageBoxListenerList = new MessageBoxListenerList();

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "selectedButton"}, {"Default value", "0"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedButton.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "selectedButton";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ColorDialog(Frame frame) {
        super(frame, RB.getStringResource((String)RB_KEY, (String)"color.txt"));
        this.commonInit();
    }

    public ColorDialog(Frame frame, boolean modal, boolean custom) {
        super(frame, RB.getStringResource((String)RB_KEY, (String)"color.txt"), modal);
        this.showCustom = custom;
        this.commonInit();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.buttonOK) {
            this.selectedButton = 1;
        } else if (source == this.buttonCancel) {
            this.selectedButton = 64;
        } else if (source == this.buttonAdd) {
            this.cp.addCustomColor();
        }
        this.fireMessageBoxEvent(this.selectedButton);
        if (source == this.buttonOK || source == this.buttonCancel) {
            this.dispose();
        }
    }

    protected void commonInit() {
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        Panel main = new Panel();
        main.setLayout(new BorderLayout());
        this.add((Component)main, "Center");
        this.cp = this.showCustom ? new ColorPanel(true) : new ColorPanel();
        this.cp.initialize();
        main.add((Component)this.cp, "Center");
        Panel panel1 = new Panel();
        main.add((Component)panel1, "South");
        panel1.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel1.add((Component)panel, "West");
        this.buttonOK = new Button(Message.format((String)RB.getStringResource((String)"okButton.txt"), (Object)"       ", (Object)"       "));
        this.buttonOK.initialize();
        panel.add(this.buttonOK);
        this.buttonCancel = new Button(Message.format((String)RB.getStringResource((String)"cancelButton.txt"), (Object)"   ", (Object)"   "));
        this.buttonCancel.initialize();
        panel.add(this.buttonCancel);
        if (this.showCustom) {
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout());
            panel1.add((Component)panel2, "Center");
            this.buttonAdd = new Button(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"addCustomButton.txt"), (Object)"  ", (Object)"  "));
            this.buttonAdd.initialize();
            panel2.add(this.buttonAdd);
            this.buttonAdd.addActionListener(this);
        }
        this.buttonOK.addActionListener(this);
        this.buttonOK.addFocusListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.addFocusListener(this);
        this.buttonOK.requestFocus();
        this.addWindowListener(this);
        this.validate();
        this.pack();
    }

    public int getSelectedButton() {
        return this.selectedButton;
    }

    public Color getSelectedColor() {
        return this.cp.getCurrentColor();
    }

    @Override
    protected String paramString() {
        String string = "title=" + this.getTitle() + ",";
        return string;
    }

    public void setSelectedColor(Color cl) {
        this.cp.setCurrentColor(cl);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.selectedButton = 0;
        }
        super.setVisible(visible);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.selectedButton = 64;
        this.fireMessageBoxEvent(64);
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (this.lastButtonWithFocus != null) {
            this.lastButtonWithFocus.requestFocus();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.lastButtonWithFocus = (Button)event.getSource();
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void addMessageBoxListener(MessageBoxListener listener) {
        this.messageBoxListenerList.add(listener);
    }

    @Override
    public void removeMessageBoxListener(MessageBoxListener listener) {
        this.messageBoxListenerList.remove(listener);
    }

    public void fireMessageBoxEvent(int button) {
        MessageBoxListener[] listeners = this.messageBoxListenerList.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            MessageBoxEvent event = new MessageBoxEvent(this, button);
            listeners[i].messageBoxButtonSelected(event);
        }
    }
}

