/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.PropertyLinkAdaptor;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.models.ClassPathClasses;
import com.sas.models.NodeInterface;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.MessageBox;
import com.sas.visuals.NodeView;
import com.sas.visuals.OkCancelHelpDialog;
import com.sas.visuals.TreeView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ClassSelectorPanel
extends Panel
implements ItemListener,
PropertyChangeListener {
    protected TextField selectedClassField;
    protected TreeView tree;
    protected String selectedClass;

    public static String showClassSelectorDialog(Component parent, boolean modal, String title, String selectedClass) {
        OkCancelHelpDialog dialog = new OkCancelHelpDialog(Util.getParentFrame(parent), title);
        ClassSelectorPanel selectorPanel = new ClassSelectorPanel();
        if (selectedClass != null) {
            selectorPanel.setSelectedClass(selectedClass);
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        layout.setRemainderRow(1);
        dialog.getMainPanel().setLayout((LayoutManager)layout);
        dialog.getMainPanel().add(selectorPanel);
        dialog.setModal(modal);
        dialog.pack();
        Util.centerOver(dialog, Util.getParent(parent, Window.class));
        dialog.setVisible(true);
        String selectedActionCommand = dialog.getButtonPanel().getSelectedActionCommand();
        if (com.sas.util.Util.equal((Object)selectedActionCommand, (Object)"Close")) {
            return selectorPanel.getSelectedClass();
        }
        return null;
    }

    public ClassSelectorPanel() {
        this.setInsets(10, 10, 10, 10);
        this.setErrorHandler(new MessageBoxErrorHandler(this));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 1);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        layout.setRemainderRow(1);
        this.setLayout((LayoutManager)layout);
        this.tree = new TreeView();
        this.tree.initialize();
        ClassPathClasses treeModel = new ClassPathClasses();
        treeModel.initialize();
        this.tree.setModelInterface((ModelInterface)treeModel);
        this.add(this.tree);
        this.selectedClassField = new TextField();
        this.selectedClassField.initialize();
        this.selectedClassField.addPropertyChangeListener(this);
        this.add(this.selectedClassField);
        PropertyLinkAdaptor.addLink((Object)this.tree, (String)"selectedItem", (Object)this.selectedClassField, (String)"text");
        this.tree.addItemListener(this);
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    public void setSelectedClass(String selectedClass) {
        String oldSelectedClass = this.selectedClass;
        this.selectedClass = selectedClass;
        if (!com.sas.util.Util.equal((Object)oldSelectedClass, (Object)selectedClass)) {
            this.selectedClassField.setText(selectedClass);
            this.firePropertyChange("selectedClass", oldSelectedClass, selectedClass);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.selectedClassField && com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text")) {
            ErrorHandlerInterface errorHandler;
            String className = this.selectedClassField.getText();
            Cursor previousCursor = this.selectedClassField.getCursor();
            this.selectedClassField.setCursor(Cursor.getPredefinedCursor(3));
            OrderedCollection path = new OrderedCollection();
            path.add((Object)this.tree.getRoot().getNode());
            NodeInterface node = this.searchForClassNode(this.tree.getRoot().getNode(), className, path);
            if (node != null) {
                NodeInterface[] nodePath = new NodeInterface[path.count()];
                for (int i = 0; i < path.count(); ++i) {
                    nodePath[i] = (NodeInterface)path.get(i);
                }
                NodeView nodeView = this.tree.getNodeView(nodePath);
                if (nodeView != null) {
                    nodeView.setSelected(true);
                    this.tree.scrollToNode(nodeView, true);
                }
            } else if (className != null && className.length() > 0 && (errorHandler = this.getErrorHandler()) != null) {
                String errorMessage = "Unable to find class : {0}";
                errorHandler.handleError((ComponentInterface)this, new Message(errorMessage, (Object)className), "UnableToFindMessage");
            }
            this.selectedClassField.setCursor(previousCursor);
        }
        super.propertyChange(event);
    }

    protected NodeInterface searchForClassNode(NodeInterface baseNode, String className, OrderedCollection path) {
        int index = className.indexOf(".");
        String classNamePart = className;
        String nextClassName = "";
        if (index != -1) {
            classNamePart = className.substring(0, index);
            nextClassName = className.substring(index + 1);
        }
        int n = baseNode.getNodeChildCount();
        for (int i = 0; i < n; ++i) {
            NodeInterface node = (NodeInterface)baseNode.getNodeChild(i);
            if (!com.sas.util.Util.equal((Object)node.getNodeText(), (Object)classNamePart)) continue;
            path.add((Object)node);
            if (nextClassName.length() == 0) {
                return node;
            }
            return this.searchForClassNode(node, nextClassName, path);
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        NodeInterface node = (NodeInterface)event.getItem();
        if (!node.isLeafNode()) {
            this.setSelectedClass(null);
        } else {
            String className = node.getNodeExpandedText();
            try {
                Class selectedClass = GlobalInfoTable.loadClass((String)className);
                this.setSelectedClass(className);
            }
            catch (Exception e) {
                String message = "InvalidClassName.ex.txt";
                MessageBox msgBox = new MessageBox(Util.getParentFrame(this.selectedClassField), com.sas.util.Util.getCommonStringResource((String)"Error.txt"), true, Message.format((String)message, (Object)className), 1, 1, 2);
                msgBox.centerOver(Util.getParent(this.selectedClassField, Window.class));
                msgBox.setVisible(true);
                this.setSelectedClass(null);
            }
        }
    }
}

