/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BoxLayout
implements LayoutManager2,
Serializable {
    static final long serialVersionUID = -8945095518237210928L;
    public static final int NONE = 0;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    Component top;
    Component bottom;
    Component right;
    Component left;
    Component center;
    int topHeight;
    int bottomHeight;
    int leftWidth;
    int rightWidth;
    int topBorder;
    int bottomBorder;
    int leftBorder;
    int rightBorder;

    public BoxLayout() {
        this(0, 0, 0, 0);
    }

    public BoxLayout(int topGap, int bottomGap, int rightGap, int leftGap) {
        this.topBorder = topGap;
        this.bottomBorder = bottomGap;
        this.rightBorder = rightGap;
        this.leftBorder = leftGap;
    }

    public int getTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(int size) {
        this.topBorder = size;
    }

    public int getBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(int size) {
        this.bottomBorder = size;
    }

    public int getRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(int size) {
        this.rightBorder = size;
    }

    public int getLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(int size) {
        this.leftBorder = size;
    }

    public int getTopHeight() {
        return this.topHeight;
    }

    public void setTopHeight(int size) {
        this.topHeight = size;
    }

    public int getBottomHeight() {
        return this.bottomHeight;
    }

    public void setBottomHeight(int size) {
        this.bottomHeight = size;
    }

    public int getRightWidth() {
        return this.rightWidth;
    }

    public void setRightWidth(int size) {
        this.rightWidth = size;
    }

    public int getLeftWidth() {
        return this.leftWidth;
    }

    public void setLeftWidth(int size) {
        this.leftWidth = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeOrientation(Component comp, int newOrientation) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int prevOrientation;
            Component oldComp = null;
            if (this.top != null && comp.equals(this.top)) {
                prevOrientation = 4;
                this.top = null;
            } else if (this.bottom != null && comp.equals(this.bottom)) {
                prevOrientation = 8;
                this.bottom = null;
            } else if (this.left != null && comp.equals(this.left)) {
                prevOrientation = 1;
                this.left = null;
            } else if (this.right != null && comp.equals(this.right)) {
                prevOrientation = 2;
                this.right = null;
            } else if (this.center != null && comp.equals(this.center)) {
                prevOrientation = 0;
                this.center = null;
            } else {
                return;
            }
            switch (newOrientation) {
                case 4: {
                    oldComp = this.top;
                    this.top = comp;
                    break;
                }
                case 8: {
                    oldComp = this.bottom;
                    this.bottom = comp;
                    break;
                }
                case 1: {
                    oldComp = this.left;
                    this.left = comp;
                    break;
                }
                case 2: {
                    oldComp = this.right;
                    this.right = comp;
                    break;
                }
                case 0: {
                    oldComp = this.center;
                    this.center = comp;
                }
            }
            switch (prevOrientation) {
                case 4: {
                    this.top = oldComp;
                    break;
                }
                case 8: {
                    this.bottom = oldComp;
                    break;
                }
                case 1: {
                    this.left = oldComp;
                    break;
                }
                case 2: {
                    this.right = oldComp;
                    break;
                }
                case 0: {
                    this.center = oldComp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null || constraints instanceof String || constraints instanceof Integer) {
                Integer idx = constraints == null ? new Integer(0) : (constraints instanceof String ? new Integer((String)constraints) : (Integer)constraints);
                int index = idx;
                switch (index) {
                    case 4: {
                        this.top = comp;
                        break;
                    }
                    case 8: {
                        this.bottom = comp;
                        break;
                    }
                    case 1: {
                        this.left = comp;
                        break;
                    }
                    case 2: {
                        this.right = comp;
                        break;
                    }
                    default: {
                        this.center = comp;
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException("cannot add to layout: constraint must be an Integer (or null)");
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.center) {
                this.center = null;
            } else if (comp == this.top) {
                this.top = null;
            } else if (comp == this.bottom) {
                this.bottom = null;
            } else if (comp == this.right) {
                this.right = null;
            } else if (comp == this.left) {
                this.left = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.center != null && this.center.isVisible()) {
                d = this.center.getMinimumSize();
                dim.width += d.width;
                dim.height = d.height;
            }
            if (this.right != null && this.right.isVisible()) {
                d = this.right.getMinimumSize();
                dim.width += d.width + this.rightBorder;
                if (dim.height < d.height) {
                    dim.height = d.height;
                }
            }
            if (this.left != null && this.left.isVisible()) {
                d = this.left.getMinimumSize();
                dim.width += d.width + this.leftBorder;
                if (dim.height < d.height) {
                    dim.height = d.height;
                }
            }
            if (this.top != null && this.top.isVisible()) {
                d = this.top.getMinimumSize();
                dim.height += d.height + this.topBorder;
                if (dim.width < d.width) {
                    dim.width = d.width;
                }
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                d = this.bottom.getMinimumSize();
                dim.height += d.height + this.bottomBorder;
                if (dim.width < d.width) {
                    dim.width = d.width;
                }
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.center != null && this.center.isVisible()) {
                d = this.center.getPreferredSize();
                dim.width = d.width;
                dim.height = d.height;
            }
            if (this.right != null && this.right.isVisible()) {
                d = this.right.getPreferredSize();
                dim.width += d.width + this.rightBorder;
                if (dim.height < d.height) {
                    dim.height = d.height;
                }
            }
            if (this.left != null && this.left.isVisible()) {
                d = this.left.getPreferredSize();
                dim.width += d.width + this.leftBorder;
                if (dim.height < d.height) {
                    dim.height = d.height;
                }
            }
            if (this.top != null && this.top.isVisible()) {
                d = this.top.getPreferredSize();
                dim.height += d.height + this.topBorder;
                if (dim.width < d.width) {
                    dim.width = d.width;
                }
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                d = this.bottom.getPreferredSize();
                dim.height += d.height + this.bottomBorder;
                if (dim.width < d.width) {
                    dim.width = d.width;
                }
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Dimension parentSize = parent.getSize();
            Dimension centerSize = new Dimension();
            boolean topVisible = false;
            boolean rightVisible = false;
            boolean leftVisible = false;
            boolean bottomVisible = false;
            int topGap = 0;
            int bottomGap = 0;
            int rightGap = 0;
            int leftGap = 0;
            int topMax = 0;
            int bottomMax = 0;
            int rightMax = 0;
            int leftMax = 0;
            if (this.top != null && this.top.isVisible()) {
                topMax = Math.max(this.top.getPreferredSize().height, this.topHeight);
                topGap = this.topBorder;
                topVisible = true;
            }
            if (this.bottom != null && this.bottom.isVisible()) {
                bottomMax = Math.max(this.bottom.getPreferredSize().height, this.bottomHeight);
                bottomGap = this.bottomBorder;
                bottomVisible = true;
            }
            if (this.left != null && this.left.isVisible()) {
                leftMax = Math.max(this.left.getPreferredSize().width, this.leftWidth);
                leftGap = this.leftBorder;
                leftVisible = true;
            }
            if (this.right != null && this.right.isVisible()) {
                rightMax = Math.max(this.right.getPreferredSize().width, this.rightWidth);
                rightGap = this.rightBorder;
                rightVisible = true;
            }
            centerSize.width = parentSize.width - (leftMax + rightMax + insets.left + insets.right);
            centerSize.height = parentSize.height - (topMax + bottomMax + insets.top + insets.bottom);
            if (topVisible) {
                this.top.setBounds(insets.left + leftMax, insets.top, centerSize.width, topMax);
            }
            if (bottomVisible) {
                this.bottom.setBounds(insets.left + leftMax, insets.top + topMax + centerSize.height, centerSize.width, bottomMax);
            }
            if (leftVisible) {
                this.left.setBounds(insets.left, insets.top + topMax, leftMax, centerSize.height);
            }
            if (rightVisible) {
                this.right.setBounds(insets.left + leftMax + centerSize.width, insets.top + topMax, rightMax, centerSize.height);
            }
            if (this.center != null && this.center.isVisible()) {
                this.center.setBounds(insets.left + leftMax + leftGap, insets.top + topMax + topGap, centerSize.width - leftGap - rightGap, centerSize.height - topGap - bottomGap);
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

