/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.util.Util;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.RB;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class Border
extends Component
implements PublicClonable,
BorderInterface {
    static final long serialVersionUID = 2553712793328927313L;
    public static final String RB_KEY = "Border.";
    protected int lightSource = 5;
    protected int style = 0;
    protected int borderWidth;
    protected com.sas.awt.Color baseColor;
    protected Color baseColorJ;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "style"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"style.pd.txt")}}, {{"Name", "lightSource"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"lightSource.pd.txt")}}, {{"Name", "borderWidth"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"borderWidth.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "style";
        ebi.defaultOutputPropertyName = "style";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public void drawInRect(Graphics g, Rectangle rect) {
        this.drawInRect(null, g, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawInRect(Graphics g, Rectangle rect, int lSource) {
        int oldLightSource = this.lightSource;
        this.lightSource = lSource;
        this.drawInRect(g, rect);
        this.lightSource = oldLightSource;
    }

    public void drawInRect(Graphics g, int x, int y, int width, int height) {
        this.drawInRect(null, g, x, y, width, height);
    }

    public abstract void drawInRect(java.awt.Component var1, Graphics var2, int var3, int var4, int var5, int var6);

    public Color getBaseColor() {
        return this.baseColorJ;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Insets getInsets() {
        return this.getInsets(null);
    }

    public abstract Insets getInsets(java.awt.Component var1);

    public Rectangle getInteriorBounds(Rectangle exterior) {
        return this.getInteriorBounds(exterior.x, exterior.y, exterior.width, exterior.height);
    }

    public Rectangle getInteriorBounds(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle();
        Insets insets = this.getInsets();
        rect.x = x + insets.left;
        rect.y = y + insets.top;
        rect.width = width - insets.left - insets.right;
        rect.height = height - insets.top - insets.bottom;
        return rect;
    }

    public int getLightSource() {
        return this.lightSource;
    }

    public int getStyle() {
        return this.style;
    }

    public int getLeftMargin() {
        return this.getInsets().left;
    }

    public int getBottomMargin() {
        return this.getInsets().bottom;
    }

    public int getRightMargin() {
        return this.getInsets().right;
    }

    public int getTopMargin() {
        return this.getInsets().top;
    }

    public void setBaseColor(Color c) {
        if (!Util.equal((Object)c, (Object)this.baseColorJ)) {
            Color oldColor = this.baseColorJ;
            this.baseColorJ = c;
            this.firePropertyChange("baseColor", oldColor, this.baseColorJ);
        }
    }

    public void setBorderWidth(int width) {
        if (this.borderWidth != width) {
            int oldWidth = this.borderWidth;
            this.borderWidth = width;
            this.firePropertyChange("borderWidth", new Integer(oldWidth), new Integer(width));
        }
    }

    public void setStyle(int s) {
        if (this.style != s) {
            int oldStyle = this.getStyle();
            this.style = s;
            this.firePropertyChange("style", new Integer(oldStyle), new Integer(s));
        }
    }

    public void setLightSource(int ltSrc) {
        if (this.lightSource != ltSrc) {
            int oldType = this.getLightSource();
            this.lightSource = ltSrc;
            this.firePropertyChange("lightSource", new Integer(oldType), new Integer(ltSrc));
        }
    }

    protected String paramString() {
        return "Insets=" + this.getInsets();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.paramString() + "]";
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.baseColor != null) {
            this.baseColorJ = this.baseColor;
            this.baseColor = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int code = 0;
        if (this.getBaseColor() != null) {
            code += this.getBaseColor().hashCode();
        }
        code += this.getLightSource();
        code += this.getStyle();
        return code += this.getBorderWidth();
    }

    public boolean equals(Object object) {
        Border border;
        return object instanceof Border && (border = (Border)((Object)object)) != null && this.getLightSource() == border.getLightSource() && this.getStyle() == border.getStyle() && this.getBorderWidth() == border.getBorderWidth() && Util.equal((Object)this.getBaseColor(), (Object)border.getBaseColor());
    }
}

