/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.ActionSource;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.ObjectDataInterface;
import com.sas.lang.StringDataInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.Alignment;
import com.sas.visuals.ButtonListenerInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.DefaultButtonListener;
import com.sas.visuals.DefaultButtonModel;
import com.sas.visuals.IconInterface;
import com.sas.visuals.RB;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class BaseButton
extends CompositeContainer
implements ActionSource,
ItemSelectable,
ActionListener,
ItemListener,
FocusListener,
StringDataInterface,
Alignment,
ResizeToFitInterface,
PublicClonable {
    static final long serialVersionUID = 6606768798127461921L;
    public static final String RB_KEY = "BaseButton.";
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    protected IconInterface defaultIcon;
    protected IconInterface disabledIcon;
    protected IconInterface pressedIcon;
    protected IconInterface rolloverIcon;
    protected IconInterface selectedIcon;
    protected Object item;
    protected String actionCommand;
    protected String text;
    protected int textPosition;
    protected int gap;
    protected int focusGap;
    protected Insets currentInsets;
    protected TransformInterface displayTransform;
    protected int verticalAlignment;
    protected int horizontalAlignment;
    protected int verticalTextAlignment;
    protected int horizontalTextAlignment;
    protected boolean resizeToFit;
    protected boolean focusPainted;
    protected boolean borderPainted;
    protected boolean hasFocus;
    protected ButtonListenerInterface buttonListener;
    protected ButtonModelInterface buttonModel;
    protected transient boolean updateText;
    protected transient boolean updateItem;
    protected transient ActionListener actionListenerList;
    protected transient ItemListener itemListenerList;
    static String[] requiredInterfacesString = new String[]{"com.sas.lang.ObjectDataInterface"};

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "displayTransform"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "text"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"buttonText.pd.txt")}}, {{"Name", "borderPainted"}, {"Expert", "true"}}, {{"Name", "buttonListener"}, {"Hidden", "true"}}, {{"Name", "buttonModel"}, {"Hidden", "true"}}, {{"Name", "defaultIcon"}, {"Property editor class", "com.sas.visuals.IconInterfaceEditor"}}, {{"Name", "pressedIcon"}, {"Property editor class", "com.sas.visuals.IconInterfaceEditor"}}, {{"Name", "disabledIcon"}, {"Property editor class", "com.sas.visuals.IconInterfaceEditor"}}, {{"Name", "selectedIcon"}, {"Property editor class", "com.sas.visuals.IconInterfaceEditor"}}, {{"Name", "rolloverIcon"}, {"Property editor class", "com.sas.visuals.IconInterfaceEditor"}}, {{"Name", "focusGap"}, {"Expert", "true"}}, {{"Name", "focusPainted"}, {"Expert", "true"}}, {{"Name", "horizontalAlignment"}, {"Property editor class", "com.sas.beans.editors._HorizontalAlignmentEditor"}}, {{"Name", "horizontalTextAlignment"}, {"Property editor class", "com.sas.beans.editors._HorizontalAlignmentEditor"}}, {{"Name", "textPosition"}, {"Property editor class", "com.sas.beans.editors._SideOrientationEditor"}}, {{"Name", "verticalAlignment"}, {"Property editor class", "com.sas.beans.editors._VerticalAlignmentEditor"}}, {{"Name", "verticalTextAlignment"}, {"Property editor class", "com.sas.beans.editors._VerticalAlignmentEditor"}}, {{"Name", "keyAccelerator"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.buttonModel) {
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, listener);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListenerList = AWTEventMulticaster.add(this.itemListenerList, listener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.resizeToFit();
    }

    protected void buttonModelArmed(ButtonModelInterface btnModel) {
        if (!btnModel.isDisabled()) {
            this.repaint();
        }
    }

    protected void buttonModelDisabled(ButtonModelInterface btnModel) {
    }

    protected void buttonModelPressed(ButtonModelInterface btnModel) {
        if (!btnModel.isDisabled()) {
            this.repaint();
        }
    }

    protected void buttonModelRollover(ButtonModelInterface btnModel) {
        if (btnModel.isDisabled() || this.getDefaultIcon() == null || this.getRolloverIcon() == null || btnModel.isSelected() && this.getSelectedIcon() != null || btnModel.isPressed() && this.getPressedIcon() != null) {
            return;
        }
        this.repaint();
    }

    protected void buttonModelSelected(ButtonModelInterface btnModel) {
        this.repaint();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseButton clone = (BaseButton)super.clone();
        ActionListener oldAL = this.actionListenerList;
        ItemListener oldIL = this.itemListenerList;
        this.removeKeyListener(this.buttonListener);
        this.removeMouseListener(this.buttonListener);
        this.removeActionListener(this.actionListenerList);
        this.removeItemListener(this.itemListenerList);
        this.removeFocusListener(this);
        ButtonModelInterface oldBM = this.buttonModel;
        clone.removeKeyListener(this.buttonListener);
        clone.removeMouseListener(this.buttonListener);
        clone.removeActionListener(this.actionListenerList);
        clone.removeFocusListener(this);
        clone.removeItemListener(this.itemListenerList);
        clone.setButtonModel(null);
        clone.setButtonModel(new DefaultButtonModel());
        clone.setButtonListener(new DefaultButtonListener(clone.buttonModel));
        clone.addActionListener(clone.actionListenerList);
        clone.addItemListener(clone.itemListenerList);
        clone.addKeyListener(clone.getButtonListener());
        clone.addMouseListener(clone.getButtonListener());
        clone.addFocusListener(clone);
        this.buttonListener.setButtonModel(oldBM);
        this.addKeyListener(this.buttonListener);
        this.addMouseListener(this.buttonListener);
        this.addActionListener(oldAL);
        this.addItemListener(oldIL);
        this.addFocusListener(this);
        return clone;
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.hasFocus = true;
        if (this.isFocusPainted()) {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.hasFocus = false;
        if (this.isFocusPainted()) {
            this.repaint();
        }
    }

    public String getActionCommand() {
        String actionCmd = this.getButtonModel().getActionCommand();
        if (actionCmd == null) {
            return this.getText();
        }
        return actionCmd;
    }

    public ButtonListenerInterface getButtonListener() {
        return this.buttonListener;
    }

    public ButtonModelInterface getButtonModel() {
        return this.buttonModel;
    }

    protected Dimension getContentSize(Dimension textSize, Dimension iconSize) {
        Dimension contentSize = new Dimension(0, 0);
        int iconTextGap = this.getIconTextGap();
        if (textSize.width == 0 || textSize.height == 0 || iconSize.width == 0 || iconSize.height == 0) {
            iconTextGap = 0;
        }
        switch (this.getTextPosition()) {
            case 4: 
            case 8: {
                contentSize.width = textSize.width > iconSize.width ? textSize.width : iconSize.width;
                contentSize.height = iconSize.height + iconTextGap + textSize.height;
                break;
            }
            case 1: 
            case 2: {
                contentSize.height = textSize.height > iconSize.height ? textSize.height : iconSize.height;
                contentSize.width = textSize.width + iconTextGap + iconSize.width;
                break;
            }
            default: {
                contentSize.height = textSize.height > iconSize.height ? textSize.height : iconSize.height;
                contentSize.width = textSize.width > iconSize.width ? textSize.width : iconSize.width;
            }
        }
        return contentSize;
    }

    public IconInterface getDefaultIcon() {
        return this.defaultIcon;
    }

    public IconInterface getDisabledIcon() {
        return this.disabledIcon;
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public int getFocusGap() {
        return this.focusGap;
    }

    public int getIconTextGap() {
        return this.gap;
    }

    @Override
    public Insets getInsets() {
        Insets borderInsets = this.getBorder().getInsets((Component)this);
        Insets insets = (Insets)this.currentInsets.clone();
        if (this.isBorderPainted()) {
            if (insets.top < borderInsets.top) {
                insets.top = borderInsets.top;
            }
            if (insets.bottom < borderInsets.bottom) {
                insets.bottom = borderInsets.bottom;
            }
            if (insets.right < borderInsets.right) {
                insets.right = borderInsets.right;
            }
            if (insets.left < borderInsets.left) {
                insets.left = borderInsets.left;
            }
        }
        return insets;
    }

    public Object getItem() {
        return this.item;
    }

    public String getText() {
        return this.text;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    public char getKeyAccelerator() {
        return this.getButtonModel().getKeyAccelerator();
    }

    @Override
    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    public IconInterface getPressedIcon() {
        return this.pressedIcon;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public IconInterface getRolloverIcon() {
        return this.rolloverIcon;
    }

    public IconInterface getSelectedIcon() {
        return this.selectedIcon;
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.getButtonModel().isSelected()) {
            Object[] items = new Object[]{this.getItem()};
            return items;
        }
        return null;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextAlignment() {
        return this.verticalTextAlignment;
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    public boolean isSelected() {
        return this.getButtonModel().isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.getButtonModel()) {
            this.processItemEvent(new ItemEvent(this, 701, this, event.getStateChange()));
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListenerList != null) {
            this.itemListenerList.itemStateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String name = event.getPropertyName();
        ButtonModelInterface currentButtonModel = this.getButtonModel();
        ModelInterface model = this.getModelInterface();
        if (eSource == this.item) {
            this.refreshItem(this.item);
            this.firePropertyChange("item", null, this.item);
        } else if (eSource == currentButtonModel && name != null) {
            if (name.equals("disabled")) {
                boolean enabled = !currentButtonModel.isDisabled();
                super.setEnabled(enabled);
                this.buttonModelDisabled(currentButtonModel);
            } else if (name.equals("selected")) {
                this.buttonModelSelected(currentButtonModel);
                ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"selected", (Object)event.getOldValue(), (Object)event.getNewValue());
            } else if (name.equals("pressed")) {
                this.buttonModelPressed(currentButtonModel);
            } else if (name.equals("armed")) {
                this.buttonModelArmed(currentButtonModel);
            } else if (name.equals("rollover")) {
                this.buttonModelRollover(currentButtonModel);
            }
        } else if (eSource == this.displayTransform) {
            this.firePropertyChange("displayTransform", null, this.displayTransform);
            this.refreshItem(this.item);
        } else if (eSource == model && model != null && model instanceof ObjectDataInterface) {
            this.setItem(((ObjectDataInterface)model).getObjectData());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        String displayText;
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.buttonModel != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.buttonModel, (PropertyChangeListener)((Object)this));
        }
        Object displayItem = this.item;
        if (this.displayTransform != null) {
            try {
                displayItem = this.displayTransform.transform(this.item);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (displayItem != null && (displayText = displayItem.toString()) != null && !displayText.equals(this.text)) {
            this.item = this.text;
        }
        if (this.item != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.item, (PropertyChangeListener)((Object)this));
        }
        if (this.displayTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)((Object)this));
        }
        if (this.buttonListener != null) {
            this.removeKeyListener(this.buttonListener);
            this.addKeyListener(this.buttonListener);
        }
        if (this.horizontalAlignment == 0) {
            this.horizontalAlignment = 256;
        }
        if (this.horizontalTextAlignment == 0) {
            this.horizontalTextAlignment = 256;
        }
        if (this.verticalAlignment == 0) {
            this.verticalAlignment = 256;
        }
        if (this.verticalTextAlignment == 0) {
            this.verticalTextAlignment = 256;
        }
        if (this.currentInsets == null) {
            Insets superInsets = super.getInsets();
            Insets borderInsets = this.getBorder().getInsets((Component)this);
            this.currentInsets = new Insets(0, 0, 0, 0);
            this.currentInsets.top = superInsets.top - borderInsets.top;
            this.currentInsets.bottom = superInsets.bottom - borderInsets.bottom;
            this.currentInsets.left = superInsets.left - borderInsets.left;
            this.currentInsets.right = superInsets.right - borderInsets.right;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model != null) {
            com.sas.beans.Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        }
        super.detachModel(model);
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null && model instanceof ObjectDataInterface) {
            com.sas.beans.Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
            this.setItem(((ObjectDataInterface)model).getObjectData());
        }
    }

    protected void refreshItem(Object newItem) {
        if (this.updateText) {
            return;
        }
        Object displayItem = newItem;
        if (this.displayTransform != null) {
            try {
                displayItem = this.displayTransform.transform(displayItem);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (displayItem == null) {
            this.setText(null);
        } else {
            this.setText(displayItem.toString());
        }
        this.resizeToFit();
        this.repaint();
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListenerList = AWTEventMulticaster.remove(this.itemListenerList, listener);
    }

    public void resizeToFit() {
        if (this.isResizeToFit() && this.isDisplayable()) {
            this.setSize(this.getPreferredSize());
        }
    }

    public void setActionCommand(String cmd) {
        String oldCmd = this.getButtonModel().getActionCommand();
        if (oldCmd == null || Util.unequal((Object)oldCmd, (Object)cmd)) {
            this.getButtonModel().setActionCommand(cmd);
            this.actionCommand = cmd;
            this.firePropertyChange("actionCommand", oldCmd, cmd);
        }
    }

    public void setBorderPainted(boolean paint) {
        if (this.borderPainted != paint) {
            this.borderPainted = paint;
            this.repaint();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (!this.isResizeToFit()) {
            super.setBounds(x, y, width, height);
        } else {
            Dimension pSize = this.getPreferredSize();
            super.setBounds(x, y, pSize.width, pSize.height);
        }
    }

    public void setButtonListener(ButtonListenerInterface btnListener) {
        if (btnListener != null && btnListener != this.buttonListener) {
            ButtonListenerInterface oldBtnListener = this.buttonListener;
            if (oldBtnListener != null) {
                oldBtnListener.setButtonModel(null);
                this.removeMouseListener(oldBtnListener);
                this.removeMouseMotionListener(oldBtnListener);
                this.removeKeyListener(oldBtnListener);
            }
            this.buttonListener = btnListener;
            this.buttonListener.setButtonModel(this.getButtonModel());
            this.addMouseListener(this.buttonListener);
            this.addMouseMotionListener(this.buttonListener);
            this.addKeyListener(this.buttonListener);
            this.firePropertyChange("buttonListener", oldBtnListener, this.buttonListener);
        }
    }

    public void setButtonModel(ButtonModelInterface model) {
        if (this.getButtonModel() != model) {
            ButtonModelInterface oldButtonModel = this.getButtonModel();
            this.buttonModel = model;
            if (oldButtonModel != null) {
                oldButtonModel.removeActionListener(this);
                oldButtonModel.removeItemListener(this);
                com.sas.beans.Util.removePropertyChangeListener((Object)oldButtonModel, (PropertyChangeListener)((Object)this));
            }
            if (this.buttonModel != null) {
                if (this.buttonListener != null) {
                    this.buttonListener.setButtonModel(this.buttonModel);
                }
                this.buttonModel.addActionListener(this);
                this.buttonModel.addItemListener(this);
                com.sas.beans.Util.addPropertyChangeListener((Object)this.buttonModel, (PropertyChangeListener)((Object)this));
            }
            this.firePropertyChange("buttonModel", oldButtonModel, this.buttonModel);
        }
    }

    public void setDefaultIcon(IconInterface defaultImg) {
        if (this.defaultIcon != defaultImg) {
            IconInterface oldDefaultIcon = this.defaultIcon;
            this.defaultIcon = defaultImg;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("defaultIcon", oldDefaultIcon, this.defaultIcon);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropBarrier(false);
        this.setIDEDnDDropTarget(false);
        this.verticalAlignment = 256;
        this.horizontalAlignment = 256;
        this.verticalTextAlignment = 256;
        this.horizontalTextAlignment = 256;
        this.textPosition = 8;
        this.gap = 5;
        this.focusGap = 1;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.borderPainted = true;
        this.focusPainted = true;
        this.addFocusListener(this);
        this.setButtonModel(new DefaultButtonModel());
        this.setButtonListener(new DefaultButtonListener(this.getButtonModel()));
    }

    public void setDisabledIcon(IconInterface disabledImg) {
        if (this.disabledIcon != disabledImg) {
            IconInterface oldDisabledIcon = this.disabledIcon;
            this.disabledIcon = disabledImg;
            this.resizeToFit();
            if (this.getButtonModel().isDisabled()) {
                this.repaint();
            }
            this.firePropertyChange("disabledIcon", oldDisabledIcon, this.disabledIcon);
        }
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (transform != this.displayTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)((Object)this));
            }
            if (this.displayTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)((Object)this));
            }
            this.refreshItem(this.getItem());
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.getButtonModel().setDisabled(!b);
    }

    public void setFocusGap(int g) {
        if (this.focusGap != g) {
            int oldGap = this.focusGap;
            this.focusGap = g;
            if (this.isFocusPainted() && this.hasFocus) {
                this.repaint();
            }
            this.firePropertyChange("focusGap", new Integer(oldGap), new Integer(this.focusGap));
        }
    }

    public void setFocusPainted(boolean paint) {
        if (this.focusPainted != paint) {
            this.focusPainted = paint;
            if (this.hasFocus) {
                this.repaint();
            }
            this.firePropertyChange("focusPainted", new Boolean(!this.resizeToFit), new Boolean(this.resizeToFit));
        }
    }

    @Override
    public void setFont(Font f) {
        Font oldFont = this.getFont();
        super.setFont(f);
        if (oldFont == null || !oldFont.equals(f)) {
            this.resizeToFit();
        }
    }

    public void setIconTextGap(int g) {
        if (g != this.gap) {
            int oldGap = this.gap;
            this.gap = g;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("iconTextGap", new Integer(oldGap), new Integer(this.gap));
        }
    }

    public void setHorizontalAlignment(int horizontalAlign) {
        if (this.horizontalAlignment != horizontalAlign) {
            int oldHorizontalAlign = this.horizontalAlignment;
            this.horizontalAlignment = horizontalAlign;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("horizontalAlignment", new Integer(oldHorizontalAlign), new Integer(this.horizontalAlignment));
        }
    }

    public void setHorizontalTextAlignment(int hTextAlign) {
        if (this.horizontalTextAlignment != hTextAlign) {
            int oldHorizontalTextAlign = this.horizontalTextAlignment;
            this.horizontalTextAlignment = hTextAlign;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("horizontalTextAlignment", new Integer(oldHorizontalTextAlign), new Integer(this.horizontalTextAlignment));
        }
    }

    @Override
    public void setInsets(Insets insets) {
        if (Util.unequal((Object)insets, (Object)this.currentInsets)) {
            Insets oldInsets = (Insets)this.currentInsets.clone();
            this.currentInsets = insets;
            this.firePropertyChange("insets", oldInsets, this.currentInsets);
        }
    }

    public void setItem(Object newItem) {
        if (this.updateItem) {
            return;
        }
        if (this.item != newItem) {
            try {
                this.updateItem = true;
                Object oldItem = this.item;
                this.item = newItem;
                if (oldItem != null) {
                    com.sas.beans.Util.removePropertyChangeListener((Object)oldItem, (PropertyChangeListener)((Object)this));
                }
                if (this.item != null) {
                    com.sas.beans.Util.addPropertyChangeListener((Object)this.item, (PropertyChangeListener)((Object)this));
                }
                this.refreshItem(this.item);
                this.firePropertyChange("item", oldItem, this.item);
            }
            finally {
                this.updateItem = false;
            }
        }
    }

    public void setKeyAccelerator(char key) {
        if (this.getKeyAccelerator() != key) {
            char oldKey = this.getButtonModel().getKeyAccelerator();
            this.getButtonModel().setKeyAccelerator(key);
            this.firePropertyChange("selected", new Character(oldKey), new Character(key));
        }
    }

    public void setPressedIcon(IconInterface pressedImg) {
        if (this.pressedIcon != pressedImg) {
            IconInterface oldPressedIcon = this.pressedIcon;
            this.pressedIcon = pressedImg;
            this.resizeToFit();
            if (this.getButtonModel().isPressed()) {
                this.repaint();
            }
            this.firePropertyChange("pressedIcon", oldPressedIcon, this.pressedIcon);
        }
    }

    public void setResizeToFit(boolean resize) {
        if (this.resizeToFit != resize) {
            this.resizeToFit = resize;
            this.resizeToFit();
            this.firePropertyChange("resizeToFit", new Boolean(!this.resizeToFit), new Boolean(this.resizeToFit));
        }
    }

    public void setRolloverIcon(IconInterface rolloverImg) {
        if (this.rolloverIcon != rolloverImg) {
            IconInterface oldRolloverIcon = this.rolloverIcon;
            this.rolloverIcon = rolloverImg;
            this.resizeToFit();
            if (this.getButtonModel().isRollover()) {
                this.repaint();
            }
            this.firePropertyChange("rolloverIcon", oldRolloverIcon, this.rolloverIcon);
        }
    }

    public void setSelected(boolean selected) {
        if (this.isSelected() != selected) {
            this.getButtonModel().setSelected(selected);
        }
    }

    public void setSelectedIcon(IconInterface selectedImg) {
        if (this.selectedIcon != selectedImg) {
            IconInterface oldSelectedIcon = this.selectedIcon;
            this.selectedIcon = selectedImg;
            this.resizeToFit();
            if (this.getButtonModel().isSelected()) {
                this.repaint();
            }
            this.firePropertyChange("selectedIcon", oldSelectedIcon, this.selectedIcon);
        }
    }

    public void setText(String txt) {
        String oldText = this.getText();
        if (txt != oldText) {
            try {
                this.updateText = true;
                this.text = txt;
                this.setItem(this.text);
                this.resizeToFit();
                this.repaint();
                this.firePropertyChange("text", oldText, this.text);
            }
            finally {
                this.updateText = false;
            }
        }
    }

    public void setTextPosition(int position) {
        if (this.textPosition != position) {
            int oldTextPosition = this.textPosition;
            this.textPosition = position;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("textPosition", new Integer(oldTextPosition), new Integer(this.textPosition));
        }
    }

    public void setVerticalAlignment(int verticalAlign) {
        if (this.verticalAlignment != verticalAlign) {
            int oldVerticalAlign = this.verticalAlignment;
            this.verticalAlignment = verticalAlign;
            this.repaint();
            this.firePropertyChange("verticalAlignment", new Integer(oldVerticalAlign), new Integer(this.verticalAlignment));
        }
    }

    public void setVerticalTextAlignment(int vTextAlign) {
        if (this.verticalTextAlignment != vTextAlign) {
            int oldVerticalTextAlign = this.verticalTextAlignment;
            this.verticalTextAlignment = vTextAlign;
            this.repaint();
            this.firePropertyChange("verticalTextAlignment", new Integer(oldVerticalTextAlign), new Integer(this.verticalTextAlignment));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListenerList);
        AWTEventMulticaster2.save(s, "itemL", this.itemListenerList);
        s.writeObject(null);
    }
}

