/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.IconInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.SystemColor;

public class ArrowIcon
implements IconInterface {
    private int orientation;
    private Dimension minimumSize;
    private Dimension preferredSize;

    public ArrowIcon() {
        this(4);
    }

    public ArrowIcon(int orient) {
        this.orientation = orient;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            return this.getMinimumSize();
        }
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension size) {
        this.preferredSize = size != null ? new Dimension(size) : null;
    }

    public void setMinimumSize(Dimension size) {
        this.minimumSize = size != null ? new Dimension(size) : null;
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            return new Dimension(11, 11);
        }
        return this.minimumSize;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        Color currentColor = g.getColor();
        Color foreground = comp.getForeground();
        if (foreground == null) {
            foreground = SystemColor.text;
        }
        int dWidth = width;
        int dHeight = height;
        int dx = x;
        int dy = y;
        if (this.orientation == 4 || this.orientation == 8) {
            int arrowHeight = height / 3;
            int arrowBase = arrowHeight * 2 - 1;
            if (arrowBase >= width - 1) {
                arrowBase = width - 1;
                if (arrowBase % 2 == 0) {
                    ++arrowBase;
                }
                arrowHeight = arrowBase / 2 + 1;
            }
            dx += (width - arrowBase) / 2;
            dy += (height - arrowHeight) / 2;
            dWidth = arrowBase;
            dHeight = arrowHeight;
        } else {
            int arrowHeight = width / 3;
            int arrowBase = arrowHeight * 2 - 1;
            if (arrowBase >= height - 1) {
                arrowBase = height - 1;
                if (arrowBase % 2 == 0) {
                    ++arrowBase;
                }
                arrowHeight = arrowBase / 2 + 1;
            }
            dx += (width - arrowHeight) / 2;
            dy += (height - arrowBase) / 2;
            dWidth = arrowHeight;
            dHeight = arrowBase;
        }
        g.setColor(foreground);
        this.paintArrow(g, dx, dy, dWidth, dHeight, this.orientation);
        g.setColor(currentColor);
    }

    private void paintArrow(Graphics g, int x, int y, int width, int height, int direction) {
        Polygon arrow = new Polygon();
        switch (direction) {
            case 4: {
                arrow.addPoint(x + width / 2, y - 1);
                arrow.addPoint(x - 1, y + height);
                arrow.addPoint(x + 1 + width, y + height);
                break;
            }
            case 8: {
                arrow.addPoint(x + width / 2, y + height);
                arrow.addPoint(x, y);
                arrow.addPoint(x + width, y);
                break;
            }
            case 2: {
                arrow.addPoint(x + width, y + height / 2);
                arrow.addPoint(x, y - 1);
                arrow.addPoint(x, y + height);
                break;
            }
            case 1: {
                arrow.addPoint(x, y + height / 2);
                arrow.addPoint(x + width, y - 1);
                arrow.addPoint(x + width, y + height);
            }
        }
        g.fillPolygon(arrow);
    }
}

