/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.awt.print.PDFGraphics;
import com.sas.awt.print.PrintException;
import com.sas.awt.print.PrintJob;
import com.sas.awt.print.PrintableInterface;
import com.sas.mail.ByteArrayDataSource;
import com.sas.util.transforms.ToDataSourceTransform;
import com.sas.util.transforms.TransformException;
import java.io.ByteArrayOutputStream;

public class PrintableInterfaceToPDFDataSourceTransform
extends ToDataSourceTransform {
    static final long serialVersionUID = 8414026630763227483L;
    public static final PrintableInterfaceToPDFDataSourceTransform defaultInstance = new PrintableInterfaceToPDFDataSourceTransform();

    public PrintableInterfaceToPDFDataSourceTransform() {
        this.extension = ".pdf";
        this.defaultName = "print";
        this.setText("( to PDF DataSource )");
    }

    public Object transform(Object object) throws TransformException {
        ByteArrayDataSource dataSource = null;
        if (object instanceof PrintableInterface) {
            PrintableInterface printable = (PrintableInterface)object;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PDFGraphics pdfGraphics = new PDFGraphics(outputStream);
            PrintJob printJob = PrintJob.getPrintJob(pdfGraphics);
            printJob.setPrintable(printable);
            try {
                printJob.print();
            }
            catch (PrintException pe) {
                pe.printStackTrace();
                throw new TransformException("Error creating PDF DataSource.");
            }
            dataSource = new ByteArrayDataSource(outputStream, "application/pdf", this.getFullName());
        }
        return dataSource;
    }
}

