/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.selectors;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AVLTree;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.datasetinfo.DataSetInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticFormattedDataInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.util.ApplyInterface;
import com.sas.util.Comparator;
import com.sas.util.EventGateInterface;
import com.sas.util.GenericComparator;
import com.sas.util.Util;
import com.sas.util.selectors.BaseSelector;
import com.sas.util.selectors.RB;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ColumnSelector
extends BaseSelector
implements StaticOrderedCollectionInterface {
    public static final String RB_KEY = "ColumnSelector.";
    static final long serialVersionUID = -6209322708319709038L;
    private Comparator comparator;
    private boolean duplicatesRemoved;
    private boolean formatted;
    private transient boolean dirty;
    private StaticOrderedCollection staticCollection;
    private OrderedCollectionInterface columnCollection;
    protected transient ContentsChangedListenerList allContentsChangedListeners;
    private static String[] requiredInterfacesString = new String[]{"com.sas.table.StaticTableInterface"};

    public ColumnSelector() {
    }

    public ColumnSelector(StaticTableInterface table) {
        super((Object)table);
    }

    public ColumnSelector(StaticTableInterface table, Object key, Comparator comparator) {
        this(table);
        this.setComparator(comparator);
    }

    public ColumnSelector(StaticTableInterface table, Object key, boolean duplicatesRemoved, boolean formatted) {
        this(table, key, (Comparator)GenericComparator.defaultInstance, duplicatesRemoved, formatted);
    }

    public ColumnSelector(StaticTableInterface table, Object key, Comparator comparator, boolean duplicatesRemoved, boolean formatted) {
        super((Object)table);
        this.setComparator(comparator);
        this.setFormatted(formatted);
        this.setDuplicatesRemoved(duplicatesRemoved);
        this.setKey(key);
    }

    public void setDefaultValues() {
        this.setComparator((Comparator)GenericComparator.defaultInstance);
        this.setFormatted(true);
        this.setDuplicatesRemoved(true);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "duplicatesRemoved"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"duplicatesRemoved.pd.txt")}}, {{"Name", "formatted"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"formatted.pd.txt")}}, {{"Name", "comparator"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"comparator.pd.txt")}}, {{"Name", "dirty"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"dirty.pd.txt")}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public void setModelInterface(ModelInterface model) {
        super.setModelInterface(model);
        super.setCollection((Object)model);
        this.forgetValue();
    }

    public void setDuplicatesRemoved(boolean unique) {
        boolean oldDuplicatesRemoved = this.isDuplicatesRemoved();
        if (oldDuplicatesRemoved == unique) {
            return;
        }
        this.forgetValue();
        this.duplicatesRemoved = unique;
        ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"duplicatesRemoved", (boolean)this.isDuplicatesRemoved());
        this.maybeFireValue(null);
    }

    public boolean isDuplicatesRemoved() {
        return this.duplicatesRemoved;
    }

    protected void forgetValue() {
        this.setDirty(true);
        super.forgetValue();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            if (this.columnCollection != null) {
                this.columnCollection.removeContentsChangedListener((ContentsChangedListener)this);
                this.columnCollection = null;
            }
            this.staticCollection = null;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setComparator(Comparator comparator) {
        Comparator oldComparator = this.getComparator();
        if (Util.equal((Object)oldComparator, (Object)comparator)) {
            return;
        }
        this.comparator = comparator;
        this.forgetValue();
        this.firePropertyChange("comparator", oldComparator, this.getComparator());
        this.maybeFireValue(null);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setFormatted(boolean formatted) {
        boolean oldFormatted = this.isFormatted();
        if (oldFormatted == formatted) {
            return;
        }
        this.formatted = formatted;
        this.forgetValue();
        ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"formatted", (boolean)this.isFormatted());
        this.maybeFireValue(null);
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void getUniqueColumnValues(Object key) throws Exception {
        OrderedCollectionInterface column = this.getColumnCollection();
        try {
            ColumnSelector.disableEvents(column);
            OrderedCollectionInterface orderedCollectionInterface = column;
            synchronized (orderedCollectionInterface) {
                int len;
                block9: {
                    this.getTableColumn(key);
                    len = column.count();
                    if (len > 1) break block9;
                    return;
                }
                AVLTree tree = new AVLTree(this.getComparator(), false);
                for (int i = 0; i < len; ++i) {
                    Object cell = column.get(i);
                    tree.add(cell);
                }
                Enumeration e = tree.getItems();
                column.removeAll();
                column.addItems(e);
            }
        }
        finally {
            ColumnSelector.enableEvents(column);
        }
    }

    public final void setCollection(Object object) {
        this.setModelInterface((ModelInterface)object);
    }

    protected OrderedCollectionInterface newOrderedCollection() {
        return new OrderedCollection();
    }

    public final StaticOrderedCollectionInterface getColumn() {
        if (this.staticCollection == null) {
            this.staticCollection = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.getColumnCollection());
        }
        return this.staticCollection;
    }

    protected OrderedCollectionInterface getColumnCollection() {
        if (this.columnCollection == null) {
            this.columnCollection = this.newOrderedCollection();
            this.columnCollection.addContentsChangedListener((ContentsChangedListener)this);
            this.staticCollection = null;
        }
        return this.columnCollection;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null && event.getSource() == this.getColumnCollection()) {
            this.allContentsChangedListeners.contentsChanged(new ContentsChangedEvent((Object)this));
        }
        super.contentsChanged(event);
    }

    public Object getValue(Object key) {
        if (this.isDirty()) {
            this.update(key);
        }
        return this.getColumn();
    }

    protected void update(Object key) {
        StaticTableInterface table = (StaticTableInterface)this.getCollection();
        try {
            if (this.isDuplicatesRemoved()) {
                if (table instanceof DataSetInterface && this.isFormatted()) {
                    this.getUniqueFormattedColumnValues(key);
                } else {
                    this.getUniqueColumnValues(key);
                }
            } else {
                this.getTableColumn(key);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.setDirty(false);
    }

    protected void maybeFireValue(Object oldValue) {
        Object selection = this.getValue();
        if (selection != oldValue && this.anyPropertyChangeListeners()) {
            this.firePropertyChange("value", oldValue, selection);
            this.firePropertyChange("column", oldValue, selection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void getUniqueFormattedColumnValues(Object key) throws Exception {
        StaticTableInterface table = (StaticTableInterface)this.getCollection();
        DataSetInterface ds = (DataSetInterface)table;
        RemoteBaseClient remote = (RemoteBaseClient)((Object)ds);
        Connection connection = remote._RemoteObject_getContext();
        DataSetInfoInterface dsInfo = (DataSetInfoInterface)connection.getClassFactory().newInstance("com.sas.sasserver.datasetinfo.DataSetInfoInterface", connection);
        OrderedCollectionInterface column = this.getColumnCollection();
        try {
            ColumnSelector.disableEvents(column);
            dsInfo.setDataSet(ds.getDataSet());
            int columnIndex = key instanceof Number ? ((Number)key).intValue() : dsInfo.getVariableIndex(((String)key).trim());
            String[] values = dsInfo.getVariableUniqueValues(columnIndex);
            OrderedCollectionInterface orderedCollectionInterface = column;
            synchronized (orderedCollectionInterface) {
                column.removeAll();
                int valuesLen = values.length;
                for (int i = 0; i < valuesLen; ++i) {
                    column.add((Object)values[i]);
                }
            }
        }
        finally {
            ColumnSelector.enableEvents(column);
            dsInfo.setDataSet("");
        }
    }

    protected static void enableEvents(Object object) {
        if (object instanceof EventGateInterface) {
            ((EventGateInterface)object).enableEvents();
        }
    }

    protected static void disableEvents(Object object) {
        if (object instanceof EventGateInterface) {
            ((EventGateInterface)object).disableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void getTableColumn(Object key) throws Exception {
        StaticTableInterface table = (StaticTableInterface)this.getCollection();
        int columnIndex = -1;
        if (key instanceof Number) {
            columnIndex = ((Number)key).intValue();
        } else if (table instanceof StaticColumnLabelInterface) {
            String columnName = ((String)key).trim();
            columnIndex = ColumnSelector.findColumn(columnName, table);
        }
        OrderedCollectionInterface column = this.getColumnCollection();
        if (this.isFormatted() && table instanceof StaticFormattedDataInterface) {
            String[] strings = ((StaticFormattedDataInterface)table).getFormattedColumn(columnIndex);
            OrderedCollectionInterface orderedCollectionInterface = column;
            synchronized (orderedCollectionInterface) {
                try {
                    ColumnSelector.disableEvents(column);
                    column.removeAll();
                    int stringsLen = strings.length;
                    for (int i = 0; i < stringsLen; ++i) {
                        column.add((Object)strings[i]);
                    }
                }
                finally {
                    ColumnSelector.enableEvents(column);
                }
            }
        }
        Object[] values = table.getColumn(columnIndex);
        OrderedCollectionInterface orderedCollectionInterface = column;
        synchronized (orderedCollectionInterface) {
            try {
                ColumnSelector.disableEvents(column);
                column.removeAll();
                int valuesLen = values.length;
                for (int i = 0; i < valuesLen; ++i) {
                    column.add(values[i]);
                }
            }
            finally {
                ColumnSelector.enableEvents(column);
            }
        }
    }

    protected static int findColumn(String columnName, StaticTableInterface table) throws TableException {
        StaticColumnLabelInterface columnNames = (StaticColumnLabelInterface)table;
        if (columnNames.isColumnLabelsSupported()) {
            Object label;
            int i;
            int nLabels = table.getColumnCount();
            for (i = 1; i <= nLabels; ++i) {
                label = columnNames.getColumnLabel(i);
                if (!columnName.equals(label)) continue;
                return i;
            }
            for (i = 1; i <= nLabels; ++i) {
                label = columnNames.getColumnLabel(i);
                if (!(label instanceof String) || !columnName.equalsIgnoreCase(((String)label).trim())) continue;
                return i;
            }
        }
        try {
            int i = Integer.parseInt(columnName);
            return i;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Object getKey(Object value) {
        throw new IllegalStateException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public boolean equals(ColumnSelector other) {
        if (other == null) {
            return false;
        }
        if (Util.unequal((Object)this.getCollection(), (Object)other.getCollection())) {
            return false;
        }
        if (this.isDuplicatesRemoved() == other.isDuplicatesRemoved()) {
            return false;
        }
        if (this.isFormatted() == other.isFormatted()) {
            return false;
        }
        return !Util.unequal((Object)this.getKey(), (Object)other.getKey());
    }

    public boolean equals(Object object) {
        if (object instanceof ColumnSelector) {
            return this.equals((ColumnSelector)((Object)object));
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        this.allContentsChangedListeners = null;
        this.forgetValue();
        return clone;
    }

    public Enumeration getItems() {
        return this.getColumnCollection().getItems();
    }

    public boolean equals(StaticOrderedCollectionInterface otherCollection) {
        return this.getColumnCollection().equals(otherCollection);
    }

    public int getIndex(Object object, int index) {
        return this.getColumnCollection().getIndex(object, index);
    }

    public Enumeration getItems(int start, int end) {
        return this.getColumnCollection().getItems(start, end);
    }

    public int getLastIndex(Object object, int startIndex) {
        return this.getColumnCollection().getLastIndex(object, startIndex);
    }

    public void apply(ApplyInterface action) {
        this.getColumnCollection().apply(action);
    }

    public boolean contains(Object object) {
        return this.getColumnCollection().contains(object);
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    public int count() {
        return this.getColumnCollection().count();
    }

    public Object get(int index) {
        return this.getColumnCollection().get(index);
    }
}

