/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.errorhandlers;

import com.sas.ComponentInterface;
import com.sas.awt.util.Util;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.RB;
import com.sas.visuals.MessageBox;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;

public class MessageBoxErrorHandler
implements ErrorHandlerInterface,
Serializable {
    static final long serialVersionUID = 3329191431422271049L;
    public static final String RB_KEY = "MessageBoxErrorHandler.";
    static final String validationErrorText = RB.getStringResource((String)"MessageBoxErrorHandler.", (String)"validationError.txt");
    static final String constructionExceptionText = RB.getStringResource((String)"MessageBoxErrorHandler.", (String)"constructionException.txt");
    protected Frame frame;
    protected String overrideMessage;

    public MessageBoxErrorHandler() {
    }

    public MessageBoxErrorHandler(String overrideMessage) {
        this(null, overrideMessage);
    }

    public MessageBoxErrorHandler(Component frame) {
        this(frame, null);
    }

    public MessageBoxErrorHandler(Component frame, String overrideMessage) {
        if (frame != null) {
            this.frame = Util.getParentFrame(frame);
        }
        this.overrideMessage = overrideMessage;
    }

    public void handleError(ComponentInterface component, Message message, String messageCode) {
        Frame parentFrame = this.frame;
        if (parentFrame == null) {
            if (component instanceof Component) {
                parentFrame = Util.getParentFrame((Component)component);
            }
            if (parentFrame == null) {
                parentFrame = new Frame();
            }
        }
        MessageBox.showModalMessageBox(parentFrame, validationErrorText, this.overrideMessage == null ? message.toString() : this.overrideMessage, 1, 1, 2);
    }
}

