/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools;

import com.sas.awt.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;

public class SimpleLabel
extends Component {
    protected String text = "";
    protected boolean enabled = true;

    public SimpleLabel() {
    }

    public SimpleLabel(String text) {
        this.text = text;
    }

    public void initialize() {
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        Dimension box = this.getSize();
        Font currentFont = this.getFont();
        if (currentFont != null) {
            g.setColor(SystemColor.controlText);
            int gap = (box.height - currentFont.getSize()) / 2;
            Util.drawString(g, this.text, 2, box.height - gap, this.enabled);
            g.setColor(oldColor);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(5, 5);
        Font currentFont = this.getFont();
        if (currentFont != null) {
            prefSize.height = currentFont.getSize() + 11;
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(currentFont);
            prefSize.width = fontMetrics.stringWidth(this.text) + 5;
        }
        return prefSize;
    }
}

