/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.ComponentException;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ContainerInterfaceSupport;
import com.sas.awt.PanelVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.awt.print.PDFGraphics;
import com.sas.awt.print.PrintException;
import com.sas.awt.print.PrintGraphics;
import com.sas.awt.print.PrintScrollInterface;
import com.sas.awt.print.PrintableInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.Dictionary;
import com.sas.collection.LongKeyDictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.StaticDictionary;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticOrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.geometry.Rectangles;
import com.sas.measures.Length;
import com.sas.models.AlphabeticSequencer;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.CacheMonitorInterface;
import com.sas.models.SequentialCache;
import com.sas.models.SparseCache;
import com.sas.models.StaticCacheInterface;
import com.sas.table.Cell;
import com.sas.table.CellChangedEvent;
import com.sas.table.CellSelection;
import com.sas.table.CellStyle;
import com.sas.table.CellVector;
import com.sas.table.CellVectorChangedEvent;
import com.sas.table.CellVectorSelection;
import com.sas.table.CellVectorStyle;
import com.sas.table.Column;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.ColumnLabelChangedEvent;
import com.sas.table.ColumnLabelInterface;
import com.sas.table.ColumnSelection;
import com.sas.table.ColumnStyle;
import com.sas.table.DataCell;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.FontStyle;
import com.sas.table.FormattedDataInterface;
import com.sas.table.LabelCell;
import com.sas.table.LabelCellTypeInterface;
import com.sas.table.Row;
import com.sas.table.RowChangedEvent;
import com.sas.table.RowLabelChangedEvent;
import com.sas.table.RowLabelInterface;
import com.sas.table.RowSelection;
import com.sas.table.RowStyle;
import com.sas.table.Selection;
import com.sas.table.SelectionChangedEvent;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticFormattedDataInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.StaticTableStyleInterface;
import com.sas.table.StaticTableTypeInterface;
import com.sas.table.StaticTableTypeStylesInterface;
import com.sas.table.TableElement;
import com.sas.table.TableException;
import com.sas.table.TableInterface;
import com.sas.table.TableViewDefaults;
import com.sas.text.Message;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.ContextCommandsInterface;
import com.sas.util.Util;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.FullPaintInterface;
import com.sas.visuals.RadioBox;
import com.sas.visuals.ScrollbarLayout;
import com.sas.visuals.ScrollbarVisibilityInterface;
import com.sas.visuals.ScrollingInterface;
import com.sas.visuals.util.RubberBand;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class TableView
extends CompositeContainer
implements AdjustmentListener,
ContentsChangedListener,
FullPaintInterface,
ItemSelectable,
PropertyBagChangedListener,
PublicClonable,
ScrollbarVisibilityInterface,
ScrollingInterface,
ViewDefaultModelInterface,
PrintableInterface,
ContextCommandsInterface,
PrintScrollInterface {
    public static final String RB_KEY = "TableViewer.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.table.StaticTableInterface"};
    public static final int CELL = 0;
    public static final int COLUMN = 1;
    public static final int ROW = 2;
    public static final int USER_DEFINED = 3;
    public static final String COMMIT_CELL_ERROR = "Commit Cell Error";
    public static final int ROW_MAJOR = 0;
    public static final int COLUMN_MAJOR = 1;
    static final long serialVersionUID = -4593354686405682051L;
    private static int defaultHeight = 124;
    private static int defaultWidth = 248;
    private static final int TE_UPDATE_COLS = 1;
    private static final int TE_UPDATE_ROWLABEL_COL = 2;
    private static final int TE_UPDATE_ROWS = 4;
    private static final int TE_UPDATE_COLLABEL_ROW = 8;
    private static final int TE_PAINT_DISABLED = 16;
    private static final int TE_FONT_CHANGED = 32;
    private static final int TE_RESIZED = 64;
    private static final int TE_REPAINTED = 128;
    private static final int TE_FORCE_PAINT = 256;
    private static final int TE_SMOOTH_SCROLL = 512;
    private static final int TE_CURCELL_HAS_MOUSE_CAPTURE = 1024;
    private static final int TE_UPDATE_MODEL_WRITABILITY = 2048;
    private static final int TE_DEFAULT_DATASOURCE = 65536;
    private static final int TE_SCROLL_TRACKING = 131072;
    private static final int TE_UPDATE_MODEL_STYLES = 262144;
    private static final int TE_UPDATE_CELL_TYPES = 524288;
    private static final int TE_HOLD_REPAINTS = 0x100000;
    private static final int TE_UPDATE_INSETS = 0x200000;
    private static final int TE_UPDATING = 0x400000;
    private static final int TE_COMPUTE_PREFERRED_SIZE = 0x800000;
    private static final int TE_IGNORE_CURRENT_ELEMENT_VETO = 0x1000000;
    private static final int TE_UPDATE_FLAGS = 2361359;
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_HORIZONTALLY = 1;
    private static final int RESIZE_VERTICALLY = 2;
    private static final int activeBorderWidth = 2;
    private transient Rectangle m_bounds;
    transient int m_cellTypesVersion;
    private transient CellVectorFactory m_colFactory;
    private transient CellVectorFactory m_rowFactory;
    transient ColumnLabelInterface m_columnLabelModel;
    private transient Row m_columnLabelsRow;
    private transient Vector m_contentsChangedEventQueue;
    private transient TableElement m_currentElement;
    private transient Selection m_currentSelection;
    private transient Object m_currentSelectionInitialEnd;
    private transient FontStyle m_defaultFontStyle;
    private transient int m_flags;
    transient FormattedDataInterface m_formattedDataModel;
    private transient Rectangle m_gridBounds;
    private transient com.sas.visuals.Scrollbar m_hbar;
    private transient Alarm m_hbarAlarm;
    private transient HScrollListener m_hbarAlarmListener;
    private transient int m_hbarHeight;
    private transient Insets m_insets;
    private transient OrderedCollection m_invalidCells;
    private transient ItemListener m_itemListeners;
    transient StaticPropertyBagInterface m_modelDefaultCellStyle;
    transient StaticPropertyBagInterface m_modelDefaultLabelStyle;
    transient StaticPropertyBagInterface m_modelDefaultColumnStyle;
    transient StaticPropertyBagInterface m_modelDefaultRowStyle;
    transient boolean m_modelSupportsCellStyles;
    transient boolean m_modelSupportsColumnStyles;
    transient boolean m_modelSupportsColumnLabelStyles;
    transient boolean m_modelSupportsRowStyles;
    transient boolean m_modelSupportsRowLabelStyles;
    private transient OrderedCollection m_modifiedCells;
    private transient MouseEvent m_mousePressedEvent;
    private transient LabelCell m_originCell;
    private transient Graphics m_printGraphics;
    private transient PrintInfo m_printInfo;
    private transient boolean m_printTable;
    private transient Vector m_processEventThreads;
    private transient RubberBand m_resizer;
    transient RowLabelInterface m_rowLabelModel;
    private transient Column m_rowLabelsColumn;
    private transient boolean m_rowLabelsWritable;
    private transient boolean m_colLabelsWritable;
    private transient boolean m_cellsWritable;
    private transient SelectionListener m_selectionListener;
    private transient OrderedCollection m_selections;
    private transient Dimension m_size;
    private transient StaticDictionary m_staticCellTypeStyles;
    transient StaticColumnLabelInterface m_staticColumnLabelModel;
    transient StaticFormattedDataInterface m_staticFormattedDataModel;
    private transient StaticOrderedCollection m_staticInvalidCells;
    private transient StaticOrderedCollection m_staticModifiedCells;
    transient StaticRowLabelInterface m_staticRowLabelModel;
    transient StaticTableInterface m_staticTableModel;
    transient StaticTableStyleInterface m_staticTableStyleModel;
    transient StaticTableTypeInterface m_staticTableTypeModel;
    transient TableInterface m_tableModel;
    private transient boolean m_usingLabelInsets;
    public transient com.sas.visuals.Scrollbar m_vbar;
    private transient Alarm m_vbarAlarm;
    private transient VScrollListener m_vbarAlarmListener;
    private transient int m_vbarWidth;
    private transient PropertyVetoException m_pve;
    private boolean m_allowExtendedSelection;
    private boolean m_allowMultipleSelection;
    private boolean m_allowSelection;
    private Dictionary m_cellTypeStyles;
    private boolean m_cellTypeStylesSaved;
    private int m_columnLabelsOrientation;
    private boolean m_conformColumns;
    private int m_conformColumnsThreshold;
    private boolean m_conformRows;
    private int m_conformRowsThreshold;
    private CellStyle m_defaultCellStyle;
    private ColumnStyle m_defaultColumnStyle;
    private CellStyle m_defaultInvalidCellStyle;
    private CellStyle m_defaultLabelStyle;
    private ModelInterface m_defaultModel;
    private RowStyle m_defaultRowStyle;
    private Color m_gridColor;
    private int m_hbarVisibility;
    private boolean m_hidePopupMenu;
    private PopupMenu m_popupMenu;
    private int m_printOrder;
    private int m_rowLabelsOrientation;
    private boolean m_selectAllByOriginCell;
    private boolean m_selectColumnsByLabel;
    private boolean m_selectRowsByLabel;
    private int m_selectionElement;
    private boolean m_showActiveCellBorder;
    private boolean m_showClippedBottomRow;
    private boolean m_showClippedRightColumn;
    private boolean m_showColumnLabels;
    private boolean m_showCurrentElementCue;
    private boolean m_showGrid;
    private boolean m_showRowLabels;
    private int m_transactionElement;
    private int m_vbarVisibility;
    private static final CacheMonitor m_cacheMonitor = new CacheMonitor();

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static void setDefaultHeight(int newValue) {
        defaultHeight = newValue;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static void setDefaultWidth(int newValue) {
        defaultWidth = newValue;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        return TableViewDefaults.getTableViewExtendedBeanInfo();
    }

    public TableView() {
        this.initializeTransients();
        this.setIDEDnDDropTarget(false);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(60L);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.m_itemListeners = AWTEventMulticaster.add(this.m_itemListeners, listener);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.clone(1.0, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitModifiedCells() {
        if (this.m_modifiedCells == null) {
            return true;
        }
        OrderedCollection orderedCollection = this.m_modifiedCells;
        synchronized (orderedCollection) {
            int i;
            int count = this.m_modifiedCells.count();
            if (count == 0) {
                return true;
            }
            if (this.m_invalidCells != null) {
                this.m_invalidCells.removeAll();
            }
            boolean oldValue = false;
            try {
                oldValue = this.setFlag(256, false);
                for (i = 0; i < count; ++i) {
                    Cell cell = (Cell)this.m_modifiedCells.get(i);
                    try {
                        cell.writeObjectData();
                        continue;
                    }
                    catch (Exception ex) {
                        this.internalGetInvalidCells().add((Object)cell);
                        cell.repaint();
                        ErrorHandlerInterface errorHandler = this.getErrorHandler();
                        if (errorHandler == null) continue;
                        String msg = ex.getMessage();
                        if (msg == null) {
                            msg = ex.toString();
                        }
                        errorHandler.handleError((ComponentInterface)this, new Message(msg), COMMIT_CELL_ERROR);
                    }
                }
            }
            finally {
                this.setFlag(256, oldValue);
            }
            this.m_modifiedCells.removeAll();
            if (this.m_invalidCells != null) {
                int maxi = this.m_invalidCells.count();
                for (i = 0; i < maxi; ++i) {
                    this.m_modifiedCells.add(this.m_invalidCells.get(i));
                }
                return this.m_invalidCells.count() == 0;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension computePreferredSize() {
        int height;
        int width;
        int defaultWidth = TableView.getDefaultWidth();
        int defaultHeight = TableView.getDefaultHeight();
        try {
            Dimension size = this.getSize();
            if (size.width < defaultWidth || size.height < defaultHeight) {
                this.m_size = new Dimension(Math.max(size.width, defaultWidth), Math.max(size.height, defaultHeight));
                this.m_flags |= 0x800040;
            }
            this.updateView(null);
            int colCount = this.getColumnCount();
            width = colCount == 0 || colCount != this.m_hbar.getVisibleAmount() ? defaultWidth : this.m_bounds.width + this.m_insets.left + this.m_insets.right + this.m_vbarWidth;
            int rowCount = this.getRowCount();
            height = rowCount == 0 || rowCount != this.m_vbar.getVisibleAmount() ? defaultHeight : this.m_bounds.height + this.m_insets.top + this.m_insets.bottom + this.m_hbarHeight;
        }
        finally {
            if ((this.m_flags & 0x800000) != 0) {
                this.m_flags &= 0xFF7FFFFF;
                this.m_flags |= 0x40;
                this.updateView(null);
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public void disableFullPaint() {
        this.m_flags |= 0x10;
    }

    @Override
    public void enableFullPaint() {
        this.m_flags &= 0xFFFFFFEF;
        this.repaint();
    }

    public synchronized Cell findCell(Point point) {
        this.updateView(null);
        if (this.m_gridBounds.contains(point)) {
            return this.getCell(this.findRow(point.y), this.findColumn(point.x));
        }
        if (!this.m_bounds.contains(point)) {
            return null;
        }
        if (this.m_rowLabelsColumn != null && this.m_rowLabelsColumn.contains(point.x)) {
            if (this.m_columnLabelsRow != null && this.m_columnLabelsRow.contains(point.y)) {
                return this.getOriginCell();
            }
            return this.findRow(point.y).getLabel();
        }
        return this.findColumn(point.x).getLabel();
    }

    public synchronized Column findColumn(int x) {
        return (Column)this.findCellVector(x, this.m_colFactory.m_displayedCache);
    }

    public synchronized Row findRow(int y) {
        return (Row)this.findCellVector(y, this.m_rowFactory.m_displayedCache);
    }

    public Command[] getContextCommands(Object context, int x, int y) {
        return CommandManager.getEmptyCommandArray();
    }

    public void hold(CellVector cellVector) {
        if (cellVector.isHeld()) {
            return;
        }
        if (cellVector instanceof Column) {
            this.m_colFactory.hold(cellVector, true);
            this.m_flags |= 1;
            this.repaintColumns();
        } else {
            this.m_rowFactory.hold(cellVector, true);
            this.m_flags |= 4;
            this.repaintRows();
        }
    }

    public DataCell getCell(Row row, Column col) {
        return row.getCell(col.getIndex());
    }

    public Column getColumn(int index) {
        this.updateView(null);
        return (Column)this.m_colFactory.getCellVector(index);
    }

    public Row getRow(int index) {
        this.updateView(null);
        return (Row)this.m_rowFactory.getCellVector(index);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.m_defaultCellStyle.addPropertyBagChangedListener(this);
        this.m_defaultInvalidCellStyle.addPropertyBagChangedListener(this);
        this.m_defaultLabelStyle.addPropertyBagChangedListener(this);
        this.m_defaultRowStyle.addPropertyBagChangedListener(this);
        this.m_defaultColumnStyle.addPropertyBagChangedListener(this);
        if (this.m_cellTypeStyles != null) {
            Enumeration e = this.m_cellTypeStyles.getItems();
            while (e.hasMoreElements()) {
                CellStyle cs = (CellStyle)((Object)e.nextElement());
                cs.addPropertyBagChangedListener(this);
            }
        }
        if (this.getModelInterface() == null) {
            this.setModelInterface(this.getDefaultModel());
        }
    }

    public final boolean isDefaultModelAttached() {
        return this.getDefaultModel() == this.getModelInterface() && this.getDefaultModel() != null;
    }

    public boolean isFullPaintDisabled() {
        return (this.m_flags & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paint(Graphics g) {
        if (this.m_printGraphics != null && !this.m_printTable) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.isFullPaintDisabled()) {
                super.paint(g);
            } else {
                this.m_flags &= 0xFFFFFF7F;
                Rectangle bounds = this.getTableBounds(g);
                if ((this.m_flags & 0x80) != 0) {
                } else {
                    super.paint(g);
                    g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    Rectangle invalidBounds = g.getClipBounds();
                    if (invalidBounds.width != 0) {
                        if (invalidBounds.height == 0) {
                        } else {
                            this.paintTable(g, invalidBounds);
                        }
                    }
                }
            }
        }
        finally {
            this.setCursor(cursor);
        }
    }

    @Override
    public void print(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void print(Graphics g, int pageNumber, int pageWidth, int pageHeight) throws PrintException {
        if (!this.pageExists(pageNumber)) {
            throw new IndexOutOfBoundsException();
        }
        this.m_printInfo.print(g, pageNumber, pageWidth, pageHeight);
    }

    @Override
    public int nextPrintScrollDirection() {
        if (this.m_printInfo == null) {
            throw new IllegalStateException("printInitialize() not called.");
        }
        return this.m_printInfo.nextPrintScrollDirection();
    }

    @Override
    public int previousPrintScrollDirection() {
        if (this.m_printInfo == null) {
            throw new IllegalStateException("printInitialize() not called.");
        }
        return this.m_printInfo.previousPrintScrollDirection();
    }

    @Override
    public boolean isPrintScrollNeeded(int direction) {
        if (this.m_printInfo == null) {
            throw new IllegalStateException("printInitialize() not called.");
        }
        return this.m_printInfo.isPrintScrollNeeded(direction);
    }

    @Override
    public void printInitialize(Graphics g) throws PrintException {
        if (this.m_printInfo != null) {
            throw new IllegalStateException("printInitialize() already called.");
        }
        try {
            this.m_printInfo = new PrintInfo(this, g);
        }
        catch (CloneNotSupportedException cnse) {
            throw new PrintException(cnse);
        }
    }

    @Override
    public void printFinalize() {
        if (this.m_printInfo != null) {
            this.m_printInfo.dispose();
            this.m_printInfo = null;
        }
    }

    @Override
    public boolean pageExists(int pageNumber) {
        if (this.m_printInfo == null) {
            throw new IllegalStateException("printInitialize() not called.");
        }
        return this.m_printInfo.pageExists(pageNumber);
    }

    @Override
    public Rectangle getPageBounds(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
        if (!this.pageExists(pageNumber)) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_printInfo.getPageBounds(g, pageNumber, pageWidth, pageHeight);
    }

    @Override
    public Panel getPrintOptionsPanel() {
        PrintOptionsPanel panel = new PrintOptionsPanel(this);
        ((PanelVisualComponent)panel).initialize();
        return panel;
    }

    public int getPrintOrder() {
        return this.m_printOrder;
    }

    public void setPrintOrder(int newValue) {
        if (newValue != 0 && newValue != 1) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getPrintOrder();
        this.m_printOrder = newValue;
        newValue = this.getPrintOrder();
        if (oldValue != newValue && this.anyPropertyChangeListeners()) {
            this.firePropertyChange("printOrder", new Integer(oldValue), new Integer(newValue));
        }
    }

    public final void refresh() {
        this.refresh(this.getModelInterface());
    }

    @Override
    public synchronized void refresh(ModelInterface model) {
        super.refresh(model);
        this.m_contentsChangedEventQueue.removeAllElements();
        this.contentsChanged(new ContentsChangedEvent((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModifiedCells() {
        if (this.m_modifiedCells == null) {
            return;
        }
        OrderedCollection orderedCollection = this.m_modifiedCells;
        synchronized (orderedCollection) {
            while (this.m_modifiedCells.count() > 0) {
                ((Cell)this.m_modifiedCells.get(0)).refresh(1);
            }
        }
    }

    public void release(CellVector cellVector) {
        if (!cellVector.isHeld()) {
            return;
        }
        if (cellVector instanceof Column) {
            this.m_colFactory.hold(cellVector, false);
            this.m_flags |= 1;
            this.repaintColumns();
        } else {
            this.m_rowFactory.hold(cellVector, false);
            this.m_flags |= 4;
            this.repaintRows();
        }
    }

    public void releaseAllColumns() {
        if (this.m_colFactory.releaseAll()) {
            this.m_flags |= 1;
            this.repaintColumns();
        }
    }

    public void releaseAllRows() {
        if (this.m_rowFactory.releaseAll()) {
            this.m_flags |= 4;
            this.repaintRows();
        }
    }

    public void remeasureAllColumns(boolean preserveResizes) {
        if (!(this.m_rowLabelsColumn == null || preserveResizes && this.m_rowLabelsColumn.isResized())) {
            this.m_rowLabelsColumn.remeasure();
        }
        this.m_colFactory.remeasureAll(preserveResizes);
        this.m_flags |= 3;
        this.repaint();
    }

    public void remeasureAllRows(boolean preserveResizes) {
        if (!(this.m_columnLabelsRow == null || preserveResizes && this.m_columnLabelsRow.isResized())) {
            this.m_columnLabelsRow.remeasure();
        }
        this.m_rowFactory.remeasureAll(preserveResizes);
        this.m_flags |= 0xC;
        this.repaint();
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.m_itemListeners = AWTEventMulticaster.remove(this.m_itemListeners, listener);
    }

    @Override
    public void repaint() {
        if ((this.m_flags & 0x100000) != 0) {
            return;
        }
        this.m_flags |= 0x200080;
        super.repaint();
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        Graphics g;
        if ((this.m_flags & 0x100000) != 0) {
            return;
        }
        if ((this.m_flags & 0x100) != 0 && this.isScrollingSmooth() && (g = this.getGraphics()) != null) {
            this.paint(g, x, y, width, height);
        } else {
            super.repaint(x, y, width, height);
        }
    }

    public void repaintColumns() {
        if ((this.m_flags & 0x100000) != 0) {
            return;
        }
        Rectangle bounds = this.getPaintableBounds();
        this.repaint(this.m_gridBounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void repaintRows() {
        if ((this.m_flags & 0x100000) != 0) {
            return;
        }
        Rectangle bounds = this.getPaintableBounds();
        this.repaint(bounds.x, this.m_gridBounds.y, bounds.width, bounds.height);
    }

    @Override
    public void scrollHorizontally(int numUnits, int unit) {
        this.updateView(null);
        this.m_colFactory.scroll(numUnits, unit);
    }

    @Override
    public void scrollVertically(int numUnits, int unit) {
        this.updateView(null);
        this.m_rowFactory.scroll(numUnits, unit);
    }

    public void scrollToCell(Cell cell, boolean makeFirst) {
        if (cell.isLabel()) {
            LabelCell label = (LabelCell)cell;
            if (label.isRowLabel()) {
                this.scrollToRow((Row)label.getChild(), makeFirst);
            } else if (label.isColumnLabel()) {
                this.scrollToColumn((Column)label.getChild(), makeFirst);
            }
        } else {
            DataCell dataCell = (DataCell)cell;
            this.scrollToRow(dataCell.getRow(), makeFirst);
            this.scrollToColumn(dataCell.getColumn(), makeFirst);
        }
    }

    public void scrollToColumn(Column col, boolean makeFirst) {
        this.updateView(null);
        this.m_colFactory.scrollTo(col, makeFirst);
    }

    public void scrollToRow(Row row, boolean makeFirst) {
        this.updateView(null);
        this.m_rowFactory.scrollTo(row, makeFirst);
    }

    public void select(DataCell start, DataCell end, boolean extend) {
        this.select(new CellSelection(start, end), extend);
    }

    public void select(Column start, Column end, boolean extend) {
        this.select(new ColumnSelection(start, end), extend);
    }

    public void select(Selection range, boolean extend) {
        if (!extend) {
            this.unselect();
        }
        this.internalGetSelections().add((Object)range);
        range.repaint();
        this.fireSelectionsChanged(range, null);
    }

    public void select(Row start, Row end, boolean extend) {
        this.select(new RowSelection(start, end), extend);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resized;
        Rectangle bounds = this.getBounds();
        boolean moved = bounds.x != x || bounds.y != y;
        boolean bl = resized = bounds.width != width || bounds.height != height;
        if (resized) {
            this.m_flags |= 0x40;
        }
        if (moved || resized) {
            super.setBounds(x, y, width, height);
        }
    }

    public void unselect() {
        if (this.m_selections == null || this.m_selections.count() == 0) {
            return;
        }
        Object[] selections = this.m_selections.toArray();
        this.m_selections.removeAll();
        this.setCurrentSelection(null);
        if ((this.m_flags & 0x100000) == 0) {
            for (int i = 0; i < selections.length; ++i) {
                ((Selection)selections[i]).repaint();
            }
        }
        this.fireSelectionsChanged(null, selections);
    }

    public boolean isActiveCellHighlighted() {
        return this.m_showActiveCellBorder;
    }

    public void setActiveCellHighlighted(boolean newValue) {
        boolean oldValue = this.isActiveCellHighlighted();
        this.m_showActiveCellBorder = newValue;
        newValue = this.isActiveCellHighlighted();
        if (oldValue != newValue) {
            Cell cell = this.getCurrentCell();
            if (cell != null && cell.isActivated()) {
                this.repaintActiveCell(cell);
            }
            this.firePropertyChange("activeCellHighlighted", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public StaticDictionaryInterface getCellTypeStyles() {
        if ((this.m_flags & 0x80000) != 0) {
            this.m_flags &= 0xFFF7FFFF;
            this.refreshCellTypeStyles();
        }
        if (this.m_staticCellTypeStyles == null) {
            this.m_staticCellTypeStyles = new StaticDictionary((StaticDictionaryInterface)this.m_cellTypeStyles);
        }
        return this.m_staticCellTypeStyles;
    }

    boolean isCellTypeStylesSaved() {
        return this.m_cellTypeStylesSaved;
    }

    void setCellTypeStylesSaved(boolean newValue) {
        boolean oldValue = this.isCellTypeStylesSaved();
        this.m_cellTypeStylesSaved = newValue;
        newValue = this.isCellTypeStylesSaved();
        if (oldValue != newValue) {
            this.firePropertyChange("cellTypeStylesSaved", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public Rectangle getColumnLabelBounds() {
        Rectangle bounds = this.getTableBounds();
        bounds.x = this.m_gridBounds.x;
        bounds.width = this.m_gridBounds.width;
        bounds.height = this.m_gridBounds.y - bounds.y;
        return bounds;
    }

    public boolean isColumnLabelsVisible() {
        return this.m_showColumnLabels;
    }

    public void setColumnLabelsVisible(boolean newValue) {
        boolean oldValue = this.isColumnLabelsVisible();
        this.m_showColumnLabels = newValue;
        newValue = this.isColumnLabelsVisible();
        if (oldValue != newValue) {
            this.m_flags |= 8;
            this.remeasureAllColumns(true);
            this.firePropertyChange("columnLabelsVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isColumnsConformed() {
        return this.m_conformColumns;
    }

    public void setColumnsConformed(boolean newValue) {
        boolean oldValue = this.isColumnsConformed();
        this.m_conformColumns = newValue;
        newValue = this.isColumnsConformed();
        if (oldValue != newValue) {
            this.remeasureAllColumns(true);
            this.firePropertyChange("columnsConformed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getColumnsConformedThreshold() {
        return this.m_conformColumnsThreshold;
    }

    public void setColumnsConformedThreshold(int newValue) {
        if (newValue < 0 || newValue > 99) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getColumnsConformedThreshold();
        this.m_conformColumnsThreshold = newValue;
        newValue = this.getColumnsConformedThreshold();
        if (oldValue != newValue) {
            if (this.isColumnsConformed()) {
                this.remeasureAllColumns(true);
            }
            if (this.anyPropertyChangeListeners()) {
                this.firePropertyChange("columnsConformedThreshold", new Integer(oldValue), new Integer(newValue));
            }
        }
    }

    public boolean isColumnsSelectedByLabel() {
        return this.m_selectColumnsByLabel;
    }

    public void setColumnsSelectedByLabel(boolean newValue) {
        boolean oldValue = this.isColumnsSelectedByLabel();
        this.m_selectColumnsByLabel = newValue;
        newValue = this.isColumnsSelectedByLabel();
        if (oldValue != newValue) {
            this.firePropertyChange("columnsSelectedByLabel", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public TableElement getCurrentElement() {
        return this.m_currentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentElement(TableElement newValue) throws PropertyVetoException {
        TableElement oldValue = this.getCurrentElement();
        if (!Util.equal((Object)oldValue, (Object)newValue)) {
            boolean commit = true;
            switch (this.getTransactionElement()) {
                case 3: {
                    commit = false;
                    break;
                }
                case 2: {
                    if (!(oldValue instanceof DataCell) || !(newValue instanceof DataCell)) break;
                    DataCell oldDC = (DataCell)oldValue;
                    DataCell newDC = (DataCell)newValue;
                    if (!oldDC.getRow().equals(newDC.getRow())) break;
                    commit = false;
                    break;
                }
                case 1: {
                    if (!(oldValue instanceof DataCell) || !(newValue instanceof DataCell)) break;
                    DataCell oldDC = (DataCell)oldValue;
                    DataCell newDC = (DataCell)newValue;
                    if (!oldDC.getColumn().equals(newDC.getColumn())) break;
                    commit = false;
                }
            }
            if (commit) {
                this.commitModifiedCells();
            }
            TableView tableView = this;
            synchronized (tableView) {
                oldValue = this.getCurrentElement();
                Cell oldCurCell = this.getCurrentCell(oldValue);
                if ((this.m_flags & 0x1000000) == 0) {
                    this.fireVetoableChange("currentElement", oldValue, newValue);
                } else {
                    try {
                        this.fireVetoableChange("currentElement", oldValue, newValue);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (oldCurCell != null) {
                    this.deactivateCell(oldCurCell);
                    oldCurCell.setActiveState(0);
                }
                this.m_currentElement = newValue;
                this.setCurrentSelection(null);
                Cell curCell = this.getCurrentCell(newValue);
                if (curCell != null) {
                    Boolean activateCellOnCurrent = (Boolean)curCell.getEffectiveStylePropertyValue("activatedOnCurrent", Boolean.FALSE);
                    if (activateCellOnCurrent.booleanValue()) {
                        this.activateCell(curCell, false, null);
                        if (this.m_mousePressedEvent != null && curCell.isActivated()) {
                            curCell.processMouseEvent(this.m_mousePressedEvent);
                        }
                    } else {
                        curCell.setActiveState(1);
                    }
                }
                if (oldValue != null) {
                    oldValue.repaint();
                }
                if (newValue != null) {
                    newValue.repaint();
                }
                this.firePropertyChange("currentElement", oldValue, newValue);
            }
        }
    }

    public boolean isCurrentElementHighlighted() {
        return this.m_showCurrentElementCue;
    }

    public void setCurrentElementHighlighted(boolean newValue) {
        boolean oldValue = this.isCurrentElementHighlighted();
        this.m_showCurrentElementCue = newValue;
        newValue = this.isCurrentElementHighlighted();
        if (oldValue != newValue) {
            TableElement ce = this.getCurrentElement();
            if (ce != null) {
                ce.repaint();
            }
            this.firePropertyChange("currentElementHighlighted", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public Rectangle getDataCellBounds() {
        return new Rectangle(this.m_gridBounds);
    }

    public CellStyle getDefaultCellStyle() {
        return this.m_defaultCellStyle;
    }

    public void setDefaultCellStyle(CellStyle newValue) {
        if (newValue == this.m_defaultCellStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        CellStyle oldValue = this.m_defaultCellStyle;
        this.m_defaultCellStyle = newValue;
        oldValue.removePropertyBagChangedListener(this);
        newValue.addPropertyBagChangedListener(this);
        this.repaint();
        this.firePropertyChange("defaultCellStyle", (Object)oldValue, (Object)newValue);
    }

    public ColumnStyle getDefaultColumnStyle() {
        return this.m_defaultColumnStyle;
    }

    public void setDefaultColumnStyle(ColumnStyle newValue) {
        if (newValue == this.m_defaultColumnStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        ColumnStyle oldValue = this.m_defaultColumnStyle;
        this.m_defaultColumnStyle = newValue;
        oldValue.removePropertyBagChangedListener(this);
        newValue.addPropertyBagChangedListener(this);
        this.repaint();
        this.firePropertyChange("defaultColumnStyle", (Object)oldValue, (Object)newValue);
    }

    public CellStyle getDefaultInvalidCellStyle() {
        return this.m_defaultInvalidCellStyle;
    }

    public void setDefaultInvalidCellStyle(CellStyle newValue) {
        if (newValue == this.m_defaultInvalidCellStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        CellStyle oldValue = this.m_defaultInvalidCellStyle;
        this.m_defaultInvalidCellStyle = newValue;
        oldValue.removePropertyBagChangedListener(this);
        newValue.addPropertyBagChangedListener(this);
        this.repaint();
        this.firePropertyChange("defaultInvalidCellStyle", (Object)oldValue, (Object)newValue);
    }

    public CellStyle getDefaultLabelStyle() {
        return this.m_defaultLabelStyle;
    }

    public void setDefaultLabelStyle(CellStyle newValue) {
        if (newValue == this.m_defaultLabelStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        CellStyle oldValue = this.m_defaultLabelStyle;
        this.m_defaultLabelStyle = newValue;
        oldValue.removePropertyBagChangedListener(this);
        newValue.addPropertyBagChangedListener(this);
        this.repaint();
        this.firePropertyChange("defaultLabelStyle", (Object)oldValue, (Object)newValue);
    }

    public ModelInterface getDefaultModel() {
        return this.m_defaultModel;
    }

    public void setDefaultModel(ModelInterface newValue) {
        if (newValue == this.m_defaultModel) {
            return;
        }
        if (newValue != null && !this.supportsRequiredInterfaces(newValue)) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"VisualInterfaceSupport.unsupportedInterface.ex.txt"), (Object)this.getClass().getName()));
        }
        ModelInterface oldValue = this.m_defaultModel;
        this.m_defaultModel = newValue;
        this.firePropertyChange("defaultModel", oldValue, newValue);
        ModelInterface model = this.getModelInterface();
        if (model == oldValue || model == null) {
            this.setModelInterface(this.m_defaultModel);
        }
    }

    public RowStyle getDefaultRowStyle() {
        return this.m_defaultRowStyle;
    }

    public void setDefaultRowStyle(RowStyle newValue) {
        if (newValue == this.m_defaultRowStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        RowStyle oldValue = this.m_defaultRowStyle;
        this.m_defaultRowStyle = newValue;
        oldValue.removePropertyBagChangedListener(this);
        newValue.addPropertyBagChangedListener(this);
        this.repaint();
        this.firePropertyChange("defaultRowStyle", (Object)oldValue, (Object)newValue);
    }

    public StaticOrderedCollectionInterface getDisplayedColumns() {
        this.updateView(null);
        return this.m_colFactory.getDisplayedCache();
    }

    public StaticOrderedCollectionInterface getDisplayedRows() {
        this.updateView(null);
        return this.m_rowFactory.getDisplayedCache();
    }

    public boolean isExtendedSelectionAllowed() {
        return this.m_allowExtendedSelection;
    }

    public void setExtendedSelectionAllowed(boolean newValue) {
        boolean oldValue = this.isExtendedSelectionAllowed();
        this.m_allowExtendedSelection = newValue;
        newValue = this.isExtendedSelectionAllowed();
        if (oldValue != newValue) {
            this.firePropertyChange("extendedSelectionAllowed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void setFont(Font newValue) {
        super.setFont(newValue);
        this.m_flags |= 0x20;
        this.remeasureAllColumns(true);
        this.remeasureAllRows(true);
    }

    @Override
    public Graphics getGraphics() {
        if (this.m_printGraphics != null) {
            return this.m_printGraphics;
        }
        return super.getGraphics();
    }

    public Color getGridColor() {
        return this.m_gridColor;
    }

    public void setGridColor(Color newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        Color oldValue = this.getGridColor();
        this.m_gridColor = newValue;
        newValue = this.getGridColor();
        if (!oldValue.equals(newValue)) {
            this.repaint();
            this.firePropertyChange("gridColor", oldValue, newValue);
        }
    }

    public boolean isGridVisible() {
        return this.m_showGrid;
    }

    public void setGridVisible(boolean newValue) {
        boolean oldValue = this.isGridVisible();
        this.m_showGrid = newValue;
        newValue = this.isGridVisible();
        if (oldValue != newValue) {
            this.repaint();
            this.firePropertyChange("gridVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public StaticOrderedCollectionInterface getHeldColumns() {
        return this.m_colFactory.getHeldCache();
    }

    public StaticOrderedCollectionInterface getHeldRows() {
        return this.m_rowFactory.getHeldCache();
    }

    @Override
    public int getHorizontalScrollbarVisibility() {
        return this.m_hbarVisibility;
    }

    @Override
    public void setHorizontalScrollbarVisibility(int newValue) {
        if (newValue != 0 && newValue != 1 && newValue != 2) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getHorizontalScrollbarVisibility();
        this.m_hbarVisibility = newValue;
        newValue = this.getHorizontalScrollbarVisibility();
        if (newValue == oldValue) {
            return;
        }
        this.updateScrollbar(this.m_hbar, newValue, this.m_hbar.getVisibleAmount());
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("horizontalScrollbarVisibility", new Integer(oldValue), new Integer(newValue));
        }
    }

    public StaticOrderedCollectionInterface getInvalidCells() {
        if (this.m_staticInvalidCells == null) {
            this.m_staticInvalidCells = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.internalGetInvalidCells());
        }
        return this.m_staticInvalidCells;
    }

    @Override
    public synchronized void setModelInterface(ModelInterface newValue) {
        super.setModelInterface(newValue);
        if (newValue == null) {
            super.setModelInterface(this.getDefaultModel());
        }
    }

    public StaticOrderedCollectionInterface getModifiedCells() {
        if (this.m_staticModifiedCells == null) {
            this.m_staticModifiedCells = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.internalGetModifiedCells());
        }
        return this.m_staticModifiedCells;
    }

    public boolean isMultipleSelectionAllowed() {
        return this.m_allowMultipleSelection;
    }

    public void setMultipleSelectionAllowed(boolean newValue) {
        boolean oldValue = this.isMultipleSelectionAllowed();
        this.m_allowMultipleSelection = newValue;
        newValue = this.isMultipleSelectionAllowed();
        if (oldValue != newValue) {
            this.firePropertyChange("multipleSelectionAllowed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public LabelCell getOriginCell() {
        if (this.m_originCell == null) {
            this.m_originCell = this.createOriginCell();
        }
        return this.m_originCell;
    }

    public Rectangle getOriginCellBounds() {
        Rectangle bounds = this.getTableBounds();
        bounds.width = this.m_gridBounds.x - bounds.x;
        bounds.height = this.m_gridBounds.y - bounds.y;
        return bounds;
    }

    public Rectangle getPaintableBounds() {
        if ((this.m_flags & 0x40) != 0) {
            this.updateView(null);
        }
        return new Rectangle(this.getDrawableLeftEdge(), this.getDrawableTopEdge(), this.getDrawableWidth(), this.getDrawableHeight());
    }

    public boolean isPartialColumnVisible() {
        return this.m_showClippedRightColumn;
    }

    public void setPartialColumnVisible(boolean newValue) {
        boolean oldValue = this.isPartialColumnVisible();
        this.m_showClippedRightColumn = newValue;
        newValue = this.isPartialColumnVisible();
        if (oldValue != newValue) {
            this.m_flags |= 1;
            this.repaint();
            this.firePropertyChange("partialColumnVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isPartialRowVisible() {
        return this.m_showClippedBottomRow;
    }

    public void setPartialRowVisible(boolean newValue) {
        boolean oldValue = this.isPartialRowVisible();
        this.m_showClippedBottomRow = newValue;
        newValue = this.isPartialRowVisible();
        if (oldValue != newValue) {
            this.m_flags |= 4;
            this.repaint();
            this.firePropertyChange("partialRowVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isPopupMenuVisible() {
        return !this.m_hidePopupMenu;
    }

    public void setPopupMenuVisible(boolean newValue) {
        boolean bl = newValue = !newValue;
        if (newValue != this.m_hidePopupMenu) {
            this.m_hidePopupMenu = newValue;
            this.firePropertyChange("popupMenuVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public Rectangle getRowLabelBounds() {
        Rectangle bounds = this.getTableBounds();
        bounds.y = this.m_gridBounds.y;
        bounds.width = this.m_gridBounds.x - bounds.x;
        bounds.height = this.m_gridBounds.height;
        return bounds;
    }

    public boolean isRowLabelsVisible() {
        return this.m_showRowLabels;
    }

    public void setRowLabelsVisible(boolean newValue) {
        boolean oldValue = this.isRowLabelsVisible();
        this.m_showRowLabels = newValue;
        newValue = this.isRowLabelsVisible();
        if (oldValue != newValue) {
            this.m_flags |= 2;
            this.remeasureAllRows(true);
            this.firePropertyChange("rowLabelsVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isRowsConformed() {
        return this.m_conformRows;
    }

    public void setRowsConformed(boolean newValue) {
        boolean oldValue = this.isRowsConformed();
        this.m_conformRows = newValue;
        newValue = this.isRowsConformed();
        if (oldValue != newValue) {
            this.remeasureAllRows(true);
            this.firePropertyChange("rowsConformed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getRowsConformedThreshold() {
        return this.m_conformRowsThreshold;
    }

    public void setRowsConformedThreshold(int newValue) {
        if (newValue < 0 || newValue > 99) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getRowsConformedThreshold();
        this.m_conformRowsThreshold = newValue;
        newValue = this.getRowsConformedThreshold();
        if (oldValue != newValue) {
            if (this.isRowsConformed()) {
                this.remeasureAllRows(true);
            }
            if (this.anyPropertyChangeListeners()) {
                this.firePropertyChange("rowsConformedThreshold", new Integer(oldValue), new Integer(newValue));
            }
        }
    }

    public boolean isRowsSelectedByLabel() {
        return this.m_selectRowsByLabel;
    }

    public void setRowsSelectedByLabel(boolean newValue) {
        boolean oldValue = this.isRowsSelectedByLabel();
        this.m_selectRowsByLabel = newValue;
        newValue = this.isRowsSelectedByLabel();
        if (oldValue != newValue) {
            this.firePropertyChange("rowsSelectedByLabel", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSelectedCells() {
        OrderedCollection selectedCells = new OrderedCollection();
        if (this.m_selections != null) {
            OrderedCollection orderedCollection = this.m_selections;
            synchronized (orderedCollection) {
                int maxi = this.m_selections.count();
                for (int i = 0; i < maxi; ++i) {
                    CellSelection cellSelection;
                    Selection selection = (Selection)this.m_selections.get(i);
                    if (selection instanceof CellVectorSelection) {
                        cellSelection = ((CellVectorSelection)selection).getCells();
                        if (cellSelection == null) {
                            continue;
                        }
                    } else {
                        cellSelection = (CellSelection)selection;
                    }
                    Enumeration cells = cellSelection.getItems();
                    while (cells.hasMoreElements()) {
                        Object cell = cells.nextElement();
                        if (selectedCells.contains(cell)) continue;
                        selectedCells.add(cell);
                    }
                }
            }
        }
        return selectedCells.getItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSelectedColumns() {
        OrderedCollection selectedColumns = new OrderedCollection();
        if (this.m_selections != null) {
            OrderedCollection orderedCollection = this.m_selections;
            synchronized (orderedCollection) {
                int maxi = this.m_selections.count();
                for (int i = 0; i < maxi; ++i) {
                    Selection selection = (Selection)this.m_selections.get(i);
                    if (!(selection instanceof ColumnSelection)) continue;
                    Enumeration cols = selection.getItems();
                    while (cols.hasMoreElements()) {
                        Object col = cols.nextElement();
                        if (selectedColumns.contains(col)) continue;
                        selectedColumns.add(col);
                    }
                }
            }
        }
        return selectedColumns.getItems();
    }

    @Override
    public Object[] getSelectedObjects() {
        OrderedCollection selections = this.internalGetSelections();
        if (selections.count() == 0) {
            return null;
        }
        return selections.toArray();
    }

    public Enumeration getSelectedRanges() {
        return this.internalGetSelections().getItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSelectedRows() {
        OrderedCollection selectedRows = new OrderedCollection();
        if (this.m_selections != null) {
            OrderedCollection orderedCollection = this.m_selections;
            synchronized (orderedCollection) {
                int maxi = this.m_selections.count();
                for (int i = 0; i < maxi; ++i) {
                    Selection selection = (Selection)this.m_selections.get(i);
                    if (!(selection instanceof RowSelection)) continue;
                    Enumeration rows = selection.getItems();
                    while (rows.hasMoreElements()) {
                        Object row = rows.nextElement();
                        if (selectedRows.contains(row)) continue;
                        selectedRows.add(row);
                    }
                }
            }
        }
        return selectedRows.getItems();
    }

    public boolean isSelectionAllowed() {
        return this.m_allowSelection;
    }

    public void setSelectionAllowed(boolean newValue) {
        boolean oldValue = this.isSelectionAllowed();
        this.m_allowSelection = newValue;
        newValue = this.isSelectionAllowed();
        if (oldValue != newValue) {
            this.firePropertyChange("selectionAllowed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getSelectionElement() {
        return this.m_selectionElement;
    }

    public void setSelectionElement(int newValue) {
        if (newValue == this.m_selectionElement) {
            return;
        }
        if (newValue != 0 && newValue != 1 && newValue != 2) {
            throw new IllegalArgumentException();
        }
        this.unselect();
        this.setCurrentElement();
        int oldValue = this.m_selectionElement;
        this.m_selectionElement = newValue;
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("selectionElement", new Integer(oldValue), new Integer(newValue));
        }
    }

    public final Rectangle getTableBounds() {
        return this.getTableBounds(null);
    }

    public boolean isTableSelectedByOriginCell() {
        return this.m_selectAllByOriginCell;
    }

    public void setTableSelectedByOriginCell(boolean newValue) {
        boolean oldValue = this.isTableSelectedByOriginCell();
        this.m_selectAllByOriginCell = newValue;
        newValue = this.isTableSelectedByOriginCell();
        if (oldValue != newValue) {
            this.firePropertyChange("tableSelectedByOriginCell", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getTransactionElement() {
        return this.m_transactionElement;
    }

    public void setTransactionElement(int newValue) {
        if (newValue != 0 && newValue != 1 && newValue != 2 && newValue != 3) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getTransactionElement();
        this.m_transactionElement = newValue;
        newValue = this.getTransactionElement();
        if (oldValue != newValue && this.anyPropertyChangeListeners()) {
            this.firePropertyChange("transactionElement", new Integer(oldValue), new Integer(newValue));
        }
    }

    @Override
    public int getVerticalScrollbarVisibility() {
        return this.m_vbarVisibility;
    }

    @Override
    public void setVerticalScrollbarVisibility(int newValue) {
        if (newValue != 0 && newValue != 1 && newValue != 2) {
            throw new IllegalArgumentException();
        }
        int oldValue = this.getVerticalScrollbarVisibility();
        this.m_vbarVisibility = newValue;
        newValue = this.getVerticalScrollbarVisibility();
        if (newValue == oldValue) {
            return;
        }
        this.updateScrollbar(this.m_vbar, newValue, this.m_vbar.getVisibleAmount());
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("verticalScrollbarVisibility", new Integer(oldValue), new Integer(newValue));
        }
    }

    @Override
    public synchronized void attachModel(ModelInterface model) {
        if (this.isDefaultModelAttached()) {
            this.detachModel(this.getDefaultModel());
        }
        if (this.getModelInterface() != null) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"ViewInterfaceSupport.attachMax.ex.txt"), (Object)this.getClass().getName(), (Object)new Integer(1)));
        }
        super.attachModel(model);
        this.m_staticTableModel = (StaticTableInterface)model;
        if (model instanceof TableInterface) {
            this.m_tableModel = (TableInterface)model;
        }
        if (model instanceof StaticColumnLabelInterface) {
            this.m_staticColumnLabelModel = (StaticColumnLabelInterface)model;
            try {
                if (!this.m_staticColumnLabelModel.isColumnLabelsSupported()) {
                    this.m_staticColumnLabelModel = null;
                } else if (model instanceof ColumnLabelInterface) {
                    this.m_columnLabelModel = (ColumnLabelInterface)model;
                }
            }
            catch (TableException ex) {
                ex.printStackTrace();
                this.m_staticColumnLabelModel = null;
            }
        }
        if (this.m_staticColumnLabelModel == null) {
            this.m_staticColumnLabelModel = new CharacterColumnLabels();
        }
        if (model instanceof StaticRowLabelInterface) {
            this.m_staticRowLabelModel = (StaticRowLabelInterface)model;
            try {
                if (!this.m_staticRowLabelModel.isRowLabelsSupported()) {
                    this.m_staticRowLabelModel = null;
                } else if (model instanceof RowLabelInterface) {
                    this.m_rowLabelModel = (RowLabelInterface)model;
                }
            }
            catch (TableException ex) {
                ex.printStackTrace();
                this.m_staticRowLabelModel = null;
            }
        }
        if (this.m_staticRowLabelModel == null) {
            this.m_staticRowLabelModel = new NumericRowLabels();
        }
        if (model instanceof StaticFormattedDataInterface) {
            this.m_staticFormattedDataModel = (StaticFormattedDataInterface)model;
            if (model instanceof FormattedDataInterface) {
                this.m_formattedDataModel = (FormattedDataInterface)model;
            }
        }
        if (model instanceof StaticTableTypeInterface) {
            this.m_staticTableTypeModel = (StaticTableTypeInterface)model;
        }
        if (model instanceof StaticTableStyleInterface) {
            this.m_staticTableStyleModel = (StaticTableStyleInterface)model;
        }
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        com.sas.beans.Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    @Override
    public synchronized void detachModel(ModelInterface model) {
        if (model != this.m_staticTableModel || model == null) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"ViewInterfaceSupport.noAttach.ex.txt"), (Object)this.getClass().getName()));
        }
        super.detachModel(model);
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        com.sas.beans.Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        boolean oldValue = false;
        try {
            oldValue = this.setFlag(0x100000, true);
            this.setCurrentElement();
            this.unselect();
        }
        finally {
            this.setFlag(0x100000, oldValue);
        }
        this.m_staticTableModel = null;
        this.m_tableModel = null;
        this.m_staticColumnLabelModel = null;
        this.m_columnLabelModel = null;
        this.m_staticRowLabelModel = null;
        this.m_rowLabelModel = null;
        this.m_staticFormattedDataModel = null;
        this.m_formattedDataModel = null;
        this.m_staticTableStyleModel = null;
        this.m_staticTableTypeModel = null;
    }

    private boolean isInSwingContainer(Component parent) {
        return parent instanceof JFrame || parent instanceof JDialog || parent instanceof JPanel || parent instanceof JWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object synchObj = new Integer(0);
        if (this.isInSwingContainer(this.getParent())) {
            synchObj = this.getTreeLock();
        }
        Integer n = synchObj;
        synchronized (n) {
            TableView tableView = this;
            synchronized (tableView) {
                Object source = event.getSource();
                Cursor cursor = this.getCursor();
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (event.getAdjustmentType() == 5) {
                        this.m_flags |= 0x20000;
                    }
                    if (source.equals(this.m_vbar)) {
                        this.onVScroll(event);
                    } else if (source.equals(this.m_hbar)) {
                        this.onHScroll(event);
                    }
                }
                finally {
                    this.m_flags &= 0xFFFDFFFF;
                    this.setCursor(cursor);
                }
            }
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        this.m_contentsChangedEventQueue.addElement(event);
        this.repaint(0, 0, 1, 1);
    }

    public void propertyBagChanged(PropertyBagChangedEvent e) {
        String propName = e.getPropertyName();
        if (propName == null || e.getSource() instanceof CellVectorStyle || Util.equal((Object)propName, (Object)"fontStyle") || Util.equal((Object)propName, (Object)"bottomMargin") || Util.equal((Object)propName, (Object)"leftMargin") || Util.equal((Object)propName, (Object)"rightMargin") || Util.equal((Object)propName, (Object)"topMargin") || Util.equal((Object)propName, (Object)"splitCharacter") || Util.equal((Object)propName, (Object)"viewClass")) {
            this.remeasureAllColumns(true);
            this.remeasureAllRows(true);
        } else {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name != null) {
            if (name.equals("cellsModifiable") || name.equals("columnLabelsModifiable") || name.equals("rowLabelsModifiable")) {
                this.m_flags |= 0x800;
                this.repaint(0, 0, 1, 1);
            } else if (name.equals("cellTypes")) {
                this.m_flags |= 0x80000;
                ++this.m_cellTypesVersion;
                this.repaint();
            } else if (name.equals("defaultCellStyle") || name.equals("defaultLabelStyle") || name.equals("defaultColumnStyle") || name.equals("defaultRowStyle")) {
                this.m_flags |= 0x40000;
                this.repaint();
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void setDefaultValues() {
        if (this.m_hbar != null) {
            throw new IllegalStateException();
        }
        super.setDefaultValues();
        this.m_allowExtendedSelection = true;
        this.m_allowMultipleSelection = true;
        this.m_allowSelection = true;
        this.m_columnLabelsOrientation = 4;
        this.m_defaultCellStyle = TableViewDefaults.getCellStyle();
        this.m_defaultColumnStyle = TableViewDefaults.getColumnStyle();
        this.m_defaultInvalidCellStyle = TableViewDefaults.getInvalidCellStyle();
        this.m_defaultLabelStyle = TableViewDefaults.getLabelStyle();
        this.m_defaultRowStyle = TableViewDefaults.getRowStyle();
        this.m_gridColor = Color.lightGray;
        this.m_hbarVisibility = 0;
        this.m_rowLabelsOrientation = 1;
        this.m_selectColumnsByLabel = true;
        this.m_selectRowsByLabel = true;
        this.m_showActiveCellBorder = true;
        this.m_showClippedBottomRow = true;
        this.m_showClippedRightColumn = true;
        this.m_showColumnLabels = true;
        this.m_showCurrentElementCue = true;
        this.m_showGrid = true;
        this.m_showRowLabels = true;
        this.m_vbarVisibility = 0;
        BaseBorder border = new BaseBorder(2);
        border.setBorderWidth(1);
        this.setBorder(border);
        this.setLayout(new ScrollbarLayout());
        this.createScrollbars();
        this.createPopupMenu();
    }

    protected TableView clone(double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        TableView clone;
        try {
            clone = (TableView)this.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
        clone.initialize();
        this.cloneModelIndependentState(clone, horizontalScale, verticalScale);
        this.cloneModelDependentState(clone, horizontalScale, verticalScale);
        return clone;
    }

    protected void cloneModelDependentState(TableView clone, double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        StaticOrderedCollectionInterface heldRows;
        StaticOrderedCollectionInterface heldColumns;
        CellVector cv;
        int i;
        this.updateView(null);
        clone.updateView(null);
        Object[] cvs = this.m_rowFactory.getCachedCellVectors();
        for (i = 0; i < cvs.length; ++i) {
            cv = (CellVector)cvs[i];
            if (cv.isTransient()) continue;
            cv.copyTo(clone.getRow(cv.getIndex()), verticalScale);
        }
        cvs = this.m_colFactory.getCachedCellVectors();
        for (i = 0; i < cvs.length; ++i) {
            cv = (CellVector)cvs[i];
            if (cv.isTransient()) continue;
            cv.copyTo(clone.getColumn(cv.getIndex()), horizontalScale);
        }
        if (this.m_columnLabelsRow != null && !this.m_columnLabelsRow.isTransient()) {
            this.m_columnLabelsRow.copyTo(clone.getColumnLabelsRow(), verticalScale);
        }
        if (this.m_rowLabelsColumn != null && !this.m_rowLabelsColumn.isTransient()) {
            this.m_rowLabelsColumn.copyTo(clone.getRowLabelsColumn(), horizontalScale);
        }
        if ((heldColumns = this.getHeldColumns()) != null) {
            for (i = 0; i < heldColumns.count(); ++i) {
                clone.hold(clone.getColumn(((Column)heldColumns.get(i)).getIndex()));
            }
        }
        if ((heldRows = this.getHeldRows()) != null) {
            for (i = 0; i < heldRows.count(); ++i) {
                clone.hold(clone.getRow(((Row)heldRows.get(i)).getIndex()));
            }
        }
    }

    protected void cloneModelIndependentState(TableView clone, double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
        VisualInterfaceSupport.clone(this, clone);
        ContainerInterfaceSupport.clone(this, clone);
        clone.setActiveCellHighlighted(this.isActiveCellHighlighted());
        clone.setCellTypeStylesSaved(this.isCellTypeStylesSaved());
        clone.setColumnLabelsVisible(this.isColumnLabelsVisible());
        clone.setColumnsConformed(this.isColumnsConformed());
        clone.setColumnsConformedThreshold(this.getColumnsConformedThreshold());
        clone.setColumnsSelectedByLabel(this.isColumnsSelectedByLabel());
        clone.setCurrentElementHighlighted(this.isCurrentElementHighlighted());
        DeepCloneSupport deepCloneSupport = new DeepCloneSupport();
        clone.setDefaultCellStyle((CellStyle)((Object)deepCloneSupport.clone((DeepClonable)this.getDefaultCellStyle(), true)));
        clone.setDefaultColumnStyle((ColumnStyle)((Object)deepCloneSupport.clone((DeepClonable)this.getDefaultColumnStyle(), true)));
        clone.setDefaultInvalidCellStyle((CellStyle)((Object)deepCloneSupport.clone((DeepClonable)this.getDefaultInvalidCellStyle(), true)));
        clone.setDefaultLabelStyle((CellStyle)((Object)deepCloneSupport.clone((DeepClonable)this.getDefaultLabelStyle(), true)));
        clone.setDefaultModel(this.getDefaultModel());
        clone.setDefaultRowStyle((RowStyle)((Object)deepCloneSupport.clone((DeepClonable)this.getDefaultRowStyle(), true)));
        clone.setExtendedSelectionAllowed(this.isExtendedSelectionAllowed());
        clone.setGridColor(this.getGridColor());
        clone.setGridVisible(this.isGridVisible());
        clone.setHorizontalScrollbarVisibility(this.getHorizontalScrollbarVisibility());
        clone.setMultipleSelectionAllowed(this.isMultipleSelectionAllowed());
        clone.setPartialColumnVisible(this.isPartialColumnVisible());
        clone.setPartialRowVisible(this.isPartialRowVisible());
        clone.setPopupMenuVisible(this.isPopupMenuVisible());
        clone.setPrintOrder(this.getPrintOrder());
        clone.setRowLabelsVisible(this.isRowLabelsVisible());
        clone.setRowsConformed(this.isRowsConformed());
        clone.setRowsConformedThreshold(this.getRowsConformedThreshold());
        clone.setRowsSelectedByLabel(this.isRowsSelectedByLabel());
        clone.setSelectionAllowed(this.isSelectionAllowed());
        clone.setSelectionElement(this.getSelectionElement());
        clone.setTableSelectedByOriginCell(this.isTableSelectedByOriginCell());
        clone.setTransactionElement(this.getTransactionElement());
        clone.setVerticalScrollbarVisibility(this.getVerticalScrollbarVisibility());
        if (this.m_cellTypeStyles != null) {
            clone.m_cellTypeStyles = this.cloneCellTypeStyles(this.m_cellTypeStyles, deepCloneSupport);
        }
    }

    protected DataCell createCell(Row row, Column col) {
        return new DataCell(this, row, col);
    }

    protected Column createColumn(int index) {
        return new Column(this, index);
    }

    protected LabelCell createColumnLabel(Column col) {
        return new LabelCell(this, LabelCell.COLUMN_LABEL, col);
    }

    protected LabelCell createOriginCell() {
        return new LabelCell(this, LabelCell.ORIGIN_LABEL, null);
    }

    protected Row createRow(int index) {
        return new Row(this, index);
    }

    protected LabelCell createRowLabel(Row row) {
        return new LabelCell(this, LabelCell.ROW_LABEL, row);
    }

    protected int getDefaultColumnIndex() {
        return 1;
    }

    protected int getDefaultRowIndex() {
        return 1;
    }

    protected Insets getLabelInsets() {
        this.m_usingLabelInsets = false;
        return this.getInsets();
    }

    protected Rectangle getTableBounds(Graphics g) {
        this.updateView(g);
        return new Rectangle(this.m_bounds);
    }

    protected TableView newTableView() {
        return new TableView();
    }

    protected void paintTable(Graphics g, Rectangle invalidBounds) {
        this.paintColumnLabels(g, invalidBounds);
        this.paintRows(g, invalidBounds);
        TableElement curElement = this.getCurrentElement();
        if (curElement != null) {
            Cell curCell = this.getCurrentCell(curElement);
            if (curCell == null) {
                this.paintCurrentElementCue(g, curElement);
            } else if (curCell.isActivated()) {
                this.paintCellActivationBorder(g, curCell);
            }
        }
    }

    protected void populatePopupMenu(PopupMenu popupMenu, TableElement element) {
    }

    @Override
    protected void processEvent(AWTEvent event) {
        Thread curThread = Thread.currentThread();
        this.m_processEventThreads.addElement(curThread);
        try {
            if (this.isEnabled()) {
                super.processEvent(event);
            }
        }
        finally {
            this.m_processEventThreads.removeElement(curThread);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent fe) {
        Cell curCell = this.getCurrentCell();
        if (curCell != null) {
            curCell.processFocusEvent(fe);
        }
        super.processFocusEvent(fe);
    }

    @Override
    protected void processKeyEvent(KeyEvent ke) {
        if (!ke.isConsumed()) {
            this.onProcessKeyEvent(ke);
        }
        ke.consume();
        super.processKeyEvent(ke);
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        int id = me.getID();
        if (id == 501) {
            this.requestFocus();
            this.m_mousePressedEvent = me;
        }
        if (this.m_resizer == null && !me.isConsumed()) {
            this.onProcessMouseEvent(me);
        }
        if (id == 502) {
            this.m_mousePressedEvent = null;
            if (this.m_resizer != null) {
                this.m_resizer.stop();
                this.m_resizer = null;
                me.consume();
            }
        }
        if (me.isPopupTrigger() && !me.isConsumed() && this.isPopupMenuVisible()) {
            this.m_popupMenu.removeAll();
            this.populatePopupMenu(this.m_popupMenu, this.getCurrentElement());
            if (this.m_popupMenu.getItemCount() != 0) {
                Point point = me.getPoint();
                this.m_popupMenu.show(this, point.x, point.y);
            }
        }
        super.processMouseEvent(me);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me) {
        if (!me.isConsumed()) {
            this.onProcessMouseMotionEvent(me);
        }
        super.processMouseMotionEvent(me);
    }

    protected synchronized void updateView(Graphics g) {
        if ((this.m_flags & 0x400000) != 0) {
            return;
        }
        try {
            this.m_flags |= 0x400000;
            this.processChanges();
            if ((this.m_flags & 0x24084F) != 0) {
                this.formatView(g);
            }
        }
        finally {
            this.m_flags &= 0xFFBFFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChanges() {
        Vector queue;
        Vector vector = this.m_contentsChangedEventQueue;
        synchronized (vector) {
            if (this.m_contentsChangedEventQueue.isEmpty()) {
                return;
            }
            queue = (Vector)this.m_contentsChangedEventQueue.clone();
            this.m_contentsChangedEventQueue.removeAllElements();
        }
        boolean oldValue = this.setFlag(256, false);
        try {
            int iCount = queue.size();
            for (int i = 0; i < iCount; ++i) {
                if (!this.processContentsChangedEvent((ContentsChangedEvent)queue.elementAt(i))) continue;
                break;
            }
        }
        finally {
            this.setFlag(256, oldValue);
        }
    }

    protected boolean processContentsChangedEvent(ContentsChangedEvent event) {
        if (event instanceof CellChangedEvent) {
            if (event instanceof DataCellChangedEvent) {
                this.refresh((DataCellChangedEvent)event);
                return false;
            }
            if (event instanceof ColumnLabelChangedEvent) {
                this.refresh((ColumnLabelChangedEvent)event);
                return false;
            }
            if (event instanceof RowLabelChangedEvent) {
                this.refresh((RowLabelChangedEvent)event);
                return false;
            }
        } else {
            if (event instanceof ColumnChangedEvent) {
                this.m_colFactory.refresh((ColumnChangedEvent)event);
                return false;
            }
            if (event instanceof RowChangedEvent) {
                this.m_rowFactory.refresh((RowChangedEvent)event);
                return false;
            }
        }
        this.onAllChanged();
        return true;
    }

    protected void onAllChanged() {
        boolean oldValue = this.setFlag(0x100000, true);
        try {
            this.refreshCellVectorFactories(true, true);
        }
        finally {
            this.setFlag(0x100000, oldValue);
            this.m_rowLabelsColumn = null;
            this.m_columnLabelsRow = null;
            this.m_originCell = null;
            this.m_flags |= 0xC0A0A;
            this.repaint();
        }
    }

    protected void formatView(Graphics g) {
        if ((this.m_flags & 0x800) != 0) {
            this.m_flags &= 0xFFFFF7FF;
            this.m_cellsWritable = this.m_tableModel != null ? this.m_tableModel.isCellsModifiable() : false;
            this.m_colLabelsWritable = this.m_columnLabelModel != null ? this.m_columnLabelModel.isColumnLabelsModifiable() : false;
            this.m_rowLabelsWritable = this.m_rowLabelModel != null ? this.m_rowLabelModel.isRowLabelsModifiable() : false;
        }
        if ((this.m_flags & 0x40000) != 0) {
            this.m_flags &= 0xFFFBFFFF;
            if (this.m_modelDefaultCellStyle != null) {
                this.m_modelDefaultCellStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this);
                this.m_modelDefaultCellStyle = null;
            }
            if (this.m_modelDefaultLabelStyle != null) {
                this.m_modelDefaultLabelStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this);
                this.m_modelDefaultLabelStyle = null;
            }
            if (this.m_modelDefaultColumnStyle != null) {
                this.m_modelDefaultColumnStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this);
                this.m_modelDefaultColumnStyle = null;
            }
            if (this.m_modelDefaultRowStyle != null) {
                this.m_modelDefaultRowStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this);
                this.m_modelDefaultRowStyle = null;
            }
            this.m_modelSupportsCellStyles = false;
            this.m_modelSupportsColumnStyles = false;
            this.m_modelSupportsColumnLabelStyles = false;
            this.m_modelSupportsRowStyles = false;
            this.m_modelSupportsRowLabelStyles = false;
            if (this.m_staticTableStyleModel != null) {
                try {
                    this.m_modelDefaultCellStyle = this.m_staticTableStyleModel.getDefaultCellStyle();
                    if (this.m_modelDefaultCellStyle != null) {
                        this.m_modelDefaultCellStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this);
                    }
                    this.m_modelDefaultLabelStyle = this.m_staticTableStyleModel.getDefaultLabelStyle();
                    if (this.m_modelDefaultLabelStyle != null) {
                        this.m_modelDefaultLabelStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this);
                    }
                    this.m_modelDefaultColumnStyle = this.m_staticTableStyleModel.getDefaultColumnStyle();
                    if (this.m_modelDefaultColumnStyle != null) {
                        this.m_modelDefaultColumnStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this);
                    }
                    this.m_modelDefaultRowStyle = this.m_staticTableStyleModel.getDefaultRowStyle();
                    if (this.m_modelDefaultRowStyle != null) {
                        this.m_modelDefaultRowStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this);
                    }
                    this.m_modelSupportsCellStyles = this.m_staticTableStyleModel.isCellStylesSupported();
                    this.m_modelSupportsColumnStyles = this.m_staticTableStyleModel.isColumnStylesSupported();
                    this.m_modelSupportsColumnLabelStyles = this.m_staticTableStyleModel.isColumnLabelStylesSupported();
                    this.m_modelSupportsRowStyles = this.m_staticTableStyleModel.isRowStylesSupported();
                    this.m_modelSupportsRowLabelStyles = this.m_staticTableStyleModel.isRowLabelStylesSupported();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((this.m_flags & 0x200000) != 0) {
            this.m_flags &= 0xFFDFFFFF;
            if (this.checkInsets()) {
                this.m_flags |= 0x40;
            }
        }
        if ((this.m_flags & 0x40) != 0) {
            this.m_flags &= 0xFFFFFFBF;
            this.remeasureAllColumns(true);
            this.remeasureAllRows(true);
            if ((this.m_flags & 0x800000) == 0) {
                this.m_size = this.getSize();
            }
            this.m_vbarWidth = this.m_vbar.isVisible() ? this.m_vbar.getSize().width : 0;
            this.m_hbarHeight = this.m_hbar.isVisible() ? this.m_hbar.getSize().height : 0;
            this.m_flags |= 0xF;
        }
        if ((this.m_flags & 0xF) != 0) {
            if (g == null && (g = this.getGraphics()) == null) {
                return;
            }
            int flags = this.m_flags;
            this.m_flags &= 0xFFFFFFF0;
            if ((flags & 8) != 0) {
                flags |= 4;
                this.m_bounds.y = this.getDrawableTopEdge();
                if (this.isColumnLabelsVisible() && !this.m_usingLabelInsets && (this.getColumnCount() > 0 || this.getRowCount() > 0)) {
                    this.getColumnLabelsRow();
                    int height = this.m_columnLabelsRow.getSize();
                    if (height == 0) {
                        this.m_columnLabelsRow.setPreferredSize(this.m_columnLabelsRow.computePreferredSize(g));
                        height = this.m_columnLabelsRow.getSize();
                        if (height == 0) {
                            height = 1;
                        }
                    }
                    this.m_gridBounds.y = this.m_bounds.y + height;
                    this.m_columnLabelsRow.setDisplayed(true);
                    this.m_columnLabelsRow.setPosition(this.m_bounds.y);
                } else {
                    this.m_gridBounds.y = this.m_bounds.y;
                    if (this.m_columnLabelsRow != null) {
                        this.m_columnLabelsRow.setDisplayed(false);
                    }
                }
                this.m_bounds.height = this.m_gridBounds.y - this.m_bounds.y;
            }
            if ((flags & 2) != 0) {
                flags |= 1;
                this.m_bounds.x = this.getDrawableLeftEdge();
                if (this.isRowLabelsVisible() && !this.m_usingLabelInsets && (this.getColumnCount() > 0 || this.getRowCount() > 0)) {
                    this.getRowLabelsColumn();
                    int width = this.m_rowLabelsColumn.getSize();
                    if (width == 0) {
                        this.m_rowLabelsColumn.setPreferredSize(this.m_rowLabelsColumn.computePreferredSize(g));
                        width = this.m_rowLabelsColumn.getSize();
                        if (width == 0) {
                            width = 1;
                        }
                    }
                    this.m_gridBounds.x = this.m_bounds.x + width;
                    this.m_rowLabelsColumn.setDisplayed(true);
                    this.m_rowLabelsColumn.setPosition(this.m_bounds.x);
                } else {
                    this.m_gridBounds.x = this.m_bounds.x;
                    if (this.m_rowLabelsColumn != null) {
                        this.m_rowLabelsColumn.setDisplayed(false);
                    }
                }
                this.m_bounds.width = this.m_gridBounds.x - this.m_bounds.x;
            }
            if ((flags & 1) != 0) {
                this.updateDisplayedColumns(g);
            }
            if ((flags & 4) != 0) {
                this.updateDisplayedRows(g);
            }
            if ((this.m_flags & 0x40) != 0) {
                this.formatView(g);
            }
        }
    }

    protected void updateDisplayedColumns(Graphics g) {
        this.m_gridBounds.width = this.m_colFactory.updateDisplayedCellVectors(g, this.m_gridBounds.x, this.getDrawableRightEdge());
        this.m_bounds.width = this.m_gridBounds.x - this.m_bounds.x + this.m_gridBounds.width;
    }

    protected void updateDisplayedRows(Graphics g) {
        this.m_gridBounds.height = this.m_rowFactory.updateDisplayedCellVectors(g, this.m_gridBounds.y, this.getDrawableBottomEdge());
        this.m_bounds.height = this.m_gridBounds.y - this.m_bounds.y + this.m_gridBounds.height;
    }

    protected void onSizeColumn(Column col, Graphics g) {
        col.setPreferredSize(col.computePreferredSize(g));
    }

    protected void onSizeRow(Row row, Graphics g) {
        row.setPreferredSize(row.computePreferredSize(g));
    }

    final int countColumns(int maxCount) {
        return this.m_colFactory.count(maxCount);
    }

    final int countRows(int maxCount) {
        return this.m_rowFactory.count(maxCount);
    }

    final int getColumnIndex(int index, int version) {
        return this.m_colFactory.getIndex(index, version);
    }

    final int getRowIndex(int index, int version) {
        return this.m_rowFactory.getIndex(index, version);
    }

    final Row getColumnLabelsRow() {
        if (this.m_columnLabelsRow == null) {
            this.m_columnLabelsRow = new ColumnLabelsRow(this);
        }
        return this.m_columnLabelsRow;
    }

    final Column getRowLabelsColumn() {
        if (this.m_rowLabelsColumn == null) {
            this.m_rowLabelsColumn = new RowLabelsColumn(this);
        }
        return this.m_rowLabelsColumn;
    }

    final int getColumnVersion() {
        return this.m_colFactory.m_currentVersion;
    }

    final int getRowVersion() {
        return this.m_rowFactory.m_currentVersion;
    }

    final FontStyle getDefaultFontStyle() {
        if (this.m_defaultFontStyle == null) {
            this.m_defaultFontStyle = new FontStyle();
            this.m_flags |= 0x20;
        }
        if ((this.m_flags & 0x20) != 0) {
            this.m_defaultFontStyle.setFont(this.getFont());
            this.m_flags &= 0xFFFFFFDF;
        }
        return this.m_defaultFontStyle;
    }

    final boolean isCellSelected(Cell cell) {
        block3: {
            block4: {
                LabelCell label;
                block5: {
                    if (this.m_selections == null) break block3;
                    if (!cell.isLabel()) break block4;
                    label = (LabelCell)cell;
                    if (!label.isRowLabel()) break block5;
                    int maxi = this.m_selections.count();
                    for (int i = 0; i < maxi; ++i) {
                        Selection selection = (Selection)this.m_selections.get(i);
                        if (!(selection instanceof RowSelection) || !selection.contains(label.getChild())) continue;
                        return true;
                    }
                    break block3;
                }
                if (!label.isColumnLabel()) break block3;
                int maxi = this.m_selections.count();
                for (int i = 0; i < maxi; ++i) {
                    Selection selection = (Selection)this.m_selections.get(i);
                    if (!(selection instanceof ColumnSelection) || !selection.contains(label.getChild())) continue;
                    return true;
                }
                break block3;
            }
            int maxi = this.m_selections.count();
            for (int i = 0; i < maxi; ++i) {
                if (!((Selection)this.m_selections.get(i)).contains(cell)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isColumnSelected(Column col) {
        if (this.m_selections != null) {
            int maxi = this.m_selections.count();
            for (int i = 0; i < maxi; ++i) {
                Selection selection = (Selection)this.m_selections.get(i);
                if (!(selection instanceof ColumnSelection) || !selection.contains(col)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isRowSelected(Row row) {
        if (this.m_selections != null) {
            int maxi = this.m_selections.count();
            for (int i = 0; i < maxi; ++i) {
                Selection selection = (Selection)this.m_selections.get(i);
                if (!(selection instanceof RowSelection) || !selection.contains(row)) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isHeld(Column col) {
        return this.m_colFactory.isHeld(col);
    }

    final boolean isHeld(Row row) {
        return this.m_rowFactory.isHeld(row);
    }

    final void noteCellModified(Cell cell) {
        if (!this.internalGetModifiedCells().contains((Object)cell)) {
            this.m_modifiedCells.add((Object)cell);
        }
    }

    final void noteCellRefreshed(Cell cell) {
        if (this.m_modifiedCells != null) {
            this.m_modifiedCells.remove((Object)cell);
        }
        if (this.m_invalidCells != null) {
            this.m_invalidCells.remove((Object)cell);
        }
    }

    final void noteColumnResized(Column col) {
        if (col.isDisplayed()) {
            if (col.equals(this.m_rowLabelsColumn)) {
                this.m_flags |= 2;
                this.repaint();
                return;
            }
            this.m_flags |= 1;
            if (this.isColumnsConformed()) {
                this.repaintColumns();
            } else {
                this.repaint(col.getPosition(), this.m_bounds.y, this.m_size.width, this.m_bounds.height);
            }
        } else {
            this.updateTableRight(col.getIndex());
        }
    }

    final void noteRowResized(Row row) {
        if (row.isDisplayed()) {
            if (row.equals(this.m_columnLabelsRow)) {
                this.m_flags |= 8;
                this.repaint();
                return;
            }
            this.m_flags |= 4;
            if (this.isRowsConformed()) {
                this.repaintRows();
            } else {
                this.repaint(this.m_bounds.x, row.getPosition(), this.m_bounds.width, this.m_size.height);
            }
        } else {
            this.updateTableBottom(row.getIndex());
        }
    }

    final void refreshColumns(int startColIndex, int endColIndex, int flags, boolean makeCellsObsolete) {
        int i;
        Object[] rows = this.m_rowFactory.m_transientCache.getCacheValues();
        for (i = 0; i < rows.length; ++i) {
            ((Row)rows[i]).refreshCells(startColIndex, endColIndex, flags, makeCellsObsolete);
        }
        if (this.m_rowFactory.m_permanentCache == null) {
            return;
        }
        rows = this.m_rowFactory.m_permanentCache.getValues();
        for (i = 0; i < rows.length; ++i) {
            ((Row)rows[i]).refreshCells(startColIndex, endColIndex, flags, makeCellsObsolete);
        }
    }

    final void setScrollingSmooth(boolean newValue) {
        this.setFlag(512, newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void activateCell(Cell cell, boolean fullyActivate, Point point) {
        Integer ActivationLevel;
        int state;
        if (cell.isLabel()) {
            LabelCellTypeInterface type = ((LabelCell)cell).getLabelType();
            if (type == LabelCell.ROW_LABEL) {
                if (!this.m_rowLabelsWritable) {
                    return;
                }
            } else {
                if (type != LabelCell.COLUMN_LABEL) return;
                if (!this.m_colLabelsWritable) {
                    return;
                }
            }
        } else if (!this.m_cellsWritable) {
            return;
        }
        int n = state = (ActivationLevel = (Integer)cell.getEffectiveStylePropertyValue("activationLevel", null)) != null ? ActivationLevel : 3;
        if (!fullyActivate && state == 3) {
            state = 2;
        }
        cell.setActiveState(state, point);
        if (!cell.isActivated()) return;
        this.scrollToCell(cell, false);
        this.repaintActiveCell(cell);
    }

    private boolean checkInsets() {
        this.m_usingLabelInsets = true;
        Insets insets = this.getLabelInsets();
        if (!insets.equals(this.m_insets)) {
            this.m_insets = insets;
            return true;
        }
        return false;
    }

    private Dictionary cloneCellTypeStyles(Dictionary src, DeepCloneSupport deepCloneSupport) throws CloneNotSupportedException {
        Dictionary clone = (Dictionary)src.clone();
        Enumeration keys = clone.getKeys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object item = src.get(key);
            CellStyle clonedItem = (CellStyle)((Object)deepCloneSupport.clone((DeepClonable)((CellStyle)((Object)item)), true));
            clonedItem.addPropertyBagChangedListener(this);
            clone.set(key, (Object)clonedItem);
        }
        return clone;
    }

    private void createPopupMenu() {
        this.m_popupMenu = new PopupMenu();
        this.add(this.m_popupMenu);
    }

    private void createScrollbars() {
        this.m_hbar = new com.sas.visuals.Scrollbar();
        this.m_hbar.initialize();
        this.m_hbar.setVisible(false);
        this.m_hbar.setOrientation(0);
        this.m_hbar.setMinimum(1);
        this.m_hbar.setMaximumReachable(true);
        this.m_hbar.addAdjustmentListener(this);
        this.m_vbar = new com.sas.visuals.Scrollbar();
        this.m_vbar.initialize();
        this.m_vbar.setVisible(false);
        this.m_vbar.setOrientation(1);
        this.m_vbar.setMinimum(1);
        this.m_vbar.setMaximumReachable(true);
        this.m_vbar.addAdjustmentListener(this);
        this.add("South", this.m_hbar);
        this.add("East", this.m_vbar);
    }

    private void deactivateCell(Cell cell) {
        if (!cell.isActivated()) {
            return;
        }
        cell.setActiveState(1);
        this.repaintActiveCell(cell);
        if (this.getTransactionElement() == 0) {
            this.commitModifiedCells();
        }
    }

    private CellVector findCellVector(int pos, OrderedCollection vectors) {
        this.updateView(null);
        int maxi = vectors.count();
        for (int i = 0; i < maxi; ++i) {
            if (!((CellVector)vectors.get(i)).contains(pos)) continue;
            return (CellVector)vectors.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionsChanged(Object selection, Object[] deselections) {
        if (this.m_itemListeners == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        if (!this.m_processEventThreads.contains(curThread)) {
            return;
        }
        ItemEvent ie = selection != null ? new ItemEvent(this, 701, selection, 1) : new ItemEvent(this, 701, deselections, 2);
        this.m_processEventThreads.removeElement(curThread);
        try {
            this.m_itemListeners.itemStateChanged(ie);
        }
        finally {
            this.m_processEventThreads.addElement(curThread);
        }
    }

    private Row getBottomRow() {
        return (Row)this.m_rowFactory.getLastDisplayed();
    }

    private Column getRightColumn() {
        return (Column)this.m_colFactory.getLastDisplayed();
    }

    private int getColumnCount() {
        return this.m_colFactory.count();
    }

    private int getRowCount() {
        return this.m_rowFactory.count();
    }

    private Row getColumnLabelsRowNeighbor() {
        return this.getTopRow();
    }

    private Cell getCurrentCell() {
        return this.getCurrentCell(this.getCurrentElement());
    }

    private Cell getCurrentCell(TableElement curElement) {
        return curElement instanceof Cell ? (Cell)curElement : null;
    }

    private Column getCurrentColumn() {
        TableElement curElement = this.getCurrentElement();
        if (curElement instanceof Cell) {
            Cell cell = (Cell)curElement;
            if (cell.isLabel()) {
                LabelCell label = (LabelCell)cell;
                if (label.isColumnLabel()) {
                    return (Column)label.getChild();
                }
                return this.getRowLabelsColumn();
            }
            return ((DataCell)cell).getColumn();
        }
        return curElement instanceof Column ? (Column)curElement : null;
    }

    private Row getCurrentRow() {
        TableElement curElement = this.getCurrentElement();
        if (curElement instanceof Cell) {
            Cell cell = (Cell)curElement;
            if (cell.isLabel()) {
                LabelCell label = (LabelCell)cell;
                if (label.isRowLabel()) {
                    return (Row)label.getChild();
                }
                return this.getColumnLabelsRow();
            }
            return ((DataCell)cell).getRow();
        }
        return curElement instanceof Row ? (Row)curElement : null;
    }

    private Rectangle getElementBounds(TableElement element) {
        if (!element.isDisplayed()) {
            return null;
        }
        if (element instanceof Row) {
            return this.getRowBounds((Row)element);
        }
        if (element instanceof Column) {
            return this.getColumnBounds((Column)element);
        }
        return ((Cell)element).getBounds();
    }

    private Rectangle getRowBounds(Row row) {
        int width = this.m_bounds.width;
        Column rightColumn = this.getRightColumn();
        if (rightColumn != null && (rightColumn.getIndex() < this.getColumnCount() || rightColumn.isPartiallyDisplayed())) {
            width += 5;
        }
        return new Rectangle(this.m_bounds.x, row.getPosition(), width, row.getSize());
    }

    private Rectangle getColumnBounds(Column col) {
        int height = this.m_bounds.height;
        Row bottomRow = this.getBottomRow();
        if (bottomRow != null && (bottomRow.getIndex() < this.getRowCount() || bottomRow.isPartiallyDisplayed())) {
            height += 5;
        }
        return new Rectangle(col.getPosition(), this.m_bounds.y, col.getSize(), height);
    }

    private int getDrawableBottomEdge() {
        return this.m_size.height - this.m_insets.bottom - this.m_hbarHeight - 1;
    }

    private int getDrawableHeight() {
        int h = this.getDrawableBottomEdge() - this.getDrawableTopEdge() + 1;
        return h < 0 ? 0 : h;
    }

    private int getDrawableLeftEdge() {
        return this.m_insets.left;
    }

    private int getDrawableRightEdge() {
        return this.m_size.width - this.m_insets.right - this.m_vbarWidth - 1;
    }

    private int getDrawableTopEdge() {
        return this.m_insets.top;
    }

    private int getDrawableWidth() {
        int w = this.getDrawableRightEdge() - this.getDrawableLeftEdge() + 1;
        return w < 0 ? 0 : w;
    }

    private Column getLeftColumn() {
        return (Column)this.m_colFactory.getFirstToDisplay();
    }

    private Row getTopRow() {
        return (Row)this.m_rowFactory.getFirstToDisplay();
    }

    private Column getRowLabelsColumnNeighbor() {
        return this.getLeftColumn();
    }

    private long getTimeOutInterval(int d) {
        return (long)(d >= 140 ? 1.0 : Math.pow(2.0, 7.0 - (double)d / 20.0));
    }

    private void initializeTransients() {
        this.m_bounds = new Rectangle();
        this.m_contentsChangedEventQueue = new Vector();
        this.m_processEventThreads = new Vector(1, 1);
        this.m_flags = 2885711;
        this.m_gridBounds = new Rectangle();
        this.m_colFactory = new ColumnFactory();
        this.m_rowFactory = new RowFactory();
    }

    private OrderedCollection internalGetInvalidCells() {
        if (this.m_invalidCells == null) {
            this.m_invalidCells = new OrderedCollection();
        }
        return this.m_invalidCells;
    }

    private OrderedCollection internalGetModifiedCells() {
        if (this.m_modifiedCells == null) {
            this.m_modifiedCells = new OrderedCollection();
        }
        return this.m_modifiedCells;
    }

    private OrderedCollection internalGetSelections() {
        if (this.m_selections == null) {
            this.m_selections = new OrderedCollection();
        }
        return this.m_selections;
    }

    private boolean isScrollableBackward(com.sas.visuals.Scrollbar scrollBar) {
        return scrollBar.getMinimum() != scrollBar.getValue();
    }

    private boolean isScrollableForward(com.sas.visuals.Scrollbar scrollBar) {
        return scrollBar.getMaximum() >= scrollBar.getValue() + scrollBar.getVisibleAmount();
    }

    private boolean isScrollingSmooth() {
        return !((this.m_flags & 0x200) == 0 || this.m_hbarAlarm != null && this.m_hbarAlarm.isRunning() || this.m_vbarAlarm != null && this.m_vbarAlarm.isRunning());
    }

    private void moveCurrentElementByPage(boolean pageUp, boolean multipleSelection, boolean extendedSelection) {
        TableElement element;
        Row bottomRow;
        Row curRow = this.getCurrentRow();
        if (curRow == null) {
            return;
        }
        Row row = curRow;
        int offset = -1;
        if (row.isDisplayed()) {
            offset = this.m_rowFactory.m_displayedCache.getIndex((Object)row, 0);
        }
        if (pageUp) {
            this.scrollPageUp();
        } else {
            this.scrollPageDown();
        }
        if (row.getIndex() == 0 || row.isHeld()) {
            return;
        }
        row = offset >= 0 && offset < this.m_rowFactory.m_displayedCache.count() ? (Row)this.m_rowFactory.m_displayedCache.get(offset) : (pageUp || offset > 0 ? ((bottomRow = this.getBottomRow()).isPartiallyDisplayed() && bottomRow != this.getTopRow() ? (Row)this.m_rowFactory.m_displayedCache.get(this.m_rowFactory.m_displayedCache.getIndex((Object)bottomRow, 0) - 1) : bottomRow) : this.getTopRow());
        if (curRow.equals(row)) {
            return;
        }
        Column curCol = this.getCurrentColumn();
        if (this.getSelectionElement() == 2) {
            element = row;
        } else {
            if (curCol == null) {
                return;
            }
            element = curCol.getIndex() == 0 ? row.getLabel() : curCol.getCell(row.getIndex());
        }
        if (multipleSelection) {
            this.selectMultiple(element, extendedSelection);
        } else {
            this.select(element, extendedSelection);
        }
    }

    private void tabCurrentElement(boolean forward, boolean multipleSelection, boolean extendedSelection) {
        TableElement element;
        int selectionElement = this.getSelectionElement();
        Column curCol = this.getCurrentColumn();
        Row curRow = this.getCurrentRow();
        if (curRow == null || curCol == null) {
            return;
        }
        if (selectionElement == 1) {
            if (curCol == null) {
                return;
            }
            curCol = forward ? curCol.nextColumn() : curCol.previousColumn();
            if (curCol == null) {
                return;
            }
            element = curCol;
        } else if (selectionElement == 2) {
            if (curRow == null) {
                return;
            }
            curRow = forward ? curRow.nextRow() : curRow.previousRow();
            if (curRow == null) {
                return;
            }
            element = curRow;
        } else {
            curCol = forward ? curCol.nextColumn() : curCol.previousColumn();
            if (curCol == null || curCol.getIndex() == 0 || curRow.getIndex() == 0) {
                curRow = forward ? curRow.nextRow() : curRow.previousRow();
                if (curRow == null || curRow.getIndex() == 0) {
                    return;
                }
                curCol = forward ? this.getColumn(1) : this.getColumn(this.getColumnCount());
            }
            element = curRow.getCell(curCol.getIndex());
        }
        if (multipleSelection) {
            this.selectMultiple(element, extendedSelection);
        } else {
            this.select(element, extendedSelection);
        }
        if (curCol != null) {
            this.scrollToColumn(curCol.getIndex() == 0 ? this.getRowLabelsColumnNeighbor() : curCol, false);
        }
        if (curRow != null) {
            this.scrollToRow(curRow.getIndex() == 0 ? this.getColumnLabelsRowNeighbor() : curRow, false);
        }
    }

    private void moveCurrentElementHorizontally(boolean forward, boolean multipleSelection, boolean extendedSelection) {
        TableElement element;
        Column curCol = this.getCurrentColumn();
        if (curCol == null) {
            return;
        }
        Column col = (Column)this.m_colFactory.getNextVisible(curCol, forward);
        if (col == null) {
            return;
        }
        int colIndex = col.getIndex();
        Row curRow = this.getCurrentRow();
        if (this.getSelectionElement() == 1) {
            element = col;
        } else {
            if (curRow == null) {
                return;
            }
            element = colIndex == 0 ? curRow.getLabel() : (curRow.getIndex() == 0 ? col.getLabel() : curRow.getCell(colIndex));
        }
        if (multipleSelection) {
            this.selectMultiple(element, extendedSelection);
        } else {
            this.select(element, extendedSelection);
        }
        this.scrollToColumn(colIndex == 0 ? this.getRowLabelsColumnNeighbor() : col, false);
    }

    private void moveCurrentElementVertically(boolean forward, boolean multipleSelection, boolean extendedSelection) {
        TableElement element;
        Row curRow = this.getCurrentRow();
        if (curRow == null) {
            return;
        }
        Row row = (Row)this.m_rowFactory.getNextVisible(curRow, forward);
        if (row == null) {
            return;
        }
        int rowIndex = row.getIndex();
        Column curCol = this.getCurrentColumn();
        if (this.getSelectionElement() == 2) {
            element = row;
        } else {
            if (curCol == null) {
                return;
            }
            element = rowIndex == 0 ? curCol.getLabel() : (curCol.getIndex() == 0 ? row.getLabel() : curCol.getCell(rowIndex));
        }
        if (multipleSelection) {
            this.selectMultiple(element, extendedSelection);
        } else {
            this.select(element, extendedSelection);
        }
        this.scrollToRow(rowIndex == 0 ? this.getColumnLabelsRowNeighbor() : row, false);
    }

    private void onHScroll(AdjustmentEvent event) {
        switch (event.getAdjustmentType()) {
            case 1: {
                this.scrollHorizontally(1, 4);
                break;
            }
            case 2: {
                this.scrollHorizontally(-1, 4);
                break;
            }
            case 4: {
                this.scrollHorizontally(1, 1);
                break;
            }
            case 3: {
                this.scrollHorizontally(-1, 1);
                break;
            }
            case 5: {
                this.scrollHorizontally(event.getValue() - this.m_colFactory.getScrollIndex(this.getLeftColumn()), 4);
            }
        }
    }

    private void onMousePressed(MouseEvent me) {
        Cell cell;
        int modifiers;
        Point point;
        block9: {
            block8: {
                point = me.getPoint();
                modifiers = me.getModifiers();
                if ((modifiers & 0x10) != 0) break block8;
                if ((modifiers & (0x10 | 8 | 4)) != 0) break block9;
            }
            if (!me.isPopupTrigger() && this.resizeHitTest(point, true) != 0) {
                return;
            }
        }
        if ((cell = this.findCell(point)) != null) {
            boolean multipleSelect;
            if (!com.sas.awt.util.Util.isLeftMouseButton(me) && cell.isSelected()) {
                return;
            }
            boolean extendedSelect = (modifiers & 2) != 0 && this.isExtendedSelectionAllowed();
            boolean bl = multipleSelect = (modifiers & 1) != 0 && this.isMultipleSelectionAllowed();
            if (multipleSelect) {
                this.selectMultiple(cell, extendedSelect);
            } else {
                this.select(cell, extendedSelect);
            }
        }
    }

    private void onMouseReleased(MouseEvent me) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onProcessKeyEvent(KeyEvent ke) {
        if (this.m_resizer != null) {
            return;
        }
        int keyID = ke.getID();
        int keyCode = ke.getKeyCode();
        int keyMods = ke.getModifiers();
        Cell curCell = this.getCurrentCell();
        if (curCell != null) {
            switch (curCell.getActiveState()) {
                case 1: {
                    if (keyID != 401 || ke.isActionKey()) break;
                    if (keyCode == 10) break;
                    if (keyCode == 9) break;
                    if (keyCode == 17) break;
                    if (keyCode != 16) {
                        if ((keyMods & 2) == 0) {
                            this.activateCell(curCell, false, null);
                            if (!curCell.isActivated()) return;
                            curCell.processKeyEvent(ke);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    curCell.processKeyEvent(ke);
                    if (curCell.isKeyHandled()) {
                        return;
                    }
                    break;
                }
                case 3: {
                    curCell.processKeyEvent(ke);
                    if (curCell.isKeyHandled()) return;
                    if (keyCode != 9) {
                        if (keyCode != 10) {
                            return;
                        }
                    }
                    break;
                }
            }
        }
        if (keyID != 401) {
            return;
        }
        if (keyCode != 9) {
            if (keyCode != 10) {
                if (keyCode != 37) {
                    if (keyCode != 39) {
                        if (keyCode != 38) {
                            if (keyCode != 40) {
                                if (keyCode != 33) {
                                    if (keyCode != 34) {
                                        if (keyCode != 113) return;
                                        Cell cell = this.getCurrentCell();
                                        if (cell == null) return;
                                        this.activateCell(cell, true, null);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        boolean ctrl = (keyMods & 2) != 0;
        boolean shift = (keyMods & 1) != 0;
        boolean multipleSelect = shift && this.isMultipleSelectionAllowed();
        boolean extendedSelect = ctrl && this.isExtendedSelectionAllowed();
        boolean oldValue = false;
        Cursor cursor = this.getCursor();
        try {
            this.m_pve = null;
            oldValue = this.setFlag(256, true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            switch (keyCode) {
                case 9: {
                    this.tabCurrentElement(!shift, false, false);
                    break;
                }
                case 10: {
                    this.moveCurrentElementVertically(!shift, false, false);
                    break;
                }
                case 37: {
                    this.moveCurrentElementHorizontally(false, multipleSelect, extendedSelect);
                    break;
                }
                case 39: {
                    this.moveCurrentElementHorizontally(true, multipleSelect, extendedSelect);
                    break;
                }
                case 38: {
                    this.moveCurrentElementVertically(false, multipleSelect, extendedSelect);
                    break;
                }
                case 40: {
                    this.moveCurrentElementVertically(true, multipleSelect, extendedSelect);
                    break;
                }
                case 33: {
                    Row curRow = this.getCurrentRow();
                    if (curRow == null) {
                        this.scrollPageUp();
                        break;
                    }
                    this.moveCurrentElementByPage(true, multipleSelect, extendedSelect);
                    break;
                }
                case 34: {
                    Row curRow = this.getCurrentRow();
                    if (curRow == null) {
                        this.scrollPageDown();
                        break;
                    }
                    this.moveCurrentElementByPage(false, multipleSelect, extendedSelect);
                    break;
                }
            }
            Cell newCell = this.getCurrentCell();
            if (this.m_pve != null) return;
            if (newCell == null) return;
            if (!curCell.equals(newCell)) return;
            if (!curCell.isActivated()) return;
            this.deactivateCell(curCell);
            return;
        }
        finally {
            this.setCursor(cursor);
            this.setFlag(256, oldValue);
        }
    }

    private void onProcessMouseEvent(MouseEvent me) {
        Point point = me.getPoint();
        Cell curCell = this.getCurrentCell();
        if (curCell != null && (curCell.isMouseCaptured() || curCell.isActivated() && curCell.isDisplayed() && curCell.getBounds().contains(point))) {
            if (curCell.getActiveState() == 2 && me.getID() == 501) {
                this.activateCell(curCell, true, null);
            }
            curCell.processMouseEvent(me);
            return;
        }
        switch (me.getID()) {
            case 501: {
                this.onMousePressed(me);
                break;
            }
            case 502: {
                if (this.m_hbarAlarm != null) {
                    this.m_hbarAlarm.stop();
                }
                if (this.m_vbarAlarm != null) {
                    this.m_vbarAlarm.stop();
                }
                this.onMouseReleased(me);
                if (this.m_currentSelection == null || this.m_currentSelectionInitialEnd == this.m_currentSelection.getEnd()) break;
                this.fireSelectionsChanged(this.m_currentSelection, null);
                break;
            }
            case 500: {
                if (me.getClickCount() != 2 || !com.sas.awt.util.Util.isLeftMouseButton(me)) break;
                if (this.getCursor() == Cursor.getPredefinedCursor(11)) {
                    Cell cell = this.findCell(point);
                    LabelCell label = (LabelCell)cell;
                    Column col = null;
                    if (label.isColumnLabel()) {
                        col = (Column)label.getChild();
                    } else if (label.isOriginLabel()) {
                        col = this.getRowLabelsColumn();
                    }
                    if (point.x < col.getRightEdge() - 3 && point.x < col.getPosition() + 3) {
                        Point pnt = new Point(col.getPosition() - 1, point.y);
                        label = (LabelCell)this.findCell(pnt);
                        if (label.isColumnLabel()) {
                            col = (Column)label.getChild();
                        } else if (label.isOriginLabel()) {
                            col = this.getRowLabelsColumn();
                        }
                    }
                    if (!col.isResizable()) break;
                    col.setSize(col.getPreferredSize());
                    break;
                }
                if (this.getCursor() == Cursor.getPredefinedCursor(8)) {
                    Cell cell = this.findCell(point);
                    LabelCell label = (LabelCell)cell;
                    Row row = null;
                    if (label.isRowLabel()) {
                        row = (Row)label.getChild();
                    } else if (label.isOriginLabel()) {
                        row = this.getColumnLabelsRow();
                    }
                    if (point.y < row.getBottomEdge() - 3 && point.y < row.getPosition() + 3) {
                        Point pnt = new Point(point.x, row.getPosition() - 1);
                        label = (LabelCell)this.findCell(pnt);
                        if (label.isRowLabel()) {
                            row = (Row)label.getChild();
                        } else if (label.isOriginLabel()) {
                            row = this.getColumnLabelsRow();
                        }
                    }
                    if (!row.isResizable()) break;
                    row.setSize(row.getPreferredSize());
                    break;
                }
                if ((me.getModifiers() & 2) != 0) break;
                if ((me.getModifiers() & 1) != 0 || curCell == null || !curCell.isDisplayed() || !curCell.getBounds().contains(point)) break;
                this.activateCell(curCell, true, point);
            }
        }
    }

    private void onProcessMouseMotionEvent(MouseEvent me) {
        if (this.m_resizer != null) {
            return;
        }
        Point point = me.getPoint();
        Cell curCell = this.getCurrentCell();
        if (curCell != null && (curCell.isMouseCaptured() || curCell.isActivated() && curCell.isDisplayed() && curCell.getBounds().contains(point))) {
            curCell.processMouseMotionEvent(me);
            return;
        }
        switch (me.getID()) {
            case 506: {
                if (!this.isMultipleSelectionAllowed() || this.m_currentSelection == null) break;
                this.updateCurrentSelection(point);
                break;
            }
            case 503: {
                this.setCursor(point);
            }
        }
    }

    private void updateCurrentSelection(Point p) {
        Point point = new Point(p);
        if (point.x < this.m_gridBounds.x) {
            point.x = this.m_gridBounds.x;
        } else if (point.x > Rectangles.getRight((Rectangle)this.m_gridBounds)) {
            point.x = Rectangles.getRight((Rectangle)this.m_gridBounds);
        }
        if (point.y < this.m_gridBounds.y) {
            point.y = this.m_gridBounds.y;
        } else if (point.y > Rectangles.getBottom((Rectangle)this.m_gridBounds)) {
            point.y = Rectangles.getBottom((Rectangle)this.m_gridBounds);
        }
        Cell cell = this.findCell(point);
        if (cell == null) {
            return;
        }
        if (this.m_currentSelection != null) {
            this.m_currentSelection.setEnd(cell);
        }
    }

    private void onVScroll(AdjustmentEvent event) {
        switch (event.getAdjustmentType()) {
            case 1: {
                this.scrollVertically(1, 4);
                break;
            }
            case 2: {
                this.scrollVertically(-1, 4);
                break;
            }
            case 4: {
                this.scrollVertically(1, 1);
                break;
            }
            case 3: {
                this.scrollVertically(-1, 1);
                break;
            }
            case 5: {
                this.scrollVertically(event.getValue() - this.m_rowFactory.getScrollIndex(this.getTopRow()), 4);
            }
        }
    }

    private void paint(Graphics g, int x, int y, int width, int height) {
        if (this.m_printGraphics != null && !this.m_printTable) {
            return;
        }
        g.setClip(x, y, width, height);
        this.paint(g);
    }

    private void paintCellActivationBorder(Graphics g, Cell cell) {
        if (!this.isActiveCellHighlighted()) {
            return;
        }
        if (!cell.isDisplayed()) {
            return;
        }
        Rectangle cellBounds = cell.getBounds();
        Rectangle r = new Rectangle();
        if (cell.isSelected()) {
            com.sas.awt.util.Util.invertRect(g, cellBounds);
        }
        r.setBounds(cellBounds.x - 3, cellBounds.y - 3, cellBounds.width + 4 + 1, 2);
        com.sas.awt.util.Util.invertRect(g, r);
        r.y = Rectangles.getBottom((Rectangle)cellBounds) + 1;
        com.sas.awt.util.Util.invertRect(g, r);
        r.y = cellBounds.y;
        r.width = 2;
        r.height = cellBounds.height;
        com.sas.awt.util.Util.invertRect(g, r);
        r.x = Rectangles.getRight((Rectangle)cellBounds) + 1;
        com.sas.awt.util.Util.invertRect(g, r);
    }

    private void paintCurrentElementCue(Graphics g, TableElement curElement) {
        if (!this.isCurrentElementHighlighted()) {
            return;
        }
        Rectangle rect = this.getElementBounds(curElement);
        if (rect != null) {
            com.sas.awt.util.Util.drawFocusRect(g, rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
    }

    private void paintColumnLabels(Graphics g, Rectangle invalidBounds) {
        LabelCell cell;
        if (this.m_bounds.y == this.m_gridBounds.y) {
            return;
        }
        if (invalidBounds.y >= this.m_gridBounds.y) {
            return;
        }
        int invalidMaxX = invalidBounds.x + invalidBounds.width - 1;
        if (invalidBounds.x < this.m_gridBounds.x && invalidMaxX >= this.m_bounds.x && (cell = this.getOriginCell()).isDisplayed()) {
            cell.paint(g);
        }
        if (invalidMaxX < this.m_gridBounds.x) {
            return;
        }
        int maxc = this.m_colFactory.m_displayedCache.count();
        for (int c = 0; c < maxc; ++c) {
            Column col = (Column)this.m_colFactory.m_displayedCache.get(c);
            int rightEdge = col.getRightEdge();
            if (invalidBounds.x > rightEdge) continue;
            col.getLabel().paint(g);
            if (invalidMaxX <= rightEdge) break;
        }
    }

    private void paintRows(Graphics g, Rectangle invalidBounds) {
        int invalidMaxY = invalidBounds.y + invalidBounds.height - 1;
        if (invalidMaxY < this.m_gridBounds.y) {
            return;
        }
        int invalidMaxX = invalidBounds.x + invalidBounds.width - 1;
        if (invalidMaxX < this.m_bounds.x) {
            return;
        }
        int maxr = this.m_rowFactory.m_displayedCache.count();
        for (int r = 0; r < maxr; ++r) {
            Row row = (Row)this.m_rowFactory.m_displayedCache.get(r);
            int bottomEdge = row.getBottomEdge();
            if (invalidBounds.y > bottomEdge) continue;
            if (invalidBounds.x < this.m_gridBounds.x && this.m_bounds.x != this.m_gridBounds.x) {
                row.getLabel().paint(g);
            }
            if (invalidMaxX >= this.m_gridBounds.x) {
                int maxc = this.m_colFactory.m_displayedCache.count();
                for (int c = 0; c < maxc; ++c) {
                    Column col = (Column)this.m_colFactory.m_displayedCache.get(c);
                    int rightEdge = col.getRightEdge();
                    if (invalidBounds.x > rightEdge) continue;
                    row.getCell(col.getIndex()).paint(g);
                    if (invalidMaxX <= rightEdge) break;
                }
            }
            if (invalidMaxY <= bottomEdge) break;
        }
    }

    private void refresh(ColumnLabelChangedEvent event) {
        if (event.count == 0) {
            return;
        }
        ColumnSelection s = new ColumnSelection(this.getColumn(event.index), this.getColumn(event.index + event.count - 1));
        s.refresh(10);
    }

    private void refresh(RowLabelChangedEvent event) {
        if (event.count == 0) {
            return;
        }
        RowSelection s = new RowSelection(this.getRow(event.index), this.getRow(event.index + event.count - 1));
        s.refresh(10);
    }

    private void refresh(DataCellChangedEvent event) {
        if (event.colCount == 0 || event.rowCount == 0) {
            return;
        }
        CellSelection s = new CellSelection(this.getRow(event.rowIndex).getCell(event.colIndex), this.getRow(event.rowIndex + event.rowCount - 1).getCell(event.colIndex + event.colCount - 1));
        s.refresh(31);
    }

    private void refreshCellTypeStyles() {
        CellStyle cs;
        String key;
        Object[] types = null;
        StaticPropertyBagInterface[] styles = null;
        if (this.m_staticTableTypeModel != null) {
            try {
                types = this.m_staticTableTypeModel.getCellTypes();
                if (this.m_staticTableTypeModel instanceof StaticTableTypeStylesInterface) {
                    styles = ((StaticTableTypeStylesInterface)this.m_staticTableTypeModel).getCellTypeStyles();
                }
            }
            catch (TableException ex) {
                ex.printStackTrace();
            }
        }
        if (this.m_cellTypeStyles == null) {
            this.m_cellTypeStyles = new Dictionary(types != null && types.length != 0 ? types.length : 1);
        }
        int len = types == null ? 0 : types.length;
        for (int i = 0; i < len; ++i) {
            key = types[i];
            if (this.m_cellTypeStyles.containsKey((Object)key)) continue;
            cs = new CellStyle();
            cs.addPropertyBagChangedListener(this);
            if (styles != null && styles[i] != null) {
                cs.set(styles[i]);
            }
            this.m_cellTypeStyles.set((Object)key, (Object)cs);
        }
        if (this.m_cellTypeStyles.count() > len) {
            Enumeration keys = this.m_cellTypeStyles.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (types != null && Util.arrayContains((Object[])types, (Object)key)) continue;
                cs = (CellStyle)((Object)this.m_cellTypeStyles.get((Object)key));
                cs.removePropertyBagChangedListener(this);
                this.m_cellTypeStyles.removeAt((Object)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCellVectorFactories(boolean refreshCols, boolean refreshRows) {
        if (refreshRows) {
            this.releaseAllRows();
            this.m_rowFactory.refresh();
        }
        if (refreshCols) {
            this.releaseAllColumns();
            this.m_colFactory.refresh();
        }
        boolean oldValue = this.setFlag(512, false);
        try {
            Row row = (Row)this.m_rowFactory.getFirstToDisplay();
            Column col = (Column)this.m_colFactory.getFirstToDisplay();
            if (row != null && col != null) {
                this.scrollToCell(this.getCell(row, col), true);
            }
        }
        finally {
            this.setFlag(512, oldValue);
        }
    }

    private void repaintActiveCell(Cell cell) {
        if (!cell.isDisplayed()) {
            return;
        }
        Rectangle cellBounds = cell.getBounds();
        cellBounds.x -= 3;
        cellBounds.y -= 3;
        cellBounds.width += 5;
        cellBounds.height += 5;
        this.repaint(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
    }

    private boolean setFlag(int flag, boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (this.m_flags & flag) != 0;
        this.m_flags = newValue ? (this.m_flags |= flag) : (this.m_flags &= ~flag);
        return oldValue;
    }

    private int resizeHitTest(Point point, boolean resize) {
        return this.resizeHitTest2(point, resize);
    }

    private int resizeHitTest2(Point point, boolean resize) {
        Cell cell = this.findCell(point);
        if (cell == null) {
            return 0;
        }
        if (!cell.isLabel() || this.m_usingLabelInsets) {
            return 0;
        }
        LabelCell label = (LabelCell)cell;
        Column col = null;
        Row row = null;
        if (label.isColumnLabel()) {
            col = (Column)label.getChild();
        } else if (label.isRowLabel()) {
            row = (Row)label.getChild();
        } else {
            col = this.getRowLabelsColumn();
            row = this.getColumnLabelsRow();
        }
        if (col != null) {
            if (point.x < col.getRightEdge() - 3) {
                if (point.x < col.getPosition() + 3) {
                    Point pnt = new Point(col.getPosition() - 1, point.y);
                    return this.resizeHitTest2(pnt, resize);
                }
            } else if (col.isResizable() && !col.isPartiallyDisplayed()) {
                if (resize) {
                    this.m_resizer = new ColumnResizer(col);
                    Rectangle r = new Rectangle(col.getPosition(), this.m_bounds.y, col.getSize(), this.m_bounds.height);
                    this.m_resizer.start(this, r, this.m_mousePressedEvent.getPoint());
                }
                return 1;
            }
        }
        if (row != null) {
            if (point.y < row.getBottomEdge() - 3) {
                if (point.y < row.getPosition() + 3) {
                    Point pnt = new Point(point.x, row.getPosition() - 1);
                    return this.resizeHitTest2(pnt, resize);
                }
            } else if (row.isResizable() && !row.isPartiallyDisplayed()) {
                if (resize) {
                    this.m_resizer = new RowResizer(row);
                    Rectangle r = new Rectangle(this.m_bounds.x, row.getPosition(), this.m_bounds.width, row.getSize());
                    this.m_resizer.start(this, r, this.m_mousePressedEvent.getPoint());
                }
                return 2;
            }
        }
        return 0;
    }

    private void scrollPageDown() {
        this.scrollVertically(1, 1);
    }

    private void scrollPageRight() {
        this.scrollHorizontally(1, 1);
    }

    private void scrollPageUp() {
        this.scrollVertically(-1, 1);
    }

    private void scrollPageLeft() {
        this.scrollHorizontally(-1, 1);
    }

    private void scrollWindowHorizontally(Column oldLeftColumn) {
        int dx;
        int x2;
        int x;
        boolean forward;
        this.m_flags |= 1;
        Graphics g = oldLeftColumn != null && this.isScrollingSmooth() ? this.getGraphics() : null;
        if (g == null) {
            this.repaintColumns();
            return;
        }
        Column newLeftColumn = this.getLeftColumn();
        boolean bl = forward = newLeftColumn.getIndex() > oldLeftColumn.getIndex();
        if (forward) {
            if (!newLeftColumn.isDisplayed() || newLeftColumn.isPartiallyDisplayed()) {
                this.updateView(g);
                this.repaintColumns();
                return;
            }
            x = newLeftColumn.getPosition();
            Column rightColumn = this.getRightColumn();
            x2 = rightColumn.isPartiallyDisplayed() ? rightColumn.getPosition() - 1 : rightColumn.getRightEdge();
            this.updateView(g);
            dx = newLeftColumn.getPosition() - x;
        } else {
            x = oldLeftColumn.getPosition();
            x2 = this.getRightColumn().getRightEdge();
            this.updateView(g);
            if (!oldLeftColumn.isDisplayed() || oldLeftColumn.isPartiallyDisplayed()) {
                this.repaintColumns();
                return;
            }
            dx = oldLeftColumn.getPosition() - x;
        }
        int w = x2 - x + 1;
        int right = this.getDrawableRightEdge();
        if (dx > 0 && x2 + dx > right) {
            w -= x2 + dx - right;
        }
        g.copyArea(x, this.m_bounds.y, w, this.m_bounds.height, dx, 0);
        if (this.m_bounds.y == this.m_gridBounds.y && this.m_bounds.y != 0) {
            this.paint(g, this.m_gridBounds.x, 0, right - this.m_gridBounds.x + 1, this.m_bounds.y);
        }
        if (forward) {
            this.paint(g, dx + x2 + 1, this.m_bounds.y, right - dx - x2, this.m_bounds.height);
            int gridRight = Rectangles.getRight((Rectangle)this.m_gridBounds);
            if (gridRight < right) {
                this.repaint(gridRight + 1, 0, right - gridRight, this.getDrawableBottomEdge() + 1);
            }
        } else {
            this.paint(g, newLeftColumn.getPosition(), this.m_bounds.y, dx, this.m_bounds.height);
        }
    }

    private void scrollWindowVertically(Row oldTopRow) {
        int dy;
        int y2;
        int y;
        boolean forward;
        this.m_flags |= 4;
        Graphics g = oldTopRow != null && this.isScrollingSmooth() ? this.getGraphics() : null;
        if (g == null) {
            this.repaintRows();
            return;
        }
        Row newTopRow = this.getTopRow();
        boolean bl = forward = newTopRow.getIndex() > oldTopRow.getIndex();
        if (forward) {
            if (!newTopRow.isDisplayed() || newTopRow.isPartiallyDisplayed()) {
                this.updateView(g);
                this.repaintRows();
                return;
            }
            y = newTopRow.getPosition();
            Row bottomRow = this.getBottomRow();
            y2 = bottomRow.isPartiallyDisplayed() ? bottomRow.getPosition() - 1 : bottomRow.getBottomEdge();
            this.updateView(g);
            dy = newTopRow.getPosition() - y;
        } else {
            y = oldTopRow.getPosition();
            y2 = this.getBottomRow().getBottomEdge();
            this.updateView(g);
            if (!oldTopRow.isDisplayed() || oldTopRow.isPartiallyDisplayed()) {
                this.repaintRows();
                return;
            }
            dy = oldTopRow.getPosition() - y;
        }
        int h = y2 - y + 1;
        int bottom = this.getDrawableBottomEdge();
        if (dy > 0 && y2 + dy > bottom) {
            h -= y2 + dy - bottom;
        }
        g.copyArea(this.m_bounds.x, y, this.m_bounds.width, h, 0, dy);
        if (this.m_bounds.x == this.m_gridBounds.x && this.m_bounds.x != 0) {
            this.paint(g, 0, this.m_gridBounds.y, this.m_bounds.x, bottom - this.m_gridBounds.y + 1);
        }
        if (forward) {
            this.paint(g, this.m_bounds.x, dy + y2 + 1, this.m_bounds.width, bottom - dy - y2);
            int gridBottom = Rectangles.getBottom((Rectangle)this.m_gridBounds);
            if (gridBottom < bottom) {
                this.repaint(0, gridBottom + 1, this.getDrawableRightEdge() + 1, bottom - gridBottom);
            }
        } else {
            this.paint(g, this.m_bounds.x, newTopRow.getPosition(), this.m_bounds.width, dy);
        }
    }

    private void select(TableElement element, boolean extend) {
        this.selectMultiple(element, element, extend);
    }

    private void selectMultiple(TableElement end, boolean extend) {
        TableElement anchor;
        if (this.m_currentSelection != null) {
            anchor = (TableElement)this.m_currentSelection.getAnchor();
        } else {
            anchor = this.getCurrentElement();
            if (anchor == null) {
                this.select(end, extend);
                return;
            }
        }
        this.selectMultiple(anchor, end, extend);
    }

    private void selectMultiple(TableElement anchor, TableElement end, boolean extend) {
        if (!extend) {
            this.unselect();
        }
        boolean selected = false;
        switch (this.getSelectionElement()) {
            case 0: {
                Cell endCell = (Cell)end;
                Integer level = (Integer)endCell.getEffectiveStylePropertyValue("activationLevel", null);
                boolean setCurrent = true;
                if (level != null && level == 0) {
                    setCurrent = false;
                }
                if (setCurrent) {
                    try {
                        this.setCurrentElement(end);
                    }
                    catch (PropertyVetoException pve) {
                        this.m_pve = pve;
                        return;
                    }
                }
                if (!this.isSelectionAllowed()) break;
                Cell anchorCell = null;
                LabelCell anchorLabel = null;
                if (anchor instanceof Cell && (anchorCell = (Cell)anchor).isLabel()) {
                    anchorLabel = (LabelCell)anchorCell;
                }
                if (endCell.isLabel()) {
                    LabelCell endLabel = (LabelCell)endCell;
                    if (!this.isMultipleSelectionAllowed()) break;
                    if (endLabel.isRowLabel()) {
                        Row endRow;
                        if (!this.isRowsSelectedByLabel()) break;
                        if (anchorLabel != null) {
                            if (!anchorLabel.isRowLabel()) break;
                            anchor = (TableElement)anchorLabel.getChild();
                            if (anchor == null) {
                                return;
                            }
                        } else if (anchorCell != null) {
                            anchor = ((DataCell)anchorCell).getRow();
                        } else if (anchor instanceof Column) {
                            anchor = this.getColumnLabelsRowNeighbor();
                        }
                        if ((endRow = (Row)endLabel.getChild()) == null) {
                            return;
                        }
                        this.select((Row)anchor, endRow, extend);
                        selected = true;
                        break;
                    }
                    if (endLabel.isColumnLabel()) {
                        Column endCol;
                        if (!this.isColumnsSelectedByLabel()) break;
                        if (anchorLabel != null) {
                            if (!anchorLabel.isColumnLabel()) break;
                            anchor = (TableElement)anchorLabel.getChild();
                            if (anchor == null) {
                                return;
                            }
                        } else if (anchorCell != null) {
                            anchor = ((DataCell)anchorCell).getColumn();
                        } else if (anchor instanceof Row) {
                            anchor = this.getRowLabelsColumnNeighbor();
                        }
                        if ((endCol = (Column)endLabel.getChild()) == null) {
                            return;
                        }
                        this.select((Column)anchor, endCol, extend);
                        selected = true;
                        break;
                    }
                    if (!this.isTableSelectedByOriginCell()) break;
                    int rowCount = this.getRowCount();
                    int colCount = this.getColumnCount();
                    if (rowCount <= 0 || colCount <= 0 || this.m_rowFactory.isCountUnknown() || this.m_colFactory.isCountUnknown()) break;
                    this.select(this.getRow(1).getCell(1), this.getRow(rowCount).getCell(colCount), extend);
                    selected = true;
                    break;
                }
                if (!setCurrent) {
                    return;
                }
                if (anchorCell == null) {
                    anchorCell = anchor instanceof Row ? this.getCell((Row)anchor, this.getLeftColumn()) : this.getCell(this.getTopRow(), (Column)anchor);
                } else if (anchorLabel != null) break;
                this.select((DataCell)anchorCell, (DataCell)endCell, extend);
                selected = true;
                break;
            }
            case 1: {
                LabelCell anchorLabel;
                if (anchor instanceof DataCell) {
                    anchor = ((DataCell)anchor).getColumn();
                } else if (anchor instanceof LabelCell && (anchor = (TableElement)(anchorLabel = (LabelCell)anchor).getChild()) == null) {
                    return;
                }
                if (end instanceof DataCell) {
                    end = ((DataCell)end).getColumn();
                } else if (end instanceof LabelCell) {
                    LabelCell endLabel = (LabelCell)end;
                    if (!endLabel.isColumnLabel()) {
                        return;
                    }
                    end = (TableElement)endLabel.getChild();
                    if (end == null) {
                        return;
                    }
                }
                try {
                    this.setCurrentElement(end);
                }
                catch (PropertyVetoException pve) {
                    this.m_pve = pve;
                    return;
                }
                if (!this.isSelectionAllowed()) break;
                this.select((Column)anchor, (Column)end, extend);
                selected = true;
                break;
            }
            case 2: {
                LabelCell anchorLabel;
                if (anchor instanceof DataCell) {
                    anchor = ((DataCell)anchor).getRow();
                } else if (anchor instanceof LabelCell && (anchor = (TableElement)(anchorLabel = (LabelCell)anchor).getChild()) == null) {
                    return;
                }
                if (end instanceof DataCell) {
                    end = ((DataCell)end).getRow();
                } else if (end instanceof LabelCell) {
                    LabelCell endLabel = (LabelCell)end;
                    if (!endLabel.isRowLabel()) {
                        return;
                    }
                    end = (TableElement)endLabel.getChild();
                    if (end == null) {
                        return;
                    }
                }
                try {
                    this.setCurrentElement(end);
                }
                catch (PropertyVetoException pve) {
                    this.m_pve = pve;
                    return;
                }
                if (!this.isSelectionAllowed()) break;
                this.select((Row)anchor, (Row)end, extend);
                selected = true;
            }
        }
        if (selected && end != null && this.m_selections != null && this.m_selections.count() > 0) {
            this.setCurrentSelection((Selection)this.m_selections.get(this.m_selections.count() - 1));
        }
    }

    private synchronized void setCurrentElement() {
        boolean oldValue = this.setFlag(0x1000000, true);
        try {
            this.setCurrentElement(null);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.setFlag(0x1000000, oldValue);
        }
    }

    private void setCurrentSelection(Selection newValue) {
        if (this.m_currentSelection == newValue) {
            return;
        }
        if (this.m_currentSelection != null) {
            this.m_currentSelection.removeContentsChangedListener(this.m_selectionListener);
        }
        if (newValue != null) {
            if (this.m_selectionListener == null) {
                this.m_selectionListener = new SelectionListener();
            }
            newValue.addContentsChangedListener(this.m_selectionListener);
            this.m_currentSelectionInitialEnd = newValue.getEnd();
        }
        this.m_currentSelection = newValue;
    }

    protected void setCursor(Point point) {
        if (this.getCursor() != Cursor.getPredefinedCursor(3)) {
            switch (this.resizeHitTest(point, false)) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                default: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        Cursor oldCursor = this.getCursor();
        if (Util.equal((Object)oldCursor, (Object)cursor)) {
            return;
        }
        super.setCursor(cursor);
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("cursor", oldCursor, cursor);
        }
    }

    private void updateScrollbar(com.sas.visuals.Scrollbar scrollbar, int visibility, int visibleAmount) {
        boolean visible;
        if (visibleAmount <= 0) {
            visibleAmount = 1;
        }
        int max = scrollbar.getMaximum();
        switch (visibility) {
            case 2: {
                visible = false;
                break;
            }
            case 1: {
                visible = true;
                break;
            }
            default: {
                visible = visibleAmount != max;
            }
        }
        scrollbar.setVisibleAmount(visibleAmount);
        if (visible && visibleAmount != max) {
            scrollbar.setBlockIncrement(visibleAmount);
        }
        if (visible != scrollbar.isVisible()) {
            scrollbar.setVisible(visible);
            this.m_flags |= 0x40;
            this.repaint();
            this.validate();
        }
    }

    private void updateTableBottom(int rowIndex) {
        Row bottomRow = this.getBottomRow();
        if (bottomRow != null && (bottomRow.isPartiallyDisplayed() || bottomRow.getIndex() + 1 != rowIndex)) {
            return;
        }
        this.m_flags |= 4;
        if (bottomRow == null) {
            this.repaint();
        } else {
            this.repaint(0, bottomRow.getPosition(), this.m_size.width, this.m_size.height);
        }
    }

    private void updateTableRight(int colIndex) {
        Column rightColumn = this.getRightColumn();
        if (rightColumn != null && (rightColumn.isPartiallyDisplayed() || rightColumn.getIndex() + 1 != colIndex)) {
            return;
        }
        this.m_flags |= 1;
        if (rightColumn == null) {
            this.repaint();
        } else {
            this.repaint(rightColumn.getPosition(), 0, this.m_size.width, this.m_size.height);
        }
    }

    private void updateHPowerScroll(Point point) {
        if (this.m_hbarAlarm == null) {
            this.m_hbarAlarm = new Alarm();
            this.m_hbarAlarm.setCount(0);
            this.m_hbarAlarmListener = new HScrollListener();
            this.m_hbarAlarm.addAlarmListener((AlarmListener)this.m_hbarAlarmListener);
        } else if (this.m_hbarAlarm.isRunning()) {
            this.m_hbarAlarm.stop();
        }
        if (point.x <= this.m_gridBounds.x && this.isScrollableBackward(this.m_hbar)) {
            this.startAlarm(this.m_hbarAlarm, this.m_hbarAlarmListener, this.getTimeOutInterval(this.m_gridBounds.x - point.x), point, false);
        } else if (point.x >= Rectangles.getRight((Rectangle)this.m_gridBounds) && this.isScrollableForward(this.m_hbar)) {
            this.startAlarm(this.m_hbarAlarm, this.m_hbarAlarmListener, this.getTimeOutInterval(point.x - Rectangles.getRight((Rectangle)this.m_gridBounds) + 1), point, true);
        }
    }

    private void updateVPowerScroll(Point point) {
        if (this.m_vbarAlarm == null) {
            this.m_vbarAlarm = new Alarm();
            this.m_vbarAlarm.setCount(0);
            this.m_vbarAlarmListener = new VScrollListener();
            this.m_vbarAlarm.addAlarmListener((AlarmListener)this.m_vbarAlarmListener);
        } else if (this.m_vbarAlarm.isRunning()) {
            this.m_vbarAlarm.stop();
        }
        if (point.y <= this.m_gridBounds.y && this.isScrollableBackward(this.m_vbar)) {
            this.startAlarm(this.m_vbarAlarm, this.m_vbarAlarmListener, this.getTimeOutInterval(this.m_gridBounds.y - point.y), point, false);
        } else if (point.y >= Rectangles.getBottom((Rectangle)this.m_gridBounds) && this.isScrollableForward(this.m_vbar)) {
            this.startAlarm(this.m_vbarAlarm, this.m_vbarAlarmListener, this.getTimeOutInterval(point.y - Rectangles.getBottom((Rectangle)this.m_gridBounds) + 1), point, true);
        }
    }

    private void startAlarm(Alarm alarm, ScrollListener listener, long interval, Point point, boolean scrollForward) {
        alarm.setInterval(interval);
        listener.scrollForward = scrollForward;
        listener.mousePoint.x = point.x;
        listener.mousePoint.y = point.y;
        alarm.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            stream.defaultReadObject();
        }
        finally {
            this.initializeTransients();
            Component hbar = this.getComponent(0);
            Component vbar = this.getComponent(1);
            if (hbar instanceof Scrollbar) {
                this.remove(hbar);
                this.remove(vbar);
                this.createScrollbars();
            } else {
                this.m_hbar = (com.sas.visuals.Scrollbar)hbar;
                this.m_vbar = (com.sas.visuals.Scrollbar)vbar;
            }
            if (this.m_popupMenu == null) {
                this.createPopupMenu();
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Dictionary temp = this.m_cellTypeStyles;
        if (!this.isCellTypeStylesSaved()) {
            this.m_cellTypeStyles = null;
        }
        this.m_popupMenu.removeAll();
        try {
            stream.defaultWriteObject();
        }
        finally {
            this.m_cellTypeStyles = temp;
        }
    }

    private com.sas.visuals.Scrollbar getHorizontalScrollbar() {
        return this.m_hbar;
    }

    private com.sas.visuals.Scrollbar getVerticalScrollbar() {
        return this.m_vbar;
    }

    private StaticTableInterface getStaticTableModel() {
        return this.m_staticTableModel;
    }

    private void noteColumnsRefreshed() {
        this.m_bounds.width = 0;
        this.m_gridBounds.width = 0;
        this.m_flags |= 1;
        this.repaint();
    }

    private void noteRowsRefreshed() {
        this.m_bounds.height = 0;
        this.m_gridBounds.height = 0;
        this.m_flags |= 4;
        this.repaint();
    }

    private static CacheMonitor getCacheMonitor() {
        return m_cacheMonitor;
    }

    static /* synthetic */ CacheMonitor access$1500() {
        return TableView.getCacheMonitor();
    }

    private static final class CacheMonitor
    implements CacheMonitorInterface {
        public boolean deleteItems;

        private CacheMonitor() {
        }

        public boolean isCacheItemRemovable(Object item, long key, StaticCacheInterface cache) {
            CellVector cv = (CellVector)item;
            return !cv.isDisplayed() && !cv.isCurrent() && !cv.isModified();
        }

        public void noteCacheItemRemoved(Object item, long key, StaticCacheInterface cache) {
            TableElement te = (TableElement)item;
            if (te.isTransient() || this.deleteItems) {
                te.setObsolete();
            } else {
                CellVectorFactory factory = (CellVectorFactory)cache.getSecondaryCache();
                factory.storeInCache(key, te);
            }
        }

        public boolean noteCacheFull(int capacity, StaticCacheInterface cache) {
            try {
                cache.configureCache((int)((double)capacity * 1.1), -1, -1, -1, -1);
            }
            catch (CacheException cex) {
                cex.printStackTrace();
                return true;
            }
            return false;
        }
    }

    private abstract class CellVectorFactory
    implements StaticCacheInterface {
        LongKeyDictionary m_permanentCache;
        SparseCache m_transientCache = new SparseCache((StaticCacheInterface)this, (CacheMonitorInterface)TableView.access$1500(), this.getInitialCapacity(), 0);
        private int m_count = -1;
        private boolean m_unknownCount;
        private OrderedCollection m_displayedCache = new OrderedCollection();
        private StaticOrderedCollection m_staticDisplayedCache;
        private OrderedCollection m_heldCache;
        private StaticOrderedCollection m_staticHeldCache;
        private int m_baselineVersion;
        private int m_currentVersion;
        private OrderedCollection m_history;
        private CellVector m_first;
        private boolean m_updateScrollbar;

        public final long[] computeCacheKeyRange(long startKey, long endKey, int size) throws CacheException {
            return SequentialCache.computeSequentialKeyRange((long)startKey, (long)endKey, (int)size);
        }

        public final void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) {
        }

        public final long[] getCacheKeys() throws CacheException {
            return this.computeCacheKeyRange(this.getMinKey(), this.getMaxKey(), 0);
        }

        public final Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
            Object[] items = new Object[keys.length];
            for (int i = 0; i < items.length; ++i) {
                items[i] = this.getFromCache(keys[i]);
            }
            return items;
        }

        public final Object[] getFromCache(long startKey, long endKey, boolean readFully) throws CacheException {
            return this.getFromCache(this.computeCacheKeyRange(startKey, endKey, 0), readFully);
        }

        public final StaticCacheInterface getSecondaryCache() {
            return null;
        }

        public final void useBufferHints(BufferHints hints) {
        }

        public final CellVector getCellVector(long key) {
            try {
                if (!this.cacheContainsKey(key)) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.m_permanentCache != null && this.m_permanentCache.containsKey(key)) {
                    return (CellVector)this.m_permanentCache.get(key);
                }
                return (CellVector)this.m_transientCache.getFromCache(key);
            }
            catch (CacheException cex) {
                throw new RuntimeException(cex.getMessage());
            }
        }

        private void storeInCache(long key, TableElement item) {
            if (this.m_permanentCache == null) {
                this.m_permanentCache = new LongKeyDictionary();
            }
            this.m_permanentCache.set(key, (Object)item);
        }

        public final boolean cacheContainsKey(long key) {
            if (key < 1L) {
                return false;
            }
            return key <= (long)this.count((int)key);
        }

        public final int getCacheKeyUse() {
            return 0;
        }

        private long getMinKey() {
            return 1L;
        }

        private long getMaxKey() {
            return this.count();
        }

        private int getInitialCapacity() {
            return 128;
        }

        public final int count() {
            return this.count(1);
        }

        public final int count(int maxCount) {
            if (maxCount < 0) {
                throw new IllegalArgumentException();
            }
            if ((TableView.this.m_flags & 0x400000) == 0) {
                TableView.this.processChanges();
            }
            int oldCount = this.m_count;
            if (this.m_count == -1) {
                try {
                    this.m_count = this.onGetCount();
                    if (this.m_count < 0) {
                        this.m_unknownCount = true;
                    }
                }
                catch (TableException tex) {
                    tex.printStackTrace();
                    this.m_count = 0;
                }
            }
            if (this.m_unknownCount && (maxCount == 0 || maxCount > this.m_count)) {
                try {
                    this.m_count = this.onCount(maxCount);
                    if (this.m_count < maxCount || maxCount == 0) {
                        if (this.m_count < 0) {
                            this.m_count = 0;
                        }
                        if (this.onGetCount() >= 0) {
                            this.m_unknownCount = false;
                        }
                    }
                }
                catch (TableException tex) {
                    tex.printStackTrace();
                }
            }
            if (oldCount != this.m_count) {
                this.onCountChanged();
            }
            return this.m_count;
        }

        public final StaticOrderedCollectionInterface getDisplayedCache() {
            if (this.m_staticDisplayedCache == null) {
                this.m_staticDisplayedCache = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.m_displayedCache);
            }
            return this.m_staticDisplayedCache;
        }

        public final StaticOrderedCollectionInterface getHeldCache() {
            if (this.m_staticHeldCache == null) {
                this.m_staticHeldCache = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.internalGetHeldCache());
            }
            return this.m_staticHeldCache;
        }

        private OrderedCollection internalGetHeldCache() {
            if (this.m_heldCache == null) {
                this.m_heldCache = new OrderedCollection();
            }
            return this.m_heldCache;
        }

        public final void hold(CellVector cv, boolean hold) {
            if (hold) {
                this.internalGetHeldCache().add((Object)cv);
            } else {
                this.internalGetHeldCache().remove((Object)cv);
            }
            if (cv.equals(this.m_first)) {
                CellVector first = this.getNextScrollable(cv, 1, false);
                if (first == null) {
                    first = this.getNextScrollable(cv, -1, false);
                }
                this.m_first = first;
            }
            this.onCountChanged();
            this.setFirstToDisplay(this.m_first);
            this.m_updateScrollbar = true;
        }

        public final boolean isHeld(CellVector cv) {
            return this.m_heldCache != null && this.m_heldCache.contains((Object)cv);
        }

        public final boolean releaseAll() {
            if (this.getHeldCount() != 0) {
                this.m_heldCache.removeAll();
                this.onCountChanged();
                this.setFirstToDisplay(this.m_first);
                this.m_updateScrollbar = true;
                return true;
            }
            return false;
        }

        public final CellVector getLastDisplayed() {
            int count = this.m_displayedCache.count();
            if (count == 0) {
                return null;
            }
            return (CellVector)this.m_displayedCache.get(count - 1);
        }

        public final int getIndex(int index, int version) {
            if (version == this.m_currentVersion || index == 0) {
                return index;
            }
            if (version < this.m_baselineVersion) {
                throw new IllegalStateException();
            }
            int maxi = this.m_history.count();
            for (int i = 0; i < maxi; ++i) {
                CellVectorEvent event = (CellVectorEvent)this.m_history.get(i);
                if (event.version < version || event.index > index) continue;
                if (event.howChanged == 1) {
                    index += event.count;
                    continue;
                }
                if (index < event.index + event.count) {
                    throw new IllegalStateException();
                }
                index -= event.count;
            }
            return index;
        }

        public final CellVector getNextScrollable(CellVector cv, int amt, boolean maxit) {
            CellVector next;
            block9: {
                next = null;
                boolean forward = amt > 0;
                int heldCount = this.getHeldCount();
                if (!maxit) {
                    if (heldCount == 0) {
                        try {
                            next = this.getCellVector(cv.getIndex() + amt);
                            amt = 0;
                        }
                        catch (IndexOutOfBoundsException iobex) {
                            if (amt == 1 || amt == -1) {
                                return null;
                            }
                            maxit = true;
                        }
                    } else {
                        next = cv;
                        amt = Math.abs(amt);
                    }
                }
                if (maxit) {
                    next = forward ? this.getCellVector(this.count(0)) : this.getCellVector(1L);
                    if (next.equals(cv)) {
                        return null;
                    }
                    forward = !forward;
                    amt = 0;
                }
                if (amt <= 0 && !next.isHeld()) break block9;
                do {
                    if ((next = forward ? next.next() : next.previous()) != null) continue;
                    return null;
                } while (next.isHeld() || --amt > 0);
            }
            return next;
        }

        public final CellVector getNextVisible(CellVector cv, boolean forward) {
            if (cv.getIndex() == 0) {
                if (!forward) {
                    return null;
                }
                if (this.getHeldCount() != 0) {
                    return (CellVector)this.m_heldCache.get(0);
                }
                return this.getFirstToDisplay();
            }
            int heldIndex = -1;
            if (this.m_heldCache != null) {
                heldIndex = this.m_heldCache.getIndex((Object)cv, 0);
            }
            if (heldIndex != -1) {
                if (forward) {
                    if (heldIndex + 1 < this.m_heldCache.count()) {
                        return (CellVector)this.m_heldCache.get(heldIndex + 1);
                    }
                    return this.getFirstToDisplay();
                }
                if (heldIndex > 0) {
                    return (CellVector)this.m_heldCache.get(heldIndex - 1);
                }
                if (this.isOppositeLabelsVisible() && TableView.this.getSelectionElement() != this.getID()) {
                    return this.getOppositeLabelsVector();
                }
                return null;
            }
            if ((cv = this.getNextScrollable(cv, forward ? 1 : -1, false)) == null && !forward) {
                int heldCount = this.getHeldCount();
                if (heldCount > 0) {
                    return (CellVector)this.m_heldCache.get(heldCount - 1);
                }
                if (this.isOppositeLabelsVisible() && TableView.this.getSelectionElement() != this.getID()) {
                    return this.getOppositeLabelsVector();
                }
            }
            return cv;
        }

        public final CellVector getFirstToDisplay() {
            if (this.m_first == null) {
                int index = this.getDefaultIndex();
                if (index > this.count(index)) {
                    index = this.count(index);
                }
                if (index > 0) {
                    CellVector cv = this.getCellVector(index);
                    if (cv.isHeld() && (cv = this.getNextScrollable(cv, 1, false)) == null && index != 1 && (cv = this.getCellVector(1L)).isHeld()) {
                        cv = this.getNextScrollable(cv, 1, false);
                    }
                    if (cv != null) {
                        this.setFirstToDisplay(cv);
                    }
                }
            }
            return this.m_first;
        }

        private void setFirstToDisplay(CellVector cv) {
            this.m_first = cv;
            int index = cv == null ? 1 : this.getScrollIndex(cv);
            this.getScrollbar().setValue(index);
        }

        private void setLastToDisplay(CellVector cv) {
            if (cv.equals(this.getLastDisplayed()) && !cv.isPartiallyDisplayed()) {
                return;
            }
            CellVector firstNonHeld = null;
            int iCount = this.m_displayedCache.count();
            for (int i = 0; i < iCount; ++i) {
                CellVector temp = (CellVector)this.m_displayedCache.get(i);
                if (temp.isHeld()) continue;
                firstNonHeld = temp;
                break;
            }
            if (firstNonHeld != null) {
                cv = this.findFirstToDisplay(cv, firstNonHeld.getPosition(), this.getScrollableLastPos());
            }
            this.scrollToCellVector(cv, true);
        }

        public final int getScrollIndex(CellVector cv) {
            int index = cv.getIndex();
            int heldCount = this.getHeldCount();
            for (int i = 0; i < heldCount; ++i) {
                if (((CellVector)this.m_heldCache.get(i)).getIndex() <= index) continue;
                ++index;
            }
            return index - heldCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invalidateDisplayedCache() {
            OrderedCollection orderedCollection = this.m_displayedCache;
            synchronized (orderedCollection) {
                int maxi = this.m_displayedCache.count();
                for (int i = 0; i < maxi; ++i) {
                    ((CellVector)this.m_displayedCache.get(i)).setDisplayed(false);
                }
                this.m_displayedCache.removeAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidatePermanentCache() {
            if (this.m_permanentCache == null) {
                return;
            }
            LongKeyDictionary longKeyDictionary = this.m_permanentCache;
            synchronized (longKeyDictionary) {
                this.updatePermanentCache(null);
            }
        }

        private void invalidateTransientCache(boolean deleteItems) {
            this.invalidateDisplayedCache();
            CacheMonitor monitor = (CacheMonitor)this.m_transientCache.getMonitor();
            try {
                if (deleteItems) {
                    monitor.deleteItems = true;
                } else {
                    this.m_transientCache.setMonitor(null);
                }
                this.m_transientCache.invalidateCache();
            }
            finally {
                if (deleteItems) {
                    monitor.deleteItems = false;
                } else {
                    this.m_transientCache.setMonitor((CacheMonitorInterface)monitor);
                }
            }
        }

        public final boolean isCountUnknown() {
            this.count();
            return this.m_unknownCount;
        }

        protected abstract int onGetCount() throws TableException;

        protected abstract int onCount(int var1) throws TableException;

        private void onCountChanged() {
            int max;
            if (this.m_unknownCount) {
                max = this.m_count - this.getHeldCount() + 1;
            } else if (this.m_count <= 0) {
                max = 1;
            } else {
                max = this.m_count - this.getHeldCount();
                if (max == 0) {
                    max = 1;
                }
            }
            this.getScrollbar().setMaximum(max);
        }

        public final void refresh() {
            TableView.this.setCurrentElement();
            TableView.this.unselect();
            this.setFirstToDisplay(null);
            if (this instanceof ColumnFactory) {
                TableView.this.refreshColumns(1, -1, 0, true);
            }
            this.invalidateTransientCache(true);
            this.invalidatePermanentCache();
            this.m_count = -1;
            this.m_unknownCount = false;
            this.onCountChanged();
            ++this.m_baselineVersion;
            this.m_currentVersion = this.m_baselineVersion;
            this.m_history = null;
        }

        public final void refresh(CellVectorChangedEvent event) {
            if (this.m_count == -1) {
                return;
            }
            if (event.howChanged == 3) {
                TableView.this.refreshCellVectorFactories(event instanceof ColumnChangedEvent, event instanceof RowChangedEvent);
                this.remeasureOppositeAxis();
                return;
            }
            switch (event.howChanged) {
                case 4: {
                    this.getSelection(event).refresh(31);
                    break;
                }
                case 2: {
                    CellVector first;
                    TableView.this.setCurrentElement();
                    TableView.this.unselect();
                    if (this.getHeldCount() != 0) {
                        int maxi = event.index + event.count - 1;
                        for (int i = event.index; i <= maxi; ++i) {
                            TableView.this.release(this.getCellVector(i));
                        }
                    }
                    if ((first = this.getFirstToDisplay()) != null && first.getIndex() >= event.index && first.getIndex() < event.index + event.count) {
                        CellVector cv = this.getCellVector(event.index + event.count - 1);
                        first = this.getNextScrollable(cv, 1, false);
                        if (first == null) {
                            cv = this.getCellVector(event.index);
                            first = this.getNextScrollable(cv, -1, false);
                        }
                        this.setFirstToDisplay(first);
                    }
                }
                case 1: {
                    int count;
                    if (this.m_history == null) {
                        this.m_history = new OrderedCollection();
                    }
                    this.m_history.add((Object)new CellVectorEvent(this.m_currentVersion, event));
                    ++this.m_currentVersion;
                    this.adjustCellVectors(event);
                    if (event.howChanged == 1) {
                        count = this.m_count;
                        this.m_count += event.count;
                    } else {
                        this.m_count -= event.count;
                        count = this.m_count;
                    }
                    this.onCountChanged();
                    if (count == 0) {
                        TableView.this.remeasureAllColumns(false);
                        TableView.this.remeasureAllRows(false);
                    }
                    this.setFirstToDisplay(this.getFirstToDisplay());
                }
            }
        }

        public final Object[] getCachedCellVectors() {
            Object[] cvs1 = this.m_transientCache.getCacheValues();
            if (this.m_permanentCache == null) {
                return cvs1;
            }
            Object[] cvs2 = this.m_permanentCache.getValues();
            if (cvs2.length == 0) {
                return cvs1;
            }
            if (cvs1.length == 0) {
                return cvs2;
            }
            Object[] cellVectors = new Object[cvs1.length + cvs2.length];
            System.arraycopy(cvs1, 0, cellVectors, 0, cvs1.length);
            System.arraycopy(cvs2, 0, cellVectors, cvs1.length, cvs2.length);
            return cellVectors;
        }

        public final void remeasureAll(boolean preserveResizes) {
            Object[] cellVectors = this.getCachedCellVectors();
            for (int i = 0; i < cellVectors.length; ++i) {
                CellVector cv = (CellVector)cellVectors[i];
                if (preserveResizes && cv.isResized()) continue;
                cv.remeasure();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int updateDisplayedCellVectors(Graphics g, int pos, int maxPos) {
            OrderedCollection orderedCollection = this.m_displayedCache;
            synchronized (orderedCollection) {
                int n;
                try {
                    int newCount;
                    int oldCount;
                    this.m_displayedCache.disableEvents();
                    int iCount = oldCount = this.m_displayedCache.count();
                    if (oldCount > 1 && this.getLastDisplayed().isPartiallyDisplayed()) {
                        --oldCount;
                    }
                    for (int i = 0; i < iCount; ++i) {
                        ((CellVector)this.m_displayedCache.get(i)).setDisplayed(false);
                    }
                    this.m_displayedCache.removeAll();
                    int sizeUsed = 0;
                    int maxSize = maxPos - pos + 1;
                    if (maxSize < 0) {
                        maxSize = 0;
                    }
                    boolean partialDisplayed = false;
                    int heldCount = this.getHeldCount();
                    CellVector cv = heldCount > 0 ? (CellVector)this.m_heldCache.get(0) : this.getFirstToDisplay();
                    while (cv != null) {
                        int size = cv.getSize();
                        if (size == 0) {
                            this.onSizeCellVector(cv, g);
                            size = cv.getSize();
                            if (size == 0) {
                                size = 1;
                            }
                        }
                        if ((sizeUsed += size) > maxSize) {
                            if (this.isPartialCellVectorVisible() || this.m_displayedCache.count() == 0 || cv.isHeld() || this.m_displayedCache.count() == heldCount) {
                                partialDisplayed = true;
                                size -= sizeUsed - maxSize;
                                sizeUsed = maxSize;
                            } else {
                                sizeUsed -= size;
                                break;
                            }
                        }
                        this.m_displayedCache.add((Object)cv);
                        cv.setDisplayed(true);
                        cv.setPartiallyDisplayed(partialDisplayed);
                        cv.setPosition(pos);
                        if (sizeUsed == maxSize) break;
                        pos += size;
                        if (heldCount != 0) {
                            int displayedHeldCount = this.m_displayedCache.count();
                            if (displayedHeldCount < heldCount) {
                                cv = (CellVector)this.m_heldCache.get(displayedHeldCount);
                                continue;
                            }
                            if (displayedHeldCount == heldCount) {
                                cv = this.getFirstToDisplay();
                                continue;
                            }
                            cv = this.getNextScrollable(cv, 1, false);
                            continue;
                        }
                        cv = cv.next();
                    }
                    if ((newCount = this.m_displayedCache.count()) > 1 && this.getLastDisplayed().isPartiallyDisplayed()) {
                        --newCount;
                    } else if (this.isCellVectorsConformed() && newCount == this.count() && newCount > 0 && !this.m_unknownCount && !this.getLastDisplayed().isPartiallyDisplayed() && (double)sizeUsed / (double)maxSize * 100.0 > (double)this.getConformThreshold()) {
                        sizeUsed = CellVector.resize(this.m_displayedCache, maxSize, false);
                    }
                    if (newCount != oldCount || this.m_updateScrollbar) {
                        TableView.this.updateScrollbar(this.getScrollbar(), this.getScrollbarVisibility(), newCount - heldCount);
                        this.m_updateScrollbar = false;
                    }
                    n = sizeUsed;
                }
                catch (Throwable throwable) {
                    this.m_displayedCache.enableEvents();
                    throw throwable;
                }
                this.m_displayedCache.enableEvents();
                return n;
            }
        }

        public final CellVector findFirstToDisplay(CellVector lastToDisplay, int pos, int maxPos) {
            Graphics g = TableView.this.getGraphics();
            CellVector cv = lastToDisplay;
            CellVector firstToDisplay = lastToDisplay;
            int sizeUsed = 0;
            int maxSize = maxPos - pos + 1;
            if (maxSize < 0) {
                maxSize = 0;
            }
            do {
                int size;
                if ((size = cv.getSize()) == 0) {
                    this.onSizeCellVector(cv, g);
                    size = cv.getSize();
                    if (size == 0) {
                        size = 1;
                    }
                }
                if ((sizeUsed += size) > maxSize) break;
                firstToDisplay = cv;
            } while (sizeUsed != maxSize && (cv = this.getNextScrollable(cv, -1, false)) != null);
            return firstToDisplay;
        }

        public final void scroll(int numUnits, int unit) {
            block7: {
                block9: {
                    block8: {
                        if (numUnits == 0) {
                            return;
                        }
                        CellVector first = this.getFirstToDisplay();
                        if (first == null) {
                            return;
                        }
                        if (unit != 4 && unit != 3) break block8;
                        CellVector cv = this.getNextScrollable(first, numUnits, unit == 3);
                        if (cv != null) {
                            this.scrollToCellVector(cv, true);
                        }
                        break block7;
                    }
                    if (unit != 1) break block9;
                    int numPages = Math.abs(numUnits);
                    do {
                        CellVector cv;
                        if (numUnits > 0) {
                            cv = this.getLastDisplayed();
                            if (cv.isPartiallyDisplayed() && cv != this.getFirstToDisplay() || (cv = this.getNextScrollable(cv, 1, false)) != null) {
                                this.scrollToCellVector(cv, true);
                                continue;
                            }
                            break block7;
                        }
                        cv = this.getNextScrollable(this.getFirstToDisplay(), -1, false);
                        if (cv == null) break block7;
                        this.setLastToDisplay(cv);
                    } while (--numPages != 0);
                    break block7;
                    {
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void scrollTo(CellVector cv, boolean makeFirst) {
            if (cv.getIndex() != 0 && !cv.isHeld()) {
                if (makeFirst || this.m_first == null) {
                    CellVector oldFirst = this.m_first;
                    this.setFirstToDisplay(cv);
                    boolean oldValue = false;
                    try {
                        oldValue = TableView.this.setFlag(256, false);
                        this.scrollWindow(oldFirst);
                    }
                    finally {
                        TableView.this.setFlag(256, oldValue);
                    }
                } else if (cv.getIndex() < this.m_first.getIndex()) {
                    this.scrollToCellVector(cv, true);
                } else {
                    CellVector last = this.getLastDisplayed();
                    if (last != null && cv.getIndex() >= last.getIndex()) {
                        this.setLastToDisplay(cv);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustCellVectors(CellVectorChangedEvent event) {
            if (event instanceof ColumnChangedEvent) {
                TableView.this.refreshColumns(event.index, -1, 0, true);
            }
            SparseCache sparseCache = this.m_transientCache;
            synchronized (sparseCache) {
                this.updateTransientCache(event);
                if (this.m_permanentCache != null) {
                    LongKeyDictionary longKeyDictionary = this.m_permanentCache;
                    synchronized (longKeyDictionary) {
                        this.updatePermanentCache(event);
                    }
                }
            }
        }

        private void updatePermanentCache(CellVectorChangedEvent event) {
            Object[] values = this.m_permanentCache.getValues();
            this.m_permanentCache.removeAll();
            for (int i = 0; i < values.length; ++i) {
                CellVector cv = (CellVector)values[i];
                if (event != null && this.cellVectorUpdated(cv, event)) {
                    this.m_permanentCache.set((long)cv.hashCode(), (Object)cv);
                    continue;
                }
                cv.setObsolete();
            }
        }

        private void updateTransientCache(CellVectorChangedEvent event) {
            Object[] values = this.m_transientCache.getCacheValues();
            this.invalidateTransientCache(false);
            for (int i = 0; i < values.length; ++i) {
                CellVector cv = (CellVector)values[i];
                if (event != null && this.cellVectorUpdated(cv, event)) {
                    try {
                        this.m_transientCache.storeInCache((long)cv.hashCode(), (Object)cv);
                    }
                    catch (Exception ex) {
                        cv.setObsolete();
                    }
                    continue;
                }
                cv.setObsolete();
            }
        }

        private boolean cellVectorUpdated(CellVector cv, CellVectorChangedEvent event) {
            if (cv.m_index >= event.index) {
                if (event.howChanged == 2) {
                    if (cv.m_index < event.index + event.count) {
                        return false;
                    }
                    cv.m_index -= event.count;
                } else {
                    cv.m_index += event.count;
                }
            }
            cv.m_version = this.m_currentVersion;
            return true;
        }

        private int getHeldCount() {
            return this.m_heldCache == null ? 0 : this.m_heldCache.count();
        }

        protected abstract int getConformThreshold();

        protected abstract int getDefaultIndex();

        protected abstract int getID();

        protected abstract CellVector getOppositeLabelsVector();

        protected abstract int getScrollableLastPos();

        protected abstract com.sas.visuals.Scrollbar getScrollbar();

        protected abstract int getScrollbarVisibility();

        protected abstract Selection getSelection(CellVectorChangedEvent var1);

        protected abstract boolean isCellVectorsConformed();

        protected abstract boolean isOppositeLabelsVisible();

        protected abstract boolean isPartialCellVectorVisible();

        protected abstract void onSizeCellVector(CellVector var1, Graphics var2);

        protected abstract void remeasureOppositeAxis();

        protected abstract void scrollToCellVector(CellVector var1, boolean var2);

        protected abstract void scrollWindow(CellVector var1);
    }

    private final class PrintInfo {
        private TableView _tableView;
        private int _pageNumber;
        private int _pageWidth;
        private int _pageHeight;
        private int _order;

        PrintInfo(TableView tableView2, Graphics g) throws CloneNotSupportedException {
            double horizontalScale = 1.0;
            double verticalScale = 1.0;
            if (g instanceof PrintGraphics) {
                int srx;
                PrintGraphics pg = (PrintGraphics)g;
                int prx = pg.getPageResolutionHorizontal();
                int pry = pg.getPageResolutionVertical();
                int sry = srx = Toolkit.getDefaultToolkit().getScreenResolution();
                horizontalScale = (double)prx / (double)srx;
                verticalScale = (double)pry / (double)sry;
            }
            this._tableView = tableView2.clone(horizontalScale, verticalScale);
            this._tableView.m_printGraphics = g;
            try {
                this._tableView.setCurrentElement(null);
            }
            catch (PropertyVetoException pg) {
                // empty catch block
            }
            this._tableView.unselect();
            this._tableView.setForeground(tableView2.getForeground());
            this._tableView.setBackground(tableView2.getBackground());
            this._tableView.setFont(tableView2.getFont());
            this._tableView.setPartialColumnVisible(false);
            this._tableView.setPartialRowVisible(false);
            this._tableView.setHorizontalScrollbarVisibility(2);
            this._tableView.setVerticalScrollbarVisibility(2);
            this._tableView.setBorder(new BaseBorder(0));
            this._tableView.setInsets(0, 0, 0, 0);
            this._tableView.getDefaultColumnStyle().setCellsToSizeCount(-1);
            this._tableView.getDefaultRowStyle().setCellsToSizeCount(-1);
            this._order = tableView2.getPrintOrder();
            if (g instanceof PDFGraphics) {
                CellStyle cellStyle = this._tableView.getDefaultCellStyle();
                Length rightMargin = null;
                if (cellStyle.isRightMarginSet()) {
                    rightMargin = cellStyle.getRightMargin();
                }
                if (rightMargin == null || rightMargin.getMagnitude() == 1.0 && rightMargin.getUnit().equals("sp")) {
                    cellStyle.setRightMargin(new Length(4.5, "pt"));
                }
            }
        }

        void dispose() {
            if (this._tableView != null) {
                this._tableView.setDefaultModel(null);
                this._tableView.setModelInterface(null);
                this._tableView = null;
            }
        }

        boolean pageExists(int pageNumber) {
            if (pageNumber == this._pageNumber && pageNumber != 0) {
                return true;
            }
            if (pageNumber < this._pageNumber || pageNumber > this._pageNumber + 1) {
                throw new IllegalStateException("Printing must be sequential starting from 1.");
            }
            if (this._pageNumber == 0) {
                return TableView.this.getLeftColumn() != null || TableView.this.getTopRow() != null;
            }
            Column col = this._tableView.getRightColumn();
            if (col != null && col.next() != null) {
                return true;
            }
            Row row = this._tableView.getBottomRow();
            return row != null && row.next() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void print(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
            this.scroll(pageNumber, pageWidth, pageHeight);
            this.resize(pageWidth, pageHeight);
            try {
                this._tableView.m_printTable = true;
                do {
                    this._tableView.print(g);
                } while ((this._tableView.m_flags & 0x80) != 0);
            }
            finally {
                this._tableView.m_printTable = false;
            }
        }

        Rectangle getPageBounds(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
            this.scroll(pageNumber, pageWidth, pageHeight);
            this.resize(pageWidth, pageHeight);
            return this._tableView.getTableBounds(g);
        }

        int nextPrintScrollDirection() {
            int scrollDirection = -1;
            Column col = this._tableView.getRightColumn();
            Row row = this._tableView.getBottomRow();
            if (this._order == 0) {
                if (col != null && col.next() != null) {
                    scrollDirection = 0;
                } else if (row != null && row.next() != null) {
                    scrollDirection = 1;
                }
            } else if (this._order == 1) {
                if (row != null && row.next() != null) {
                    scrollDirection = 1;
                } else if (col != null && col.next() != null) {
                    scrollDirection = 0;
                }
            }
            return scrollDirection;
        }

        int previousPrintScrollDirection() {
            int scrollDirection = -1;
            Column col = this._tableView.getLeftColumn();
            Row row = this._tableView.getTopRow();
            if (this._order == 0) {
                if (col != null && col.previous() != null) {
                    scrollDirection = 0;
                } else if (row != null && row.previous() != null) {
                    scrollDirection = 1;
                }
            } else if (this._order == 1) {
                if (row != null && row.previous() != null) {
                    scrollDirection = 1;
                } else if (col != null && col.previous() != null) {
                    scrollDirection = 0;
                }
            }
            return scrollDirection;
        }

        boolean isPrintScrollNeeded(int direction) {
            Column col = this._tableView.getRightColumn();
            Row row = this._tableView.getBottomRow();
            boolean scroll = false;
            if (direction == 0) {
                scroll = col != null && col.next() != null;
            } else if (direction == 1) {
                scroll = row != null && row.next() != null;
            }
            return scroll;
        }

        private void resize(int pageWidth, int pageHeight) {
            if (pageWidth != this._pageWidth || pageHeight != this._pageHeight) {
                this._tableView.setSize(pageWidth, pageHeight);
                this._pageWidth = pageWidth;
                this._pageHeight = pageHeight;
            }
        }

        private void scroll(int pageNumber, int pageWidth, int pageHeight) {
            if (this._pageNumber == 0) {
                this._pageNumber = 1;
            } else if (pageNumber > this._pageNumber) {
                Row topRow = this._tableView.getTopRow();
                Column leftColumn = this._tableView.getLeftColumn();
                switch (this._order) {
                    case 0: {
                        this._tableView.scrollHorizontally(1, 1);
                        if (!Util.equal((Object)leftColumn, (Object)this._tableView.getLeftColumn())) break;
                        this._tableView.scrollVertically(1, 1);
                        if (!Util.equal((Object)topRow, (Object)this._tableView.getTopRow())) {
                            this._tableView.scrollHorizontally(-1, 3);
                            break;
                        }
                        throw new IllegalStateException();
                    }
                    case 1: {
                        this._tableView.scrollVertically(1, 1);
                        if (!Util.equal((Object)topRow, (Object)this._tableView.getTopRow())) break;
                        this._tableView.scrollHorizontally(1, 1);
                        if (!Util.equal((Object)leftColumn, (Object)this._tableView.getLeftColumn())) {
                            this._tableView.scrollVertically(-1, 3);
                            break;
                        }
                        throw new IllegalStateException();
                    }
                }
                ++this._pageNumber;
            }
            if (pageNumber != this._pageNumber) {
                throw new IllegalStateException();
            }
        }
    }

    private final class PrintOptionsPanel
    extends com.sas.awt.Panel
    implements ItemListener,
    PropertyChangeListener {
        private TableView _tableView;
        private RadioBox _radioBox;

        public PrintOptionsPanel(TableView tableView2) {
            super((LayoutManager)new AutoSizingGridLayout(1, 1));
            this._tableView = tableView2;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this._tableView.addPropertyChangeListener(this);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this._tableView.removePropertyChangeListener(this);
        }

        @Override
        public void initialize() {
            this.setInsets(5, 5, 5, 5);
            this._radioBox = new RadioBox();
            this._radioBox.initialize();
            this._radioBox.addItemListener(this);
            this._radioBox.addItem(com.sas.table.RB.getStringResource("PrintOptionsPanel.", "rowMajor.txt"));
            this._radioBox.addItem(com.sas.table.RB.getStringResource("PrintOptionsPanel.", "colMajor.txt"));
            this._radioBox.setSelectedIndex(this._tableView.getPrintOrder());
            BaseBorder border = (BaseBorder)this._radioBox.getBorder();
            border.setStyle(3);
            border.setLightSource(10);
            border.setBorderWidth(2);
            border.setTextMargin(5);
            border.setText(com.sas.table.RB.getStringResource("PrintOptionsPanel.", "printOrder.txt"));
            this.add(this._radioBox);
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                this._tableView.setPrintOrder(this._radioBox.getSelectedIndex());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (name != null && name.equals("printOrder")) {
                this._radioBox.setSelectedIndex(this._tableView.getPrintOrder());
            }
        }
    }

    private final class CharacterColumnLabels
    implements StaticColumnLabelInterface {
        private CharacterColumnLabels() {
        }

        public Object getColumnLabel(int index) {
            return (String)AlphabeticSequencer.defaultInstance.get(index);
        }

        public Object[] getColumnLabels(int startIndex, int count) {
            return null;
        }

        public boolean isColumnsLabelSupported() {
            return false;
        }

        public boolean isColumnLabelsSupported() {
            return true;
        }
    }

    private final class NumericRowLabels
    implements StaticRowLabelInterface {
        private NumericRowLabels() {
        }

        public Object getRowLabel(int index) {
            return new Integer(index);
        }

        public Object[] getRowLabels(int startIndex, int count) {
            return null;
        }

        public boolean isRowsLabelSupported() {
            return false;
        }

        public boolean isRowLabelsSupported() {
            return true;
        }
    }

    private final class ColumnLabelsRow
    extends Row {
        protected ColumnLabelsRow(TableView table) {
            super(table, 0);
        }

        @Override
        public LabelCell getLabel() {
            return this.tableView.getOriginCell();
        }

        @Override
        public DataCell getCell(int rowIndex) {
            throw new IllegalStateException();
        }

        protected CellVectorStyle onGetStyle() throws TableException {
            return null;
        }
    }

    private final class RowLabelsColumn
    extends Column {
        protected RowLabelsColumn(TableView table) {
            super(table, 0);
        }

        @Override
        public LabelCell getLabel() {
            return this.tableView.getOriginCell();
        }

        @Override
        public int computePreferredSize(Graphics g) {
            int w;
            int width = super.computePreferredSize(g);
            int rowCount = this.count(100);
            if (rowCount != 0 && (w = TableView.this.getRow(rowCount).getLabel().getPreferredWidth(g)) > width) {
                width = w;
            }
            return width;
        }

        @Override
        public DataCell getCell(int rowIndex) {
            throw new IllegalStateException();
        }

        protected CellVectorStyle onGetStyle() throws TableException {
            return null;
        }
    }

    private final class ColumnFactory
    extends CellVectorFactory {
        private ColumnFactory() {
        }

        public Object getFromCache(long key) {
            return TableView.this.createColumn((int)key);
        }

        @Override
        protected int onGetCount() throws TableException {
            if (TableView.this.getStaticTableModel() != null) {
                return TableView.this.getStaticTableModel().getColumnCount();
            }
            return 0;
        }

        @Override
        protected int onCount(int maxCount) throws TableException {
            if (TableView.this.getStaticTableModel() != null) {
                return TableView.this.getStaticTableModel().countColumns(maxCount);
            }
            return 0;
        }

        @Override
        protected void onSizeCellVector(CellVector cv, Graphics g) {
            TableView.this.onSizeColumn((Column)cv, g);
        }

        @Override
        protected com.sas.visuals.Scrollbar getScrollbar() {
            return TableView.this.getHorizontalScrollbar();
        }

        @Override
        protected int getScrollbarVisibility() {
            return TableView.this.getHorizontalScrollbarVisibility();
        }

        @Override
        protected Selection getSelection(CellVectorChangedEvent event) {
            return new ColumnSelection(TableView.this.getColumn(event.index), TableView.this.getColumn(event.index + event.count - 1));
        }

        @Override
        protected int getConformThreshold() {
            return TableView.this.getColumnsConformedThreshold();
        }

        @Override
        protected int getDefaultIndex() {
            return TableView.this.getDefaultColumnIndex();
        }

        @Override
        protected int getID() {
            return 1;
        }

        @Override
        protected CellVector getOppositeLabelsVector() {
            return TableView.this.getRowLabelsColumn();
        }

        @Override
        protected int getScrollableLastPos() {
            return TableView.this.getDrawableRightEdge();
        }

        @Override
        protected boolean isCellVectorsConformed() {
            return TableView.this.isColumnsConformed();
        }

        @Override
        protected boolean isOppositeLabelsVisible() {
            return TableView.this.isRowLabelsVisible();
        }

        @Override
        protected boolean isPartialCellVectorVisible() {
            return TableView.this.isPartialColumnVisible();
        }

        @Override
        protected void invalidateDisplayedCache() {
            super.invalidateDisplayedCache();
            TableView.this.noteColumnsRefreshed();
        }

        @Override
        protected void remeasureOppositeAxis() {
            TableView.this.remeasureAllRows(true);
        }

        @Override
        protected void scrollToCellVector(CellVector cv, boolean makeFirst) {
            TableView.this.scrollToColumn((Column)cv, makeFirst);
        }

        @Override
        protected void scrollWindow(CellVector cv) {
            TableView.this.scrollWindowHorizontally((Column)cv);
        }
    }

    private final class RowFactory
    extends CellVectorFactory {
        private RowFactory() {
        }

        public Object getFromCache(long key) {
            return TableView.this.createRow((int)key);
        }

        @Override
        protected int onGetCount() throws TableException {
            if (TableView.this.getStaticTableModel() != null) {
                return TableView.this.getStaticTableModel().getRowCount();
            }
            return 0;
        }

        @Override
        protected int onCount(int maxCount) throws TableException {
            if (TableView.this.getStaticTableModel() != null) {
                return TableView.this.getStaticTableModel().countRows(maxCount);
            }
            return 0;
        }

        @Override
        protected void onSizeCellVector(CellVector cv, Graphics g) {
            TableView.this.onSizeRow((Row)cv, g);
        }

        @Override
        protected com.sas.visuals.Scrollbar getScrollbar() {
            return TableView.this.getVerticalScrollbar();
        }

        @Override
        protected int getScrollbarVisibility() {
            return TableView.this.getVerticalScrollbarVisibility();
        }

        @Override
        protected Selection getSelection(CellVectorChangedEvent event) {
            return new RowSelection(TableView.this.getRow(event.index), TableView.this.getRow(event.index + event.count - 1));
        }

        @Override
        protected int getConformThreshold() {
            return TableView.this.getRowsConformedThreshold();
        }

        @Override
        protected int getDefaultIndex() {
            return TableView.this.getDefaultRowIndex();
        }

        @Override
        protected int getID() {
            return 2;
        }

        @Override
        protected CellVector getOppositeLabelsVector() {
            return TableView.this.getColumnLabelsRow();
        }

        @Override
        protected int getScrollableLastPos() {
            return TableView.this.getDrawableBottomEdge();
        }

        @Override
        protected boolean isCellVectorsConformed() {
            return TableView.this.isRowsConformed();
        }

        @Override
        protected boolean isOppositeLabelsVisible() {
            return TableView.this.isColumnLabelsVisible();
        }

        @Override
        protected boolean isPartialCellVectorVisible() {
            return TableView.this.isPartialRowVisible();
        }

        @Override
        protected void invalidateDisplayedCache() {
            super.invalidateDisplayedCache();
            TableView.this.noteRowsRefreshed();
        }

        @Override
        protected void remeasureOppositeAxis() {
            TableView.this.remeasureAllColumns(true);
        }

        @Override
        protected void scrollWindow(CellVector cv) {
            TableView.this.scrollWindowVertically((Row)cv);
        }

        @Override
        protected void scrollToCellVector(CellVector cv, boolean makeFirst) {
            TableView.this.scrollToRow((Row)cv, makeFirst);
        }
    }

    private final class ColumnResizer
    extends RubberBand {
        private Column m_col;

        public ColumnResizer(Column col) {
            this.setConstraints(1);
            this.setMaximumWidth(TableView.this.getDrawableRightEdge() - col.getPosition() + 1);
            this.m_col = col;
        }

        @Override
        public void stop() {
            super.stop();
            this.m_col.setSize(this.getBounds().width);
        }
    }

    private final class RowResizer
    extends RubberBand {
        private Row m_row;

        public RowResizer(Row row) {
            this.setConstraints(0);
            this.setMaximumHeight(TableView.this.getDrawableBottomEdge() - row.getPosition() + 1);
            this.m_row = row;
        }

        @Override
        public void stop() {
            super.stop();
            this.m_row.setSize(this.getBounds().height);
        }
    }

    private final class SelectionListener
    implements ContentsChangedListener {
        private SelectionListener() {
        }

        public void contentsChanged(ContentsChangedEvent e) {
            int i;
            SelectionChangedEvent event = (SelectionChangedEvent)e;
            for (i = 0; i < event.deletions.length; ++i) {
                event.deletions[i].repaint();
            }
            for (i = 0; i < event.additions.length; ++i) {
                event.additions[i].repaint();
            }
        }
    }

    private final class HScrollListener
    extends ScrollListener {
        private HScrollListener() {
        }

        public void fireAlarm(AlarmEvent event) {
            TableView.this.scrollHorizontally(this.scrollForward ? 1 : -1, 4);
            TableView.this.updateCurrentSelection(this.mousePoint);
        }
    }

    private abstract class ScrollListener
    implements AlarmListener {
        public boolean scrollForward;
        public Point mousePoint = new Point();

        private ScrollListener() {
        }
    }

    private final class VScrollListener
    extends ScrollListener {
        private VScrollListener() {
        }

        public void fireAlarm(AlarmEvent event) {
            TableView.this.scrollVertically(this.scrollForward ? 1 : -1, 4);
            TableView.this.updateCurrentSelection(this.mousePoint);
        }
    }

    private final class CellVectorEvent {
        int version;
        int index;
        int count;
        int howChanged;

        CellVectorEvent(int version, CellVectorChangedEvent event) {
            this.version = version;
            this.index = event.index;
            this.count = event.count;
            this.howChanged = event.howChanged;
        }
    }
}

