/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.table.TableElementInterface;
import com.sas.table.TableException;
import com.sas.table.TableView;

public abstract class TableElement
implements TableElementInterface {
    private static final PropertyBag PLACEHOLDER_STYLE = new PropertyBag();
    private StaticPropertyBagInterface m_modelStyle;
    private StaticPropertyBagInterface m_style;
    protected static final String[] emptyModelTypesArray = new String[0];
    protected static final StaticPropertyBagInterface[] emptyModelTypeStylesArray = new StaticPropertyBagInterface[0];
    public final TableView tableView;

    public TableElement(TableView table) {
        this.tableView = table;
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.m_modelStyle = PLACEHOLDER_STYLE;
    }

    public final boolean equals(Object obj) {
        return obj instanceof TableElement && this.equals((TableElement)obj);
    }

    public abstract boolean equals(TableElement var1);

    @Override
    public final TableView getTableView() {
        return this.tableView;
    }

    public StaticPropertyBagInterface getStyle() {
        return this.getThis().m_style;
    }

    public void setStyle(StaticPropertyBagInterface newValue) {
        TableElement self = this.getThis();
        if (self.m_style == newValue) {
            return;
        }
        self.m_style = newValue;
        this.repaint();
    }

    public StaticPropertyBagInterface getModelStyle() {
        TableElement self = this.getThis();
        if (self.m_modelStyle == PLACEHOLDER_STYLE) {
            try {
                self.m_modelStyle = this.onGetModelStyle();
            }
            catch (TableException ex) {
                ex.printStackTrace();
                self.m_modelStyle = null;
            }
        }
        return self.m_modelStyle;
    }

    public abstract StaticPropertyBagInterface getDefaultStyle();

    public abstract StaticPropertyBagInterface getModelDefaultStyle();

    public Object getEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        StaticPropertyBagInterface style = this.getStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        style = this.getModelStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        StaticPropertyBagInterface[] typeStyles = this.getModelTypeStyles();
        for (int i = 0; i < typeStyles.length; ++i) {
            if (!typeStyles[i].containsKey(propertyID)) continue;
            return typeStyles[i].get(propertyID);
        }
        return this.onGetEffectiveStylePropertyValue(propertyID, defaultValue);
    }

    public void getEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag, boolean clearBag) {
        StaticPropertyBagInterface style;
        if (clearBag) {
            bag.removeAll();
        }
        if ((style = this.getStyle()) != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        if ((style = this.getModelStyle()) != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        StaticPropertyBagInterface[] typeStyles = this.getModelTypeStyles();
        for (int i = 0; i < typeStyles.length; ++i) {
            if (!typeStyles[i].containsKey(propertyID)) continue;
            bag.merge((StaticPropertyBagInterface)typeStyles[i].get(propertyID));
        }
        this.onGetEffectiveStylePropertyBag(propertyID, bag);
        if (propertyID == "fontStyle") {
            bag.merge((StaticPropertyBagInterface)this.tableView.getDefaultFontStyle());
        }
    }

    public abstract String[] getModelTypes();

    public abstract StaticPropertyBagInterface[] getModelTypeStyles();

    public final boolean isCurrent() {
        return this.equals(this.tableView.getCurrentElement());
    }

    public boolean isTransient() {
        return this.getStyle() == null;
    }

    @Override
    public void refresh(int flags) {
        if ((flags & 0x10) != 0) {
            this.getThis().m_modelStyle = PLACEHOLDER_STYLE;
        }
        this.repaint();
    }

    public abstract void setObsolete();

    protected abstract TableElement getThis();

    protected abstract StaticPropertyBagInterface onGetModelStyle() throws TableException;

    protected Object onGetEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        StaticPropertyBagInterface style = this.getDefaultStyle();
        if (style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        style = this.getModelDefaultStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        return defaultValue;
    }

    protected void onGetEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        StaticPropertyBagInterface style = this.getDefaultStyle();
        if (style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        if ((style = this.getModelDefaultStyle()) != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
    }
}

