/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;

public abstract class StaticTableInterfaceSupport {
    public static int countColumns(StaticTableInterface table, int maxCount) throws TableException {
        return table.getColumnCount();
    }

    public static int countRows(StaticTableInterface table, int maxCount) throws TableException {
        return table.getRowCount();
    }

    public static Object[][] getCells(StaticTableInterface table, int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Object[][] cells = new Object[rowCount][columnCount];
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                cells[r][c] = table.getCell(startRowIndex + r, startColumnIndex + c);
            }
        }
        return cells;
    }

    public static Class[][] getCellClasses(StaticTableInterface table, int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Class[][] classes = new Class[rowCount][columnCount];
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                classes[r][c] = table.getCellClass(startRowIndex + r, startColumnIndex + c);
            }
        }
        return classes;
    }

    public static Object[] getColumn(StaticTableInterface table, int colIndex) throws TableException {
        int rowCount = table.getRowCount();
        Object[] col = new Object[rowCount];
        for (int r = 1; r <= rowCount; ++r) {
            col[r - 1] = table.getCell(r, colIndex);
        }
        return col;
    }

    public static Object[] getRow(StaticTableInterface table, int rowIndex) throws TableException {
        int colCount = table.getColumnCount();
        Object[] row = new Object[colCount];
        for (int c = 1; c <= colCount; ++c) {
            row[c - 1] = table.getCell(rowIndex, c);
        }
        return row;
    }

    public static Object[] getColumnLabels(StaticColumnLabelInterface table, int startIndex, int count) throws TableException {
        Object[] labels = new Object[count];
        for (int i = 0; i < count; ++i) {
            labels[i] = table.getColumnLabel(startIndex + i);
        }
        return labels;
    }

    public static Object[] getRowLabels(StaticRowLabelInterface table, int startIndex, int count) throws TableException {
        Object[] labels = new Object[count];
        for (int i = 0; i < count; ++i) {
            labels[i] = table.getRowLabel(startIndex + i);
        }
        return labels;
    }
}

