/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.awt.util.Util;
import com.sas.collection.PropertyBag;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.MultidimensionalTableView;
import com.sas.sasserver.mdtable.NamedTypesCustomizerPanel;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.table.AppearanceCustomizerPanel;
import com.sas.table.BorderStyle;
import com.sas.table.CellStyle;
import com.sas.table.FontStyle;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class RangeTypesViewPanel
extends SwingCustomizerPanel
implements PropertyChangeListener,
ItemListener {
    JComboBox _namesCombo;
    DefaultComboBoxModel _namesComboModel;
    AppearanceCustomizerPanel _customizerPanel;
    NamedTypesCustomizerPanel _modelPanel;
    HashMap _hashMap;
    MultidimensionalTableView _tableView;

    public RangeTypesViewPanel() {
        super(RB.getStringResource("RangeTypesDialog.", "viewPanelTitle.txt"));
        this.createGUI();
    }

    protected void createGUI() {
        this.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, false, false, true));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel panel = new JPanel();
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        asgl.setRemainderColumn(2);
        panel.setLayout((LayoutManager)asgl);
        panel.add(new JLabel(RB.getStringResource("RangeTypesDialog.", "namedRangesLabel.txt")));
        this._namesCombo = new JComboBox();
        panel.add(this._namesCombo);
        this._namesCombo.addItemListener(this);
        this.add(panel);
        this._customizerPanel = new AppearanceCustomizerPanel();
        this._customizerPanel.setObject((Object)new com.sas.swing.visuals.table.CellStyle());
        this.add(this._customizerPanel);
    }

    public void setTableView(MultidimensionalTableView tableView) {
        this._tableView = tableView;
        this.refresh();
        StaticDictionaryInterface typeStyles = this._tableView.getCellTypeStyles();
        Set keys = this._hashMap.keySet();
        for (String key : keys) {
            com.sas.swing.visuals.table.CellStyle cellStyle = (com.sas.swing.visuals.table.CellStyle)((Object)this._hashMap.get(key));
            CellStyle tableCellStyle = (CellStyle)((Object)typeStyles.get((Object)key));
            this.mergePropertyBag(tableCellStyle, cellStyle);
        }
    }

    private void mergePropertyBag(PropertyBag fromBag, PropertyBag toBag) {
        String[] keys = fromBag.listKeys();
        if (keys != null && keys.length > 0) {
            int cnt = keys.length;
            for (int i = 0; i < cnt; ++i) {
                Object obj = fromBag.get(keys[i]);
                try {
                    Object newObj = obj;
                    if (obj instanceof FontStyle) {
                        com.sas.swing.visuals.table.FontStyle newFS = new com.sas.swing.visuals.table.FontStyle();
                        this.mergePropertyBag((PropertyBag)obj, newFS);
                        newObj = newFS;
                    } else if (obj instanceof BorderStyle) {
                        com.sas.swing.visuals.table.BorderStyle newBS = new com.sas.swing.visuals.table.BorderStyle();
                        this.mergePropertyBag((PropertyBag)obj, newBS);
                        newObj = newBS;
                    } else if (obj instanceof PropertyBag) {
                        newObj = ((PropertyBag)obj).clone();
                    }
                    toBag.set(keys[i], newObj);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Clone failed for: " + obj);
                    System.out.println("...setting value directly.");
                    toBag.set(keys[i], obj);
                }
            }
        }
    }

    public void setModelPanel(NamedTypesCustomizerPanel modelPanel) {
        this._modelPanel = modelPanel;
    }

    public void onApply() {
        if (this._tableView != null) {
            StaticDictionaryInterface typeStyles = this._tableView.getCellTypeStyles();
            Set keys = this._hashMap.keySet();
            for (String key : keys) {
                com.sas.swing.visuals.table.CellStyle cellStyle = (com.sas.swing.visuals.table.CellStyle)((Object)this._hashMap.get(key));
                CellStyle tableCellStyle = (CellStyle)((Object)typeStyles.get((Object)key));
                tableCellStyle.merge((StaticPropertyBagInterface)cellStyle);
                this.mergePropertyBag(cellStyle, tableCellStyle);
            }
            this._tableView.setCellTypeStylesSaved(true);
        }
    }

    public void onVisible() {
        if (this.refresh()) {
            this._customizerPanel.setObject(this._hashMap.get(this._namesCombo.getSelectedItem()));
            Util.setEnabledOnContainer(this, true);
        } else {
            this._customizerPanel.setObject((Object)new com.sas.swing.visuals.table.CellStyle());
            Util.setEnabledOnContainer(this, false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this._modelPanel) {
            String propertyName = event.getPropertyName();
            if (com.sas.util.Util.equal((Object)propertyName, (Object)"addRange")) {
                this.refresh();
                this._hashMap.put((String)event.getNewValue(), new com.sas.swing.visuals.table.CellStyle());
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"removeRange")) {
                ArrayList rangeNames = this._modelPanel.getRangeNames();
                String name = (String)event.getNewValue();
                if (rangeNames == null || rangeNames.isEmpty() || !rangeNames.contains(name)) {
                    this.refresh();
                    this._hashMap.remove(name);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this._customizerPanel.setObject(this._hashMap.get(this._namesCombo.getSelectedItem()));
        }
    }

    private boolean refresh() {
        boolean hashWasNull = false;
        if (this._hashMap == null) {
            this._hashMap = new HashMap();
            hashWasNull = true;
        }
        if (this._namesComboModel == null) {
            this._namesComboModel = new DefaultComboBoxModel();
            this._namesCombo.setModel(this._namesComboModel);
        } else {
            this._namesComboModel.removeAllElements();
        }
        ArrayList aList = this._modelPanel.getRangeNames();
        if (aList != null && !aList.isEmpty()) {
            this._namesCombo.removeItemListener(this);
            for (String name : aList) {
                this._namesComboModel.addElement(name);
                if (!hashWasNull) continue;
                this._hashMap.put(name, new com.sas.swing.visuals.table.CellStyle());
            }
            this._namesCombo.addItemListener(this);
            return true;
        }
        return false;
    }
}

