/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.ComponentInterface;
import com.sas.ModelInterface;
import com.sas.awt.ActionSource;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.table.RB;
import com.sas.table.TableNavigationInterface;
import com.sas.table.TableNavigationV2Interface;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.ImageView;
import com.sas.visuals.MessageBox;
import com.sas.visuals.MultipleValueEventSourceInterface;
import com.sas.visuals.PushButton;
import com.sas.visuals.Resources;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Vector;

public class NavigationBar
extends CompositeContainer
implements ActionSource,
ActionListener,
MultipleValueEventSourceInterface {
    static final long serialVersionUID = -9011602246613109402L;
    public static final String RB_KEY = "NavigationBar.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.table.TableNavigationInterface"};
    private PushButton firstButton;
    private PushButton prevButton;
    private PushButton nextButton;
    private PushButton lastButton;
    private PushButton insertButton;
    private PushButton commitButton;
    private PushButton deleteButton;
    private boolean confirmCommit;
    private boolean doNotConfirmDelete;
    private int orientation;
    private transient ActionListener listenerList;
    private transient Method m_actionPerformedMethod;
    private transient Method m_actionCommandMethod;
    private String errorMessage;
    private String errorCode;
    public static final String COMMIT = "COMMIT";
    public static final String DELETE = "DELETE";
    public static final String FIRST = "FIRST";
    public static final String INSERT = "INSERT";
    public static final String LAST = "LAST";
    public static final String NEXT = "NEXT";
    public static final String PREVIOUS = "PREVIOUS";
    private static final String TITLE = RB.getStringResource("NavigationBar.", "warning.txt");
    private static final String MSG_COMMIT = RB.getStringResource("NavigationBar.", "commitWarning.txt");
    private static final String MSG_DELETE = RB.getStringResource("NavigationBar.", "deleteWarning.txt");
    private transient TableNavigationInterface model;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static int defaultHeight = 24;
    private static int defaultWidth = 198;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "commitButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "commitBtnVisible.pd.txt")}}, {{"Name", "commitConfirmed"}, {"Description", RB.getStringResource(RB_KEY, "commitConfirmed.pd.txt")}}, {{"Name", "deleteButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "deleteBtnVisible.pd.txt")}}, {{"Name", "deleteConfirmed"}, {"Description", RB.getStringResource(RB_KEY, "deleteConfirmed.pd.txt")}}, {{"Name", "firstButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "firstBtnVisible.pd.txt")}}, {{"Name", "insertButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "insertBtnVisible.pd.txt")}}, {{"Name", "lastButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "lastBtnVisible.pd.txt")}}, {{"Name", "nextButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "nextBtnVisible.pd.txt")}}, {{"Name", "orientation"}, {"Description", RB.getStringResource(RB_KEY, "orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors._NavigationBarOrientationEditor"}}, {{"Name", "previousButtonVisible"}, {"Description", RB.getStringResource(RB_KEY, "prevBtnVisible.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDesc.txt");
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public NavigationBar() {
    }

    public NavigationBar(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listenerList = AWTEventMulticaster.add(this.listenerList, listener);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropTarget(false);
        this.setIDEDnDDropBarrier(true);
        this.orientation = 0;
        this.confirmCommit = true;
        this.init();
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    protected void init() {
        if (this.firstButton == null) {
            this.firstButton = new PushButton(null, null);
        }
        this.firstButton.setActionCommand(FIRST);
        this.firstButton.setDefaultIcon(new ImageView(Resources.getImage((String)"First")));
        this.firstButton.setItem(null);
        this.firstButton.setEnabled(false);
        this.firstButton.removeActionListener(this);
        this.firstButton.addActionListener(this);
        if (this.prevButton == null) {
            this.prevButton = new PushButton(null, null);
        }
        this.prevButton.setActionCommand(PREVIOUS);
        this.prevButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Previous")));
        this.prevButton.setItem(null);
        this.prevButton.setEnabled(false);
        this.prevButton.removeActionListener(this);
        this.prevButton.addActionListener(this);
        if (this.nextButton == null) {
            this.nextButton = new PushButton(null, null);
        }
        this.nextButton.setActionCommand(NEXT);
        this.nextButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Next")));
        this.nextButton.setItem(null);
        this.nextButton.setEnabled(false);
        this.nextButton.removeActionListener(this);
        this.nextButton.addActionListener(this);
        if (this.lastButton == null) {
            this.lastButton = new PushButton(null, null);
        }
        this.lastButton.setActionCommand(LAST);
        this.lastButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Last")));
        this.lastButton.setItem(null);
        this.lastButton.setEnabled(false);
        this.lastButton.removeActionListener(this);
        this.lastButton.addActionListener(this);
        if (this.insertButton == null) {
            this.insertButton = new PushButton(null, null);
        }
        this.insertButton.setActionCommand(INSERT);
        this.insertButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Insert")));
        this.insertButton.setItem(null);
        this.insertButton.setEnabled(false);
        this.insertButton.removeActionListener(this);
        this.insertButton.addActionListener(this);
        if (this.commitButton == null) {
            this.commitButton = new PushButton(null, null);
        }
        this.commitButton.setActionCommand(COMMIT);
        this.commitButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Commit")));
        this.commitButton.setItem(null);
        this.commitButton.setEnabled(false);
        this.commitButton.removeActionListener(this);
        this.commitButton.addActionListener(this);
        if (this.deleteButton == null) {
            this.deleteButton = new PushButton(null, null);
        }
        this.deleteButton.setActionCommand(DELETE);
        this.deleteButton.setDefaultIcon(new ImageView(Resources.getImage((String)"Delete")));
        this.deleteButton.setItem(null);
        this.deleteButton.setEnabled(false);
        this.deleteButton.removeActionListener(this);
        this.deleteButton.addActionListener(this);
        this.layoutButtons();
    }

    @Override
    public void attachModel(ModelInterface mi) {
        super.attachModel(mi);
        Util.addPropertyChangeListener((Object)mi, (PropertyChangeListener)((Object)this));
    }

    @Override
    public void detachModel(ModelInterface mi) {
        super.detachModel(mi);
        Util.removePropertyChangeListener((Object)mi, (PropertyChangeListener)((Object)this));
    }

    protected void fireActionEvent(String actionCommand) {
        this.processEvent(new ActionEvent(this, 1001, actionCommand));
    }

    private void internalSetOrientation(int orientation) {
        int cols = 0;
        if (this.firstButton.isVisible()) {
            ++cols;
        }
        if (this.prevButton.isVisible()) {
            ++cols;
        }
        if (this.nextButton.isVisible()) {
            ++cols;
        }
        if (this.lastButton.isVisible()) {
            ++cols;
        }
        if (this.insertButton.isVisible()) {
            ++cols;
        }
        if (this.commitButton.isVisible()) {
            ++cols;
        }
        if (this.deleteButton.isVisible()) {
            ++cols;
        }
        AutoSizingGridLayout layout = orientation == 0 ? new AutoSizingGridLayout(1, cols, 5, 5) : new AutoSizingGridLayout(cols, 1, 5, 5);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)layout);
    }

    private void layoutButtons() {
        this.internalSetOrientation(this.getOrientation());
        this.removeAll();
        if (this.firstButton.isVisible()) {
            this.add(this.firstButton);
        }
        if (this.prevButton.isVisible()) {
            this.add(this.prevButton);
        }
        if (this.nextButton.isVisible()) {
            this.add(this.nextButton);
        }
        if (this.lastButton.isVisible()) {
            this.add(this.lastButton);
        }
        if (this.insertButton.isVisible()) {
            this.add(this.insertButton);
        }
        if (this.commitButton.isVisible()) {
            this.add(this.commitButton);
        }
        if (this.deleteButton.isVisible()) {
            this.add(this.deleteButton);
        }
        this.validate();
        Dimension ps = this.getPreferredSize();
        ps.width = Math.max(ps.width, 0);
        ps.height = Math.max(ps.height, 0);
        this.setSize(ps);
        this.setSize(this.getPreferredSize());
    }

    public boolean isCommitButtonVisible() {
        return this.commitButton.isVisible();
    }

    public boolean isCommitConfirmed() {
        return this.confirmCommit;
    }

    public boolean isDeleteButtonVisible() {
        return this.deleteButton.isVisible();
    }

    public boolean isDeleteConfirmed() {
        return !this.doNotConfirmDelete;
    }

    public boolean isFirstButtonVisible() {
        return this.firstButton.isVisible();
    }

    public boolean isInsertButtonVisible() {
        return this.insertButton.isVisible();
    }

    public boolean isLastButtonVisible() {
        return this.lastButton.isVisible();
    }

    public boolean isNextButtonVisible() {
        return this.nextButton.isVisible();
    }

    public boolean isPreviousButtonVisible() {
        return this.prevButton.isVisible();
    }

    public void refresh() {
        this.refresh(this.getModelInterface());
    }

    @Override
    public void refresh(ModelInterface mi) {
        if (mi != null && mi instanceof TableNavigationInterface) {
            this.model = (TableNavigationInterface)mi;
            this.firstButton.setEnabled(this.model.isFirstSupported());
            this.prevButton.setEnabled(this.model.isPreviousSupported());
            this.nextButton.setEnabled(this.model.isNextSupported());
            this.lastButton.setEnabled(this.model.isLastSupported());
            this.insertButton.setEnabled(this.model.isInsertSupported());
            this.commitButton.setEnabled(this.model.isCommitSupported());
            this.deleteButton.setEnabled(this.model.isDeleteSupported());
        } else {
            this.firstButton.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.insertButton.setEnabled(false);
            this.commitButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        listener = AWTEventMulticaster.remove(this.listenerList, listener);
    }

    public void setCommitButtonVisible(boolean newValue) {
        if (this.isCommitButtonVisible() == newValue) {
            return;
        }
        this.commitButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("commitButtonVisible", newValue);
    }

    public void setCommitConfirmed(boolean newValue) {
        if (this.confirmCommit == newValue) {
            return;
        }
        this.confirmCommit = newValue;
        this.firePropertyChange("commitConfirmed", this.confirmCommit ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setDeleteButtonVisible(boolean newValue) {
        if (this.isDeleteButtonVisible() == newValue) {
            return;
        }
        this.deleteButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("deleteButtonVisible", newValue);
    }

    public void setDeleteConfirmed(boolean newValue) {
        if (this.doNotConfirmDelete != newValue) {
            return;
        }
        this.doNotConfirmDelete = !newValue;
        this.firePropertyChange("deleteConfirmed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setFirstButtonVisible(boolean newValue) {
        if (this.isFirstButtonVisible() == newValue) {
            return;
        }
        this.firstButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("firstButtonVisible", newValue);
    }

    public void setInsertButtonVisible(boolean newValue) {
        if (this.isInsertButtonVisible() == newValue) {
            return;
        }
        this.insertButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("insertButtonVisible", newValue);
    }

    public void setLastButtonVisible(boolean newValue) {
        if (this.isLastButtonVisible() == newValue) {
            return;
        }
        this.lastButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("lastButtonVisible", newValue);
    }

    public void setNextButtonVisible(boolean newValue) {
        if (this.isNextButtonVisible() == newValue) {
            return;
        }
        this.nextButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("nextButtonVisible", newValue);
    }

    public void setOrientation(int newValue) {
        if (newValue == this.orientation) {
            return;
        }
        Integer oldValue = new Integer(this.orientation);
        this.orientation = newValue;
        Dimension d = this.getSize();
        int temp = d.width;
        d.width = d.height;
        d.height = temp;
        this.internalSetOrientation(this.orientation);
        this.setSize(d);
        this.invalidate();
        this.validate();
        this.firePropertyChange("orientation", oldValue, new Integer(newValue));
    }

    public void setPreviousButtonVisible(boolean newValue) {
        if (this.isPreviousButtonVisible() == newValue) {
            return;
        }
        this.prevButton.setVisible(newValue);
        this.layoutButtons();
        this.repaint();
        this.firePropertyChange("previousButtonVisible", newValue);
    }

    private void firePropertyChange(String property, boolean newValue) {
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        this.firePropertyChange(property, newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void handleError(String message, String errorCode) {
        ErrorHandlerInterface errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            Message msg = message == null ? this.getValidator().getValidationMessage() : new Message(message);
            if (errorCode == null) {
                errorCode = this.getValidator().getValidationMessageCode();
            }
            errorHandler.handleError((ComponentInterface)this, msg, errorCode);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.model == null) {
            return;
        }
        Object source = ae.getSource();
        if (source == this.deleteButton) {
            this.onButtonPressed(DELETE);
        } else if (source == this.commitButton) {
            this.onButtonPressed(COMMIT);
        } else if (source == this.firstButton) {
            this.onButtonPressed(FIRST);
        } else if (source == this.lastButton) {
            this.onButtonPressed(LAST);
        } else if (source == this.prevButton) {
            this.onButtonPressed(PREVIOUS);
        } else if (source == this.nextButton) {
            this.onButtonPressed(NEXT);
        } else if (source == this.insertButton) {
            this.onButtonPressed(INSERT);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object source = pce.getSource();
        if (source == this.model) {
            String propertyName = pce.getPropertyName();
            if (com.sas.util.Util.equal((Object)propertyName, (Object)"previousSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.prevButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"nextSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.nextButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"insertSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.insertButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"commitSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.commitButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"deleteSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.deleteButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"firstSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.firstButton.setEnabled(supported);
            } else if (com.sas.util.Util.equal((Object)propertyName, (Object)"lastSupported")) {
                Boolean supported = (Boolean)pce.getNewValue();
                this.lastButton.setEnabled(supported);
            }
        }
    }

    @Override
    public boolean supportsListenerInterface(Class listenerInterface) {
        boolean rc = false;
        if (listenerInterface == ActionListener.class) {
            rc = true;
        }
        return rc;
    }

    @Override
    public Method getEventMethod(Method lMethod) {
        Method m = null;
        if (this.m_actionPerformedMethod == null) {
            this.m_actionPerformedMethod = this.findActionPerformedMethod();
        }
        if (this.m_actionCommandMethod == null) {
            this.m_actionCommandMethod = this.findActionCommandMethod();
        }
        if (this.m_actionPerformedMethod != null && lMethod.equals(this.m_actionPerformedMethod)) {
            m = this.m_actionCommandMethod;
        }
        return m;
    }

    @Override
    public String[] getEventValues(Method lMethod) {
        String[] e = new String[]{"\"COMMIT\"", "\"DELETE\"", "\"FIRST\"", "\"INSERT\"", "\"LAST\"", "\"NEXT\"", "\"PREVIOUS\""};
        return e;
    }

    protected Method findActionPerformedMethod() {
        Method m = null;
        try {
            m = ActionListener.class.getMethod("actionPerformed", ActionEvent.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return m;
    }

    protected Method findActionCommandMethod() {
        Method m = null;
        try {
            m = ActionEvent.class.getMethod("getActionCommand", new Class[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return m;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
            return;
        }
        super.processEvent(event);
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.listenerList != null) {
            this.listenerList.actionPerformed(event);
        }
    }

    protected void onButtonPressed(String button) {
        boolean rc = true;
        try {
            if (button == DELETE) {
                int buttonClicked = 2;
                if (this.isDeleteConfirmed()) {
                    buttonClicked = MessageBox.showModalMessageBox(TITLE, MSG_DELETE, 6, 4, 3);
                }
                if (buttonClicked == 2) {
                    if (!this.onDelete()) {
                        this.handleError(null, null);
                    }
                    this.fireActionEvent(DELETE);
                    return;
                }
            } else if (button != COMMIT && this.model.isModified() && this.model.isCommitSupported()) {
                if (this.isCommitConfirmed() && (!(this.model instanceof TableNavigationV2Interface) || ((TableNavigationV2Interface)this.model).getAutoCommitLevel() == 0)) {
                    int buttonClicked = MessageBox.showModalMessageBox(TITLE, MSG_COMMIT, 70, 2, 3);
                    if (buttonClicked == 2) {
                        rc = this.onCommit();
                    } else {
                        if (buttonClicked == 64) {
                            this.fireActionEvent(button);
                            return;
                        }
                        if (buttonClicked == 4 && this.model instanceof TableNavigationV2Interface && (button == FIRST || button == PREVIOUS || button == NEXT || button == LAST)) {
                            ((TableNavigationV2Interface)this.model).cancel();
                        }
                    }
                } else {
                    rc = this.onCommit();
                }
            }
            if (rc) {
                if (button == FIRST) {
                    rc = this.onFirst();
                } else if (button == LAST) {
                    rc = this.onLast();
                } else if (button == PREVIOUS) {
                    rc = this.onPrevious();
                } else if (button == NEXT) {
                    rc = this.onNext();
                } else if (button == COMMIT) {
                    rc = this.onCommit();
                } else if (button == INSERT) {
                    rc = this.onInsert();
                }
            }
            this.fireActionEvent(button);
        }
        catch (Throwable e) {
            this.errorMessage = e.getClass().getName() + " : " + e.getMessage();
            this.errorCode = "exception";
            rc = false;
        }
        if (!rc) {
            this.handleError(this.errorMessage, this.errorCode);
        }
    }

    protected boolean onFirst() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)FIRST))) && !(rc = this.model.first())) {
            this.errorMessage = RB.getStringResource(RB_KEY, "unableToGoToFirstRow.txt");
            this.errorCode = INSERT;
        }
        return rc;
    }

    protected boolean onLast() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)LAST))) && !(rc = this.model.last())) {
            this.errorMessage = RB.getStringResource(RB_KEY, "unableToGoToLastRow.txt");
            this.errorCode = INSERT;
        }
        return rc;
    }

    protected boolean onPrevious() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)PREVIOUS))) && !(rc = this.model.previous())) {
            this.errorMessage = RB.getStringResource(RB_KEY, "unableToGoToPreviousRow.txt");
            this.errorCode = INSERT;
        }
        return rc;
    }

    protected boolean onNext() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)NEXT))) && !(rc = this.model.next())) {
            this.errorMessage = RB.getStringResource(RB_KEY, "unableToGoToNextRow.txt");
            this.errorCode = INSERT;
        }
        return rc;
    }

    protected boolean onInsert() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if (validator == null || (rc = validator.validateValue((Object)this, (Object)INSERT))) {
            rc = this.model.insert();
            rc = this.model.insert();
            if (!rc) {
                this.errorMessage = RB.getStringResource(RB_KEY, "unableToInsertRow.txt");
                this.errorCode = INSERT;
            }
        }
        return rc;
    }

    protected boolean onCommit() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)COMMIT))) && !(rc = this.model.commit())) {
            this.errorMessage = RB.getStringResource(RB_KEY, "unableToCommitRow.txt");
            this.errorCode = COMMIT;
        }
        return rc;
    }

    protected boolean onDelete() {
        boolean rc = true;
        ValidationInterface validator = this.getValidator();
        if ((validator == null || (rc = validator.validateValue((Object)this, (Object)DELETE))) && !(rc = this.model.delete())) {
            this.handleError(RB.getStringResource(RB_KEY, "unableToDeleteRow.txt"), DELETE);
        }
        return rc;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, NotActiveException {
        is.defaultReadObject();
        this.init();
    }
}

