/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.table.Cell;
import com.sas.table.CellViewInterface;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.GraphicalCheckBox;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class CheckBoxCell
extends GraphicalCheckBox
implements CellViewInterface {
    public static ImageView defaultImageView;
    public static ImageView selectedImageView;
    private static CheckedImage _checkedImage;
    private static CheckedImage _unCheckedImage;
    Cell cell;

    public CheckBoxCell() {
        this.setFocusPainted(false);
        this.setHorizontalAlignment(256);
        this.initValues();
    }

    @Override
    protected void buttonModelSelected(ButtonModelInterface btnModel) {
        super.buttonModelSelected(btnModel);
        this.cell.setModified(true);
    }

    protected void initValues() {
        this.imageSet = 0;
        if (_checkedImage == null) {
            _checkedImage = new CheckedImage(true);
        }
        if (_unCheckedImage == null) {
            _unCheckedImage = new CheckedImage(false);
        }
        this.setDefaultIcon(_unCheckedImage);
        this.setSelectedIcon(_checkedImage);
        this.setPressedIcon(_checkedImage);
    }

    @Override
    public Cell getCell() {
        return this.cell;
    }

    public Object getObjectData() {
        if (this.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setObjectData(Object object) {
        if (object instanceof Boolean) {
            this.setSelected((Boolean)object);
        }
    }

    @Override
    public String getFormattedData() {
        if (this.isSelected()) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    @Override
    public int getMinimumHeight(Graphics g) {
        if (this.label != null) {
            this.label.setFont(this.cell.getEffectiveFont());
        }
        return this.getMinimumSize().height;
    }

    @Override
    public int getMinimumWidth(Graphics g) {
        if (this.label != null) {
            this.label.setFont(this.cell.getEffectiveFont());
        }
        return this.getMinimumSize().width;
    }

    @Override
    public int getPreferredHeight(Graphics g, int width) {
        if (this.label != null) {
            this.label.setFont(this.cell.getEffectiveFont());
        }
        return this.getPreferredSize().height;
    }

    @Override
    public int getPreferredInputType() {
        return 0;
    }

    @Override
    public int getPreferredOutputType() {
        return 0;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.cell.getWidth();
        int height = this.cell.getHeight();
        this.setSize(width, height);
        if (this.getText() != null && this.getText().length() != 0) {
            if (this.label != null) {
                this.label.setFont(this.cell.getEffectiveFont());
            }
            this.setForeground((Color)this.cell.getEffectiveStylePropertyValue("foregroundColor", Color.black));
        }
        super.paint(g);
    }

    @Override
    public int getPreferredWidth(Graphics g, int height) {
        if (this.label != null) {
            this.label.setFont(this.cell.getEffectiveFont());
        }
        return this.getPreferredSize().width;
    }

    @Override
    public void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    @Override
    public void repaint() {
        if (this.cell != null) {
            this.cell.repaint();
        }
        if (this.getParent() != null) {
            super.repaint();
        }
    }

    @Override
    public void onActiveStateChanged(int oldValue, int newValue, Point point) {
    }

    @Override
    public void setCell(Cell c) {
        this.cell = c;
    }

    @Override
    public void setFormattedData(String data) {
    }

    @Override
    public boolean isPartiallyDisplayed() {
        return false;
    }

    static {
        try {
            defaultImageView = new ImageView(Resources.getImage((String)"res/Check0.gif"));
            selectedImageView = new ImageView(Resources.getImage((String)"res/Check1.gif"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class CheckedImage
    implements IconInterface {
        boolean _checked;
        Insets _insets;
        Dimension _prefSize;

        public CheckedImage(boolean checked) {
            this._checked = checked;
        }

        public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
            SystemColor darker = SystemColor.controlDkShadow;
            SystemColor dark = SystemColor.controlShadow;
            SystemColor lighter = SystemColor.control;
            SystemColor light = SystemColor.controlLtHighlight;
            SystemColor window = SystemColor.window;
            Insets insets = this.getInsets();
            int imgSize = 11;
            g.setColor(dark);
            g.drawLine(x += insets.left, y += insets.top, x + imgSize - 1, y);
            g.drawLine(x, y + 1, x, y + imgSize - 1);
            g.setColor(darker);
            g.drawLine(x + 1, y + 1, x + imgSize - 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + imgSize - 2);
            g.setColor(lighter);
            g.drawLine(x + 1, y + imgSize - 1, x + imgSize - 1, y + imgSize - 1);
            g.drawLine(x + imgSize - 1, y + 1, x + imgSize - 1, y + imgSize - 1);
            g.setColor(light);
            g.drawLine(x, y + imgSize, x + imgSize, y + imgSize);
            g.drawLine(x + imgSize, y, x + imgSize, y + imgSize);
            g.setColor(window);
            g.fillRect(x + 2, y + 2, imgSize - 4 + 1, imgSize - 4 + 1);
            if (this._checked) {
                g.setColor(darker);
                g.drawLine(x + imgSize - 3, y + 3, x + imgSize - 3, y + 3);
                g.drawLine(x + imgSize - 4, y + 4, x + imgSize - 4, y + 5);
                g.drawLine(x + imgSize - 5, y + 6, x + imgSize - 5, y + 7);
                g.drawLine(x + imgSize - 6, y + 8, x + imgSize - 6, y + 8);
                g.drawLine(x + imgSize - 7, y + 7, x + imgSize - 7, y + 7);
                g.drawLine(x + imgSize - 8, y + 6, x + imgSize - 8, y + 6);
                g.setColor(dark);
                g.drawLine(x + imgSize - 4, y + 3, x + imgSize - 4, y + 3);
                g.drawLine(x + imgSize - 3, y + 4, x + imgSize - 3, y + 4);
                g.drawLine(x + imgSize - 5, y + 5, x + imgSize - 5, y + 5);
                g.drawLine(x + imgSize - 4, y + 6, x + imgSize - 4, y + 6);
                g.drawLine(x + imgSize - 5, y + 8, x + imgSize - 5, y + 8);
                g.drawLine(x + imgSize - 6, y + 7, x + imgSize - 6, y + 7);
                g.drawLine(x + imgSize - 7, y + 6, x + imgSize - 7, y + 6);
            }
        }

        public Dimension getPreferredSize() {
            if (this._prefSize == null) {
                this._prefSize = new Dimension(16, 16);
            }
            return this._prefSize;
        }

        public Insets getInsets() {
            if (this._insets == null) {
                this._insets = new Insets(2, 2, 2, 2);
            }
            return this._insets;
        }
    }
}

