/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.GlobalInfoTable;
import com.sas.collection.PropertyBag;
import com.sas.geometry.HorizontalOrientation;
import com.sas.geometry.VerticalOrientation;
import com.sas.measures.Length;
import com.sas.table.BorderStyle;
import com.sas.table.CellActiveStates;
import com.sas.table.FontStyle;
import com.sas.table.TablePainterInterface;
import java.awt.Color;

public class CellStyle
extends PropertyBag {
    static final long serialVersionUID = 4454849133072143763L;
    public static final String ACTIVATED_ON_CURRENT = "activatedOnCurrent";
    public static final String ACTIVATION_LEVEL = "activationLevel";
    public static final String BACKGROUND = "background";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String BORDER_STYLE = "borderStyle";
    public static final String BOTTOM_MARGIN = "bottomMargin";
    public static final String FONT_STYLE = "fontStyle";
    public static final String FOREGROUND_COLOR = "foregroundColor";
    public static final String FORMAT = "format";
    public static final String HORIZONTAL_JUSTIFICATION = "horizontalJustification";
    public static final String INFORMAT = "informat";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String OPACITY = "opacity";
    public static final String RIGHT_MARGIN = "rightMargin";
    public static final String SPLIT_CHARACTER = "splitCharacter";
    public static final String TOP_MARGIN = "topMargin";
    public static final String VERTICAL_JUSTIFICATION = "verticalJustification";
    public static final String VIEW_CLASS = "viewClass";
    public static final String WRAPPED = "wrapped";
    public static final int OPAQUE = 0;
    public static final int SEMI_TRANSPARENT = 1;
    public static final int TRANSPARENT = 2;

    private void nonNullSet(String propertyID, Object newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.set(propertyID, newValue);
    }

    public boolean isActivatedOnCurrent() {
        Boolean v = (Boolean)this.get(ACTIVATED_ON_CURRENT);
        return v;
    }

    public void setActivatedOnCurrent(boolean newValue) {
        this.set(ACTIVATED_ON_CURRENT, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isActivatedOnCurrentSet() {
        return this.containsKey(ACTIVATED_ON_CURRENT);
    }

    public void unsetActivatedOnCurrent() {
        this.remove(ACTIVATED_ON_CURRENT);
    }

    public int getActivationLevel() {
        Integer v = (Integer)this.get(ACTIVATION_LEVEL);
        return v;
    }

    public void setActivationLevel(int newValue) {
        if (!CellActiveStates.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(ACTIVATION_LEVEL, new Integer(newValue));
    }

    public boolean isActivationLevelSet() {
        return this.containsKey(ACTIVATION_LEVEL);
    }

    public void unsetActivationLevel() {
        this.remove(ACTIVATION_LEVEL);
    }

    public TablePainterInterface getBackground() {
        return (TablePainterInterface)this.get(BACKGROUND);
    }

    public void setBackground(TablePainterInterface newValue) {
        this.set(BACKGROUND, newValue);
    }

    public boolean isBackgroundSet() {
        return this.containsKey(BACKGROUND);
    }

    public void unsetBackground() {
        this.remove(BACKGROUND);
    }

    public Color getBackgroundColor() {
        return (Color)this.get(BACKGROUND_COLOR);
    }

    public void setBackgroundColor(Color newValue) {
        this.nonNullSet(BACKGROUND_COLOR, newValue);
    }

    public boolean isBackgroundColorSet() {
        return this.containsKey(BACKGROUND_COLOR);
    }

    public void unsetBackgroundColor() {
        this.remove(BACKGROUND_COLOR);
    }

    public BorderStyle getBorderStyle() {
        return (BorderStyle)((Object)this.get(BORDER_STYLE));
    }

    public void setBorderStyle(BorderStyle newValue) {
        this.nonNullSet(BORDER_STYLE, (Object)newValue);
    }

    public boolean isBorderStyleSet() {
        return this.containsKey(BORDER_STYLE);
    }

    public void unsetBorderStyle() {
        this.remove(BORDER_STYLE);
    }

    public Length getBottomMargin() {
        return (Length)this.get(BOTTOM_MARGIN);
    }

    public void setBottomMargin(Length newValue) {
        this.nonNullSet(BOTTOM_MARGIN, newValue);
    }

    public boolean isBottomMarginSet() {
        return this.containsKey(BOTTOM_MARGIN);
    }

    public void unsetBottomMargin() {
        this.remove(BOTTOM_MARGIN);
    }

    public FontStyle getFontStyle() {
        return (FontStyle)((Object)this.get(FONT_STYLE));
    }

    public void setFontStyle(FontStyle newValue) {
        this.nonNullSet(FONT_STYLE, (Object)newValue);
    }

    public boolean isFontStyleSet() {
        return this.containsKey(FONT_STYLE);
    }

    public void unsetFontStyle() {
        this.remove(FONT_STYLE);
    }

    public Color getForegroundColor() {
        return (Color)this.get(FOREGROUND_COLOR);
    }

    public void setForegroundColor(Color newValue) {
        this.nonNullSet(FOREGROUND_COLOR, newValue);
    }

    public boolean isForegroundColorSet() {
        return this.containsKey(FOREGROUND_COLOR);
    }

    public void unsetForegroundColor() {
        this.remove(FOREGROUND_COLOR);
    }

    public int getHorizontalJustification() {
        return (Integer)this.get(HORIZONTAL_JUSTIFICATION);
    }

    public void setHorizontalJustification(int newValue) {
        if (!HorizontalOrientation.validate((int)newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(HORIZONTAL_JUSTIFICATION, new Integer(newValue));
    }

    public boolean isHorizontalJustificationSet() {
        return this.containsKey(HORIZONTAL_JUSTIFICATION);
    }

    public void unsetHorizontalJustification() {
        this.remove(HORIZONTAL_JUSTIFICATION);
    }

    public Length getLeftMargin() {
        return (Length)this.get(LEFT_MARGIN);
    }

    public void setLeftMargin(Length newValue) {
        this.nonNullSet(LEFT_MARGIN, newValue);
    }

    public boolean isLeftMarginSet() {
        return this.containsKey(LEFT_MARGIN);
    }

    public void unsetLeftMargin() {
        this.remove(LEFT_MARGIN);
    }

    public int getOpacity() {
        return (Integer)this.get(OPACITY);
    }

    public void setOpacity(int newValue) {
        if (newValue != 0 && newValue != 2 && newValue != 1) {
            throw new IllegalArgumentException();
        }
        this.set(OPACITY, new Integer(newValue));
    }

    public boolean isOpacitySet() {
        return this.containsKey(OPACITY);
    }

    public void unsetOpacity() {
        this.remove(OPACITY);
    }

    public Length getRightMargin() {
        return (Length)this.get(RIGHT_MARGIN);
    }

    public void setRightMargin(Length newValue) {
        this.nonNullSet(RIGHT_MARGIN, newValue);
    }

    public boolean isRightMarginSet() {
        return this.containsKey(RIGHT_MARGIN);
    }

    public void unsetRightMargin() {
        this.remove(RIGHT_MARGIN);
    }

    public char getSplitCharacter() {
        return ((Character)this.get(SPLIT_CHARACTER)).charValue();
    }

    public void setSplitCharacter(char newValue) {
        this.set(SPLIT_CHARACTER, new Character(newValue));
    }

    public boolean isSplitCharacterSet() {
        return this.containsKey(SPLIT_CHARACTER);
    }

    public void unsetSplitCharacter() {
        this.remove(SPLIT_CHARACTER);
    }

    public Length getTopMargin() {
        return (Length)this.get(TOP_MARGIN);
    }

    public void setTopMargin(Length newValue) {
        this.nonNullSet(TOP_MARGIN, newValue);
    }

    public boolean isTopMarginSet() {
        return this.containsKey(TOP_MARGIN);
    }

    public void unsetTopMargin() {
        this.remove(TOP_MARGIN);
    }

    public int getVerticalJustification() {
        return (Integer)this.get(VERTICAL_JUSTIFICATION);
    }

    public void setVerticalJustification(int newValue) {
        if (!VerticalOrientation.validate((int)newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(VERTICAL_JUSTIFICATION, new Integer(newValue));
    }

    public boolean isVerticalJustificationSet() {
        return this.containsKey(VERTICAL_JUSTIFICATION);
    }

    public void unsetVerticalJustification() {
        this.remove(VERTICAL_JUSTIFICATION);
    }

    public Class getViewClass() {
        return GlobalInfoTable._loadClass((String)((String)this.get(VIEW_CLASS)));
    }

    public void setViewClass(Class newValue) {
        if (!newValue.isInterface()) {
            Class cellViewInterface = GlobalInfoTable._loadClass((String)"com.sas.table.CellViewInterface");
            for (Class c = newValue; c != null; c = c.getSuperclass()) {
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!interfaces[i].equals(cellViewInterface)) continue;
                    this.set(VIEW_CLASS, newValue.getName().intern());
                    return;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isViewClassSet() {
        return this.containsKey(VIEW_CLASS);
    }

    public void unsetViewClass() {
        this.remove(VIEW_CLASS);
    }

    public boolean isWrapped() {
        return (Boolean)this.get(WRAPPED);
    }

    public void setWrapped(boolean newValue) {
        this.set(WRAPPED, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isWrappedSet() {
        return this.containsKey(WRAPPED);
    }

    public void unsetWrapped() {
        this.remove(WRAPPED);
    }

    public void setMargins(Length newValue) {
        this.setTopMargin(newValue);
        this.setBottomMargin(newValue);
        this.setLeftMargin(newValue);
        this.setRightMargin(newValue);
    }

    public void unsetMargins() {
        this.unsetTopMargin();
        this.unsetBottomMargin();
        this.unsetLeftMargin();
        this.unsetRightMargin();
    }

    static Class getPropertyClass(String property) {
        if (property == ACTIVATED_ON_CURRENT) {
            return Boolean.class;
        }
        if (property == ACTIVATION_LEVEL) {
            return Integer.class;
        }
        if (property == BACKGROUND) {
            return GlobalInfoTable._loadClass((String)"com.sas.table.TablePainterInterface");
        }
        if (property == BACKGROUND_COLOR) {
            return Color.class;
        }
        if (property == BORDER_STYLE) {
            return GlobalInfoTable._loadClass((String)"com.sas.table.BorderStyle");
        }
        if (property == BOTTOM_MARGIN) {
            return GlobalInfoTable._loadClass((String)"com.sas.measures.Length");
        }
        if (property == FONT_STYLE) {
            return GlobalInfoTable._loadClass((String)"com.sas.table.FontStyle");
        }
        if (property == FOREGROUND_COLOR) {
            return Color.class;
        }
        if (property == FORMAT) {
            return GlobalInfoTable._loadClass((String)"com.sas.util.transforms.TransformInterface");
        }
        if (property == HORIZONTAL_JUSTIFICATION) {
            return Integer.class;
        }
        if (property == INFORMAT) {
            return GlobalInfoTable._loadClass((String)"com.sas.util.transforms.TransformInterface");
        }
        if (property == LEFT_MARGIN) {
            return GlobalInfoTable._loadClass((String)"com.sas.measures.Length");
        }
        if (property == OPACITY) {
            return Integer.class;
        }
        if (property == RIGHT_MARGIN) {
            return GlobalInfoTable._loadClass((String)"com.sas.measures.Length");
        }
        if (property == SPLIT_CHARACTER) {
            return Character.class;
        }
        if (property == TOP_MARGIN) {
            return GlobalInfoTable._loadClass((String)"com.sas.measures.Length");
        }
        if (property == VERTICAL_JUSTIFICATION) {
            return Integer.class;
        }
        if (property == VIEW_CLASS) {
            return GlobalInfoTable._loadClass((String)"com.sas.table.CellViewInterface");
        }
        if (property == WRAPPED) {
            return Boolean.class;
        }
        throw new IllegalArgumentException();
    }
}

