/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.GlobalInfoTable;
import com.sas.awt.util.Util;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.table.BorderStyle;
import com.sas.table.CellActiveStates;
import com.sas.table.CellStyle;
import com.sas.table.CellViewInterface;
import com.sas.table.FontStyle;
import com.sas.table.TableElement;
import com.sas.table.TableException;
import com.sas.table.TablePainterInterface;
import com.sas.table.TableView;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.visuals.BaseBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class Cell
extends TableElement {
    private static BorderStyle m_tempBorderStyle = new BorderStyle();
    private static FontStyle m_tempFontStyle = new FontStyle();
    private static final String m_defaultViewClassName = "com.sas.table.TextCell";
    private static final int MOUSE_CAPTURED = 1;
    private static final int KEY_HANDLED = 2;
    private static final int VIEW_DATA_INITIALIZED = 4;
    private int m_activeState = 0;
    private int m_flags;
    private int m_typeStylesVersion = -1;
    private StaticPropertyBagInterface[] m_typeStyles;
    private CellViewInterface m_view;
    private String m_viewClassName;

    protected Cell(TableView table) {
        super(table);
    }

    @Override
    public final boolean equals(TableElement obj) {
        return obj instanceof Cell && this.equals((Cell)obj);
    }

    public abstract boolean equals(Cell var1);

    public int getActiveState() {
        return this.getThisCell().m_activeState;
    }

    private int getMargin(String name, int defaultValue, String pixelType) {
        Length margin;
        block3: {
            block2: {
                margin = (Length)this.getEffectiveStylePropertyValue(name, null);
                if (margin == null) break block2;
                if (margin.getUnitType() != Length.FONT_UNITS) break block3;
            }
            return defaultValue;
        }
        return (int)(margin.getMagnitude((Object)pixelType) + 0.5);
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.getHorizontalPosition(), this.getVerticalPosition(), this.getWidth(), this.getHeight());
    }

    public final Rectangle getDisplayedBounds() {
        return new Rectangle(this.getHorizontalPosition(), this.getVerticalPosition(), this.getDisplayedWidth(), this.getDisplayedHeight());
    }

    public abstract int getDisplayedHeight();

    public abstract int getDisplayedWidth();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getEffectiveFont() {
        FontStyle fontStyle = m_tempFontStyle;
        synchronized (fontStyle) {
            this.getEffectiveStylePropertyBag("fontStyle", (PropertyBagInterface)m_tempFontStyle, true);
            return m_tempFontStyle.getFont();
        }
    }

    @Override
    public void getEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag, boolean clearBag) {
        CellStyle style;
        if (clearBag) {
            bag.removeAll();
        }
        if (this.isDataInvalid() && (style = this.tableView.getDefaultInvalidCellStyle()).containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        super.getEffectiveStylePropertyBag(propertyID, bag, false);
    }

    @Override
    public Object getEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        CellStyle style;
        if (this.isDataInvalid() && (style = this.tableView.getDefaultInvalidCellStyle()).containsKey(propertyID)) {
            return style.get(propertyID);
        }
        return super.getEffectiveStylePropertyValue(propertyID, defaultValue);
    }

    public Graphics getGraphics() {
        if (!this.isDisplayed()) {
            return null;
        }
        Graphics g = this.getTableView().getGraphics();
        if (g == null) {
            return null;
        }
        return g.create(this.getHorizontalPosition(), this.getVerticalPosition(), this.getWidth(), this.getHeight());
    }

    public abstract int getHeight();

    public abstract int getHorizontalPosition();

    public Insets getInsets() {
        return new Insets(this.getMargin("topMargin", 2, "py"), this.getMargin("leftMargin", 3, "px"), this.getMargin("bottomMargin", 2, "py"), this.getMargin("rightMargin", 3, "px"));
    }

    public int getMinimumHeight(Graphics g) {
        int height;
        try {
            height = this.getView().getMinimumHeight(g);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            height = 0;
        }
        Insets insets = this.getInsets();
        return insets.top + height + insets.bottom;
    }

    public int getMinimumWidth(Graphics g) {
        int width;
        try {
            width = this.getView().getMinimumWidth(g);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            width = 0;
        }
        Insets insets = this.getInsets();
        return insets.left + width + insets.right;
    }

    public Object getObjectData() throws TableException {
        CellViewInterface view = this.getView();
        if (view.getPreferredOutputType() == 0) {
            return view.getObjectData();
        }
        return view.getFormattedData();
    }

    public abstract Class getObjectDataClass() throws TableException;

    public final int getPreferredHeight(Graphics g) {
        return this.getPreferredHeight(g, -1);
    }

    public int getPreferredHeight(Graphics g, int width) {
        int height;
        try {
            height = this.getView().getPreferredHeight(g, width);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            height = 0;
        }
        Insets insets = this.getInsets();
        return insets.top + height + insets.bottom;
    }

    public final int getPreferredWidth(Graphics g) {
        return this.getPreferredWidth(g, -1);
    }

    public int getPreferredWidth(Graphics g, int height) {
        int width;
        try {
            width = this.getView().getPreferredWidth(g, height);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            width = 0;
        }
        Insets insets = this.getInsets();
        return insets.left + width + insets.right;
    }

    @Override
    protected final TableElement getThis() {
        return this.getThisCell();
    }

    protected abstract Cell getThisCell();

    @Override
    public String[] getModelTypes() {
        StaticPropertyBagInterface[] typeStyles = this.getModelTypeStyles();
        if (typeStyles.length == 0) {
            return emptyModelTypesArray;
        }
        String[] types = new String[typeStyles.length];
        StaticDictionaryInterface tableTypeStyles = this.tableView.getCellTypeStyles();
        for (int i = 0; i < types.length; ++i) {
            types[i] = (String)tableTypeStyles.getKey((Object)typeStyles[i]);
        }
        return types;
    }

    @Override
    public StaticPropertyBagInterface[] getModelTypeStyles() {
        Cell self = this.getThisCell();
        if (self.m_typeStylesVersion != this.tableView.m_cellTypesVersion) {
            self.m_typeStylesVersion = this.tableView.m_cellTypesVersion;
            self.m_typeStyles = emptyModelTypeStylesArray;
            String[] types = null;
            StaticDictionaryInterface tableTypeStyles = this.tableView.m_staticTableTypeModel != null ? this.tableView.getCellTypeStyles() : null;
            if (tableTypeStyles != null && tableTypeStyles.count() > 0) {
                try {
                    types = this.onGetTypes();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
            if (types != null && types.length != 0) {
                self.m_typeStyles = new StaticPropertyBagInterface[types.length];
                for (int i = 0; i < types.length; ++i) {
                    self.m_typeStyles[i] = (StaticPropertyBagInterface)tableTypeStyles.get((Object)types[i]);
                }
            }
        }
        return self.m_typeStyles;
    }

    public abstract int getVerticalPosition();

    public final CellViewInterface getView() throws TableException {
        Cell self = this.getThisCell();
        String viewClassName = (String)this.getEffectiveStylePropertyValue("viewClass", m_defaultViewClassName);
        if (viewClassName != m_defaultViewClassName) {
            viewClassName = viewClassName.intern();
        }
        if (self.m_view != null && self.m_viewClassName != viewClassName && !this.isModified()) {
            self.m_view = null;
            self.m_flags &= 0xFFFFFFFB;
        }
        if (self.m_view == null) {
            try {
                Class viewClass = GlobalInfoTable.loadClass((String)viewClassName);
                self.m_view = (CellViewInterface)viewClass.newInstance();
            }
            catch (Exception ex) {
                throw new TableException(ex);
            }
            self.m_viewClassName = viewClassName;
            self.m_view.setCell(self);
            if (self.m_activeState != 0) {
                self.m_view.onActiveStateChanged(0, self.m_activeState, null);
            }
        }
        if ((self.m_flags & 4) == 0) {
            if (self.m_view.getPreferredInputType() == 0) {
                self.m_view.setObjectData(this.onGetObjectData());
            } else {
                self.m_view.setFormattedData(this.onGetFormattedData());
            }
            self.m_flags |= 4;
        }
        return self.m_view;
    }

    public abstract int getWidth();

    public boolean isActivated() {
        return this.getActiveState() > 1;
    }

    public boolean isDataInvalid() {
        return this.tableView.getInvalidCells().contains((Object)this.getThisCell());
    }

    public boolean isKeyHandled() {
        return (this.getThisCell().m_flags & 2) != 0;
    }

    public abstract boolean isLabel();

    @Override
    public boolean isModified() {
        return this.tableView.getModifiedCells().contains((Object)this.getThisCell());
    }

    public boolean isMouseCaptured() {
        return (this.getThisCell().m_flags & 1) != 0;
    }

    @Override
    public boolean isSelected() {
        return this.tableView.isCellSelected(this);
    }

    protected String onGetFormattedData() throws TableException {
        Object data = this.onGetObjectData();
        return data == null ? null : (String)ObjectToStringTransform.defaultInstance.transform(data);
    }

    protected abstract Object onGetObjectData() throws TableException;

    protected abstract String[] onGetTypes() throws TableException;

    protected void onPaintBackground(Graphics g, int width, int height) {
        int opacity;
        Integer Opacity = (Integer)this.getEffectiveStylePropertyValue("opacity", null);
        int n = opacity = Opacity != null ? Opacity : 0;
        if (opacity != 2) {
            TablePainterInterface painter = (TablePainterInterface)this.getEffectiveStylePropertyValue("background", null);
            if (painter != null) {
                painter.paintCell(this, g, 0, 0, width, height);
                return;
            }
            g.setColor((Color)this.getEffectiveStylePropertyValue("backgroundColor", SystemColor.window));
            g.fillRect(0, 0, width, height);
        } else {
            this.tableView.setScrollingSmooth(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPaintBorder(Graphics g, int width, int height) {
        BorderStyle borderStyle = m_tempBorderStyle;
        synchronized (borderStyle) {
            int border_type;
            this.getEffectiveStylePropertyBag("borderStyle", (PropertyBagInterface)m_tempBorderStyle, true);
            Integer borderType = (Integer)m_tempBorderStyle.get("type", null);
            if (borderType != null && (border_type = borderType.intValue()) != 0) {
                int border_width;
                Length borderWidth = (Length)m_tempBorderStyle.get("width", null);
                Color highlightColor = (Color)m_tempBorderStyle.get("highlightColor", null);
                Color shadowColor = (Color)m_tempBorderStyle.get("shadowColor", null);
                Integer borderSides = (Integer)m_tempBorderStyle.get("sides", null);
                Integer lightSource = (Integer)m_tempBorderStyle.get("lightSource", null);
                int light_source = lightSource == null ? 5 : lightSource;
                int border_sides = borderSides == null ? 15 : borderSides;
                int n = border_width = borderWidth == null ? 1 : (int)borderWidth.getMagnitude((Object)"px");
                if (highlightColor == null && (highlightColor = (Color)this.getEffectiveStylePropertyValue("foregroundColor", null)) == null) {
                    highlightColor = this.tableView.getForeground();
                }
                if (shadowColor == null) {
                    shadowColor = highlightColor;
                }
                if (highlightColor != null) {
                    BaseBorder.paintBorder(g, 0, 0, width, height, highlightColor, shadowColor, border_type, border_width, light_source, border_sides);
                }
            }
        }
    }

    protected void onPaintForeground(Graphics g, int width, int height) throws TableException {
        this.getView().paint(g);
    }

    protected abstract void onWriteObjectData() throws TableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int cx = this.getHorizontalPosition();
        int cy = this.getVerticalPosition();
        int cw = this.getWidth();
        int ch = this.getHeight();
        Graphics cg = g.create(cx, cy, cw, ch);
        try {
            this.onPaintBackground(cg, cw, ch);
            this.onPaintForeground(cg, cw, ch);
            this.onPaintBorder(cg, cw, ch);
            if (this.isSelected()) {
                Util.invertRect(cg, 0, 0, cw, ch);
            }
            if (this.isCurrent() && !this.isActivated() && this.tableView.isCurrentElementHighlighted()) {
                Util.drawFocusRect(cg, 0, 0, cw - 1, ch - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            cg.dispose();
        }
    }

    public void processFocusEvent(FocusEvent event) {
        this.m_view.processFocusEvent(event);
    }

    public void processKeyEvent(KeyEvent event) {
        this.setKeyHandled(true);
        this.m_view.processKeyEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMouseEvent(MouseEvent event) {
        int xOffset = this.getHorizontalPosition();
        int yOffset = this.getVerticalPosition();
        int id = event.getID();
        if (id == 501) {
            this.setMouseCaptured(true);
        } else if (id == 502) {
            this.setMouseCaptured(false);
        }
        try {
            event.translatePoint(-xOffset, -yOffset);
            this.m_view.processMouseEvent(event);
        }
        finally {
            event.translatePoint(xOffset, yOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMouseMotionEvent(MouseEvent event) {
        System.out.println("cell process mme");
        int xOffset = this.getHorizontalPosition();
        int yOffset = this.getVerticalPosition();
        try {
            event.translatePoint(-xOffset, -yOffset);
            this.m_view.processMouseMotionEvent(event);
        }
        finally {
            event.translatePoint(xOffset, yOffset);
        }
    }

    @Override
    public void refresh(int flags) {
        Cell self = this.getThisCell();
        if ((flags & 1) != 0) {
            self.m_flags &= 0xFFFFFFFB;
            this.setModified(false);
        }
        self.m_typeStylesVersion = -1;
        super.refresh(flags);
    }

    @Override
    public final void repaint() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(int x, int y, int width, int height) {
        if (!this.isDisplayed()) {
            return;
        }
        int x1 = this.getHorizontalPosition();
        int y1 = this.getVerticalPosition();
        int x2 = x1 + this.getWidth() - 1;
        int y2 = y1 + this.getHeight() - 1;
        x = x > 0 ? x1 + x : x1;
        y = y > 0 ? y1 + y : y1;
        if (x2 - width < x) {
            width = x2 - x + 1;
        }
        if (y2 - height < y) {
            height = y2 - y + 1;
        }
        if (width > 0 && height > 0) {
            this.tableView.repaint(x, y, width, height);
        }
    }

    public final void setActiveState(int newValue) {
        this.setActiveState(newValue, null);
    }

    public void setActiveState(int newValue, Point point) {
        if (this.getActiveState() == newValue) {
            return;
        }
        if (!CellActiveStates.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        Cell self = this.getThisCell();
        int oldValue = self.m_activeState;
        if (point != null) {
            point = new Point(point.x - this.getHorizontalPosition(), point.y - this.getVerticalPosition());
        }
        self.m_activeState = newValue;
        if (self.m_view != null) {
            self.m_view.onActiveStateChanged(oldValue, newValue, point);
        }
    }

    public void setKeyHandled(boolean newValue) {
        this.getThisCell().m_flags = newValue ? (this.getThisCell().m_flags |= 2) : (this.getThisCell().m_flags &= 0xFFFFFFFD);
    }

    public void setModified(boolean newValue) {
        if (newValue) {
            if ((this.getThisCell().m_flags & 4) == 0) {
                return;
            }
            this.tableView.noteCellModified(this.getThisCell());
        } else {
            this.tableView.noteCellRefreshed(this.getThisCell());
        }
    }

    public void setMouseCaptured(boolean newValue) {
        this.getThisCell().m_flags = newValue ? (this.getThisCell().m_flags |= 1) : (this.getThisCell().m_flags &= 0xFFFFFFFE);
    }

    @Override
    public void setObsolete() {
        this.refresh(31);
        this.m_view = null;
    }

    public void writeObjectData() throws TableException {
        this.onWriteObjectData();
    }
}

