/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.beans.Util;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.table.ColumnLabelInterface;
import com.sas.table.FormattedDataInterface;
import com.sas.table.RowLabelInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticFormattedDataInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.StaticTableStyleInterface;
import com.sas.table.StaticTableTypeInterface;
import com.sas.table.TableException;
import com.sas.table.TableInterface;
import java.beans.PropertyChangeListener;

public class TableView
extends BaseTableView
implements ViewDefaultModel {
    protected StaticTableInterface m_defaultModel;
    protected StaticTableInterface m_model;

    @Override
    public void initialize() {
        super.initialize();
        if (this.getModel() == null && this.getDefaultModel() != null) {
            this.setModel(this.getDefaultModel());
        }
    }

    public boolean isDefaultModelAttached() {
        return this.getDefaultModel() == this.getModel();
    }

    public StaticTableInterface getDefaultModel() {
        return this.m_defaultModel;
    }

    public void setDefaultModel(StaticTableInterface newValue) {
        if (newValue == this.m_defaultModel) {
            return;
        }
        StaticTableInterface oldValue = this.m_defaultModel;
        this.m_defaultModel = newValue;
        this.firePropertyChange("defaultModel", oldValue, newValue);
        StaticTableInterface model = this.getModel();
        if (model == oldValue || model == null) {
            this.setModel(this.m_defaultModel);
        }
    }

    public final void refresh() {
        this.refresh(this.getModel());
    }

    public synchronized void refresh(StaticTableInterface model) {
        this.refreshContentsChangedQueue();
    }

    public StaticTableInterface getModel() {
        return this.m_model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setModel(StaticTableInterface model) {
        StaticTableInterface oldModel = this.getModel();
        if (oldModel == model) {
            return;
        }
        if (model == null) {
            this.refresh(null);
            if (oldModel instanceof ContentsChangedSource) {
                ((ContentsChangedSource)oldModel).removeContentsChangedListener((ContentsChangedListener)this);
            }
            if (oldModel != null) {
                Util.removePropertyChangeListener((Object)oldModel, (PropertyChangeListener)this);
            }
            boolean oldValue = false;
            try {
                oldValue = this.setFlag(0x100000, true);
                this.setCurrentElement();
                this.unselect();
            }
            finally {
                this.setFlag(0x100000, oldValue);
            }
            this.m_model = null;
            this.m_staticTableModel = null;
            this.m_tableModel = null;
            this.m_staticColumnLabelModel = null;
            this.m_columnLabelModel = null;
            this.m_staticRowLabelModel = null;
            this.m_rowLabelModel = null;
            this.m_staticFormattedDataModel = null;
            this.m_formattedDataModel = null;
            this.m_staticTableStyleModel = null;
            this.m_staticTableTypeModel = null;
        } else {
            if (this.isDefaultModelAttached() && this.getDefaultModel() != null) {
                this.setModel(null);
            }
            if (this.getModel() != null) {
                this.setModel(null);
            }
            this.refresh(model);
            this.m_model = model;
            this.m_staticTableModel = model;
            if (model instanceof TableInterface) {
                this.m_tableModel = (TableInterface)model;
            }
            if (model instanceof StaticColumnLabelInterface) {
                this.m_staticColumnLabelModel = (StaticColumnLabelInterface)model;
                try {
                    if (!this.m_staticColumnLabelModel.isColumnLabelsSupported()) {
                        this.m_staticColumnLabelModel = null;
                    } else if (model instanceof ColumnLabelInterface) {
                        this.m_columnLabelModel = (ColumnLabelInterface)model;
                    }
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                    this.m_staticColumnLabelModel = null;
                }
            }
            if (this.m_staticColumnLabelModel == null) {
                this.m_staticColumnLabelModel = new BaseTableView.CharacterColumnLabels();
            }
            if (model instanceof StaticRowLabelInterface) {
                this.m_staticRowLabelModel = (StaticRowLabelInterface)model;
                try {
                    if (!this.m_staticRowLabelModel.isRowLabelsSupported()) {
                        this.m_staticRowLabelModel = null;
                    } else if (model instanceof RowLabelInterface) {
                        this.m_rowLabelModel = (RowLabelInterface)model;
                    }
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                    this.m_staticRowLabelModel = null;
                }
            }
            if (this.m_staticRowLabelModel == null) {
                this.m_staticRowLabelModel = new BaseTableView.NumericRowLabels();
            }
            if (model instanceof StaticFormattedDataInterface) {
                this.m_staticFormattedDataModel = (StaticFormattedDataInterface)model;
                if (model instanceof FormattedDataInterface) {
                    this.m_formattedDataModel = (FormattedDataInterface)model;
                }
            }
            if (model instanceof StaticTableTypeInterface) {
                this.m_staticTableTypeModel = (StaticTableTypeInterface)model;
            }
            if (model instanceof StaticTableStyleInterface) {
                this.m_staticTableStyleModel = (StaticTableStyleInterface)model;
            }
            if (model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
            Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
        }
        this.firePropertyChange("model", oldModel, this.m_model);
        this.refresh();
    }

    @Override
    protected void cloneModelIndependentState(BaseTableView clone, double horizontalScale, double verticalScale) throws CloneNotSupportedException {
        ((TableView)clone).setModel(this.getModel());
        super.cloneModelIndependentState(clone, horizontalScale, verticalScale);
    }
}

