/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.OrderedCollection;
import com.sas.lang.StringDataInterface;
import com.sas.swing.visuals.table.CellView;
import com.sas.table.TableException;
import com.sas.util.CharBuffer;
import com.sas.util.transforms.ObjectToStringTransform;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;

public class PasswordTextCell
extends CellView
implements StringDataInterface {
    public static final String ECHO_CHAR = "ECHO_CHAR";
    private static final Integer CENTER = new Integer(256);
    private static final String DOTS = "...";
    private static final Integer MIDDLE = new Integer(256);
    private static final char NEW_LINE = '\n';
    private static final Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);
    private static final int NOT_SET = -999;
    private static final int TC_NUMERIC_DATA = 1;
    private static final int TC_LINES_DIRTY = 2;
    private static final int TC_LINES_DIRTY_LIGHT = 4;
    private static final int TC_WRAPPED = 8;
    private static final int TC_TEXT_SELECTED = 16;
    private static final int TC_HOLD_PAINT = 128;
    private transient char m_breakChar;
    private transient int m_cachedHeight;
    private transient int m_cachedWidth;
    private transient int m_cachedVJust;
    private transient Caret m_caret;
    private transient boolean m_clipped;
    private transient Line m_currentLine;
    private transient int m_flags = 0;
    private transient Insets m_insets;
    private transient Lines m_lines;
    private transient int m_maxStringWidth = -1;
    private transient int m_maxTextWidth;
    private transient int m_minStringWidth = 0;
    private transient int m_renderOffX;
    private transient int m_renderOffY;
    private transient int m_selectionEnd = 0;
    private transient int m_selectionStart = 0;
    private transient CharBuffer m_text;
    private transient String m_textStr;
    private transient int m_verticalOffset;

    private boolean backspaceKeyPressed(KeyEvent event) {
        if (this.isFlagSet(16)) {
            if (this.isMinimumLengthValid(this.m_text.length() - Math.abs(this.m_selectionEnd - this.m_selectionStart))) {
                this.removeSelection();
            }
        } else if (this.getCaretPosition() > 0 && this.isMinimumLengthValid(this.m_text.length() - 1)) {
            this.m_text.removeAt(this.getCaretPosition() - 1);
            this.moveCaret(-1, true);
            this.cell.setModified(true);
        }
        return true;
    }

    private boolean deleteKeyPressed(KeyEvent event) {
        if (this.isFlagSet(16)) {
            if (this.isMinimumLengthValid(this.m_text.length() - Math.abs(this.m_selectionEnd - this.m_selectionStart))) {
                this.removeSelection();
            }
        } else if (this.getCaretPosition() != this.m_text.length() && this.isMinimumLengthValid(this.m_text.length() - 1)) {
            this.m_text.removeAt(this.getCaretPosition());
            this.moveCaret(0, true);
            this.cell.setModified(true);
        }
        return true;
    }

    private boolean downKeyPressed(KeyEvent event) {
        if (this.cell.getActiveState() == 2) {
            this.cell.setKeyHandled(false);
        }
        if (this.isFlagSet(16)) {
            int position = Math.max(this.m_selectionStart, this.m_selectionEnd);
            int offset = 0;
            Line line = this.getLineAtCharPosition(position);
            if (line != null) {
                offset = position - line.charOffset;
                line = this.m_lines.getNextLine(line);
            }
            if (line != null) {
                int newPos = line.charOffset + (offset <= line.charLength ? offset : line.charLength);
                this.moveCaret(newPos - this.getCaretPosition(), false);
            } else if (position != this.getCaretPosition()) {
                this.setCaretPosition(position);
            } else if (!this.isFlagSet(128)) {
                this.cell.repaint();
            }
            this.unsetFlag(16);
        } else {
            Line next = this.m_lines.getNextLine(this.m_caret.containingLine);
            if (next != null) {
                int newPos = next.charOffset + (this.m_caret.position <= next.charLength ? this.m_caret.position : next.charLength);
                this.moveCaret(newPos - this.getCaretPosition(), false);
            }
        }
        return true;
    }

    private boolean endKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (controlDown && shiftDown) {
            this.setSelected(this.m_text.length());
        } else if (controlDown) {
            this.unsetFlag(16);
            this.moveCaret(this.m_text.length() - this.getCaretPosition(), false);
        } else if (shiftDown) {
            this.setSelected(this.m_caret.containingLine.charLength);
        } else {
            this.unsetFlag(16);
            int amt = this.m_caret.containingLine.charLength - this.m_caret.position;
            this.moveCaret(amt, false);
        }
        return true;
    }

    private void ensureCaretIsVisible(int caretHeight) {
        int dh;
        int topEdge = this.getTopMargin();
        int leftEdge = this.getLeftMargin();
        int rightEdge = this.getRightEdge();
        int bottomEdge = this.getBottomEdge();
        int dw = this.getDisplayedRightEdge();
        if (rightEdge > dw) {
            rightEdge = dw;
        }
        if (bottomEdge > (dh = this.getDisplayedBottomEdge())) {
            bottomEdge = dh;
        }
        int effLocX = this.m_caret.location.x + this.m_renderOffX;
        int effLocY = this.m_caret.location.y + this.m_renderOffY;
        if (effLocX < leftEdge || effLocX >= rightEdge) {
            this.m_renderOffX = this.m_caret.location.x < leftEdge ? leftEdge - this.m_caret.location.x : (this.m_caret.location.x >= rightEdge ? rightEdge - this.m_caret.location.x : 0);
        }
        if (effLocY < topEdge || effLocY + caretHeight - 1 > bottomEdge) {
            this.m_renderOffY = this.m_caret.location.y < topEdge ? topEdge - this.m_caret.location.y : (this.m_caret.location.y + caretHeight - 1 > bottomEdge ? bottomEdge - (this.m_caret.location.y + caretHeight) : 0);
        }
    }

    private boolean enterKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!controlDown || !shiftDown) {
            if (controlDown) {
                this.m_text.insert(this.getCaretPosition(), '\n');
                this.moveCaret(1, true);
                this.cell.setModified(true);
            } else if (!shiftDown) {
                this.cell.setKeyHandled(false);
            }
        }
        return true;
    }

    private void formatHorizontal(Line line, int horzJust) {
        int width = this.m_cachedWidth;
        if (horzJust == -999) {
            horzJust = this.getHorizontalJustification();
        }
        if (horzJust == 512) {
            horzJust = this.isFlagSet(1) ? 2 : 1;
        }
        switch (horzJust) {
            case 257: {
                if (line.pixelLength > width) {
                    line.pixelOffset = 0;
                    break;
                }
            }
            case 258: {
                if (line.pixelLength > width) {
                    line.pixelOffset = width - line.pixelLength;
                    break;
                }
            }
            case 256: {
                line.pixelOffset = (width - line.pixelLength) / 2;
                break;
            }
            case 2: {
                line.pixelOffset = width - line.pixelLength;
                break;
            }
            default: {
                line.pixelOffset = 0;
            }
        }
    }

    private void formatLight(Graphics g, int fontHeight, int horzJust, int vertJust) {
        int cnt = this.m_lines.count();
        for (int i = 0; i < cnt; ++i) {
            this.formatHorizontal((Line)this.m_lines.get(i), horzJust);
        }
        this.formatVertical(g, fontHeight, vertJust);
        this.unsetFlag(4);
    }

    private void formatText(Graphics g, FontMetrics fm) {
        this.formatText(g, fm, this.m_cachedWidth, this.isWrapped(), this.getHorizontalJustification(), this.getVerticalJustification(), false);
    }

    private void formatText(Graphics g, FontMetrics fm, int width, boolean wrapping, int horzJust, int vertJust, boolean measuring) {
        this.m_clipped = false;
        CharBuffer cbuf = this.isBeingEdited() ? new CharBuffer(this.m_text) : new CharBuffer(this.m_textStr);
        Character echoCharacter = this.getEchoChar();
        if (echoCharacter != null) {
            char echoChar = echoCharacter.charValue();
            int count = cbuf.length();
            cbuf = new CharBuffer();
            for (int i = 0; i < count; ++i) {
                cbuf.append(echoChar);
            }
        }
        int charOffset = 0;
        boolean useEmptyLine = false;
        this.m_breakChar = this.getSplitCharacter();
        if (this.m_lines == null) {
            this.m_lines = new Lines();
        } else {
            this.m_lines.removeAll();
        }
        this.m_maxTextWidth = 0;
        this.m_currentLine = null;
        int fontHeight = fm.getHeight();
        while (!cbuf.isEmpty()) {
            Line line = new Line();
            useEmptyLine = this.getLineText(fm, line, cbuf, wrapping, width);
            line.charLength = line.text.length();
            line.pixelLength = fm.stringWidth(line.text);
            line.charOffset = charOffset;
            charOffset += line.charLength + line.trailingSpaces;
            if (line.containsBreak) {
                ++charOffset;
            }
            if (line.pixelLength > this.m_maxTextWidth) {
                this.m_maxTextWidth = line.pixelLength;
            }
            if (this.m_currentLine == null) {
                this.m_currentLine = line;
            }
            this.m_lines.add(line);
        }
        if (this.m_lines.count() == 0) {
            useEmptyLine = true;
        }
        if (useEmptyLine) {
            Line emptyLine = new Line();
            emptyLine.text = "";
            emptyLine.charLength = 0;
            emptyLine.charOffset = this.isBeingEdited() ? this.m_text.length() : this.m_textStr.length();
            emptyLine.containsBreak = false;
            emptyLine.pixelLength = 0;
            this.m_lines.add(emptyLine);
        }
        if (!measuring) {
            this.formatLight(g, fontHeight, horzJust, vertJust);
        }
        if (this.m_caret != null) {
            this.setCaretPosition(this.getCaretPosition());
        }
        this.unsetFlag(2);
    }

    private void formatVertical(Graphics g, int lineHeight, int vertJust) {
        int textHeight = lineHeight * this.m_lines.count();
        int formatHeight = this.m_cachedHeight;
        if (vertJust == -999) {
            vertJust = this.getVerticalJustification();
        }
        switch (vertJust) {
            case 260: {
                if (textHeight > formatHeight) {
                    this.m_verticalOffset = 0;
                    break;
                }
            }
            case 264: {
                if (textHeight > formatHeight) {
                    this.m_verticalOffset = formatHeight - textHeight;
                    break;
                }
            }
            case 256: {
                this.m_verticalOffset = (formatHeight - textHeight) / 2;
                break;
            }
            case 8: {
                this.m_verticalOffset = formatHeight - textHeight;
                break;
            }
            default: {
                this.m_verticalOffset = 0;
            }
        }
        this.m_verticalOffset += this.getTopMargin();
    }

    private int getBottomEdge() {
        return this.cell.getHeight() - this.getBottomMargin();
    }

    private int getDisplayedBottomEdge() {
        return this.cell.getDisplayedHeight() - this.getBottomMargin();
    }

    public int getCaretPosition() {
        if (this.m_caret == null) {
            return -1;
        }
        if (this.m_caret.containingLine != null) {
            return this.m_caret.containingLine.charOffset + this.m_caret.position;
        }
        return this.m_caret.position;
    }

    private int getCaretPosition(Line line, int xPos) {
        Graphics g = this.cell.tableView.getGraphics();
        return this.getCaretPosition(line, xPos, g.getFontMetrics(this.cell.getEffectiveFont()));
    }

    private int getCaretPosition(Line line, int xPos, FontMetrics fm) {
        int distance = xPos - (this.getLeftMargin() + line.pixelOffset + this.m_renderOffX);
        if (distance <= 0) {
            return line.charOffset;
        }
        if (distance > line.pixelLength) {
            return line.charLength + line.charOffset;
        }
        int pos = 0;
        int cnt = line.charLength;
        for (int i = 1; i <= cnt; ++i) {
            pos = i;
            int strWidth = fm.stringWidth(line.text.substring(0, i));
            if (strWidth <= distance - 3) continue;
            return pos + line.charOffset;
        }
        return pos + line.charOffset;
    }

    private int getDrawableHeight() {
        return this.cell.getHeight() - (this.getTopMargin() + this.getBottomMargin());
    }

    private int getDrawableWidth() {
        return this.cell.getWidth() - (this.getLeftMargin() + this.getRightMargin());
    }

    @Override
    public String getFormattedData() {
        return this.getText();
    }

    private int getHorizontalJustification() {
        return (Integer)this.cell.getEffectiveStylePropertyValue("horizontalJustification", CENTER);
    }

    private Insets getInsets() {
        if (this.m_insets == null) {
            this.m_insets = this.cell.getInsets();
        }
        return this.m_insets;
    }

    private int getTopMargin() {
        return this.getInsets().top;
    }

    private int getBottomMargin() {
        return this.getInsets().bottom;
    }

    private int getLeftMargin() {
        return this.getInsets().left;
    }

    private int getRightMargin() {
        return this.getInsets().right;
    }

    private Line getLineAtCharPosition(int position) {
        if (position < 0 || position > this.m_text.length()) {
            return null;
        }
        int offset = 0;
        int cnt = this.m_lines.count();
        for (int i = 0; i < cnt; ++i) {
            Line line = (Line)this.m_lines.get(i);
            offset += line.charLength + line.trailingSpaces;
            if (line.containsBreak && position == ++offset) {
                return this.m_lines.getNextLine(line);
            }
            if (line.trailingSpaces != 0 && position == offset) {
                Line nextLine = this.m_lines.getNextLine(line);
                return nextLine != null ? nextLine : line;
            }
            if (position > offset) continue;
            return line;
        }
        return null;
    }

    private Line getLineAtPixelPosition(int yPos) {
        Graphics g = this.cell.tableView.getGraphics();
        FontMetrics fm = g.getFontMetrics(this.cell.getEffectiveFont());
        return this.getLineAtPixelPosition(yPos, fm);
    }

    private Line getLineAtPixelPosition(int yPos, FontMetrics fm) {
        int distance = yPos - (this.getTopMargin() + this.m_verticalOffset + this.m_renderOffY);
        if (distance >= 0) {
            int numLines = distance / fm.getHeight();
            if (numLines < this.m_lines.count() - 1) {
                return (Line)this.m_lines.get(numLines);
            }
            return this.m_lines.getLastLine();
        }
        return this.m_lines.getFirstLine();
    }

    private boolean getLineText(FontMetrics fm, Line line, CharBuffer cbuf, boolean wrapping, int width) {
        if (width <= 0) {
            wrapping = false;
        }
        boolean prevCharSpace = false;
        int prevSpacePos = -1;
        int cnt = cbuf.length();
        for (int i = 0; i < cnt; ++i) {
            char ch = cbuf.charAt(i);
            if (ch == this.m_breakChar || ch == '\n') {
                line.text = cbuf.substring(0, i);
                line.containsBreak = true;
                cbuf.remove(0, i + 1);
                return cbuf.isEmpty();
            }
            if (Character.isSpaceChar(ch)) {
                if (wrapping) {
                    String s = i != 0 ? cbuf.substring(0, i) : String.valueOf(ch);
                    if (fm.stringWidth(s) > width) {
                        int index = i;
                        if (prevSpacePos != -1 && prevSpacePos < i - 1) {
                            index = prevSpacePos;
                        }
                        int spacePos = this.getLastSpaceIndex(index, cnt, cbuf);
                        if (prevSpacePos != -1) {
                            line.text = cbuf.substring(0, prevSpacePos);
                            line.trailingSpaces = spacePos - prevSpacePos + 1;
                        } else {
                            line.text = s;
                            line.trailingSpaces = spacePos - i + 1;
                        }
                        if (spacePos + 1 != 0) {
                            cbuf.remove(0, spacePos + 1);
                        }
                        return false;
                    }
                    if (!prevCharSpace) {
                        prevSpacePos = i;
                    }
                }
                prevCharSpace = true;
                continue;
            }
            prevCharSpace = false;
        }
        line.text = cbuf.toString();
        if (wrapping && prevSpacePos != -1 && fm.stringWidth(line.text) > width) {
            int spacePos = this.getLastSpaceIndex(prevSpacePos, cbuf.length(), cbuf);
            line.text = cbuf.substring(0, prevSpacePos);
            line.trailingSpaces = spacePos - prevSpacePos + 1;
            cbuf.remove(0, spacePos + 1);
        } else {
            cbuf.removeAll();
        }
        return false;
    }

    private int getLastSpaceIndex(int index, int cnt, CharBuffer cbuf) {
        char ch;
        int spacePos = index;
        while (spacePos + 1 < cnt && Character.isSpaceChar(ch = cbuf.charAt(spacePos + 1))) {
            ++spacePos;
        }
        return spacePos;
    }

    private Character getEchoChar() {
        return (Character)this.cell.getEffectiveStylePropertyValue(ECHO_CHAR, null);
    }

    public int getMaximumStringWidth() {
        return this.m_maxStringWidth;
    }

    public int getMinimumStringWidth() {
        return this.m_minStringWidth;
    }

    @Override
    public int getMinimumWidth(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.cell.getEffectiveFont());
        this.formatText(g, fm, -1, false, 1, -999, true);
        this.setFlag(2);
        int maxWordWidth = 0;
        int cnt = this.m_lines.count();
        for (int i = 0; i < cnt; ++i) {
            Line line = (Line)this.m_lines.get(i);
            if (line.text == null) continue;
            StringTokenizer sTok = new StringTokenizer(line.text);
            while (sTok.hasMoreTokens()) {
                int len = fm.stringWidth(sTok.nextToken());
                if (len < maxWordWidth) continue;
                maxWordWidth = len;
            }
        }
        return maxWordWidth;
    }

    public Object getObjectData() {
        return this.getFormattedData();
    }

    @Override
    public int getPreferredHeight(Graphics g, int width) {
        FontMetrics fm = g.getFontMetrics(this.cell.getEffectiveFont());
        this.formatText(g, fm, width, true, -999, 4, true);
        this.setFlag(2);
        int height = this.m_lines.count() * fm.getHeight();
        if (height == 0) {
            height = fm.getHeight();
        }
        return height;
    }

    @Override
    public int getPreferredInputType() {
        return 1;
    }

    @Override
    public int getPreferredOutputType() {
        return 1;
    }

    @Override
    public int getPreferredWidth(Graphics g, int height) {
        this.formatText(g, g.getFontMetrics(this.cell.getEffectiveFont()), -1, false, 1, -999, true);
        this.setFlag(2);
        return this.m_maxTextWidth;
    }

    private int getRightEdge() {
        return this.cell.getWidth() - this.getRightMargin();
    }

    private int getDisplayedRightEdge() {
        return this.cell.getDisplayedWidth() - this.getRightMargin();
    }

    public String getText() {
        return this.isBeingEdited() ? this.m_text.toString() : this.m_textStr;
    }

    private int getVerticalJustification() {
        return (Integer)this.cell.getEffectiveStylePropertyValue("verticalJustification", MIDDLE);
    }

    private boolean homeKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (controlDown && shiftDown) {
            this.setSelected(0);
        } else if (controlDown) {
            this.unsetFlag(16);
            this.moveCaret(-this.getCaretPosition(), false);
        } else if (shiftDown) {
            this.setSelected(this.m_caret.containingLine.charOffset);
        } else {
            this.unsetFlag(16);
            int amt = this.m_caret.containingLine.charOffset - this.getCaretPosition();
            this.moveCaret(amt, false);
        }
        return true;
    }

    private void invertRectangle(Graphics g, int x, int y, int width, int height) {
        Color c = g.getColor();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        g.fillRect(x, y, width, height);
        g.setPaintMode();
        g.setColor(c);
    }

    private boolean isBeingEdited() {
        return this.m_caret != null || this.cell.getActiveState() == 3 || this.cell.getActiveState() == 2;
    }

    protected boolean isCharacterValid(char ch) {
        return Character.getType(ch) != 15;
    }

    private boolean isFlagSet(int flag) {
        return (this.m_flags & flag) != 0;
    }

    private boolean isMaximumLengthValid(int newLen) {
        int maxWidth = this.getMaximumStringWidth();
        return maxWidth == -1 || newLen <= maxWidth;
    }

    private boolean isMinimumLengthValid(int newLen) {
        return newLen >= this.getMinimumStringWidth();
    }

    @Override
    public boolean isPartiallyDisplayed() {
        return this.m_clipped;
    }

    private boolean isWrapped() {
        return (Boolean)this.cell.getEffectiveStylePropertyValue("wrapped", Boolean.FALSE);
    }

    private char getSplitCharacter() {
        Character splitChar = (Character)this.cell.getEffectiveStylePropertyValue("splitCharacter", null);
        if (splitChar == null) {
            return '\n';
        }
        return splitChar.charValue();
    }

    private void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 65: {
                this.letterAKeyPressed(event);
                break;
            }
            case 37: {
                this.leftKeyPressed(event);
                break;
            }
            case 39: {
                this.rightKeyPressed(event);
                break;
            }
            case 38: {
                this.upKeyPressed(event);
                break;
            }
            case 40: {
                this.downKeyPressed(event);
                break;
            }
            case 36: {
                this.homeKeyPressed(event);
                break;
            }
            case 35: {
                this.endKeyPressed(event);
                break;
            }
            case 8: {
                this.backspaceKeyPressed(event);
                break;
            }
            case 127: {
                this.deleteKeyPressed(event);
                break;
            }
            case 10: {
                this.enterKeyPressed(event);
                break;
            }
            case 9: {
                this.tabKeyPressed(event);
                break;
            }
            default: {
                this.cell.setKeyHandled(false);
            }
        }
    }

    private void keyTyped(KeyEvent event) {
        char ch = event.getKeyChar();
        if (!this.isCharacterValid(ch)) {
            return;
        }
        int newLen = this.m_text.length() + 1;
        if (this.isFlagSet(16)) {
            if (!this.isMaximumLengthValid(newLen -= Math.abs(this.m_selectionEnd - this.m_selectionStart)) || !this.isMinimumLengthValid(newLen)) {
                return;
            }
            this.removeSelection();
        } else if (!this.isMaximumLengthValid(newLen)) {
            return;
        }
        int pos = this.getCaretPosition();
        if (pos == this.m_text.length()) {
            this.m_text.append(ch);
        } else {
            this.m_text.insert(pos, ch);
        }
        this.moveCaret(1, true);
        this.cell.setModified(true);
    }

    private boolean leftKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!controlDown || !shiftDown) {
            if (controlDown) {
                this.unsetFlag(16);
            } else if (shiftDown) {
                this.setSelected(this.getCaretPosition() - 1);
            } else if (this.cell.getActiveState() == 2 && this.getCaretPosition() == 0) {
                this.cell.setKeyHandled(false);
            } else {
                if (this.isFlagSet(16)) {
                    this.setCaretPosition(this.m_selectionStart < this.m_selectionEnd ? this.m_selectionStart : this.m_selectionEnd);
                } else {
                    this.moveCaret(-1, false);
                }
                this.unsetFlag(16);
            }
        }
        return true;
    }

    private boolean letterAKeyPressed(KeyEvent event) {
        if (event.isControlDown() && !event.isShiftDown()) {
            this.setSelected(0, this.m_text.length());
            this.setCaretPosition(this.m_text.length());
        }
        return true;
    }

    private void measureCaretPosition(FontMetrics fm, int leftEdge) {
        int index;
        if ((this.isBeingEdited() || !this.isFlagSet(1) || this.m_maxTextWidth <= this.m_cachedWidth) && (index = this.m_lines.getIndex(this.m_caret.containingLine, 0)) != -1) {
            int paintOffsetHeight = index * fm.getHeight() + this.m_verticalOffset;
            int paintOffsetWidth = leftEdge + this.m_caret.containingLine.pixelOffset;
            this.updateCaretLocation(fm, paintOffsetWidth, paintOffsetHeight);
        }
    }

    private void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.setSelected(this.m_currentLine.charOffset, this.m_currentLine.charOffset + this.m_currentLine.charLength);
        }
    }

    private void mouseDown(MouseEvent event) {
        Point mousePoint = event.getPoint();
        Line line = this.getLineAtPixelPosition(mousePoint.y);
        if (line != null) {
            if (event.isShiftDown()) {
                if (!this.isFlagSet(16)) {
                    this.setFlag(16);
                    this.m_selectionStart = this.getCaretPosition();
                }
                this.setCaretPosition(this.getCaretPosition(line, mousePoint.x));
                this.m_selectionEnd = this.getCaretPosition();
            } else {
                this.unsetFlag(16);
                this.setCaretPosition(this.getCaretPosition(line, mousePoint.x));
            }
            this.cell.repaint();
        }
    }

    private void mouseDragged(MouseEvent event) {
        Point mousePoint = event.getPoint();
        Line line = this.getLineAtPixelPosition(mousePoint.y);
        if (this.isFlagSet(16)) {
            if (line != null) {
                this.setSelected(this.getCaretPosition(line, mousePoint.x));
            }
        } else if (line != null) {
            this.setSelected(this.getCaretPosition(), this.getCaretPosition(line, mousePoint.x));
        }
    }

    private void moveCaret(int amount, boolean format) {
        Graphics g = this.cell.tableView.getGraphics();
        this.moveCaret(amount, format, g, g.getFontMetrics(this.cell.getEffectiveFont()));
    }

    private void moveCaret(int amount, boolean format, Graphics g, FontMetrics fm) {
        int dst = this.getCaretPosition() + amount;
        if (format) {
            this.formatText(g, fm);
        }
        this.setFlag(128);
        this.setCaretPosition(dst);
        this.unsetFlag(128);
        this.measureCaretPosition(fm, this.getLeftMargin());
        this.cell.repaint();
    }

    private void setActivated(int oldState, Point point) {
        if (this.m_clipped) {
            this.setFlag(2);
        }
        if (oldState == 1 || oldState == 0) {
            this.m_text = new CharBuffer(this.m_textStr);
            this.m_caret = new Caret();
            this.m_caret.visible = true;
        }
        if (point != null) {
            Graphics g = this.cell.tableView.getGraphics();
            FontMetrics fm = g.getFontMetrics(this.cell.getEffectiveFont());
            Line line = this.getLineAtPixelPosition(point.y, fm);
            if (line != null) {
                this.setFlag(128);
                this.setCaretPosition(this.getCaretPosition(line, point.x, fm));
                this.unsetFlag(128);
                this.measureCaretPosition(fm, this.getLeftMargin());
            } else {
                this.setCaretPosition(0);
            }
        } else {
            this.setCaretPosition(0);
        }
    }

    private void setActivatedLight(int oldState) {
        if (this.m_clipped) {
            this.setFlag(2);
        }
        if (oldState == 1 || oldState == 0) {
            this.m_text = new CharBuffer(this.m_textStr);
            this.m_caret = new Caret();
            this.m_caret.visible = true;
        }
        this.setSelected(0, this.m_text.length());
    }

    private void setDeactivated(int oldState) {
        if (this.m_text != null) {
            this.m_textStr = this.m_text.toString();
            this.m_text = null;
        }
        this.unsetFlag(16);
        this.m_renderOffY = 0;
        this.m_renderOffX = 0;
        this.m_caret = null;
    }

    @Override
    public void onActiveStateChanged(int oldState, int newState, Point point) {
        if (newState == 3) {
            this.setActivated(oldState, point);
        } else if (newState == 2) {
            this.setActivatedLight(oldState);
        } else if (newState == 1 && oldState != 0 || newState == 0 && oldState != 1) {
            this.setDeactivated(oldState);
        }
    }

    @Override
    public void paint(Graphics g) {
        Color color;
        int vJust;
        int drawableWidth;
        this.setFlag(128);
        int drawableHeight = this.getDrawableHeight();
        if (this.m_cachedHeight != drawableHeight) {
            this.m_cachedHeight = drawableHeight;
            this.setFlag(this.isWrapped() || this.m_clipped ? 2 : 4);
        }
        if (this.m_cachedWidth != (drawableWidth = this.getDrawableWidth())) {
            this.m_cachedWidth = drawableWidth;
            this.setFlag(this.isWrapped() || this.m_clipped ? 2 : 4);
        }
        if (this.m_cachedVJust != (vJust = this.getVerticalJustification())) {
            this.m_cachedVJust = vJust;
            this.setFlag(this.m_clipped ? 2 : 4);
        }
        if ((color = (Color)this.cell.getEffectiveStylePropertyValue("foregroundColor", null)) == null) {
            color = this.cell.tableView.getForeground();
        }
        g.setColor(color);
        Font font = this.cell.getEffectiveFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int lineHeight = fm.getHeight();
        if (this.isFlagSet(2)) {
            this.formatText(g, fm);
        } else {
            this.formatLight(g, lineHeight, this.getHorizontalJustification(), this.m_cachedVJust);
        }
        this.updateClippedLines(fm, drawableWidth, drawableHeight, lineHeight, vJust);
        this.unsetFlag(128);
        this.renderText(g, fm, drawableWidth);
        this.m_insets = null;
    }

    private void paintSelection(Graphics g, FontMetrics fm, Line line, int x, int y) {
        int startOfLine = line.charOffset;
        int endOfLine = line.charOffset + line.charLength;
        int width = 0;
        if (this.m_selectionStart >= startOfLine && this.m_selectionStart <= endOfLine) {
            int start = this.m_selectionStart - line.charOffset;
            if (this.m_selectionEnd >= startOfLine && this.m_selectionEnd <= endOfLine) {
                if (this.m_selectionStart != startOfLine) {
                    x += fm.stringWidth(line.text.substring(0, start));
                }
                width = fm.stringWidth(line.text.substring(start, this.m_selectionEnd - line.charOffset));
            } else if (this.m_selectionStart == startOfLine) {
                width = line.pixelLength;
            } else {
                x += fm.stringWidth(line.text.substring(0, start));
                width = fm.stringWidth(line.text.substring(start, line.charLength));
            }
        } else if (this.m_selectionEnd >= startOfLine && this.m_selectionEnd <= endOfLine) {
            if (this.m_selectionEnd == startOfLine) {
                return;
            }
            width = fm.stringWidth(line.text.substring(0, this.m_selectionEnd - line.charOffset));
        } else if (this.m_selectionStart < startOfLine && this.m_selectionEnd > endOfLine) {
            width = line.pixelLength;
        }
        this.invertRectangle(g, x, y, width, fm.getHeight());
    }

    @Override
    public void processFocusEvent(FocusEvent event) {
        if (this.isBeingEdited()) {
            int type = event.getID();
            if (type == 1004) {
                this.m_caret.visible = true;
            } else if (type == 1005) {
                this.m_caret.visible = false;
            }
            this.cell.repaint();
        }
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        switch (event.getID()) {
            case 401: {
                this.keyPressed(event);
                break;
            }
            case 400: {
                this.keyTyped(event);
            }
        }
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        this.cell.tableView.setCursor(TEXT_CURSOR);
        switch (event.getID()) {
            case 501: {
                this.mouseDown(event);
                break;
            }
            case 500: {
                this.mouseClicked(event);
            }
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent event) {
        this.cell.tableView.setCursor(TEXT_CURSOR);
        switch (event.getID()) {
            case 506: {
                this.mouseDragged(event);
            }
        }
    }

    private void removeSelection() {
        if (this.isFlagSet(16)) {
            this.unsetFlag(16);
            int tempStart = this.m_selectionStart;
            int tempEnd = this.m_selectionEnd;
            if (this.m_selectionStart > this.m_selectionEnd) {
                tempStart = this.m_selectionEnd;
                tempEnd = this.m_selectionStart;
            }
            this.m_text.remove(tempStart, tempEnd);
            this.setFlag(2);
            this.setCaretPosition(tempStart);
            this.cell.setModified(true);
        }
    }

    private void renderText(Graphics g, FontMetrics fm, int drawableWidth) {
        int lineHeight = fm.getHeight();
        if (this.isBeingEdited()) {
            this.measureCaretPosition(fm, this.getLeftMargin());
            this.ensureCaretIsVisible(lineHeight);
        }
        int selStart = this.m_selectionStart;
        int selEnd = this.m_selectionEnd;
        if (this.m_selectionStart > this.m_selectionEnd) {
            this.m_selectionStart = this.m_selectionEnd;
            this.m_selectionEnd = selStart;
        }
        this.m_lines.paint(g, fm);
        if (this.m_selectionStart != selStart) {
            this.m_selectionStart = selStart;
            this.m_selectionEnd = selEnd;
        }
        if (this.isBeingEdited() && this.m_caret.visible) {
            this.m_caret.paint(g, lineHeight);
        }
    }

    private boolean rightKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!controlDown || !shiftDown) {
            if (controlDown) {
                this.unsetFlag(16);
            } else if (shiftDown) {
                this.setSelected(this.getCaretPosition() + 1);
            } else if (this.cell.getActiveState() == 2 && this.getCaretPosition() == this.m_text.length()) {
                this.cell.setKeyHandled(false);
            } else {
                if (this.isFlagSet(16)) {
                    this.setCaretPosition(this.m_selectionStart < this.m_selectionEnd ? this.m_selectionEnd : this.m_selectionStart);
                } else {
                    this.moveCaret(1, false);
                }
                this.unsetFlag(16);
            }
        }
        return true;
    }

    private void setCaretPosition(int position) {
        if (this.m_caret == null) {
            return;
        }
        this.unsetFlag(16);
        this.m_caret.clear();
        if (this.m_lines == null) {
            this.m_caret.position = position;
            return;
        }
        if (position < 0) {
            this.m_caret.containingLine = this.m_lines.getFirstLine();
            this.m_caret.position = 0;
        } else if (position > this.m_text.length()) {
            this.m_caret.containingLine = this.m_lines.getLastLine();
            this.m_caret.position = this.m_caret.containingLine.charLength;
        } else {
            Line line = this.getLineAtCharPosition(position);
            if (line != null) {
                this.m_caret.position = position - line.charOffset;
                this.m_caret.containingLine = line;
            }
        }
        this.m_currentLine = this.m_caret.containingLine;
        if (!this.isFlagSet(128)) {
            this.cell.repaint();
        }
    }

    private void setFlag(int flag) {
        this.m_flags |= flag;
    }

    @Override
    public final void setFormattedData(String data) {
        this.setText(data == null ? "" : data);
    }

    public void setMaximumStringWidth(int newValue) {
        this.m_maxStringWidth = newValue;
    }

    public void setMinimumStringWidth(int newValue) {
        this.m_minStringWidth = newValue;
    }

    public final void setObjectData(Object newData) {
        this.setText(newData == null ? "" : (String)ObjectToStringTransform.defaultInstance.transform(newData));
    }

    private void setSelected(int newCaretPos) {
        int start = this.isFlagSet(16) ? this.m_selectionStart : this.getCaretPosition();
        this.setSelected(start, newCaretPos);
    }

    private void setSelected(int start, int end) {
        if (start == 0) {
            start = 0;
        }
        if (this.isBeingEdited()) {
            if (start > this.m_text.length()) {
                start = this.m_text.length();
            }
        } else if (start > this.getText().length()) {
            start = this.getText().length();
        }
        this.m_selectionStart = start;
        this.setCaretPosition(end);
        this.m_selectionEnd = this.getCaretPosition();
        if (this.m_selectionStart != this.m_selectionEnd) {
            this.setFlag(16);
        } else {
            this.unsetFlag(16);
        }
        if (!this.isFlagSet(128)) {
            this.cell.repaint();
        }
    }

    public void setText(String newValue) {
        Class<String> cls;
        if (this.isBeingEdited()) {
            this.m_caret.clear();
            this.m_text = new CharBuffer(newValue);
        }
        this.m_textStr = newValue;
        this.setFlag(2);
        try {
            cls = this.cell.getObjectDataClass();
        }
        catch (TableException ex) {
            cls = String.class;
        }
        if (cls == Number.class || cls == Integer.class || cls == Double.class || cls == Long.class || cls == Short.class || cls == Byte.class) {
            this.setFlag(1);
        } else {
            this.unsetFlag(1);
        }
        if (this.m_caret != null) {
            this.m_caret.position = this.m_textStr.length();
        }
        this.cell.setModified(true);
    }

    private void unsetFlag(int flag) {
        this.m_flags &= ~flag;
    }

    private void tabKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!(controlDown && shiftDown || controlDown || shiftDown)) {
            this.cell.setKeyHandled(false);
        }
    }

    private void updateCaretLocation(FontMetrics fm, int x, int y) {
        if (this.m_caret.position <= 0) {
            this.m_caret.location.x = x;
        } else if (this.m_caret.position == this.m_currentLine.charLength) {
            this.m_caret.location.x = x + this.m_currentLine.pixelLength;
        } else {
            String subStr = null;
            subStr = this.m_currentLine.trailingSpaces != 0 && this.m_caret.position > this.m_currentLine.charLength ? this.m_currentLine.text : this.m_currentLine.text.substring(0, this.m_caret.position);
            this.m_caret.location.x = x + fm.stringWidth(subStr);
        }
        this.m_caret.location.y = y;
    }

    private void updateClippedLines(FontMetrics fm, int drawableWidth, int drawableHeight, int lineHeight, int vJust) {
        if (!this.isBeingEdited()) {
            if (this.m_lines.count() == 1) {
                if (this.m_maxTextWidth > drawableWidth) {
                    this.updateClippedLine(fm, drawableWidth, this.m_lines.getFirstLine(), this.isFlagSet(1));
                }
            } else {
                int effVOff = this.m_verticalOffset - this.getTopMargin();
                int cnt = (drawableHeight - effVOff) / lineHeight;
                int numLeft = this.m_lines.count() - cnt;
                if (numLeft > 0 && cnt > 0) {
                    int pixelsLeft = drawableHeight - effVOff - cnt * lineHeight;
                    if (pixelsLeft <= lineHeight / 3) {
                        this.updateClippedLine(fm, drawableWidth, this.m_lines.getLine(cnt - 1), false);
                    } else if (numLeft > 1) {
                        this.updateClippedLine(fm, drawableWidth, this.m_lines.getLine(cnt), false);
                    }
                } else if ((vJust == 8 || vJust == 264) && Math.abs(effVOff) / lineHeight > 0) {
                    this.updateClippedLine(fm, drawableWidth, this.m_lines.getLastLine(), false);
                }
            }
        }
    }

    private void updateClippedLine(FontMetrics fm, int drawableWidth, Line line, boolean numeric) {
        if (numeric) {
            int charLength = fm.charWidth('*');
            int charCount = drawableWidth / charLength;
            if (charCount != line.charLength || !line.text.startsWith("*")) {
                if (charCount <= 0) {
                    charCount = 1;
                }
                char[] clippedArray = new char[charCount];
                for (int i = 0; i < charCount; ++i) {
                    clippedArray[i] = 42;
                }
                line.text = String.valueOf(clippedArray);
                line.pixelLength = fm.stringWidth(line.text);
                line.charLength = charCount;
                line.charOffset = 0;
                line.pixelOffset = 0;
                line.trailingSpaces = 0;
            }
        } else if (!this.m_clipped) {
            line.pixelLength = fm.stringWidth(line.text + DOTS);
            while (line.pixelLength > drawableWidth && line.text.length() > 1) {
                line.text = line.text.substring(0, line.text.length() - 1);
                line.pixelLength = fm.stringWidth(line.text + DOTS);
            }
            line.text = line.text + DOTS;
            line.charLength = line.text.length();
            this.formatHorizontal(line, this.getHorizontalJustification());
        }
        this.m_clipped = true;
    }

    private boolean upKeyPressed(KeyEvent event) {
        if (this.cell.getActiveState() == 2) {
            this.cell.setKeyHandled(false);
        }
        if (this.isFlagSet(16)) {
            int position = Math.min(this.m_selectionStart, this.m_selectionEnd);
            int offset = 0;
            Line line = this.getLineAtCharPosition(position);
            if (line != null) {
                offset = position - line.charOffset;
                line = this.m_lines.getPreviousLine(line);
            }
            if (line != null) {
                int newPos = line.charOffset + (offset <= line.charLength ? offset : line.charLength);
                this.moveCaret(newPos - this.getCaretPosition(), false);
            } else if (position != this.getCaretPosition()) {
                this.setCaretPosition(position);
            } else if (!this.isFlagSet(128)) {
                this.cell.repaint();
            }
            this.unsetFlag(16);
        } else {
            Line line = this.m_lines.getPreviousLine(this.m_caret.containingLine);
            if (line != null) {
                int newPos = line.charOffset + (this.m_caret.position <= line.charLength ? this.m_caret.position : line.charLength);
                this.moveCaret(newPos - this.getCaretPosition(), false);
            }
        }
        return true;
    }

    class Line {
        String text;
        int charLength;
        boolean containsBreak;
        int pixelLength;
        int charOffset;
        int pixelOffset;
        int trailingSpaces;

        Line() {
        }

        public String toString() {
            return this.text;
        }

        void paint(Graphics g, int hOff, int vOff) {
            g.drawString(this.text, hOff, vOff);
        }
    }

    class Lines
    extends OrderedCollection {
        Lines() {
        }

        Line getFirstLine() {
            return (Line)this.get(0);
        }

        Line getLastLine() {
            return (Line)this.get(this.count() - 1);
        }

        Line getNextLine(Line line) {
            int index = this.getIndex(line, 0);
            if (index == this.count() - 1) {
                return line;
            }
            return (Line)this.get(index + 1);
        }

        Line getPreviousLine(Line line) {
            int index = this.getIndex(line, 0);
            if (index > 0) {
                return (Line)this.get(index - 1);
            }
            return null;
        }

        Line getLine(int index) {
            return (Line)this.get(index);
        }

        void paint(Graphics g, FontMetrics fm) {
            int leftEdge = PasswordTextCell.this.getLeftMargin();
            int lineHeight = fm.getHeight();
            int maxAscent = fm.getMaxAscent();
            int paintOffsetHeight = PasswordTextCell.this.m_verticalOffset + maxAscent + PasswordTextCell.this.m_renderOffY;
            int cnt = this.count();
            for (int i = 0; i < cnt; ++i) {
                Line line = this.getLine(i);
                int paintOffsetWidth = leftEdge + line.pixelOffset + PasswordTextCell.this.m_renderOffX;
                line.paint(g, paintOffsetWidth, paintOffsetHeight);
                if (PasswordTextCell.this.isFlagSet(16)) {
                    PasswordTextCell.this.paintSelection(g, fm, line, paintOffsetWidth, paintOffsetHeight - maxAscent);
                }
                paintOffsetHeight += lineHeight;
            }
        }

        void print() {
            System.out.println("Printing Lines ......");
            int cnt = this.count();
            for (int i = 0; i < cnt; ++i) {
                System.out.println("\t]" + this.getLine((int)i).text + "[");
            }
            System.out.println();
        }
    }

    class Caret {
        Line containingLine;
        Point location = new Point();
        int position;
        boolean visible;

        Caret() {
        }

        void clear() {
            this.position = 0;
            this.location.y = 0;
            this.location.x = 0;
            this.containingLine = null;
        }

        void paint(Graphics g, int height) {
            Color c = g.getColor();
            g.setColor(Color.black);
            g.drawLine(this.location.x + PasswordTextCell.this.m_renderOffX, this.location.y + PasswordTextCell.this.m_renderOffY, this.location.x + PasswordTextCell.this.m_renderOffX, this.location.y + PasswordTextCell.this.m_renderOffY + height - 1);
            g.setColor(c);
        }
    }
}

