/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.ComponentException;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.SASProcedureTemplate;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.submit.SubmitInterface;
import com.sas.swing.visuals.table.Column;
import com.sas.swing.visuals.table.ColumnSelection;
import com.sas.swing.visuals.table.RB;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.TableException;
import com.sas.util.Util;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class DataTableSortController
implements ItemListener,
PropertyChangeListener,
PropertyChangeSource {
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected TableView tableView;
    protected DataSetInterface model;
    protected int maxSortedColumns;
    protected boolean enabled;
    protected boolean inPlace;
    protected Vector sortedVector;
    protected SASProcedureTemplate proc = this.newSortProcedure();
    protected String originalDataSetName;
    protected String originalDataSet;
    protected String workDataSetName;
    private static final String RB_KEY = "DataTableSortController.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Description", RB.getStringResource(RB_KEY, "model.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultOutputPropertyName = "model";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public DataTableSortController() {
        this(null, null, 0);
    }

    public DataTableSortController(TableView tv, DataSetInterface dsi) {
        this(tv, dsi, 0);
    }

    public DataTableSortController(TableView tv, DataSetInterface dsi, int numColumns) {
        this.sortedVector = new Vector();
        this.setTableView(tv);
        this.setModel(dsi);
        this.setMaxSortedColumns(numColumns);
        this.setEnabled(true);
        this.setWorkDataSetName(this.newWorkDataSetName());
        this.proc.setOutput(this.getWorkDataSetName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propSupport.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
        s.defaultWriteObject();
        this.sortedVector.removeAllElements();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        TableView tv = this.getTableView();
        if (tv != null) {
            tv.removeItemListener(this);
            tv.removePropertyChangeListener(this);
            tv.addItemListener(this);
            tv.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent prop) {
        if (prop.getPropertyName() != null) {
            if (prop.getSource() == this.getTableView() && prop.getPropertyName().equals("currentElement")) {
                if (this.getTableView().getCurrentElement() == this.getTableView().getOriginCell() && this.isEnabled()) {
                    this.reset();
                }
            } else if (prop.getSource() == this.getModel() && prop.getPropertyName().equals("dataSet")) {
                this.originalDataSetName = this.model.getDataSetName();
                this.originalDataSet = this.model.getDataSet();
                this.proc.setDataSet(this.getOriginalDataSet());
                this.reset();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ColumnSelection columns;
        if (event.getItem() instanceof ColumnSelection && this.isEnabled() && this.getModel() != null && (columns = (ColumnSelection)event.getItem()).count() == 1) {
            Column col = (Column)columns.getAnchor();
            try {
                String columnName = this.getModel().getColumnInfo(col.getIndex(), "NAME").toString();
                if (!this.sortedVector.isEmpty()) {
                    ColumnSort lastColumnSelected = (ColumnSort)this.sortedVector.elementAt(0);
                    if (columnName.equals(lastColumnSelected.getColumnSortName())) {
                        lastColumnSelected.changeColumnSortState();
                    } else {
                        for (int ii = 1; ii < this.sortedVector.size(); ++ii) {
                            lastColumnSelected = (ColumnSort)this.sortedVector.elementAt(ii);
                            if (!columnName.equals(lastColumnSelected.getColumnSortName())) continue;
                            this.sortedVector.removeElement(lastColumnSelected);
                            break;
                        }
                        this.sortedVector.insertElementAt(new ColumnSort(columnName), 0);
                    }
                } else {
                    this.sortedVector.insertElementAt(new ColumnSort(columnName), 0);
                }
                Cursor previousCursor = this.getTableView().getCursor();
                this.getModel().removePropertyChangeListener(this);
                this.getTableView().setCursor(Cursor.getPredefinedCursor(3));
                this.getModel().close();
                String sortStatement = this.getSortStatement();
                this.sortDataset(sortStatement);
                if (this.isInPlace()) {
                    this.getModel().setDataSet(this.getOriginalDataSetName());
                } else {
                    this.getModel().setDataSet(this.getWorkDataSetName());
                }
                this.getTableView().setCursor(previousCursor);
                this.getModel().addPropertyChangeListener(this);
            }
            catch (TableException te) {
                te.printStackTrace();
            }
        }
    }

    protected SASProcedureTemplate newSortProcedure() {
        SASProcedureTemplate newSort = new SASProcedureTemplate();
        newSort.setProc("SORT");
        newSort.setProcPrint(false);
        return newSort;
    }

    public void reset() {
        Cursor previousCursor = null;
        if (this.getTableView() != null) {
            previousCursor = this.getTableView().getCursor();
            this.getTableView().setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
            this.getModel().close();
            this.sortedVector.removeAllElements();
            this.getModel().setDataSet(this.originalDataSet);
            this.getModel().addPropertyChangeListener(this);
        }
        if (this.getTableView() != null) {
            this.getTableView().setCursor(previousCursor);
        }
    }

    protected String getSortStatement() {
        SASProcedureTemplate newSort = this.getSortProcedure();
        StringBuffer procString = new StringBuffer(100 + this.sortedVector.size() * 20);
        String byString = new String();
        int maxColumns = this.getMaxSortedColumns() > 0 && this.getMaxSortedColumns() < this.sortedVector.size() ? this.getMaxSortedColumns() : this.sortedVector.size();
        for (int ii = 0; ii < maxColumns; ++ii) {
            ColumnSort lastColumnSelected = (ColumnSort)this.sortedVector.elementAt(ii);
            byString = byString + lastColumnSelected.toString();
        }
        newSort.setBy(byString);
        return this.getSortProcedure().getText();
    }

    public SASProcedureTemplate getSortProcedure() {
        return this.proc;
    }

    public void setSortProcedure(SASProcedureTemplate newSort) {
        SASProcedureTemplate oldSort = this.getSortProcedure();
        this.proc = newSort;
        newSort = this.getSortProcedure();
        if (Util.unequal((Object)((Object)oldSort), (Object)((Object)newSort))) {
            this.firePropertyChange("sortProcedure", (Object)oldSort, (Object)newSort);
        }
    }

    protected void sortDataset(String strSort) {
        try {
            RemoteBaseClient rbo = (RemoteBaseClient)((Object)this.getModel());
            Connection con = rbo._RemoteObject_getContext();
            SubmitInterface submit = (SubmitInterface)con.getClassFactory().newInstance(SubmitInterface.class, con);
            submit.setProgramText(strSort);
            con.stop(submit);
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e);
        }
    }

    public int getMaxSortedColumns() {
        return this.maxSortedColumns;
    }

    public void setMaxSortedColumns(int numCol) {
        int oldNumCol = this.getMaxSortedColumns();
        this.maxSortedColumns = numCol;
        numCol = this.getMaxSortedColumns();
        if (oldNumCol != numCol) {
            this.firePropertyChange("maxSortedColumns", new Integer(oldNumCol), new Integer(numCol));
        }
    }

    protected String newWorkDataSetName() {
        return "WORK.T" + Long.toHexString(System.currentTimeMillis()).substring(0, 7);
    }

    public boolean isInPlace() {
        return this.inPlace;
    }

    public void setInPlace(boolean val) {
        boolean oldInPlace = this.isInPlace();
        this.inPlace = val;
        val = this.isInPlace();
        if (oldInPlace != val) {
            this.firePropertyChange("inPlace", new Boolean(oldInPlace), new Boolean(val));
            if (this.isInPlace()) {
                this.proc.removeOption("OUTPUT");
            } else {
                this.proc.setOutput(this.getWorkDataSetName());
            }
        }
    }

    public void setModel(DataSetInterface dsi) {
        DataSetInterface oldDSI = this.getModel();
        this.model = dsi;
        dsi = this.getModel();
        if (Util.unequal((Object)oldDSI, (Object)dsi)) {
            this.firePropertyChange("model", oldDSI, dsi);
            if (oldDSI != null) {
                oldDSI.removePropertyChangeListener(this);
            }
            if (dsi != null) {
                dsi.addPropertyChangeListener(this);
                this.originalDataSetName = this.model.getDataSetName();
                this.originalDataSet = this.model.getDataSet();
                this.proc.setDataSet(this.getOriginalDataSet());
            }
        }
    }

    public DataSetInterface getModel() {
        return this.model;
    }

    public void setTableView(TableView tv) {
        TableView oldTV = this.getTableView();
        this.tableView = tv;
        tv = this.getTableView();
        if (Util.unequal((Object)oldTV, (Object)tv)) {
            this.firePropertyChange("tableView", oldTV, tv);
            if (oldTV != null) {
                oldTV.removeItemListener(this);
                oldTV.removePropertyChangeListener(this);
            }
            if (tv != null) {
                tv.addItemListener(this);
                tv.addPropertyChangeListener(this);
            }
        }
    }

    public TableView getTableView() {
        return this.tableView;
    }

    protected String getOriginalDataSetName() {
        return this.originalDataSetName;
    }

    protected String getOriginalDataSet() {
        return this.originalDataSet;
    }

    public String getWorkDataSetName() {
        return this.workDataSetName;
    }

    public void setWorkDataSetName(String wds) {
        String oldWork = this.getWorkDataSetName();
        this.workDataSetName = wds;
        wds = this.getWorkDataSetName();
        if (Util.unequal((Object)oldWork, (Object)wds)) {
            this.firePropertyChange("workDataSetName", oldWork, wds);
            this.proc.setOutput(this.getWorkDataSetName());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean val) {
        boolean oldVal = this.isEnabled();
        this.enabled = val;
        val = this.isEnabled();
        if (oldVal != val) {
            this.firePropertyChange("enabled", new Boolean(oldVal), new Boolean(val));
        }
    }

    protected class ColumnSort {
        private String columnSortName;
        private boolean descending;

        public ColumnSort(String str) {
            this(str, false);
        }

        public ColumnSort(String str, boolean descending) {
            this.columnSortName = str;
            this.descending = descending;
        }

        public String getColumnSortName() {
            return this.columnSortName;
        }

        public void changeColumnSortState() {
            this.descending = !this.descending;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public boolean isAscending() {
            return !this.descending;
        }

        public String toString() {
            if (this.isDescending()) {
                return " DESCENDING " + this.columnSortName;
            }
            return " " + this.columnSortName;
        }
    }
}

