/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.swing.visuals.mdtable.Axis;
import com.sas.swing.visuals.mdtable.Dimension;
import com.sas.swing.visuals.mdtable.Level;
import com.sas.swing.visuals.mdtable.MultidimensionalTableView;
import com.sas.swing.visuals.table.LabelCell;
import com.sas.swing.visuals.table.LabelCellTypeInterface;
import com.sas.table.TableException;

public class LevelLabel
extends LabelCell {
    private static final LabelCellTypeInterface COL_LEVEL = new ColLevelLabelCellType();
    private static final LabelCellTypeInterface ROW_LEVEL = new RowLevelLabelCellType();

    public LevelLabel(MultidimensionalTableView table, Level level) {
        super(table, ((Axis)((Dimension)level.getDimension()).getAxis()).isColumnAxis() ? COL_LEVEL : ROW_LEVEL, level);
    }

    public final LevelInterface getLevel() {
        return (LevelInterface)this.getChild();
    }

    private static final class ColLevelLabelCellType
    extends LevelLabelCellType {
        private ColLevelLabelCellType() {
        }

        @Override
        public int getHeight(LabelCell cell) {
            return ((Level)((LevelLabel)cell).getLevel()).getSize();
        }

        @Override
        public int getWidth(LabelCell cell) {
            return cell.getTableView().getRowLabelBounds().width;
        }

        @Override
        public int getHorizontalPosition(LabelCell cell) {
            return cell.getTableView().getRowLabelBounds().x;
        }

        @Override
        public int getVerticalPosition(LabelCell cell) {
            return ((Level)((LevelLabel)cell).getLevel()).getPosition();
        }
    }

    private static final class RowLevelLabelCellType
    extends LevelLabelCellType {
        private RowLevelLabelCellType() {
        }

        @Override
        public int getHeight(LabelCell cell) {
            return this.getLastColumnLevel((LevelLabel)cell).getSize();
        }

        @Override
        public int getWidth(LabelCell cell) {
            return ((Level)((LevelLabel)cell).getLevel()).getSize();
        }

        @Override
        public int getHorizontalPosition(LabelCell cell) {
            return ((Level)((LevelLabel)cell).getLevel()).getPosition();
        }

        @Override
        public int getVerticalPosition(LabelCell cell) {
            return this.getLastColumnLevel((LevelLabel)cell).getPosition();
        }

        private Level getLastColumnLevel(LevelLabel cell) {
            Axis axis = ((MultidimensionalTableView)cell.getTableView()).getColumnAxis_();
            Dimension dim = (Dimension)axis.getDimension(axis.getDimensionCount() - 1);
            return (Level)dim.getLevel(dim.getLevelCount() - 1);
        }

        @Override
        public boolean isDisplayed(LabelCell cell) {
            int layout = ((MultidimensionalTableView)cell.getTableView()).getRowLabelsLayout();
            return layout == 0 || layout == 2;
        }
    }

    private static abstract class LevelLabelCellType
    implements LabelCellTypeInterface {
        private LevelLabelCellType() {
        }

        @Override
        public int getDisplayedHeight(LabelCell cell) {
            if (cell.isDisplayed()) {
                return cell.getHeight();
            }
            return 0;
        }

        @Override
        public int getDisplayedWidth(LabelCell cell) {
            if (cell.isDisplayed()) {
                return cell.getWidth();
            }
            return 0;
        }

        @Override
        public LabelCell getThisLabelCell(LabelCell cell) {
            return cell;
        }

        @Override
        public boolean isDisplayed(LabelCell cell) {
            return true;
        }

        @Override
        public Object onGetObjectData(LabelCell cell) throws TableException {
            return ((LevelLabel)cell).getLevel().getLabel();
        }

        @Override
        public void onWriteObjectData(LabelCell cell) throws TableException {
        }

        @Override
        public StaticPropertyBagInterface onGetModelStyle(LabelCell cell) throws TableException {
            return null;
        }

        @Override
        public String[] onGetTypes(LabelCell cell) throws TableException {
            return null;
        }
    }
}

