/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.awt.print.PDFGraphics;
import com.sas.collection.Dictionary;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.swing.visuals.mdtable.AbstractLevel;
import com.sas.swing.visuals.mdtable.Axis;
import com.sas.swing.visuals.mdtable.Dimension;
import com.sas.swing.visuals.mdtable.Label;
import com.sas.swing.visuals.mdtable.LevelLabel;
import com.sas.swing.visuals.mdtable.Member;
import com.sas.swing.visuals.mdtable.MultidimensionalTableView;
import com.sas.swing.visuals.mdtable.Node;
import com.sas.swing.visuals.table.CellVector;
import com.sas.table.TableException;
import java.awt.Graphics;

final class Level
extends AbstractLevel {
    Node node;
    int m_position;
    private int m_preferredSize;
    private int m_size;
    private LevelLabel m_label;
    private int m_memberCount;
    private Dictionary m_members;
    private boolean m_resized;

    public Level(Dimension dimension, LevelInterface level) {
        super(dimension);
        this.node = new Node(level);
    }

    @Override
    public final LevelInterface getMetaLevel() {
        return (LevelInterface)this.node.getMetaNode();
    }

    @Override
    public String getLabel() {
        return this.node.getLabel();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public int getMemberCount() {
        if (this.m_memberCount == 0) {
            try {
                this.m_memberCount = this.getMetaLevel().getMemberCount();
            }
            catch (TableException tex) {
                tex.printStackTrace();
            }
        }
        return this.m_memberCount;
    }

    @Override
    public MemberInterface getMember(int index) {
        throw new IllegalStateException();
    }

    public Member getMember(MemberInterface memI, boolean create) {
        if (this.m_members != null && this.m_members.containsKey((Object)memI)) {
            return (Member)this.m_members.get((Object)memI);
        }
        if (create) {
            if (this.m_members == null) {
                this.m_members = new Dictionary(Math.min(this.getMemberCount(), 25));
            }
            Member member = new Member(this, memI);
            this.m_members.set((Object)memI, (Object)member);
            return member;
        }
        return null;
    }

    @Override
    public MemberInterface[] getMembers(int index, int count) {
        throw new IllegalStateException();
    }

    public int countNodeChildren(int maxChildCount) {
        return this.getMemberCount();
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.node.getDefaultCellStyle();
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultCellStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.node.getDefaultLabelStyle();
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultLabelStyle(newValue);
    }

    public StaticPropertyBagInterface getModelDefaultCellStyle() {
        return this.node.getModelDefaultCellStyle();
    }

    public StaticPropertyBagInterface getModelDefaultLabelStyle() {
        return this.node.getModelDefaultLabelStyle();
    }

    public LevelLabel getLabelCell() {
        if (this.m_label == null) {
            this.m_label = new LevelLabel(this.getTableView(), this);
        }
        return this.m_label;
    }

    public int getPosition() {
        return ((Dimension)this.getDimension()).getPosition() + this.m_position;
    }

    public int computePreferredSize(Graphics g) {
        MemberInterface[] members;
        boolean colLevel;
        Dimension dim = (Dimension)this.getDimension();
        Axis axis = (Axis)dim.getAxis();
        MultidimensionalTableView table = axis.getTableView();
        int layout = table.getRowLabelsLayout();
        int ff = 0;
        if (axis.isRowAxis() && g instanceof PDFGraphics) {
            ff = this.getTableView().getPDFPrintingSpacer();
        }
        CellVector child = (colLevel = axis.isColumnAxis()) ? table.getColumn(1) : table.getRow(1);
        boolean lastLevel = dim == axis.getDimension(axis.getDimensionCount() - 1) && this == dim.getLevel(dim.getLevelCount() - 1);
        int size = 0;
        if (colLevel) {
            if (lastLevel) {
                Axis raxis = table.getRowAxis_();
                int maxd = raxis.getDimensionCount();
                for (int d = 0; d < maxd; ++d) {
                    Dimension rdim = (Dimension)raxis.getDimension(d);
                    int maxl = rdim.getLevelCount();
                    for (int l = 0; l < maxl; ++l) {
                        Level lev = (Level)rdim.getLevel(l);
                        int s = lev.getLabelCell().getPreferredHeight(g);
                        if (s <= size) continue;
                        size = s;
                    }
                }
            }
        } else {
            size = this.getLabelCell().getPreferredWidth(g);
        }
        try {
            members = this.getMetaLevel().getMembers(0, this.getMembersToSizeCount(colLevel));
        }
        catch (TableException tex) {
            tex.printStackTrace();
            return size;
        }
        for (int i = 0; i < members.length; ++i) {
            Label label = new Label(table, child, null, null, members[i]);
            int memsize = lastLevel ? (colLevel ? label.getPreferredHeight(g) : label.getPreferredWidth(g)) : (colLevel ? label.getMinimumHeight(g) : (layout == 0 ? label.getMinimumWidth(g) : label.getPreferredWidth(g)));
            if (memsize <= size) continue;
            size = memsize;
        }
        return size + ff;
    }

    public int getPreferredSize() {
        return this.m_preferredSize;
    }

    public void setPreferredSize(int newValue) {
        this.m_preferredSize = newValue;
    }

    public int getSize() {
        if (this.isResized()) {
            return this.m_size;
        }
        return this.getPreferredSize();
    }

    void setPosition(int newValue) {
        this.m_position = newValue;
    }

    public void setSize(int newValue) {
        if (newValue == this.m_size) {
            return;
        }
        if (newValue < 0) {
            throw new IllegalArgumentException();
        }
        this.m_size = newValue;
        this.m_resized = this.m_size != 0 && this.m_size != this.getPreferredSize();
        this.getTableView().repaint();
    }

    public boolean isResized() {
        return this.m_resized;
    }

    public final MultidimensionalTableView getTableView() {
        return ((Dimension)this.getDimension()).getTableView();
    }

    private int getMembersToSizeCount(boolean colLevel) {
        int count = 0;
        count = colLevel ? this.getTableView().getDefaultRowStyle().getCellsToSizeCount() : this.getTableView().getDefaultColumnStyle().getCellsToSizeCount();
        if (count < 0) {
            count = this.getMemberCount();
        }
        return count;
    }
}

