/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.mdtable.StaticNodeStyleInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.swing.visuals.mdtable.Axis;
import com.sas.swing.visuals.mdtable.Dimension;
import com.sas.swing.visuals.mdtable.Level;
import com.sas.swing.visuals.mdtable.Member;
import com.sas.swing.visuals.mdtable.MultidimensionalTableView;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.LabelCell;
import com.sas.table.TableException;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Label
extends LabelCell
implements AxisLabelInterface,
CommandsInterface {
    Rectangle bounds;
    private int m_childCount;
    Vector m_children;
    OrderedCollection displayedChildren;
    private Level m_level;
    private MemberInterface m_memberI;
    private int m_minCoordinate;
    private int m_maxCoordinate;
    private Label m_parent;
    private AxisLabelInterface m_metaLabel;
    private boolean m_isLeaf;
    private Label m_self = this;

    public Label(MultidimensionalTableView table, Object child, Label parent, AxisLabelInterface label, MemberInterface member) {
        this(table, child, parent, label, member, table.getLevel(member.getLevel()));
    }

    private Label(MultidimensionalTableView table, Object child, Label parent, AxisLabelInterface label, MemberInterface memI, Level level) {
        super(table, level.getDimension().getAxis().equals(table.getColumnAxis_()) ? COLUMN_LABEL : ROW_LABEL, child);
        this.m_level = level;
        this.m_memberI = memI;
        if (label != null) {
            this.m_metaLabel = label;
            if (memI instanceof StaticNodeStyleInterface) {
                level.getMember(memI, true);
            }
            this.bounds = new Rectangle();
            this.m_isLeaf = label.isLeafNode();
            if (!this.m_isLeaf) {
                this.m_childCount = label.getNodeChildCount();
                this.m_children = new Vector(this.m_childCount);
                this.m_minCoordinate = label.getMinimumCoordinate();
                this.m_maxCoordinate = label.getMaximumCoordinate();
            } else {
                this.m_maxCoordinate = this.m_minCoordinate = label.getMinimumCoordinate();
            }
            if (child == null) {
                this.displayedChildren = new OrderedCollection();
            }
        }
        if (parent != null) {
            this.m_parent = parent;
            parent.m_children.addElement(this);
        }
    }

    public int countNodeChildren(int maxChildCount) {
        return this.getNodeChildCount();
    }

    @Override
    public final boolean equals(LabelCell obj) {
        return obj instanceof Label && this.equals((Label)obj);
    }

    public boolean equals(Label other) {
        return this == other || this.getMetaLabel().equals(other.getMetaLabel());
    }

    public Command[] getCommands() {
        Command[] commands = null;
        AxisLabelInterface metaLabel = this.getMetaLabel();
        if (metaLabel instanceof CommandsInterface) {
            commands = ((CommandsInterface)metaLabel).getCommands();
        }
        if (commands == null) {
            commands = new Command[]{};
        }
        return commands;
    }

    @Override
    public final AxisInterface getAxis() {
        return this.getDimension().getAxis();
    }

    private CellVector getCellVector() {
        Object child = this.getChild();
        if (child instanceof CellVector) {
            return (CellVector)child;
        }
        return null;
    }

    OrderedCollection getCellVectorChildrenAsCollection() {
        Enumeration e = this.getCellVectorChildren();
        OrderedCollection c = new OrderedCollection();
        while (e.hasMoreElements()) {
            c.add(e.nextElement());
        }
        return c;
    }

    Enumeration getCellVectorChildren() {
        return new CellVectorEnumeration(this.getFirstCellVector(), this.getMagnitude());
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.isRowLabel() && this.getMdTableView().getRowLabelsLayout() == 1) {
            int offset = 20;
            for (Label parent = this.getParent(); parent != null; parent = parent.getParent()) {
                insets.left += offset;
            }
        }
        return insets;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        if (index < 0 || index >= this.getNodeChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    public int getNodeChildCount() {
        return this.m_childCount;
    }

    public SimpleNodeInterface[] getNodeChildren(int index, int count) {
        int maxCount = this.getNodeChildCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        SimpleNodeInterface[] array = new SimpleNodeInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getNodeChild(index + i);
        }
        return array;
    }

    public final DimensionInterface getDimension() {
        return this.getLevel().getDimension();
    }

    @Override
    public int getDisplayedHeight() {
        return this.getHeight();
    }

    @Override
    public int getDisplayedWidth() {
        return this.getWidth();
    }

    CellVector getFirstCellVector() {
        CellVector first = this.getCellVector();
        if (first == null) {
            first = this.isRowLabel() ? this.getTableView().getRow(this.getMinimumCoordinate() + 1) : this.getTableView().getColumn(this.getMinimumCoordinate() + 1);
        }
        return first;
    }

    CellVector getLastCellVector() {
        CellVector last = this.getCellVector();
        if (last == null) {
            last = this.isRowLabel() ? this.getTableView().getRow(this.getMaximumCoordinate() + 1) : this.getTableView().getColumn(this.getMaximumCoordinate() + 1);
        }
        return last;
    }

    @Override
    public int getHeight() {
        return this.isDisplayed() ? this.getThisLabel().bounds.height : 0;
    }

    @Override
    public int getHorizontalPosition() {
        return this.getThisLabel().bounds.x;
    }

    @Override
    public String getLabel() {
        try {
            if (this.isRowLabel() && this.getMdTableView().getRowLabelsLayout() == 3) {
                return this.getMdTableView().m_mdTo2d.getRowLabel(this.getMinimumCoordinate() + 1).toString();
            }
            AxisLabelInterface metaLabel = this.getMetaLabel();
            if (metaLabel != null) {
                return metaLabel.getLabel();
            }
            return this.getMember().getLabel();
        }
        catch (TableException tex) {
            return this.getName();
        }
    }

    public final LevelInterface getLevel() {
        return this.getMember().getLevel();
    }

    public final int getMagnitude() {
        return this.getMaximumCoordinate() - this.getMinimumCoordinate() + 1;
    }

    private MultidimensionalTableView getMdTableView() {
        return (MultidimensionalTableView)this.getTableView();
    }

    @Override
    public final MemberInterface getMember() {
        return this.m_memberI;
    }

    public final AxisLabelInterface getMetaLabel() {
        return this.m_metaLabel;
    }

    @Override
    public final int getMinimumCoordinate() {
        return this.m_minCoordinate;
    }

    @Override
    public final int getMaximumCoordinate() {
        return this.m_maxCoordinate;
    }

    @Override
    public String getName() {
        try {
            return this.getMetaLabel().getName();
        }
        catch (TableException tex) {
            return this.getNodeType();
        }
    }

    public final String getNodeExpandedText() {
        return this.getLabel();
    }

    public final String getNodeType() {
        return "label";
    }

    public final String getNodeText() {
        return this.getName();
    }

    public final Label getParent() {
        if (this.m_parent == null) {
            return null;
        }
        this.m_parent = this.m_parent.getThisLabel();
        return this.m_parent;
    }

    @Override
    protected final LabelCell getThisLabelCell() {
        return this.getThisLabel();
    }

    protected Label getThisLabel() {
        if (this.m_self != this) {
            if (this.m_self == null) {
                Label[] labels = (Label[])this.getAxis_().getLabels(this.m_minCoordinate);
                for (int i = 0; i < labels.length; ++i) {
                    if (!this.equals(labels[i])) continue;
                    this.m_self = labels[i];
                    break;
                }
            } else {
                this.m_self = this.m_self.getThisLabel();
            }
        }
        return this.m_self;
    }

    @Override
    public int getVerticalPosition() {
        return this.getThisLabel().bounds.y;
    }

    @Override
    public int getWidth() {
        return this.isDisplayed() ? this.getThisLabel().bounds.width : 0;
    }

    @Override
    public boolean isDisplayed() {
        CellVector cv = this.getCellVector();
        if (cv != null) {
            return cv.isDisplayed();
        }
        Label parent = this.getParent();
        if (parent != null) {
            return parent.displayedChildren.contains((Object)this);
        }
        if (this.isRowLabel()) {
            return this.getMdTableView().getDisplayedRowLabels().contains((Object)this);
        }
        return this.getMdTableView().getDisplayedColumnLabels().contains((Object)this);
    }

    public final boolean isLeafNode() {
        return this.m_isLeaf;
    }

    boolean isPartiallyDisplayed() {
        if (!this.isDisplayed()) {
            return false;
        }
        CellVector first = this.getFirstCellVector();
        if (!first.isDisplayed() || first.isPartiallyDisplayed()) {
            return true;
        }
        CellVector last = this.getLastCellVector();
        if (last.equals(first)) {
            return false;
        }
        return !last.isDisplayed() || last.isPartiallyDisplayed();
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    protected void onGetEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        CellStyle cellStyle;
        Label label = this;
        do {
            Member member;
            if ((member = label.getMember_()) == null) continue;
            member.node.getEffectiveLabelStylePropertyBag(propertyID, bag);
        } while ((label = label.getParent()) != null);
        label = this;
        do {
            label.getLevel_().node.getEffectiveLabelStylePropertyBag(propertyID, bag);
        } while ((label = label.getParent()) != null);
        label = this;
        do {
            label.getDimension_().node.getEffectiveLabelStylePropertyBag(propertyID, bag);
        } while ((label = label.getParent()) != null);
        this.getAxis_().node.getEffectiveLabelStylePropertyBag(propertyID, bag);
        if (!this.isLeafNode() && (cellStyle = this.isRowLabel() ? (CellStyle)((Object)this.tableView.getDefaultRowStyle().get("defaultLabelStyle", null)) : (CellStyle)((Object)this.tableView.getDefaultColumnStyle().get("defaultLabelStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)((PropertyBagInterface)cellStyle.get(propertyID)));
        }
        super.onGetEffectiveStylePropertyBag(propertyID, bag);
    }

    @Override
    protected Object onGetEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        CellStyle cellStyle;
        Object value;
        Label label = this;
        do {
            Member member;
            if ((member = label.getMember_()) == null || (value = member.node.getEffectiveLabelStylePropertyValue(propertyID, PropertyBag.NO_SUCH_ELEMENT)) == PropertyBag.NO_SUCH_ELEMENT) continue;
            return value;
        } while ((label = label.getParent()) != null);
        label = this;
        do {
            if ((value = label.getLevel_().node.getEffectiveLabelStylePropertyValue(propertyID, PropertyBag.NO_SUCH_ELEMENT)) == PropertyBag.NO_SUCH_ELEMENT) continue;
            return value;
        } while ((label = label.getParent()) != null);
        label = this;
        do {
            if ((value = label.getDimension_().node.getEffectiveLabelStylePropertyValue(propertyID, PropertyBag.NO_SUCH_ELEMENT)) == PropertyBag.NO_SUCH_ELEMENT) continue;
            return value;
        } while ((label = label.getParent()) != null);
        value = this.getAxis_().node.getEffectiveLabelStylePropertyValue(propertyID, PropertyBag.NO_SUCH_ELEMENT);
        if (value != PropertyBag.NO_SUCH_ELEMENT) {
            return value;
        }
        if (!this.isLeafNode() && (cellStyle = this.isRowLabel() ? (CellStyle)((Object)this.tableView.getDefaultRowStyle().get("defaultLabelStyle", null)) : (CellStyle)((Object)this.tableView.getDefaultColumnStyle().get("defaultLabelStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        return super.onGetEffectiveStylePropertyValue(propertyID, defaultValue);
    }

    @Override
    protected Object onGetObjectData() throws TableException {
        return this.getLabel();
    }

    @Override
    protected StaticPropertyBagInterface onGetModelStyle() throws TableException {
        AxisLabelInterface metaLabel = this.getMetaLabel();
        if (metaLabel instanceof StaticNodeStyleInterface) {
            return ((StaticNodeStyleInterface)((Object)metaLabel)).getDefaultLabelStyle();
        }
        return null;
    }

    @Override
    protected String[] onGetTypes() throws TableException {
        if (this.isLeafNode()) {
            return super.onGetTypes();
        }
        return null;
    }

    @Override
    public void setObsolete() {
        super.setObsolete();
        this.m_self = null;
        if (this.m_parent != null) {
            if (this.m_parent.m_children != null) {
                this.m_parent.m_children.removeElement(this);
            }
            if (this.m_parent.displayedChildren != null) {
                this.m_parent.displayedChildren.remove((Object)this);
            }
        } else {
            this.getAxis_().m_labelCache.removeElement(this);
        }
        this.bounds = null;
        this.displayedChildren = null;
        this.m_children = null;
    }

    final Member getMember_() {
        return this.m_level.getMember(this.m_memberI, false);
    }

    final Level getLevel_() {
        return this.m_level;
    }

    final Dimension getDimension_() {
        return (Dimension)this.m_level.getDimension();
    }

    final Axis getAxis_() {
        return (Axis)this.getDimension_().getAxis();
    }

    private final class CellVectorEnumeration
    implements Enumeration {
        private CellVector m_next;
        private int m_index;
        private int m_count;

        CellVectorEnumeration(CellVector first, int count) {
            this.m_next = first;
            this.m_count = count;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_index < this.m_count;
        }

        public Object nextElement() {
            if (this.m_next == null) {
                throw new NoSuchElementException();
            }
            CellVector next = this.m_next;
            this.m_next = this.m_next.next();
            ++this.m_index;
            return next;
        }
    }
}

