/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.ModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.models.IncrementInterface;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.ArrowIcon;
import com.sas.swing.visuals.RB;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SpinButton
extends JComponent
implements Adjustable,
AlarmListener,
PropertyChangeListener,
IncrementInterface,
MouseListener,
KeyListener,
ViewDefaultModel {
    static final long serialVersionUID = 2259662757882653756L;
    static final String RB_KEY = "SpinButton.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.models.BoundedNumberInterface"};
    protected Alarm valueChangeAlarm;
    private transient Rectangle topLeftRectangle;
    private transient Rectangle bottomRightRectangle;
    private transient Rectangle arrowRectangle;
    private transient Rectangle incrementRectangle;
    private transient Rectangle decrementRectangle;
    private transient boolean incrementMouseClick;
    private transient boolean decrementMouseClick;
    private transient boolean incrementKeyTyped;
    private transient boolean decrementKeyTyped;
    private transient boolean incrementRaised;
    private transient boolean decrementRaised;
    private transient AdjustmentListener adjustmentListener;
    protected long startInterval;
    protected long delay;
    private boolean swapped;
    private boolean incrementEnabled;
    private boolean decrementEnabled;
    private boolean cycleValue;
    private int minimum;
    private int maximum;
    private int unitIncrement;
    private int blockIncrement;
    private int value;
    private int buttonGap;
    private int orientation;
    private int arrowDirection;
    private boolean resized;
    protected JButton incrementButton;
    protected JButton decrementButton;
    protected ArrowIcon incrementArrow;
    protected ArrowIcon decrementArrow;
    protected BoundedNumberInterface defaultRangeModel;
    protected BoundedNumberInterface spinButtonModel;
    public static final int UP_DOWN = 2;
    public static final int LEFT_RIGHT = 3;
    private static int defaultWidth = 16;
    private static int defaultHeight = 22;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Hidden", "true"}}, {{"Name", "blockIncrement"}, {"Hidden", "true"}}, {{"Name", "blockIncrementNumber"}, {"Hidden", "true"}}, {{"Name", "buttonGap"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"buttonGapSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonGap.pd.txt")}}, {{"Name", "cycleOn"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"cycleOn.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"cycleOn.pd.txt")}}, {{"Name", "decrementEnabled"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"decrementEnabled.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"decrementEnabled.pd.txt")}}, {{"Name", "incrementEnabled"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"incrementEnabled.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"incrementEnabled.pd.txt")}}, {{"Name", "maximum"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"maximumSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"maximum.pd.txt")}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"minimumSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"minimum.pd.txt")}, {"Expert", "true"}}, {{"Name", "unitIncrement"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"unitIncrementSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"unitIncrement.pd.txt")}, {"Expert", "true"}}, {{"Name", "value"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"valueSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"value.pd.txt")}}, {{"Name", "visibleAmount"}, {"Hidden", "true"}}, {{"Name", "orientation"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"orientationSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors._AdjustableOrientationEditor"}}, {{"Name", "arrowDirection"}, {"Property editor class", "com.sas.beans.editors._SpinButtonArrowDirectionEditor"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "numberValue";
        ebi.defaultOutputPropertyName = "numberValue";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public SpinButton() {
        this.enableEvents(276L);
        this.setDefaultValues();
    }

    public SpinButton(int value, int min, int max, int unit, int block, int orient) {
        this();
        ((BoundedLong)this.spinButtonModel).setValues((long)value, (long)min, (long)max, (long)unit, (long)block);
        this.setOrientation(orient);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.incrementButton != null) {
            this.incrementButton.setToolTipText(text);
        }
        if (this.decrementButton != null) {
            this.decrementButton.setToolTipText(text);
        }
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    private void calculateButtonLayout() {
        Dimension buttonSize = this.getSize();
        Insets insets = this.getInsets();
        buttonSize.width -= insets.left + insets.right;
        buttonSize.height -= insets.top + insets.bottom;
        if (this.orientation == 0) {
            buttonSize.width = buttonSize.width % 2 == 0 ? buttonSize.width / 2 - this.buttonGap / 2 - this.buttonGap % 2 : buttonSize.width / 2 - this.buttonGap / 2;
            this.topLeftRectangle.x = 0;
            this.topLeftRectangle.y = 0;
            this.topLeftRectangle.height = buttonSize.height;
            this.topLeftRectangle.width = buttonSize.width;
            this.bottomRightRectangle.x = buttonSize.width + this.buttonGap;
            this.bottomRightRectangle.y = 0;
            this.bottomRightRectangle.height = buttonSize.height;
            this.bottomRightRectangle.width = buttonSize.width;
        } else {
            buttonSize.height = buttonSize.height % 2 == 0 ? buttonSize.height / 2 - this.buttonGap / 2 - this.buttonGap % 2 : buttonSize.height / 2 - this.buttonGap / 2;
            this.topLeftRectangle.x = 0;
            this.topLeftRectangle.y = 0;
            this.topLeftRectangle.height = buttonSize.height;
            this.topLeftRectangle.width = buttonSize.width;
            this.bottomRightRectangle.x = 0;
            this.bottomRightRectangle.y = buttonSize.height + this.buttonGap;
            this.bottomRightRectangle.height = buttonSize.height;
            this.bottomRightRectangle.width = buttonSize.width;
        }
    }

    protected void checkEnabled() {
        if (!this.isEnabled()) {
            this.incrementButton.setEnabled(false);
            this.decrementButton.setEnabled(false);
            return;
        }
        boolean incEnabled = true;
        boolean decEnabled = true;
        BoundedNumberInterface model = this.getModel();
        if (model != null && !this.cycleValue) {
            Number newValue = model.getNumberValue();
            Number min = model.getMinimumNumber();
            Number max = model.getMaximumNumber();
            if (newValue instanceof Integer) {
                if (newValue.intValue() >= max.intValue()) {
                    incEnabled = false;
                }
                if (newValue.intValue() <= min.intValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Double) {
                if (newValue.doubleValue() >= max.doubleValue()) {
                    incEnabled = false;
                }
                if (newValue.doubleValue() <= min.doubleValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Float) {
                if (newValue.floatValue() >= max.floatValue()) {
                    incEnabled = false;
                }
                if (newValue.floatValue() <= min.floatValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Byte) {
                if (newValue.byteValue() >= max.byteValue()) {
                    incEnabled = false;
                }
                if (newValue.byteValue() <= min.byteValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Long) {
                if (newValue.longValue() >= max.longValue()) {
                    incEnabled = false;
                }
                if (newValue.longValue() <= min.longValue()) {
                    decEnabled = false;
                }
            } else if (newValue instanceof Short) {
                if (newValue.shortValue() >= max.shortValue()) {
                    incEnabled = false;
                }
                if (newValue.shortValue() <= min.shortValue()) {
                    decEnabled = false;
                }
            }
        }
        this.setIncrementEnabled(incEnabled);
        this.setDecrementEnabled(decEnabled);
    }

    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    public void fireAlarm(AlarmEvent evt) {
        long interval = this.valueChangeAlarm.getInterval();
        if (interval > 100L) {
            this.valueChangeAlarm.setInterval(interval - 100L);
        }
        if (this.incrementArrow.isPressed() && this.incrementEnabled) {
            this.incrementBy(1, 0);
            this.processEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
            return;
        }
        if (this.decrementArrow.isPressed() && this.decrementEnabled) {
            this.incrementBy(-1, 0);
            this.processEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
            return;
        }
    }

    public Alarm getAlarm() {
        return this.valueChangeAlarm;
    }

    public int getArrowDirection() {
        return this.arrowDirection;
    }

    @Override
    public final int getBlockIncrement() {
        return this.getBlockIncrementNumber().intValue();
    }

    public int getButtonGap() {
        return this.buttonGap;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public final int getMaximum() {
        return this.getMaximumNumber().intValue();
    }

    @Override
    public final int getMinimum() {
        return this.getMinimumNumber().intValue();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computePreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 0) {
            return new Dimension(22, 12);
        }
        return new Dimension(12, 22);
    }

    public long getStartInterval() {
        return this.startInterval;
    }

    void fireBooleanPropertyChange(String propertyName, boolean currentState) {
        if (currentState) {
            this.firePropertyChange(propertyName, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(propertyName, Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public final int getUnitIncrement() {
        return this.getUnitIncrementNumber().intValue();
    }

    @Override
    public final int getValue() {
        if (this.getNumberValue() != null) {
            return this.getNumberValue().intValue();
        }
        return 0;
    }

    @Override
    public int getVisibleAmount() {
        return 0;
    }

    public boolean isCycleOn() {
        return this.cycleValue;
    }

    public boolean isDecrementEnabled() {
        return this.decrementEnabled;
    }

    public boolean isIncrementEnabled() {
        return this.incrementEnabled;
    }

    public Number incrementBy(int increment, int incrementType) {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            Number oldValue = this.getNumberValue();
            if (this.cycleValue) {
                Number max = this.getMaximumNumber();
                Number min = this.getMinimumNumber();
                if (max.equals(oldValue) && increment > 0) {
                    Number newValue = new Long(max.longValue() + 1L);
                    if (max instanceof Double) {
                        newValue = new Double(max.doubleValue() + 1.0);
                    }
                    this.setNumberValue(newValue);
                    return this.getNumberValue();
                }
                if (min.equals(oldValue) && increment < 0) {
                    Number newValue = new Long(min.longValue() - 1L);
                    if (min instanceof Double) {
                        newValue = new Double(min.doubleValue() - 1.0);
                    }
                    this.setNumberValue(newValue);
                    return this.getNumberValue();
                }
            }
            return model.incrementBy(increment, incrementType);
        }
        return this.getNumberValue();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.calculateButtonLayout();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        Insets insets = this.getInsets();
        Rectangle rect = new Rectangle(insets.left, insets.top, this.getSize().width - insets.left - insets.right, this.getSize().height - insets.top - insets.bottom);
        Rectangle oldClip = (Rectangle)g.getClip();
        g.setClip(rect);
        this.incrementRectangle.translate(insets.left, insets.top);
        this.decrementRectangle.translate(insets.left, insets.top);
        this.incrementButton.setBounds(this.topLeftRectangle.x, this.topLeftRectangle.y, this.incrementRectangle.getSize().width, this.incrementRectangle.getSize().height);
        this.decrementButton.setBounds(this.bottomRightRectangle.x, this.bottomRightRectangle.y, this.decrementRectangle.getSize().width, this.decrementRectangle.getSize().height);
        g.setClip(oldClip);
    }

    public void stopAdjusting() {
        if (this.valueChangeAlarm.isRunning()) {
            this.valueChangeAlarm.stop();
        }
        this.incrementArrow.setPressed(false);
        this.decrementArrow.setPressed(false);
        this.incrementMouseClick = false;
        this.decrementMouseClick = false;
        this.incrementKeyTyped = false;
        this.decrementKeyTyped = false;
        this.repaint();
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (this.incrementMouseClick) {
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
            this.incrementArrow.setPressed(true);
            this.repaint();
        }
        if (this.decrementMouseClick) {
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
            this.decrementArrow.setPressed(true);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (this.incrementMouseClick) {
            this.valueChangeAlarm.stop();
            this.incrementArrow.setPressed(false);
            this.repaint();
        }
        if (this.decrementMouseClick) {
            this.valueChangeAlarm.stop();
            this.decrementArrow.setPressed(false);
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (e.getSource() == this.incrementButton && this.incrementEnabled) {
            this.incrementArrow.setPressed(true);
            this.incrementMouseClick = true;
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
        } else if (e.getSource() == this.decrementButton && this.decrementEnabled) {
            this.decrementArrow.setPressed(true);
            this.decrementMouseClick = true;
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (this.incrementArrow.isPressed()) {
            this.incrementArrow.setPressed(false);
            if (this.incrementEnabled) {
                this.incrementBy(1, 0);
                this.processEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
            }
            this.valueChangeAlarm.stop();
        }
        if (this.decrementArrow.isPressed()) {
            this.decrementArrow.setPressed(false);
            if (this.decrementEnabled) {
                this.incrementBy(-1, 0);
                this.processEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
            }
            this.valueChangeAlarm.stop();
        }
        this.incrementMouseClick = false;
        this.decrementMouseClick = false;
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (e.getKeyCode() != 32) {
            return;
        }
        if (e.getSource() == this.incrementButton && this.incrementEnabled) {
            if (this.incrementKeyTyped) {
                return;
            }
            this.incrementArrow.setPressed(true);
            this.incrementKeyTyped = true;
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
        } else if (e.getSource() == this.decrementButton && this.decrementEnabled) {
            if (this.decrementKeyTyped) {
                return;
            }
            this.decrementArrow.setPressed(true);
            this.decrementKeyTyped = true;
            this.valueChangeAlarm.setInterval(this.startInterval);
            this.valueChangeAlarm.setDelay(this.delay);
            if (this.startInterval > 0L) {
                this.valueChangeAlarm.start();
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.isEnabled()) {
            if (this.valueChangeAlarm.isRunning()) {
                this.valueChangeAlarm.stop();
            }
            return;
        }
        if (e.getKeyCode() != 32) {
            return;
        }
        if (this.incrementArrow.isPressed()) {
            this.incrementArrow.setPressed(false);
            if (this.incrementEnabled) {
                this.incrementBy(1, 0);
                this.processEvent(new AdjustmentEvent(this, 601, 1, this.getValue()));
            }
            this.valueChangeAlarm.stop();
        }
        if (this.decrementArrow.isPressed()) {
            this.decrementArrow.setPressed(false);
            if (this.decrementEnabled) {
                this.incrementBy(-1, 0);
                this.processEvent(new AdjustmentEvent(this, 601, 2, this.getValue()));
            }
            this.valueChangeAlarm.stop();
        }
        this.incrementKeyTyped = false;
        this.decrementKeyTyped = false;
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (eSource == this.getModel() && propName != null && oldValue != null && oldValue instanceof Number && newValue != null && newValue instanceof Number) {
            Integer oldIntegerValue = new Integer(((Number)oldValue).intValue());
            Integer newIntegerValue = new Integer(((Number)newValue).intValue());
            if (propName.equals("minimumNumber")) {
                this.checkEnabled();
                this.firePropertyChange("minimum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("maximumNumber")) {
                this.checkEnabled();
                this.firePropertyChange("maximum", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("numberValue")) {
                this.checkEnabled();
                this.firePropertyChange("value", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("blockIncrementNumber")) {
                this.firePropertyChange("blockIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            } else if (propName.equals("unitIncrementNumber")) {
                this.firePropertyChange("unitIncrement", oldIntegerValue, newIntegerValue);
                this.firePropertyChange(propName, oldValue, newValue);
            }
        }
    }

    public boolean isDefaultModelAttached() {
        return this.getModel().equals((Object)this.defaultRangeModel);
    }

    public BoundedNumberInterface getModel() {
        return this.spinButtonModel;
    }

    public void setModel(BoundedNumberInterface model) {
        BoundedNumberInterface oldModel = this.spinButtonModel;
        if (model == null) {
            if (this.spinButtonModel != null) {
                Util.removePropertyChangeListener((Object)this.spinButtonModel, (PropertyChangeListener)this);
            }
            model = new BoundedLong();
        }
        this.spinButtonModel = model;
        this.refresh((ModelInterface)this.spinButtonModel);
        this.firePropertyChange("model", oldModel, this.spinButtonModel);
    }

    public void refresh(ModelInterface model) {
        if (model != null && model instanceof BoundedNumberInterface) {
            Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)this);
            BoundedNumberInterface boundedNumber = (BoundedNumberInterface)model;
            Integer integerValue = new Integer(boundedNumber.getNumberValue().intValue());
            Integer integerMax = new Integer(boundedNumber.getMaximumNumber().intValue());
            Integer integerMin = new Integer(boundedNumber.getMinimumNumber().intValue());
            Integer integerBlock = new Integer(boundedNumber.getBlockIncrementNumber().intValue());
            Integer integerUnit = new Integer(boundedNumber.getUnitIncrementNumber().intValue());
            this.firePropertyChange("value", integerValue, integerValue);
            this.firePropertyChange("maximum", integerMax, integerMax);
            this.firePropertyChange("minimum", integerMin, integerMin);
            this.firePropertyChange("blockIncrement", integerBlock, integerBlock);
            this.firePropertyChange("unitIncrement", integerUnit, integerUnit);
            this.firePropertyChange("numberValue", boundedNumber.getNumberValue(), boundedNumber.getNumberValue());
            this.firePropertyChange("maximumNumber", boundedNumber.getMaximumNumber(), boundedNumber.getMaximumNumber());
            this.firePropertyChange("minimumNumber", boundedNumber.getMinimumNumber(), boundedNumber.getMinimumNumber());
            this.firePropertyChange("blockIncrementNumber", boundedNumber.getBlockIncrementNumber(), boundedNumber.getBlockIncrementNumber());
            this.firePropertyChange("unitIncrementNumber", boundedNumber.getUnitIncrementNumber(), boundedNumber.getUnitIncrementNumber());
            Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
            this.checkEnabled();
        }
    }

    public void setArrowDirection(int d) {
        if (d != this.arrowDirection) {
            Integer oldD = new Integer(this.arrowDirection);
            this.arrowDirection = d;
            if (this.arrowDirection == 2) {
                this.incrementArrow.setDirection(1);
                this.decrementArrow.setDirection(5);
            } else {
                this.incrementArrow.setDirection(7);
                this.decrementArrow.setDirection(3);
            }
            this.repaint();
            this.firePropertyChange("arrowDirection", oldD, new Integer(this.arrowDirection));
        }
    }

    @Override
    public final void setBlockIncrement(int block) {
        this.setBlockIncrementNumber(new Integer(block));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.repaint();
    }

    public void setButtonGap(int gap) {
        if (this.getButtonGap() != gap) {
            int oldButtonGap = this.buttonGap;
            this.buttonGap = gap;
            this.repaint();
            this.firePropertyChange("buttonGap", new Integer(oldButtonGap), new Integer(this.buttonGap));
        }
    }

    public void setCycleOn(boolean cycle) {
        if (this.cycleValue != cycle) {
            this.cycleValue = cycle;
            this.checkEnabled();
            this.fireBooleanPropertyChange("cycleOn", this.cycleValue);
        }
    }

    public void setDecrementEnabled(boolean decrEnabled) {
        this.decrementButton.setEnabled(decrEnabled);
        if (this.decrementEnabled != decrEnabled) {
            this.decrementEnabled = decrEnabled;
            this.repaint();
            this.fireBooleanPropertyChange("decrementEnabled", this.decrementEnabled);
        }
    }

    public void setDefaultValues() {
        this.setOpaque(false);
        this.swapped = false;
        this.incrementMouseClick = false;
        this.decrementMouseClick = false;
        this.incrementRaised = true;
        this.decrementRaised = true;
        this.incrementEnabled = true;
        this.decrementEnabled = true;
        this.buttonGap = 0;
        this.orientation = 1;
        this.topLeftRectangle = new Rectangle();
        this.bottomRightRectangle = new Rectangle();
        this.incrementRectangle = this.topLeftRectangle;
        this.decrementRectangle = this.bottomRightRectangle;
        this.incrementArrow = new ArrowIcon(1);
        this.decrementArrow = new ArrowIcon(5);
        this.incrementButton = new JButton((Icon)this.incrementArrow);
        this.decrementButton = new JButton((Icon)this.decrementArrow);
        this.incrementButton.setFocusPainted(false);
        this.decrementButton.setFocusPainted(false);
        this.incrementButton.setDefaultCapable(false);
        this.decrementButton.setDefaultCapable(false);
        this.incrementButton.setMargin(new Insets(0, 0, 0, 0));
        this.decrementButton.setMargin(new Insets(0, 0, 0, 0));
        this.setBackground(SystemColor.control);
        this.minimum = 0;
        this.maximum = 100;
        this.unitIncrement = 1;
        this.blockIncrement = 10;
        this.value = 0;
        this.delay = 400L;
        this.startInterval = 500L;
        this.valueChangeAlarm = new Alarm();
        this.valueChangeAlarm.setDelay(this.delay);
        this.valueChangeAlarm.setInterval(this.startInterval);
        this.valueChangeAlarm.addAlarmListener((AlarmListener)this);
        this.defaultRangeModel = new BoundedLong();
        this.spinButtonModel = new BoundedLong();
        this.setModel(this.spinButtonModel);
        this.arrowDirection = 2;
        this.incrementButton.addMouseListener(this);
        this.decrementButton.addMouseListener(this);
        this.incrementButton.addKeyListener(this);
        this.decrementButton.addKeyListener(this);
        this.add(this.incrementButton);
        this.add(this.decrementButton);
    }

    public synchronized void setAlarm(Alarm alarm) {
    }

    public void setDelay(long d) {
        if (d != this.delay) {
            long oldDelay = this.delay;
            this.delay = d;
            this.firePropertyChange("delay", new Long(oldDelay), new Long(this.delay));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.checkEnabled();
        }
    }

    public void setIncrementEnabled(boolean incrEnabled) {
        this.incrementButton.setEnabled(incrEnabled);
        if (this.incrementEnabled != incrEnabled) {
            this.incrementEnabled = incrEnabled;
            this.repaint();
            this.fireBooleanPropertyChange("incrementEnabled", this.incrementEnabled);
        }
    }

    @Override
    public final void setMaximum(int max) {
        this.setMaximumNumber(new Long(max));
    }

    @Override
    public final void setMinimum(int min) {
        this.setMinimumNumber(new Long(min));
    }

    public synchronized void setOrientation(int orient) {
        if (this.getOrientation() != orient) {
            int oldOrientation = this.orientation;
            if (orient != 0) {
                this.incrementRectangle = this.topLeftRectangle;
                this.decrementRectangle = this.bottomRightRectangle;
                this.swapped = false;
                this.orientation = 1;
            } else {
                this.incrementRectangle = this.bottomRightRectangle;
                this.decrementRectangle = this.topLeftRectangle;
                this.swapped = true;
                this.orientation = 0;
            }
            if (this.arrowDirection == 2) {
                this.setArrowDirection(3);
            } else {
                this.setArrowDirection(2);
            }
            Dimension size = this.getSize();
            this.setSize(size.height, size.width);
            this.repaint();
            this.firePropertyChange("orientation", new Integer(oldOrientation), new Integer(this.orientation));
        }
    }

    public synchronized void setStartInterval(long interval) {
        if (interval != this.startInterval) {
            long oldInterval = this.startInterval;
            this.startInterval = interval;
            this.firePropertyChange("startInterval", new Long(oldInterval), new Long(this.startInterval));
        }
    }

    @Override
    public final void setUnitIncrement(int unit) {
        this.setUnitIncrementNumber(new Long(unit));
    }

    @Override
    public final void setValue(int newValue) {
        this.setNumberValue(new Long(newValue));
    }

    public Number getUnitIncrementNumber() {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            return model.getUnitIncrementNumber();
        }
        return null;
    }

    public Number getBlockIncrementNumber() {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            return model.getBlockIncrementNumber();
        }
        return null;
    }

    public Number getMaximumNumber() {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            return model.getMaximumNumber();
        }
        return null;
    }

    public Number getMinimumNumber() {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            return model.getMinimumNumber();
        }
        return null;
    }

    public Number getNumberValue() {
        BoundedNumberInterface model = this.getModel();
        if (model != null) {
            return model.getNumberValue();
        }
        return null;
    }

    public synchronized void setMaximumNumber(Number max) {
        BoundedNumberInterface model = this.getModel();
        if (model != null && max != null) {
            model.setMaximumNumber(max);
        }
    }

    public synchronized void setMinimumNumber(Number min) {
        BoundedNumberInterface model = this.getModel();
        if (model != null && min != null) {
            model.setMinimumNumber(min);
        }
    }

    public synchronized void setBlockIncrementNumber(Number block) {
        BoundedNumberInterface model = this.getModel();
        if (model != null && block != null) {
            model.setBlockIncrementNumber(block);
        }
    }

    public synchronized void setUnitIncrementNumber(Number unit) {
        BoundedNumberInterface model = this.getModel();
        if (model != null && unit != null) {
            model.setUnitIncrementNumber(unit);
        }
    }

    public synchronized void setNumberValue(Number newValue) {
        BoundedNumberInterface model = this.getModel();
        if (model != null && newValue != null) {
            Number oldValue = model.getNumberValue();
            if (this.cycleValue) {
                Number max = model.getMaximumNumber();
                Number min = model.getMinimumNumber();
                if (oldValue instanceof Integer) {
                    if (newValue.intValue() > max.intValue()) {
                        newValue = min;
                    } else if (newValue.intValue() < min.intValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Double) {
                    if (newValue.doubleValue() > max.doubleValue()) {
                        newValue = min;
                    } else if (newValue.doubleValue() < min.doubleValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Float) {
                    if (newValue.floatValue() > max.floatValue()) {
                        newValue = min;
                    } else if (newValue.floatValue() < min.floatValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Byte) {
                    if (newValue.byteValue() > max.byteValue()) {
                        newValue = min;
                    } else if (newValue.byteValue() < min.byteValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Short) {
                    if (newValue.shortValue() > max.shortValue()) {
                        newValue = min;
                    } else if (newValue.shortValue() < min.shortValue()) {
                        newValue = max;
                    }
                } else if (oldValue instanceof Long) {
                    if (newValue.longValue() > max.longValue()) {
                        newValue = min;
                    } else if (newValue.longValue() < min.longValue()) {
                        newValue = max;
                    }
                }
            }
            model.setNumberValue(newValue);
        }
    }

    @Override
    public void setVisibleAmount(int amount) {
    }

    public synchronized int swapButtonFunction() {
        if (this.incrementRectangle == this.topLeftRectangle) {
            this.incrementRectangle = this.bottomRightRectangle;
            this.decrementRectangle = this.topLeftRectangle;
            this.swapped = true;
            return 1;
        }
        this.incrementRectangle = this.topLeftRectangle;
        this.decrementRectangle = this.bottomRightRectangle;
        this.swapped = false;
        return 0;
    }
}

