/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.RB;
import com.sas.text.Message;
import com.sas.visuals.ImageAnimation;
import com.sas.visuals.ImageAnimationIcon;
import com.sas.visuals.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ProgressDialog
extends JDialog {
    Dimension _defaultDimension;
    LabelView _label;
    Thread _commandThread;
    boolean _allowCancel;
    boolean _wasCancelled;
    ImageAnimation _imageAnimation;

    public ProgressDialog(Frame f, URL codeBase, String title) {
        this(f, codeBase, title, true, null);
    }

    public ProgressDialog(Frame f, URL codeBase, String title, boolean allowCancel) {
        this(f, codeBase, title, allowCancel, null);
    }

    public ProgressDialog(Frame f, URL codeBase, String title, boolean allowCancel, Dimension defaultDimension) {
        super(f, title, false);
        this._allowCancel = allowCancel;
        this._defaultDimension = defaultDimension;
        JPanel mainPane = new JPanel();
        mainPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPane.setLayout(new BorderLayout(8, 8));
        JPanel panel = new JPanel(new BorderLayout(8, 8));
        String[] images = new String[]{"MVAAnimation1", "MVAAnimation2", "MVAAnimation3", "MVAAnimation4"};
        try {
            this._imageAnimation = new ImageAnimation();
            this._imageAnimation.initialize();
            ImageAnimationIcon animationIcon = (ImageAnimationIcon)this._imageAnimation.getAnimationIcon();
            Image[] realImages = new Image[images.length];
            for (int i = 0; i < images.length; ++i) {
                realImages[i] = Resources.getImage((String)images[i]);
            }
            animationIcon.setImageSequence(realImages);
            this._imageAnimation.getAlarm().setInterval(500L);
            panel.add("West", this._imageAnimation);
        }
        catch (Exception animationIcon) {
            // empty catch block
        }
        this._label = new LabelView();
        panel.add("Center", (Component)this._label);
        mainPane.add("North", panel);
        if (this._allowCancel) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2));
            JButton btn = new JButton(Message.format((String)RB.getStringResource((String)"cancelButton.txt"), (Object)"   ", (Object)"   "));
            buttonPanel.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.onCancel();
                }
            });
            mainPane.add("South", buttonPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ProgressDialog.this.onCancel();
                }
            });
        }
        this.getContentPane().add(mainPane);
    }

    public void setCommandThread(Thread commandThread) {
        this._commandThread = commandThread;
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this._wasCancelled = false;
            this._imageAnimation.start();
        } else {
            this._imageAnimation.stop();
        }
        super.setVisible(vis);
    }

    public void setMessage(String msg) {
        this._label.setText(msg);
        this.validate();
        this.pack();
        if (this._defaultDimension != null) {
            this.setSize(this._defaultDimension);
        }
    }

    protected void onCancel() {
        this.setVisible(false);
        this._wasCancelled = true;
        if (this._commandThread != null) {
            this._commandThread.interrupt();
        }
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }
}

