/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.models.DefaultFontFamilyList;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.util.JTextFieldValidator;
import com.sas.swing.visuals.util.Util;
import com.sas.swing.visuals.util.ValidationUtil;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontPanel
extends JPanel
implements PropertyChangeListener {
    protected static final String RB_KEY = "FontPanel.";
    protected JPanel topPanel;
    protected JPanel alignmentPanel;
    protected JTextField fontText;
    protected JList fontList;
    protected JTextField styleText;
    protected JList styleList;
    protected JTextField sizeText;
    protected JList sizeList;
    protected Font currentFont;
    protected JLabel previewLabel;
    protected DefaultFontFamilyList defaultFontFamilyList;
    protected String STYLE_REGULAR;
    protected String STYLE_ITALIC;
    protected String STYLE_BOLD;
    protected String STYLE_BOLDITALIC;
    protected boolean useFontNameRenderer;
    protected boolean useFontStyleRenderer;
    protected boolean useFontSizeRenderer;
    protected JTextFieldValidator validator;
    protected static final String prevString = RB.getStringResource((String)"FontPanel.", (String)"SampleText.txt");
    static int[] FontTypes = new int[]{0, 2, 1, 3};
    protected static final int[] fontSizes = new int[]{8, 10, 12, 14, 16, 18, 20, 24, 28, 36, 48, 72};

    public FontPanel() {
        this.setDefaultValues();
        this.createComponents();
    }

    public void setDefaultValues() {
        this.useFontNameRenderer = true;
        this.useFontStyleRenderer = true;
        this.useFontSizeRenderer = false;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)outerLayout);
        this.STYLE_REGULAR = "Plain";
        this.STYLE_ITALIC = "Italic";
        this.STYLE_BOLD = "Bold";
        this.STYLE_BOLDITALIC = "BoldItalic";
    }

    public void createComponents() {
        this.createFontLists();
        this.createPreview();
    }

    public void createFontLists() {
        this.topPanel = new JPanel();
        AutoSizingGridLayout topLayout = new AutoSizingGridLayout(1, 3, 15, 5, true, false, true);
        topLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner(true));
        this.topPanel.setLayout((LayoutManager)topLayout);
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(3, 1, 2, 2, true, true, true);
        JPanel subPanel = new JPanel((LayoutManager)asgl);
        this.topPanel.add(subPanel);
        subPanel.add(new JLabel(RB.getStringResource((String)RB_KEY, (String)"Font.txt")));
        this.fontText = new JTextField();
        subPanel.add(this.fontText);
        this.fontText.setEditable(false);
        this.fontText.setMargin(new Insets(0, 2, 0, 2));
        this.fontList = new JList();
        this.defaultFontFamilyList = new DefaultFontFamilyList();
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        int cnt = this.defaultFontFamilyList.count();
        for (int i = 0; i < cnt; ++i) {
            dlm.addElement((String)this.defaultFontFamilyList.get(i));
        }
        this.fontList.setCellRenderer(new FontListCellRenderer());
        this.fontList.setModel(dlm);
        this.fontList.setSelectionMode(0);
        JScrollPane sp1 = new JScrollPane(this.fontList);
        Dimension panePreferredSize = new Dimension((int)(sp1.getPreferredSize().getWidth() * 2.0), (int)(sp1.getPreferredSize().getHeight() * 0.85));
        sp1.setPreferredSize(panePreferredSize);
        subPanel.add(sp1);
        subPanel = new JPanel((LayoutManager)asgl);
        this.topPanel.add(subPanel);
        subPanel.add(new JLabel(RB.getStringResource((String)RB_KEY, (String)"FontStyle.txt")));
        this.styleText = new JTextField();
        subPanel.add(this.styleText);
        this.styleText.setEditable(false);
        this.styleText.setMargin(new Insets(0, 2, 0, 2));
        this.styleList = new JList();
        dlm = new DefaultListModel();
        dlm.addElement(this.STYLE_REGULAR);
        dlm.addElement(this.STYLE_ITALIC);
        dlm.addElement(this.STYLE_BOLD);
        dlm.addElement(this.STYLE_BOLDITALIC);
        this.styleList.setCellRenderer(new FontListCellRenderer());
        this.styleList.setModel(dlm);
        this.styleList.setSelectionMode(0);
        sp1 = new JScrollPane(this.styleList);
        sp1.setPreferredSize(panePreferredSize);
        subPanel.add(sp1);
        subPanel = new JPanel((LayoutManager)asgl);
        this.topPanel.add(subPanel);
        subPanel.add(new JLabel(RB.getStringResource((String)RB_KEY, (String)"Size.txt")));
        this.sizeText = new JTextField();
        subPanel.add(this.sizeText);
        this.sizeText.setMargin(new Insets(0, 2, 0, 2));
        this.topPanel.add(subPanel);
        this.sizeList = new JList();
        dlm = new DefaultListModel();
        int selIndex = 0;
        for (int idx = 0; idx < fontSizes.length; ++idx) {
            dlm.addElement(String.valueOf(fontSizes[idx]));
        }
        this.sizeList.setModel(dlm);
        this.sizeList.setSelectedIndex(selIndex);
        this.sizeList.ensureIndexIsVisible(selIndex);
        this.sizeList.setSelectionMode(0);
        sp1 = new JScrollPane(this.sizeList);
        sp1.setPreferredSize(panePreferredSize);
        subPanel.add(sp1);
        this.add(this.topPanel);
    }

    public void createPreview() {
        JPanel pp = new JPanel(new BorderLayout());
        pp.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"Sample.txt"), (int)10, (int)10, (int)10, (int)10));
        JPanel pp2 = new JPanel(new BorderLayout());
        pp.add((Component)pp2, "Center");
        this.previewLabel = new JLabel(prevString);
        pp2.add((Component)this.previewLabel, "Center");
        Dimension d = pp.getPreferredSize();
        pp.setPreferredSize(new Dimension(d.width, (int)((double)d.height * 1.1)));
        this.add(pp);
    }

    public void initialize() {
        this.fontList.addListSelectionListener(new FontListListener());
        this.styleList.addListSelectionListener(new StyleListListener());
        this.sizeList.addListSelectionListener(new SizeListListener());
        this.validator = ValidationUtil.addJTextFieldValidator(this.sizeText, 1, Integer.MAX_VALUE);
        this.validator.addPropertyChangeListener(this);
    }

    public void setUseFontNameRenderer(boolean b) {
        if (this.useFontNameRenderer != b) {
            this.useFontNameRenderer = b;
            if (b) {
                this.fontList.setCellRenderer(new FontListCellRenderer());
            } else {
                this.fontList.setCellRenderer(new DefaultListCellRenderer());
            }
        }
    }

    public boolean getUseFontNameRenderer() {
        return this.useFontNameRenderer;
    }

    public void setUseFontStyleRenderer(boolean b) {
        if (this.useFontStyleRenderer != b) {
            this.useFontStyleRenderer = b;
            if (b) {
                this.styleList.setCellRenderer(new FontListCellRenderer());
            } else {
                this.styleList.setCellRenderer(new DefaultListCellRenderer());
            }
        }
    }

    public boolean getUseFontStyleRenderer() {
        return this.useFontStyleRenderer;
    }

    public void setUseFontSizeRenderer(boolean b) {
        if (this.useFontSizeRenderer != b) {
            this.useFontSizeRenderer = b;
            if (b) {
                this.sizeList.setCellRenderer(new FontListCellRenderer());
            } else {
                this.sizeList.setCellRenderer(new DefaultListCellRenderer());
            }
        }
    }

    public boolean getUseFontSizeRenderer() {
        return this.useFontSizeRenderer;
    }

    protected void updateFont() {
        this.firePropertyChange("selectedFont", null, this.getSelectedFont());
    }

    public Font getSelectedFont() {
        return this.currentFont;
    }

    public void setSelectedFont(Font ft) {
        this.setCurrentFont(ft);
        this.firePropertyChange("selectedFont", null, ft);
    }

    protected void setSelectedStyle(int style) {
        if (style >= 0) {
            int index = 0;
            if (1 + 2 == style) {
                this.styleText.setText(this.STYLE_BOLDITALIC);
                index = 3;
            } else if (1 == style) {
                this.styleText.setText(this.STYLE_BOLD);
                index = 2;
            } else if (2 == style) {
                this.styleText.setText(this.STYLE_ITALIC);
                index = 1;
            } else {
                this.styleText.setText(this.STYLE_REGULAR);
                index = 0;
            }
            this.styleList.setSelectedIndex(index);
            this.styleList.ensureIndexIsVisible(index);
        } else {
            this.styleList.clearSelection();
            this.styleText.setText("");
        }
    }

    protected void setSelectedName(String name) {
        if (!name.equals("")) {
            int index = this.defaultFontFamilyList.getIndex(name, 0);
            this.fontList.setSelectedIndex(index);
            this.fontList.ensureIndexIsVisible(index);
            this.fontText.setText(name);
        } else {
            this.fontList.clearSelection();
            this.fontText.setText("");
        }
    }

    protected void setSelectedSize(int size) {
        if (size >= 0) {
            String val = String.valueOf(size);
            DefaultListModel dlm = (DefaultListModel)this.sizeList.getModel();
            if (dlm.contains(val)) {
                this.sizeList.setSelectedValue(val, true);
                this.sizeText.setText(val);
            } else {
                this.sizeText.setText(val);
                this.sizeList.clearSelection();
            }
        } else {
            this.sizeList.clearSelection();
            this.sizeText.setText("");
        }
    }

    public void setCurrentFont(Font font) {
        this.currentFont = font;
        this.setSelectedName(this.currentFont.getName());
        this.setSelectedStyle(this.currentFont.getStyle());
        this.setSelectedSize(this.currentFont.getSize());
        this.previewLabel.setFont(this.currentFont);
        this.updateFont();
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    public void setCurrentFontName(String s) {
        this.setSelectedName(s);
        this.RecreateFont();
    }

    public String getCurrentFontName() {
        if (this.fontList.isSelectionEmpty()) {
            return "";
        }
        return (String)this.fontList.getSelectedValue();
    }

    public void setCurrentFontSize(int s) {
        this.setSelectedSize(s);
        this.RecreateFont();
    }

    public int getCurrentFontSize() {
        if (this.sizeList.isSelectionEmpty()) {
            int size = -1;
            if (this.sizeText.getText() != null) {
                size = new Integer(this.sizeText.getText());
            }
            return size;
        }
        return fontSizes[this.sizeList.getSelectedIndex()];
    }

    public void setCurrentFontStyle(int s) {
        this.setSelectedStyle(s);
        this.RecreateFont();
    }

    public int getCurrentFontStyle() {
        if (this.styleList.isSelectionEmpty()) {
            return -1;
        }
        return FontTypes[this.styleList.getSelectedIndex()];
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.validator && evt.getPropertyName().equals("valid") && evt.getNewValue() instanceof Boolean && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.setCurrentFontSize(new Integer(this.sizeText.getText()));
        }
    }

    void RecreateFont() {
        if (!this.fontList.isSelectionEmpty() && !this.styleList.isSelectionEmpty()) {
            int size = this.getCurrentFontSize();
            if (size > 0) {
                this.currentFont = new Font((String)this.fontList.getSelectedValue(), FontTypes[this.styleList.getSelectedIndex()], size);
                this.previewLabel.setFont(this.currentFont);
                if (!this.previewLabel.isVisible()) {
                    this.previewLabel.setVisible(true);
                    this.previewLabel.invalidate();
                    this.previewLabel.getParent().validate();
                }
            } else {
                this.previewLabel.setVisible(false);
            }
        } else {
            this.previewLabel.setVisible(false);
        }
        this.updateFont();
    }

    class FontListCellRenderer
    extends DefaultListCellRenderer {
        FontListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                String temp = (String)value;
                if (list == FontPanel.this.fontList) {
                    this.setFont(new Font(temp, list.getFont().getStyle(), list.getFont().getSize()));
                } else if (list == FontPanel.this.styleList) {
                    this.setFont(new Font(list.getFont().getFontName(), FontTypes[index], list.getFont().getSize()));
                } else if (list == FontPanel.this.sizeList) {
                    this.setFont(new Font(list.getFont().getFontName(), list.getFont().getStyle(), fontSizes[index]));
                }
            }
            return this;
        }
    }

    class FontListListener
    extends KeyAdapter
    implements ListSelectionListener {
        FontListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            JList source = (JList)event.getSource();
            if (event.getValueIsAdjusting() || source.getSelectedValue() == null) {
                return;
            }
            String selItem = (String)source.getSelectedValue();
            FontPanel.this.fontText.setText(selItem);
            FontPanel.this.RecreateFont();
        }
    }

    class StyleListListener
    extends KeyAdapter
    implements ListSelectionListener {
        StyleListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            JList source = (JList)event.getSource();
            if (event.getValueIsAdjusting() || source.getSelectedValue() == null) {
                return;
            }
            String selItem = (String)source.getSelectedValue();
            FontPanel.this.styleText.setText(selItem);
            FontPanel.this.RecreateFont();
        }
    }

    class SizeListListener
    extends KeyAdapter
    implements ListSelectionListener {
        SizeListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            JList source = (JList)event.getSource();
            if (event.getValueIsAdjusting() || source.getSelectedValue() == null) {
                return;
            }
            String selItem = (String)source.getSelectedValue();
            FontPanel.this.sizeText.setText(selItem);
            FontPanel.this.RecreateFont();
        }
    }
}

