/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.ComponentException;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Permuter;
import com.sas.collection.StaticOrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.swing.models.ListModelAdapter;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.RB;
import com.sas.text.Message;
import com.sas.util.IndexedGetInterface;
import com.sas.util.IndexedSetInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.MinMaxSpacePartitioner;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DualSelector
extends JComponent
implements ActionListener,
ListSelectionListener,
ListDataListener,
ViewDefaultModel {
    static final long serialVersionUID = 3422201980233088388L;
    static final String[] requiredInterfacesString = new String[]{"javax.swing.ListModel"};
    private boolean initialized = false;
    private boolean list1ControlsVisible;
    private boolean list2ControlsVisible;
    private boolean transferAllControlsVisible;
    private boolean transferLeftControlsVisible;
    private boolean transferRightControlsVisible;
    private boolean dynamic;
    private boolean modelEventsIgnored;
    private boolean clearSelection;
    private int list1MaximumCount;
    private int list2MaximumCount;
    private ListCellRenderer cellRenderer;
    protected JPanel mainPanel;
    protected MinMaxSpacePartitioner partitioner;
    protected boolean copyMode = false;
    protected boolean copyModeDuplicates = true;
    protected JLabel label1;
    protected JLabel label2;
    protected JList jList1;
    protected JList jList2;
    protected JButton alternatingButton;
    protected JButton leftButton;
    protected JButton rightButton;
    protected JButton allRightButton;
    protected JButton allLeftButton;
    protected JButton down1Button;
    protected JButton down2Button;
    protected JButton up1Button;
    protected JButton up2Button;
    private transient ListModel listModel1;
    private transient ListModel listModel2;
    private transient ListModel list1;
    private transient ListModel list2;
    private transient boolean defaultModelsSetCalled;
    private transient boolean direction;
    private transient boolean linksSet;
    private transient boolean usingDynamic;
    private transient Icon leftArrow;
    private transient Icon rightArrow;
    private transient Dimension preferredSize;
    private static final boolean RIGHT = false;
    private static final boolean LEFT = true;
    static int defaultWidth = 325;
    static int defaultHeight = 148;
    static boolean alternatingButtonStyle = true;
    private boolean designTime;
    private static final String RB_KEY = "DualSelector.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "dynamic"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"dynamic.pd.txt")}}, {{"Name", "model"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Model.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}, {{"Name", "list1ControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1ControlsVisible.pd.txt")}}, {{"Name", "list1Count"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Count.pd.txt")}}, {{"Name", "list1Items"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Items.pd.txt")}}, {{"Name", "list1Label"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Label.pd.txt")}}, {{"Name", "list1MaximumCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1MaximumCount.pd.txt")}}, {{"Name", "list2ControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2ControlsVisible.pd.txt")}}, {{"Name", "list2Count"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Count.pd.txt")}}, {{"Name", "list2Items"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Items.pd.txt")}}, {{"Name", "list2Label"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Label.pd.txt")}}, {{"Name", "list2MaximumCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2MaximumCount.pd.txt")}}, {{"Name", "list2Model"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Model.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}, {{"Name", "modelEventsIgnored"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"modelEventsIgnored.pd.txt")}, {"Expert", "true"}}, {{"Name", "transferAllControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"transferAllControlsVisible.pd.txt")}}, {{"Name", "opaque"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultOutputPropertyName = "list2Items";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public DualSelector() {
        this.setDefaultValues();
        this.setDesignTime(com.sas.beans.Util.isDesignTime());
        this.updateUI();
    }

    private void setDesignTime(boolean newValue) {
        this.designTime = newValue;
    }

    private boolean isDesignTime() {
        return this.designTime;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newValue) {
        defaultWidth = newValue;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newValue) {
        defaultHeight = newValue;
    }

    public static synchronized void setAlternatingButtonStyle(boolean style) {
        alternatingButtonStyle = style;
    }

    public static boolean getAlternatingButtonStyle() {
        return alternatingButtonStyle;
    }

    public synchronized void setCopyModeEnabled(boolean mode) {
        this.copyMode = mode;
    }

    public boolean getCopyMode() {
        return this.copyMode;
    }

    public synchronized void setCopyModeDuplicatesEnabled(boolean duplicates) {
        this.copyModeDuplicates = duplicates;
    }

    public boolean getCopyModeDuplicates() {
        return this.copyModeDuplicates;
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer newValue) {
        if (newValue == this.cellRenderer) {
            return;
        }
        ListCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = newValue;
        this.jList1.setCellRenderer(newValue);
        this.jList2.setCellRenderer(newValue);
        this.firePropertyChange("cellRenderer", oldValue, newValue);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean newValue) {
        boolean isList2AnOC;
        if (this.dynamic == newValue) {
            return;
        }
        boolean isList1AnOC = this.getModel() == null || this.getModel() instanceof DefaultListModel;
        boolean bl = isList2AnOC = this.getList2Model() == null || this.getList2Model() instanceof DefaultListModel;
        if (this.getModel() instanceof ListModelAdapter && ((ListModelAdapter)this.getModel()).getModel() instanceof OrderedCollectionInterface) {
            isList1AnOC = true;
        }
        if (this.getList2Model() instanceof ListModelAdapter && ((ListModelAdapter)this.getList2Model()).getModel() instanceof OrderedCollectionInterface) {
            isList2AnOC = true;
        }
        if (!(!newValue || isList1AnOC && isList2AnOC)) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"modelNotDynamic.ex.txt"));
        }
        this.dynamic = newValue;
        this.refresh();
        this.firePropertyChange("dynamic", this.dynamic ? Boolean.FALSE : Boolean.TRUE, this.dynamic ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isList1ControlsVisible() {
        return this.list1ControlsVisible;
    }

    public void setList1ControlsVisible(boolean newValue) {
        if (newValue == this.list1ControlsVisible) {
            return;
        }
        this.list1ControlsVisible = newValue;
        this.up1Button.setVisible(newValue);
        this.down1Button.setVisible(newValue);
        this.ensureButtonsEnabled();
        this.validate();
        this.repaint();
        this.firePropertyChange("list1ControlsVisible", this.list1ControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.list1ControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getList1Count() {
        return this.jList1.getModel().getSize();
    }

    public ListCellRenderer getList1CellRenderer() {
        return this.jList1.getCellRenderer();
    }

    public void setList1CellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.jList1.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.jList1.setCellRenderer(newValue);
        this.firePropertyChange("list1CellRenderer", oldValue, newValue);
    }

    public StaticOrderedCollectionInterface getList1Items() {
        if (this.list1 instanceof DefaultListModel) {
            return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection(((DefaultListModel)this.list1).toArray()));
        }
        if (this.list1 instanceof ListModelAdapter && ((ListModelAdapter)this.list1).getModel() instanceof OrderedCollectionInterface) {
            return new StaticOrderedCollection((StaticOrderedCollectionInterface)((OrderedCollectionInterface)((ListModelAdapter)this.list1).getModel()));
        }
        DefaultListModel dlm = new DefaultListModel();
        for (int i = 0; i < this.list1.getSize(); ++i) {
            dlm.addElement(this.list1.getElementAt(i));
        }
        return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection(dlm.toArray()));
    }

    public String getList1Label() {
        return this.label1.getText();
    }

    public void setList1Label(String newValue) {
        String oldLabel = this.label1.getText();
        if (com.sas.util.Util.equal((Object)oldLabel, (Object)newValue)) {
            return;
        }
        this.label1.setText(newValue);
        this.firePropertyChange("list1Label", oldLabel, newValue);
    }

    public int getList1MaximumCount() {
        return this.list1MaximumCount;
    }

    public void setList1MaximumCount(int newValue) {
        if (newValue == this.list1MaximumCount) {
            return;
        }
        if (newValue != -1 && this.getList1Count() > newValue) {
            throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidCount.ex.txt"), (Object)new Integer(newValue), (Object)new Integer(1), (Object)new Integer(this.getList1Count())));
        }
        Integer oldValue = new Integer(this.list1MaximumCount);
        this.list1MaximumCount = newValue;
        this.firePropertyChange("list1MaximumCount", oldValue, new Integer(newValue));
        this.ensureButtonsEnabled();
    }

    public boolean isList2ControlsVisible() {
        return this.list2ControlsVisible;
    }

    public void setList2ControlsVisible(boolean newValue) {
        if (newValue == this.list2ControlsVisible) {
            return;
        }
        this.list2ControlsVisible = newValue;
        this.up2Button.setVisible(newValue);
        this.down2Button.setVisible(newValue);
        this.ensureButtonsEnabled();
        this.validate();
        this.repaint();
        this.firePropertyChange("list2ControlsVisible", this.list2ControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.list2ControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getList2Count() {
        return this.jList2.getModel().getSize();
    }

    public ListCellRenderer getList2CellRenderer() {
        return this.jList2.getCellRenderer();
    }

    public void setList2CellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.jList2.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.jList2.setCellRenderer(newValue);
        this.firePropertyChange("list2CellRenderer", oldValue, newValue);
    }

    public StaticOrderedCollectionInterface getList2Items() {
        if (this.list2 instanceof DefaultListModel) {
            return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection(((DefaultListModel)this.list2).toArray()));
        }
        if (this.list2 instanceof ListModelAdapter && ((ListModelAdapter)this.list2).getModel() instanceof OrderedCollectionInterface) {
            return (OrderedCollectionInterface)((ListModelAdapter)this.list2).getModel();
        }
        DefaultListModel dlm = new DefaultListModel();
        for (int i = 0; i < this.list2.getSize(); ++i) {
            dlm.addElement(this.list2.getElementAt(i));
        }
        return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection(dlm.toArray()));
    }

    public String getList2Label() {
        return this.label2.getText();
    }

    public void setList2Label(String newValue) {
        String oldValue = this.label2.getText();
        if (com.sas.util.Util.equal((Object)newValue, (Object)oldValue)) {
            return;
        }
        this.label2.setText(newValue);
        this.firePropertyChange("list2Label", oldValue, newValue);
    }

    public int getList2MaximumCount() {
        return this.list2MaximumCount;
    }

    public void setList2MaximumCount(int newValue) {
        if (newValue == this.list2MaximumCount) {
            return;
        }
        if (newValue != -1 && this.getList2Count() > newValue) {
            throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidCount.ex.txt"), (Object)new Integer(newValue), (Object)new Integer(2), (Object)new Integer(this.getList2Count())));
        }
        Integer oldValue = new Integer(this.list2MaximumCount);
        this.list2MaximumCount = newValue;
        this.firePropertyChange("list2MaximumCount", oldValue, new Integer(newValue));
        this.ensureButtonsEnabled();
    }

    @Override
    public void setEnabled(boolean e) {
        if (e != this.isEnabled() && this.initialized) {
            super.setEnabled(e);
            Util.setEnabledOnContainer(this, e);
        }
    }

    public boolean isModelEventsIgnored() {
        return this.modelEventsIgnored;
    }

    public void setModelEventsIgnored(boolean newValue) {
        if (this.modelEventsIgnored == newValue) {
            return;
        }
        this.modelEventsIgnored = newValue;
        ListModel listModel = this.getModel();
        if (listModel != null) {
            if (this.modelEventsIgnored || com.sas.beans.Util.isDesignTime()) {
                listModel.removeListDataListener(this);
            } else {
                listModel.addListDataListener(this);
            }
        }
        if ((listModel = this.getList2Model()) != null) {
            if (this.modelEventsIgnored || this.isDesignTime()) {
                listModel.removeListDataListener(this);
            } else {
                listModel.addListDataListener(this);
            }
        }
        this.firePropertyChange("modelEventsIgnored", this.modelEventsIgnored ? Boolean.FALSE : Boolean.TRUE, this.modelEventsIgnored ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTransferAllControlsVisible() {
        return this.transferAllControlsVisible;
    }

    public void setTransferAllControlsVisible(boolean newValue) {
        if (newValue == this.transferAllControlsVisible) {
            return;
        }
        this.transferAllControlsVisible = newValue;
        this.allRightButton.setVisible(this.transferAllControlsVisible);
        this.allLeftButton.setVisible(this.transferAllControlsVisible);
        this.validate();
        this.repaint();
        this.firePropertyChange("transferAllControlsVisible", this.transferAllControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.transferAllControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.mainPanel != null) {
            this.mainPanel.setToolTipText(text);
        }
        if (this.label1 != null) {
            this.label1.setToolTipText(text);
        }
        if (this.label2 != null) {
            this.label2.setToolTipText(text);
        }
        if (this.jList1 != null) {
            this.jList1.setToolTipText(text);
        }
        if (this.jList2 != null) {
            this.jList2.setToolTipText(text);
        }
        if (this.alternatingButton != null) {
            this.alternatingButton.setToolTipText(text);
        }
        if (this.leftButton != null) {
            this.leftButton.setToolTipText(text);
        }
        if (this.rightButton != null) {
            this.rightButton.setToolTipText(text);
        }
        if (this.allRightButton != null) {
            this.allRightButton.setToolTipText(text);
        }
        if (this.allLeftButton != null) {
            this.allLeftButton.setToolTipText(text);
        }
        if (this.down1Button != null) {
            this.down1Button.setToolTipText(text);
        }
        if (this.down2Button != null) {
            this.down2Button.setToolTipText(text);
        }
        if (this.up1Button != null) {
            this.up1Button.setToolTipText(text);
        }
        if (this.up2Button != null) {
            this.up2Button.setToolTipText(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void moveListItem(ListModel listModel, boolean moveItemUp) {
        JList jList = listModel == this.list1 ? this.jList1 : this.jList2;
        int[] indexes = jList.getSelectedIndices();
        if (indexes.length > 0) {
            int i2;
            boolean modelIgnored = this.isModelEventsIgnored();
            if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                listModel.removeListDataListener(this);
            }
            int offset = moveItemUp ? -1 : 1;
            OrderedCollection oci = null;
            try {
                if (listModel instanceof DefaultListModel) {
                    oci = new OrderedCollection(((DefaultListModel)listModel).toArray());
                } else if (listModel instanceof ListModelAdapter && ((ListModelAdapter)listModel).getModel() instanceof OrderedCollectionInterface) {
                    oci = (OrderedCollectionInterface)((ListModelAdapter)listModel).getModel();
                }
                if (oci != null) {
                    if (indexes.length == 1) {
                        Permuter.move((IndexedSetInterface)oci, (int)indexes[0], (int)offset);
                    } else {
                        Permuter.move((IndexedSetInterface)oci, (int[])indexes, (int)offset);
                    }
                    i2 = 0;
                    while (i2 < indexes.length) {
                        int n = i2++;
                        indexes[n] = indexes[n] + offset;
                    }
                }
            }
            catch (IllegalArgumentException i2) {
            }
            finally {
                if (listModel instanceof DefaultListModel) {
                    for (i2 = 0; i2 < oci.count(); ++i2) {
                        ((DefaultListModel)listModel).setElementAt(oci.get(i2), i2);
                    }
                } else if (listModel instanceof ListModelAdapter && ((ListModelAdapter)listModel).getModel() instanceof OrderedCollectionInterface) {
                    ((ListModelAdapter)listModel).setModel((IndexedGetInterface)oci);
                }
            }
            if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                listModel.addListDataListener(this);
            }
            if (listModel == this.list1) {
                this.firePropertyChange("list1Items", null, this.getList1Items());
            } else {
                this.firePropertyChange("list2Items", null, this.getList2Items());
            }
            jList.clearSelection();
            jList.setSelectedIndices(indexes);
            if (indexes.length > 0) {
                jList.ensureIndexIsVisible(indexes[0]);
            }
        }
    }

    public synchronized void moveList1ItemUp() {
        this.moveListItem(this.list1, true);
    }

    public synchronized void moveList1ItemDown() {
        this.moveListItem(this.list1, false);
    }

    public synchronized void moveList2ItemUp() {
        this.moveListItem(this.list2, true);
    }

    public synchronized void moveList2ItemDown() {
        this.moveListItem(this.list2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferAllItems(ListModel fromList, ListModel toList) {
        ListModel listModel = fromList;
        synchronized (listModel) {
            ListModel listModel2 = toList;
            synchronized (listModel2) {
                int maxCount;
                int count = fromList.getSize() + toList.getSize();
                int n = maxCount = fromList == this.list1 ? this.getList2MaximumCount() : this.getList1MaximumCount();
                if (maxCount == -1 || count <= maxCount) {
                    int i;
                    boolean modelIgnored = this.isModelEventsIgnored();
                    if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                        fromList.removeListDataListener(this);
                        toList.removeListDataListener(this);
                    }
                    Vector fromItems = new Vector(fromList.getSize());
                    int cnt = fromList.getSize();
                    for (i = 0; i < cnt; ++i) {
                        fromItems.addElement(fromList.getElementAt(i));
                    }
                    if (!this.copyMode || this.copyMode && fromList == this.list2) {
                        if (fromList instanceof DefaultListModel) {
                            ((DefaultListModel)fromList).removeAllElements();
                        } else if (fromList instanceof ListModelAdapter && ((ListModelAdapter)fromList).getModel() instanceof OrderedCollectionInterface) {
                            ((OrderedCollectionInterface)((ListModelAdapter)fromList).getModel()).removeAll();
                        }
                    }
                    if (!this.copyModeDuplicates) {
                        for (i = 0; i < toList.getSize(); ++i) {
                            for (int j = fromItems.size() - 1; j > -1; --j) {
                                if (fromItems.elementAt(j) != toList.getElementAt(i)) continue;
                                fromItems.remove(j);
                            }
                        }
                    }
                    if (this.copyMode && fromList == this.list1 || !this.copyMode) {
                        if (toList instanceof DefaultListModel) {
                            Enumeration e = fromItems.elements();
                            while (e.hasMoreElements()) {
                                ((DefaultListModel)toList).addElement(e.nextElement());
                            }
                        } else if (toList instanceof ListModelAdapter && ((ListModelAdapter)toList).getModel() instanceof OrderedCollectionInterface) {
                            ((OrderedCollectionInterface)((ListModelAdapter)toList).getModel()).addItems(fromItems.elements());
                        }
                    }
                    if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                        fromList.addListDataListener(this);
                        toList.addListDataListener(this);
                    }
                    this.ensureButtonsEnabled();
                    this.firePropertyChange("list1Items", null, this.getList1Items());
                    this.firePropertyChange("list2Items", null, this.getList2Items());
                }
            }
        }
    }

    public synchronized void transferAllList1Items() {
        this.transferAllItems(this.list1, this.list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferListItems(ListModel fromList, ListModel toList) {
        JList jList = fromList == this.list1 ? this.jList1 : this.jList2;
        int maxCnt = fromList == this.list1 ? this.getList2MaximumCount() : this.getList1MaximumCount();
        int[] selectedIndexes = jList.getSelectedIndices();
        if (selectedIndexes != null && selectedIndexes.length > 0) {
            ListModel listModel = fromList;
            synchronized (listModel) {
                ListModel listModel2 = toList;
                synchronized (listModel2) {
                    int count = selectedIndexes.length + toList.getSize();
                    if (maxCnt == -1 || count <= maxCnt) {
                        int i;
                        boolean modelIgnored = this.isModelEventsIgnored();
                        if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                            fromList.removeListDataListener(this);
                            toList.removeListDataListener(this);
                        }
                        int numberOfRemoves = 0;
                        Vector selectedItems = new Vector();
                        for (i = 0; i < selectedIndexes.length; ++i) {
                            Object item = fromList.getElementAt(selectedIndexes[i] - numberOfRemoves);
                            selectedItems.addElement(item);
                            if (this.copyMode && (!this.copyMode || fromList != this.list2)) continue;
                            if (fromList instanceof DefaultListModel) {
                                ((DefaultListModel)fromList).removeElementAt(selectedIndexes[i] - numberOfRemoves);
                            } else if (fromList instanceof ListModelAdapter && ((ListModelAdapter)fromList).getModel() instanceof OrderedCollectionInterface) {
                                ((OrderedCollectionInterface)((ListModelAdapter)fromList).getModel()).removeAt(selectedIndexes[i] - numberOfRemoves);
                            }
                            ++numberOfRemoves;
                        }
                        if (!this.copyModeDuplicates) {
                            for (i = 0; i < toList.getSize(); ++i) {
                                int size = selectedItems.size();
                                for (int j = 0; j < size; ++j) {
                                    if (selectedItems.elementAt(j) != toList.getElementAt(i)) continue;
                                    selectedItems.remove(j);
                                    if (selectedItems.size() < i) continue;
                                    j = size;
                                }
                            }
                        }
                        if (selectedItems.size() > 0 && (this.copyMode && fromList == this.list1 || !this.copyMode)) {
                            if (toList instanceof DefaultListModel) {
                                Enumeration e = selectedItems.elements();
                                while (e.hasMoreElements()) {
                                    ((DefaultListModel)toList).addElement(e.nextElement());
                                }
                            } else if (toList instanceof ListModelAdapter && ((ListModelAdapter)toList).getModel() instanceof OrderedCollectionInterface) {
                                ((OrderedCollectionInterface)((ListModelAdapter)toList).getModel()).addItems(selectedItems.elements());
                            }
                        }
                        if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                            fromList.addListDataListener(this);
                            toList.addListDataListener(this);
                        }
                        jList.getSelectionModel().clearSelection();
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("list1Items", null, this.getList1Items());
                        this.firePropertyChange("list2Items", null, this.getList2Items());
                    }
                }
            }
        }
    }

    public synchronized void transferList1Items() {
        this.transferListItems(this.list1, this.list2);
    }

    public synchronized void transferAllList2Items() {
        this.transferAllItems(this.list2, this.list1);
    }

    public synchronized void transferList2Items() {
        this.transferListItems(this.list2, this.list1);
    }

    public Dimension computePreferredSize() {
        if (this.preferredSize != null) {
            this.preferredSize.width = DualSelector.getDefaultWidth();
            this.preferredSize.height = DualSelector.getDefaultHeight();
        } else {
            this.preferredSize = new Dimension(defaultWidth, defaultHeight);
        }
        return this.preferredSize;
    }

    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation == 4 || representation == 1) {
            return 4;
        }
        return -1;
    }

    private void ensureButtonsEnabled() {
        int selCount;
        int numSelected = selCount = (!this.direction ? this.jList1.getSelectedIndices().length : this.jList2.getSelectedIndices().length) - 1;
        if (selCount < 0) {
            selCount = 0;
        }
        int list1Count = this.jList1.getModel().getSize();
        int list2Count = this.jList2.getModel().getSize();
        if (this.isEnabled()) {
            boolean enable = false;
            int maxCnt1 = this.getList1MaximumCount();
            int maxCnt2 = this.getList2MaximumCount();
            if (!this.direction) {
                enable = list2Count + selCount < maxCnt2 || maxCnt2 == -1;
            } else {
                boolean bl = enable = list1Count + selCount < maxCnt1 || maxCnt1 == -1;
            }
            if (alternatingButtonStyle) {
                this.alternatingButton.setEnabled(enable);
            } else if (!this.direction) {
                this.leftButton.setEnabled(false);
                this.rightButton.setEnabled(true);
            } else {
                this.leftButton.setEnabled(true);
                this.rightButton.setEnabled(false);
            }
            boolean bl = enable = list1Count + list2Count < maxCnt1 || maxCnt1 == -1;
            if (list2Count > 0) {
                this.allLeftButton.setEnabled(enable);
            } else {
                this.allLeftButton.setEnabled(false);
            }
            boolean bl2 = enable = list1Count + list2Count < maxCnt2 || maxCnt2 == -1;
            if (list1Count > 0) {
                this.allRightButton.setEnabled(enable);
            } else {
                this.allRightButton.setEnabled(false);
            }
        }
        if (this.direction) {
            if (this.list1ControlsVisible) {
                this.up1Button.setEnabled(false);
                this.down1Button.setEnabled(false);
            }
            if (this.list2ControlsVisible && numSelected >= 0 && list2Count > 1 && numSelected != list2Count - 1) {
                if (!this.jList2.isSelectedIndex(0)) {
                    this.up2Button.setEnabled(true);
                } else {
                    this.up2Button.setEnabled(false);
                }
                if (!this.jList2.isSelectedIndex(list2Count - 1)) {
                    this.down2Button.setEnabled(true);
                } else {
                    this.down2Button.setEnabled(false);
                }
            } else if (this.list2ControlsVisible) {
                this.up2Button.setEnabled(false);
                this.down2Button.setEnabled(false);
            }
        } else {
            if (this.list2ControlsVisible) {
                this.up2Button.setEnabled(false);
                this.down2Button.setEnabled(false);
            }
            if (this.list1ControlsVisible && numSelected >= 0 && list1Count > 1 && numSelected != list1Count - 1) {
                if (!this.jList1.isSelectedIndex(0)) {
                    this.up1Button.setEnabled(true);
                } else {
                    this.up1Button.setEnabled(false);
                }
                if (!this.jList1.isSelectedIndex(list1Count - 1)) {
                    this.down1Button.setEnabled(true);
                } else {
                    this.down1Button.setEnabled(false);
                }
            } else if (this.list1ControlsVisible) {
                this.up1Button.setEnabled(false);
                this.down1Button.setEnabled(false);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computePreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    private void init() {
        MouseAdapter mouseListener;
        if (this.leftArrow == null) {
            this.leftArrow = new ImageIcon(Resources.getImage((String)"LeftArrow"));
        }
        if (this.rightArrow == null) {
            this.rightArrow = new ImageIcon(Resources.getImage((String)"RightArrow"));
        }
        if (this.label1 == null) {
            this.label1 = new JLabel(RB.getStringResource((String)RB_KEY, (String)"available.txt"));
        }
        if (this.label2 == null) {
            this.label2 = new JLabel(RB.getStringResource((String)RB_KEY, (String)"selected.txt"));
        }
        if (this.jList1 == null) {
            this.jList1 = new JList();
            mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DualSelector.this.transferList1Items();
                    }
                }
            };
            this.jList1.addMouseListener(mouseListener);
        }
        if (this.jList2 == null) {
            this.jList2 = new JList();
            mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DualSelector.this.transferList2Items();
                    }
                }
            };
            this.jList2.addMouseListener(mouseListener);
        }
        if (this.allRightButton == null) {
            this.allRightButton = new JButton((String)null);
        }
        ImageIcon icon = new ImageIcon(Resources.getImage((String)"DoubleRightArrow"));
        this.allRightButton.setIcon(icon);
        this.allRightButton.setMargin(new Insets(0, 0, 0, 0));
        this.allRightButton.setDefaultCapable(false);
        this.allRightButton.setFocusPainted(true);
        if (alternatingButtonStyle) {
            if (this.alternatingButton == null) {
                this.alternatingButton = new JButton((String)null);
            }
            this.alternatingButton.setIcon(this.rightArrow);
            this.alternatingButton.setMargin(new Insets(0, 0, 0, 0));
            this.alternatingButton.setDefaultCapable(false);
            this.alternatingButton.setFocusPainted(true);
        } else {
            if (this.leftButton == null) {
                this.leftButton = new JButton((String)null);
            }
            this.leftButton.setIcon(this.leftArrow);
            this.leftButton.setMargin(new Insets(0, 0, 0, 0));
            this.leftButton.setDefaultCapable(false);
            this.leftButton.setFocusPainted(true);
            if (this.rightButton == null) {
                this.rightButton = new JButton((String)null);
            }
            this.rightButton.setIcon(this.rightArrow);
            this.rightButton.setMargin(new Insets(0, 0, 0, 0));
            this.rightButton.setDefaultCapable(false);
            this.rightButton.setFocusPainted(true);
        }
        if (this.allLeftButton == null) {
            this.allLeftButton = new JButton((String)null);
        }
        icon = new ImageIcon(Resources.getImage((String)"DoubleLeftArrow"));
        this.allLeftButton.setIcon(icon);
        this.allLeftButton.setMargin(new Insets(0, 0, 0, 0));
        this.allLeftButton.setDefaultCapable(false);
        this.allLeftButton.setFocusPainted(true);
        if (this.up1Button == null) {
            this.up1Button = new JButton((String)null);
        }
        icon = new ImageIcon(Resources.getImage((String)"UpArrow"));
        this.up1Button.setIcon(icon);
        this.up1Button.setMargin(new Insets(0, 0, 0, 0));
        this.up1Button.setDefaultCapable(false);
        this.up1Button.setFocusPainted(true);
        if (this.up2Button == null) {
            this.up2Button = new JButton((String)null);
        }
        this.up2Button.setIcon(icon);
        this.up2Button.setMargin(new Insets(0, 0, 0, 0));
        this.up2Button.setDefaultCapable(false);
        this.up2Button.setFocusPainted(true);
        if (this.down1Button == null) {
            this.down1Button = new JButton((String)null);
        }
        icon = new ImageIcon(Resources.getImage((String)"DownArrow"));
        this.down1Button.setIcon(icon);
        this.down1Button.setMargin(new Insets(0, 0, 0, 0));
        this.down1Button.setDefaultCapable(false);
        this.down1Button.setFocusPainted(true);
        if (this.down2Button == null) {
            this.down2Button = new JButton((String)null);
        }
        this.down2Button.setIcon(icon);
        this.down2Button.setMargin(new Insets(0, 0, 0, 0));
        this.down2Button.setDefaultCapable(false);
        this.down2Button.setFocusPainted(true);
        if (this.list1 == null) {
            this.list1 = new DefaultListModel();
        }
        if (this.list2 == null) {
            this.list2 = new DefaultListModel();
        }
        if (this.getModel() == null) {
            this.setModel(this.list1);
        }
        if (this.getList2Model() == null) {
            this.setList2Model(this.list2);
        }
        this.preferredSize = new Dimension(DualSelector.getDefaultWidth(), DualSelector.getDefaultHeight());
        this.initialized = true;
        this.makeDualSelector();
        this.ensureButtonsEnabled();
        this.addListeners();
    }

    private void addListeners() {
        this.jList1.removeListSelectionListener(this);
        this.jList1.addListSelectionListener(this);
        this.jList2.removeListSelectionListener(this);
        this.jList2.addListSelectionListener(this);
        this.allRightButton.removeActionListener(this);
        this.allRightButton.addActionListener(this);
        if (alternatingButtonStyle) {
            this.alternatingButton.removeActionListener(this);
            this.alternatingButton.addActionListener(this);
        } else {
            this.leftButton.removeActionListener(this);
            this.leftButton.addActionListener(this);
            this.rightButton.removeActionListener(this);
            this.rightButton.addActionListener(this);
        }
        this.allLeftButton.removeActionListener(this);
        this.allLeftButton.addActionListener(this);
        this.up1Button.removeActionListener(this);
        this.up1Button.addActionListener(this);
        this.up2Button.removeActionListener(this);
        this.up2Button.addActionListener(this);
        this.down1Button.removeActionListener(this);
        this.down1Button.addActionListener(this);
        this.down2Button.removeActionListener(this);
        this.down2Button.addActionListener(this);
    }

    private void makeDualSelector() {
        this.removeAll();
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, true, true);
        this.setLayout((LayoutManager)mainLayout);
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 3, 5, 5, true, true, true);
        this.mainPanel.setLayout((LayoutManager)layout);
        this.partitioner = new ProportionalSpacePartitioner(new double[]{0.5, -2.0, 0.5});
        layout.setColumnSpacePartitioner((SpacePartitionerInterface)this.partitioner);
        Container list1Container = new Container();
        AutoSizingGridLayout list1Layout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        list1Layout.setRemainderRow(2);
        list1Layout.setIgnoreSizeOfNonVisibleComponents(true);
        list1Container.setLayout((LayoutManager)list1Layout);
        Container upDown1Container = new Container();
        AutoSizingGridLayout upDown1Layout = new AutoSizingGridLayout(1, 2, 5, 5);
        upDown1Layout.setIgnoreSizeOfNonVisibleComponents(true);
        upDown1Layout.setGridGravity(256);
        upDown1Container.setLayout((LayoutManager)upDown1Layout);
        Container middleContainer = new Container();
        AutoSizingGridLayout middleLayout = new AutoSizingGridLayout(1, 1, 5, 5);
        middleLayout.setIgnoreSizeOfNonVisibleComponents(true);
        middleLayout.setGridGravity(256);
        middleContainer.setLayout((LayoutManager)middleLayout);
        Container middleInsideContainer = new Container();
        AutoSizingGridLayout middleInsideLayout = alternatingButtonStyle ? new AutoSizingGridLayout(3, 1, 5, 5) : new AutoSizingGridLayout(4, 1, 5, 5);
        middleInsideLayout.setIgnoreSizeOfNonVisibleComponents(true);
        middleInsideContainer.setLayout((LayoutManager)middleInsideLayout);
        Container list2Container = new Container();
        AutoSizingGridLayout list2Layout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        list2Layout.setRemainderRow(2);
        list2Layout.setIgnoreSizeOfNonVisibleComponents(true);
        list2Container.setLayout((LayoutManager)list2Layout);
        Container upDown2Container = new Container();
        AutoSizingGridLayout upDown2Layout = new AutoSizingGridLayout(1, 2, 5, 5);
        upDown2Layout.setIgnoreSizeOfNonVisibleComponents(true);
        upDown2Layout.setGridGravity(256);
        upDown2Container.setLayout((LayoutManager)upDown2Layout);
        upDown1Container.add("list1Up", this.up1Button);
        this.up1Button.setVisible(this.list1ControlsVisible);
        upDown1Container.add("list1Down", this.down1Button);
        this.down1Button.setVisible(this.list1ControlsVisible);
        upDown2Container.add("list2Up", this.up2Button);
        this.up2Button.setVisible(this.list2ControlsVisible);
        upDown2Container.add("list2Down", this.down2Button);
        this.down2Button.setVisible(this.list2ControlsVisible);
        list1Container.add("list1Label", this.label1);
        JScrollPane pane1 = new JScrollPane(this.jList1);
        list1Container.add("list1", pane1);
        list1Container.add(upDown1Container);
        if (alternatingButtonStyle) {
            middleInsideContainer.add("alternating", this.alternatingButton);
        } else {
            middleInsideContainer.add("right", this.rightButton);
            middleInsideContainer.add("left", this.leftButton);
        }
        middleInsideContainer.add("allLeft", this.allLeftButton);
        middleInsideContainer.add("allRight", this.allRightButton);
        middleContainer.add(middleInsideContainer);
        list2Container.add("list2Label", this.label2);
        JScrollPane pane2 = new JScrollPane(this.jList2);
        list2Container.add("list1", pane2);
        list2Container.add(upDown2Container);
        this.mainPanel.add(list1Container);
        this.mainPanel.add(middleContainer);
        this.mainPanel.add(list2Container);
        this.add(this.mainPanel);
    }

    public void refresh() {
        ListModel listModel = this.getModel();
        if (listModel != null) {
            this.setList(listModel, true);
        }
        if ((listModel = this.getList2Model()) != null) {
            this.setList(listModel, false);
        }
        this.ensureButtonsEnabled();
    }

    public void refresh(ListModel listModel) {
        this.refresh();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.initialized) {
            this.label1.setBackground(color);
            this.label2.setBackground(color);
            if (alternatingButtonStyle) {
                this.alternatingButton.setBackground(color);
            } else {
                this.leftButton.setBackground(color);
                this.rightButton.setBackground(color);
            }
            this.allLeftButton.setBackground(color);
            this.allRightButton.setBackground(color);
            this.up1Button.setBackground(color);
            this.down1Button.setBackground(color);
            this.up2Button.setBackground(color);
            this.down2Button.setBackground(color);
            this.mainPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setDefaultValues() {
        this.list1ControlsVisible = false;
        this.list2ControlsVisible = false;
        this.transferAllControlsVisible = true;
        this.modelEventsIgnored = true;
        this.dynamic = false;
        this.setOpaque(true);
        this.list1MaximumCount = -1;
        this.list2MaximumCount = -1;
        this.init();
    }

    @Override
    public void setFont(Font font) {
        Font oldFont = this.getFont();
        super.setFont(font);
        this.label1.setFont(font);
        this.label2.setFont(font);
        this.jList1.setFont(font);
        this.jList2.setFont(font);
        if (oldFont != null && !oldFont.equals(font)) {
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.initialized) {
            this.label1.setForeground(color);
            this.label2.setForeground(color);
            this.jList1.setForeground(color);
            this.jList2.setForeground(color);
            this.mainPanel.setForeground(color);
        }
        super.setForeground(color);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.allRightButton) {
            this.transferAllList1Items();
        } else if (source == this.alternatingButton) {
            if (!this.direction) {
                this.transferList1Items();
            } else if (this.direction) {
                this.transferList2Items();
            }
        } else if (source == this.allLeftButton) {
            this.transferAllList2Items();
        } else if (source == this.up1Button) {
            this.moveList1ItemUp();
        } else if (source == this.down1Button) {
            this.moveList1ItemDown();
        } else if (source == this.up2Button) {
            this.moveList2ItemUp();
        } else if (source == this.down2Button) {
            this.moveList2ItemDown();
        } else if (source == this.leftButton) {
            this.transferList2Items();
        } else if (source == this.rightButton) {
            this.transferList1Items();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        Object source = event.getSource();
        if (com.sas.util.Util.equal((Object)source, (Object)this.getModel()) || com.sas.util.Util.equal((Object)source, (Object)this.getList2Model())) {
            this.refresh();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.contentsChanged(event);
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.contentsChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent ie) {
        this.ensureButtonsEnabled();
        Object source = ie.getSource();
        if (!this.clearSelection) {
            if (source == this.jList1) {
                if (alternatingButtonStyle) {
                    this.alternatingButton.setIcon(this.rightArrow);
                }
                this.clearSelection = true;
                try {
                    this.jList2.getSelectionModel().clearSelection();
                    this.direction = false;
                }
                finally {
                    this.clearSelection = false;
                }
            }
            if (source == this.jList2) {
                if (alternatingButtonStyle) {
                    this.alternatingButton.setIcon(this.leftArrow);
                } else {
                    this.leftButton.setEnabled(true);
                    this.rightButton.setEnabled(false);
                }
                this.clearSelection = true;
                try {
                    this.jList1.getSelectionModel().clearSelection();
                    this.direction = true;
                }
                finally {
                    this.clearSelection = false;
                }
            }
        }
    }

    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultListModel && this.getModel().getSize() == 0;
    }

    public ListModel getModel() {
        return this.listModel1;
    }

    public void setModel(ListModel listModel) {
        ListModel oldModel = this.listModel1;
        this.listModel1 = listModel;
        if (listModel != null) {
            this.internalAttachModel1(this.listModel1);
        } else {
            if ((!this.modelEventsIgnored || this.isDesignTime()) && oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            this.listModel1 = new DefaultListModel();
            this.internalAttachModel1(this.listModel1);
        }
        this.refresh();
        this.firePropertyChange("model", oldModel, this.listModel1);
    }

    public ListModel getList2Model() {
        return this.listModel2;
    }

    public void setList2Model(ListModel listModel) {
        ListModel oldModel = this.listModel2;
        this.listModel2 = listModel;
        if (listModel != null) {
            this.internalAttachModel2(this.listModel2);
        } else {
            if ((!this.modelEventsIgnored || this.isDesignTime()) && oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            this.listModel2 = new DefaultListModel();
            this.internalAttachModel2(this.listModel2);
        }
        this.refresh();
        this.firePropertyChange("listModel2", oldModel, this.listModel2);
    }

    private void internalAttachModel1(ListModel listModel) {
        if (this.list1MaximumCount >= 0 && listModel.getSize() > this.list1MaximumCount) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"exceededMaxCount.ex.txt"), (Object)new Integer(1), (Object)new Integer(listModel.getSize()), (Object)new Integer(this.list1MaximumCount)));
        }
        this.list1 = listModel;
        this.setList(listModel, true);
        if (!this.isModelEventsIgnored() || this.isDesignTime()) {
            listModel.addListDataListener(this);
        }
    }

    private void internalAttachModel2(ListModel listModel) {
        if (this.list2MaximumCount >= 0 && listModel.getSize() > this.list2MaximumCount) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"exceededMaxCount.ex.txt"), (Object)new Integer(2), (Object)new Integer(listModel.getSize()), (Object)new Integer(this.list2MaximumCount)));
        }
        this.list2 = listModel;
        this.setList(listModel, false);
        if (!this.isModelEventsIgnored() || this.isDesignTime()) {
            listModel.addListDataListener(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setList(ListModel listModel, boolean isList1) {
        if (listModel instanceof DefaultListModel) {
            ListModel model;
            ListModel listModel2 = model = isList1 ? this.getModel() : this.getList2Model();
            if ((this.dynamic || this.isDesignTime()) && (model == null || model instanceof DefaultListModel)) {
                this.setListItems(model, true, false, isList1);
                this.usingDynamic = true;
            } else {
                if (this.dynamic) throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"listNotDynamic.ex.txt"), (Object)new Integer(2)));
                this.setListItems(model, false, false, isList1);
                this.usingDynamic = false;
            }
        } else if (listModel instanceof ListModelAdapter && ((ListModelAdapter)listModel).getModel() instanceof OrderedCollectionInterface) {
            ListModel model;
            ListModel listModel3 = model = isList1 ? this.getModel() : this.getList2Model();
            if ((this.dynamic || this.isDesignTime()) && (model == null || model instanceof ListModelAdapter && ((ListModelAdapter)model).getModel() instanceof OrderedCollectionInterface)) {
                this.setListItems(model, false, true, isList1);
                this.usingDynamic = true;
            } else {
                if (this.dynamic) throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"listNotDynamic.ex.txt"), (Object)new Integer(2)));
                this.setListItems(model, false, false, isList1);
                this.usingDynamic = false;
            }
        } else {
            if (this.dynamic) throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"listNotDynamic.ex.txt"), (Object)new Integer(2)));
            this.setListItems(listModel, false, false, isList1);
            this.usingDynamic = false;
        }
        if (isList1) {
            if (this.jList1 == null || this.list1 == null) return;
            this.jList1.setModel(this.list1);
            return;
        } else {
            if (this.jList2 == null || this.list2 == null) return;
            this.jList2.setModel(this.list2);
        }
    }

    private void setListItems(ListModel listModel, boolean isDLM, boolean isOC, boolean isList1) {
        if (isList1) {
            this.list1 = isDLM ? (DefaultListModel)listModel : (isOC ? (ListModelAdapter)listModel : this.getCollectionOfItems(listModel));
        } else {
            this.list2 = isDLM ? (DefaultListModel)listModel : (isOC ? (ListModelAdapter)listModel : this.getCollectionOfItems(listModel));
        }
    }

    private DefaultListModel getCollectionOfItems(ListModel listModel) {
        DefaultListModel dlm = new DefaultListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            dlm.addElement(listModel.getElementAt(i));
        }
        return dlm;
    }
}

