/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.beans.Util;
import com.sas.swing.property.PropertyDescriptorAttribute;
import com.sas.swing.property.PropertyEditorHost;
import com.sas.swing.property.PropertyTableModel;
import com.sas.swing.property.ValueAttribute;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertyValueEditor
extends AbstractCellEditor
implements ActionListener,
TableCellEditor,
TableCellRenderer,
PropertyChangeListener {
    protected List beanList;
    protected Map propEditorMap = new HashMap();
    protected Map propRendererMap = new HashMap();
    protected Set updateSet = new HashSet();
    protected PropertyEditorHost editorHost;
    protected boolean showControls;
    protected Border focusBorder;
    protected Border selectedBorder;
    protected Border defaultBorder;
    protected static Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    protected static Border fillBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    protected boolean valueChanging;
    protected int editingRow;
    protected PropertyTableModel tableModel;
    protected boolean forceReadOnly = false;

    public void setForceReadOnly(boolean fro) {
        this.forceReadOnly = fro;
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnly;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyTableModel model = (PropertyTableModel)table.getModel();
        PropertyDescriptor propDesc = model.getPropertyDescriptor(row);
        String propName = propDesc.getName();
        PropertyEditorHost rendererComp = (PropertyEditorHost)this.propRendererMap.get(propName);
        if (rendererComp == null) {
            rendererComp = new PropertyEditorHost();
            if (this.isForceReadOnly()) {
                rendererComp.setForceReadOnly(true);
            }
            rendererComp.setAlwaysShowControls(this.showControls);
            Object[] beans = model.getObjects();
            rendererComp.setProperty(beans[0], propDesc);
            this.propRendererMap.put(propName, rendererComp);
        } else if (this.updateSet.contains(propName)) {
            this.updateSet.remove(propName);
            if (this.isForceReadOnly()) {
                rendererComp.setForceReadOnly(true);
            }
            rendererComp.updateValue(false);
        }
        if (isSelected) {
            if (hasFocus) {
                rendererComp.setBorder(this.getFocusBorder());
            } else {
                rendererComp.setBorder(this.getSelectedBorder());
            }
            rendererComp.setForeground(table.getSelectionForeground());
            rendererComp.setBackground(table.getSelectionBackground());
        } else {
            rendererComp.setBorder(this.getDefaultBorder());
            rendererComp.setForeground(table.getForeground());
            rendererComp.setBackground(table.getBackground());
        }
        return rendererComp;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyTableModel model;
        this.tableModel = model = (PropertyTableModel)table.getModel();
        this.editingRow = row;
        PropertyDescriptor propDesc = model.getPropertyDescriptor(row);
        String propName = propDesc.getName();
        if (this.propEditorMap.containsKey(propName)) {
            this.editorHost = (PropertyEditorHost)this.propEditorMap.get(propName);
            if (this.editorHost != null) {
                this.editorHost.updateValue(true);
            }
        } else {
            this.editorHost = new PropertyEditorHost();
            Object[] objects = model.getObjects();
            this.editorHost.setProperty(objects[0], propDesc);
            PropertyEditor propEditor = this.editorHost.getPropertyEditor();
            if (propEditor != null) {
                this.editorHost.addActionListener(this);
                this.editorHost.addPropertyChangeListener(this);
            } else {
                this.editorHost = null;
            }
            this.propEditorMap.put(propName, this.editorHost);
        }
        if (this.editorHost != null) {
            if (isSelected) {
                this.editorHost.setBorder(this.getSelectedBorder());
            } else {
                this.editorHost.setBorder(this.getDefaultBorder());
            }
            this.editorHost.setForeground(table.getForeground());
            this.editorHost.setBackground(table.getBackground());
            this.editorHost.startEditing();
        }
        return this.editorHost;
    }

    @Override
    public Object getCellEditorValue() {
        PropertyEditor propEditor;
        Object obj = null;
        if (this.editorHost != null && (propEditor = this.editorHost.getPropertyEditor()) != null) {
            obj = propEditor.getValue();
        }
        return obj;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.editorHost != null) {
            this.editorHost.stopEditing();
            PropertyDescriptor propDesc = this.editorHost.getPropertyDescriptor();
            this.updateSet.add(propDesc.getName());
        }
        return super.stopCellEditing();
    }

    public Object[] getObjects() {
        return this.beanList.toArray();
    }

    public void setObjects(Object[] objs) {
        if (this.beanList != null && !this.beanList.isEmpty()) {
            Util.removePropertyChangeListener(this.beanList.get(0), (PropertyChangeListener)this);
        }
        this.refresh();
        this.beanList = objs == null ? new ArrayList() : Arrays.asList(objs);
        if (objs != null && this.beanList != null && !this.beanList.isEmpty()) {
            Util.addPropertyChangeListener(this.beanList.get(0), (PropertyChangeListener)this);
        }
    }

    public void refresh() {
        this.stopCellEditing();
        for (PropertyEditorHost propEditorHost : this.propEditorMap.values()) {
            if (propEditorHost == null) continue;
            propEditorHost.removeActionListener(this);
        }
        ValueAttribute.resetModifiedPropertySet();
        this.propEditorMap.clear();
        this.propRendererMap.clear();
        this.updateSet.clear();
    }

    public Border getDefaultBorder() {
        if (this.defaultBorder == null) {
            this.defaultBorder = emptyBorder;
        }
        return this.defaultBorder;
    }

    public void setDefaultBorder(Border border) {
        this.defaultBorder = border;
    }

    public Border getFocusBorder() {
        if (this.focusBorder == null) {
            Border focusExtBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            this.focusBorder = BorderFactory.createCompoundBorder(focusExtBorder, fillBorder);
        }
        return this.focusBorder;
    }

    public void setFocusBorder(Border border) {
        this.focusBorder = border;
    }

    public Border getSelectedBorder() {
        if (this.selectedBorder == null) {
            Border selectedExtBorder = BorderFactory.createLineBorder(UIManager.getColor("Table.selectionBackground"), 1);
            this.selectedBorder = BorderFactory.createCompoundBorder(selectedExtBorder, fillBorder);
        }
        return this.selectedBorder;
    }

    public void setSelectedBorder(Border border) {
        this.selectedBorder = border;
    }

    public boolean getShowControls() {
        return this.showControls;
    }

    public void setShowControls(boolean show) {
        this.showControls = show;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.stopCellEditing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        String propName = evt.getPropertyName();
        if (this.beanList != null && !this.beanList.isEmpty() && eSource == this.beanList.get(0)) {
            if (propName != null && this.propRendererMap.containsKey(propName)) {
                PropertyDescriptor editorHostPropDesc;
                this.updateSet.add(propName);
                if (this.editorHost != null && propName.equals((editorHostPropDesc = this.editorHost.getPropertyDescriptor()).getName())) {
                    try {
                        PropertyDescriptorAttribute valueAttribute = this.tableModel.getPropertyDescriptorAttribute("value");
                        Object value = valueAttribute.getAttribute(this.beanList.toArray(), editorHostPropDesc);
                        this.valueChanging = true;
                        this.editorHost.setPropertyValue(value);
                    }
                    finally {
                        this.valueChanging = false;
                    }
                }
            } else {
                this.updateSet.addAll(this.propRendererMap.keySet());
            }
        } else if (eSource == this.editorHost && propName != null && propName.equals("propertyValue") && !this.valueChanging) {
            try {
                this.valueChanging = true;
                PropertyDescriptor editorHostPropDesc = this.editorHost.getPropertyDescriptor();
                ValueAttribute.addModifiedProperty(editorHostPropDesc.getName());
                int column = this.tableModel.getColumnIndex("value");
                this.tableModel.setValueAt(this.editorHost.getPropertyValue(), this.editingRow, column);
            }
            finally {
                this.valueChanging = false;
            }
        }
    }
}

